/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import oracle.cluster.cvu.CVU;
import oracle.cluster.cvu.CVUFactory;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.SRVMContext;
import oracle.cluster.util.SRVMContextException;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.wallet.CLSWAliasNotExistException;
import oracle.cluster.wallet.CLSWException;
import oracle.cluster.wallet.CLSWNotExistException;
import oracle.cluster.wallet.CVUDatabaseWallet;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class HeavyWeightVerificationUtil
implements VerificationConstants {
    private static MessageBundle m_prvgMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static MessageBundle m_prvfMsgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static Util s_AlertLogContext = null;
    private static SRVMContext m_context = null;
    private static final String CVU_RESOURCE_NAME = "cvud";

    public static void printGlobalAlertLog(int msgNumber, String[] args) {
        StringBuilder sb = new StringBuilder();
        if (args != null && args.length > 0) {
            for (String msg : args) {
                int sbLen = sb.length();
                if (sbLen + msg.length() + 1 > 750) {
                    Trace.out((String)"writing to alert log");
                    boolean skipMsg = false;
                    if (sbLen == 0) {
                        Trace.out((String)(msg + " greater than max alert message length"));
                        sb.append(msg);
                        skipMsg = true;
                    }
                    HeavyWeightVerificationUtil.writeToAlertLog(msgNumber, sb);
                    if (skipMsg) continue;
                    Trace.out((String)"starting a new sb");
                    sb = new StringBuilder(msg);
                    sb.append(VerificationConstants.LINE_SEPARATOR);
                    continue;
                }
                sb.append(msg);
                sb.append(VerificationConstants.LINE_SEPARATOR);
            }
        }
        if (sb.length() != 0) {
            HeavyWeightVerificationUtil.writeToAlertLog(msgNumber, sb);
        }
    }

    public static String getDBPassword(String database, String userName, ResultSet resultSet) throws CVUException {
        resultSet.addResult(database, 1);
        if (!"DBSNMP".equalsIgnoreCase(userName)) {
            Trace.out((String)("userName=" + userName + " passed. supported user is " + "DBSNMP"));
            throw new CVUException(m_prvfMsgBundle, "7508", new Object[0]);
        }
        String password = null;
        try {
            CVUDatabaseWallet wallet = CVUDatabaseWallet.getInstance();
            wallet.open();
            password = wallet.getPassword(database);
            wallet.close();
        }
        catch (CLSWAliasNotExistException CLSWAEx) {
            Trace.out((String)("CLSWAliasNotExistException occured: msg=" + CLSWAEx.getMessage()));
            resultSet.addResult(database, 2);
            String errMsg = m_prvgMsgBundle.getMessage("11415", true, (Object[])new String[]{userName, database}) + LSEP + CLSWAEx.getMessage();
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            resultSet.addErrorDescription(database, errDesc);
            throw new CVUException(CLSWAEx, m_prvgMsgBundle, "11415", userName, database);
        }
        catch (CLSWNotExistException e) {
            if (!VerificationUtil.isCVUResource()) {
                resultSet.addResult(database, 2);
                String errMsg = m_prvgMsgBundle.getMessage("11415", true, (Object[])new String[]{userName, database}) + LSEP + e.getMessage();
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                resultSet.addErrorDescription(database, errDesc);
                throw new CVUException(e, m_prvgMsgBundle, "11415", userName, database);
            }
            Trace.out((String)"ignoring wallet not exists exception in cvu resource");
            resultSet.addResult(database, 3);
        }
        catch (CLSWException CLSWEx) {
            Trace.out((String)("CLSWException occured: msg" + CLSWEx.getMessage()));
            resultSet.addResult(database, 2);
            ErrorDescription errDesc = new ErrorDescription(CLSWEx.getMessage());
            resultSet.addErrorDescription(database, errDesc);
            throw new CVUException(CLSWEx);
        }
        return password;
    }

    private static void writeToAlertLog(int msgNumber, StringBuilder sb) {
        try {
            if (s_AlertLogContext == null) {
                s_AlertLogContext = new Util();
            }
            s_AlertLogContext.writeToAlertLog(msgNumber, sb.toString());
            Trace.out((String)"after write alert log");
        }
        catch (UtilException e) {
            Trace.out((String)"Util exception writing to alert log");
            ReportUtil.sureprintln(sb.toString() + VerificationConstants.LINE_SEPARATOR + e.getMessage());
        }
    }

    public static String getDestLocAttribute() {
        try {
            m_context = SRVMContext.getInstance();
            m_context.init(SRVMContext.ProcType.DAEMON, CVU_RESOURCE_NAME, true);
            CVUFactory cvuFac = CVUFactory.getInstance();
            CVU cvures = cvuFac.getCVU();
            return cvures.getDestLoc();
        }
        catch (oracle.cluster.cvu.CVUException e) {
            Trace.out((String)("couldn't get dest loc attribute: " + e.getMessage()));
            ReportUtil.printGlobalAlertLog(new String[]{e.getMessage()});
            return null;
        }
        catch (NotExistsException e) {
            Trace.out((String)("cvu resource doesn't exist: " + e.getMessage()));
            return null;
        }
        catch (SRVMContextException e) {
            Trace.out((String)("couldn't initialize SRVM context" + e.getMessage()));
            ReportUtil.quietprintln(e.getMessage());
            return null;
        }
    }

    protected void finalize() {
        if (s_AlertLogContext != null) {
            try {
                Trace.out((String)"closing alert log context");
                s_AlertLogContext.terminateAlertLogContext();
            }
            catch (UtilException e) {
                Trace.out((String)"Util exception closing alert log context");
                Trace.out((String)e.getMessage());
            }
        }
    }
}

