/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import oracle.ops.verification.framework.util.VerificationUtil;

public class FileInfo {
    private String m_fileName;
    private String m_fileOwner;
    private String m_fileGroup;
    private String m_filePermissions;
    private Permissions m_permissions;
    private String m_status;
    private String m_errorString;

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    public String getFileOwner() {
        return this.m_fileOwner;
    }

    public void setFileOwner(String fileOwner) {
        this.m_fileOwner = fileOwner;
    }

    public String getFileGroup() {
        return this.m_fileGroup;
    }

    public void setFileGroup(String fileGroup) {
        this.m_fileGroup = fileGroup;
    }

    public String getFilePermissions() {
        return this.m_filePermissions;
    }

    public Permissions getFilePermissionsObj() {
        return this.m_permissions;
    }

    public void setFilePermissions(String filePermissions) {
        this.m_filePermissions = filePermissions;
        this.m_permissions = new Permissions(this.m_filePermissions);
    }

    public String getStatus() {
        return this.m_status;
    }

    public void setStatus(String status) {
        this.m_status = status;
    }

    public String getErrorString() {
        return this.m_errorString;
    }

    public void setErrorString(String errorString) {
        this.m_errorString = errorString;
    }

    public String toString() {
        return "[name = " + this.m_fileName + "; owner=" + this.m_fileOwner + "; group=" + this.m_fileGroup + "; permissions=" + this.m_filePermissions + "; status=" + this.m_status + "; error =" + this.m_errorString + "]";
    }

    public static class Permissions {
        private char[] permArray = new char[]{'-', '-', '-', '-', '-', '-', '-', '-', '-'};

        public Permissions(String permStr) {
            if (VerificationUtil.isStringGood(permStr)) {
                permStr = permStr.trim();
                permStr = (permStr.length() == 1 ? "00" : (permStr.length() == 2 ? "0" : "")) + permStr;
                int i = permStr.length() - 1;
                int pointer = 6;
                while (i >= permStr.length() - 3) {
                    char c = permStr.charAt(i);
                    switch (c) {
                        case '1': {
                            this.permArray[pointer + 2] = 120;
                            break;
                        }
                        case '2': {
                            this.permArray[pointer + 1] = 119;
                            break;
                        }
                        case '3': {
                            this.permArray[pointer + 1] = 119;
                            this.permArray[pointer + 2] = 120;
                            break;
                        }
                        case '4': {
                            this.permArray[pointer] = 114;
                            break;
                        }
                        case '5': {
                            this.permArray[pointer] = 114;
                            this.permArray[pointer + 2] = 120;
                            break;
                        }
                        case '6': {
                            this.permArray[pointer] = 114;
                            this.permArray[pointer + 1] = 119;
                            break;
                        }
                        case '7': {
                            this.permArray[pointer] = 114;
                            this.permArray[pointer + 1] = 119;
                            this.permArray[pointer + 2] = 120;
                            break;
                        }
                    }
                    --i;
                    pointer -= 3;
                }
            }
        }

        public boolean isOwnerReadable() {
            return this.permArray[0] != '-';
        }

        public boolean isOwnerWritable() {
            return this.permArray[1] != '-';
        }

        public boolean isOwnerExecutable() {
            return this.permArray[2] != '-';
        }

        public boolean isGroupReadable() {
            return this.permArray[3] != '-';
        }

        public boolean isGroupWritable() {
            return this.permArray[4] != '-';
        }

        public boolean isGroupExecutable() {
            return this.permArray[5] != '-';
        }

        public boolean isOthersReadable() {
            return this.permArray[6] != '-';
        }

        public boolean isOthersWritable() {
            return this.permArray[7] != '-';
        }

        public boolean isOthersExecutable() {
            return this.permArray[8] != '-';
        }

        public String toString() {
            return new String(this.permArray);
        }

        public String toStringOwner() {
            return new String(this.permArray).substring(0, 3);
        }

        public String toStringGroup() {
            return new String(this.permArray).substring(3, 6);
        }

        public String toStringOthers() {
            return new String(this.permArray).substring(6, 9);
        }
    }
}

