/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Hashtable;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUAutoUpdateManager;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ConfigUtil {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static final String CONFIG_FILE = "cvu_config";
    private Hashtable m_hash;
    public static String s_fSep = System.getProperty("file.separator");
    private static ConfigUtil _configUtil;

    protected ConfigUtil() {
        this.init();
    }

    public static ConfigUtil getInstance() {
        if (_configUtil == null) {
            _configUtil = new ConfigUtil();
        }
        return _configUtil;
    }

    private void init() {
        this.m_hash = new Hashtable();
        this.importConfig();
    }

    private void importConfig() {
        String lntxt = null;
        String cfgFile = CVUAutoUpdateManager.getCVUFileLocation("cv" + s_fSep + "admin" + s_fSep + CONFIG_FILE);
        Trace.out((String)("==== CVU config file: " + cfgFile));
        try {
            LineNumberReader inReader = new LineNumberReader(new FileReader(cfgFile));
            while ((lntxt = inReader.readLine()) != null) {
                int idxEq;
                if ((lntxt = lntxt.trim()).startsWith("#") || lntxt.trim().length() <= 0 || (idxEq = lntxt.indexOf("=")) == -1) continue;
                String var = lntxt.substring(0, lntxt.indexOf("="));
                var = var.toLowerCase();
                String value = lntxt.substring(idxEq + 1);
                Trace.out((String)("==== Picked up config variable: " + var + " : " + value));
                this.m_hash.put(var, value);
            }
        }
        catch (FileNotFoundException fnfe) {
            ReportUtil.printError(s_msgBundle.getMessage("9406", false, new Object[]{cfgFile}));
            Trace.out((String)"==== Config file does not exist");
            Trace.out((Exception)fnfe);
        }
        catch (IOException ioe) {
            ReportUtil.printError(ioe.getMessage());
            Trace.out((Exception)ioe);
        }
    }

    public String getConfiguredValue(String cfgVar) {
        return this.getConfiguredValue(cfgVar, false);
    }

    public String getConfiguredValue(String cfgVar, boolean bFBToEnv) {
        if (cfgVar == null) {
            return null;
        }
        String value = null;
        if (this.isDefined(cfgVar)) {
            String key = cfgVar.toLowerCase();
            try {
                value = (String)this.m_hash.get(key);
            }
            catch (NullPointerException npe) {
                value = null;
            }
            Trace.out((String)("==== " + cfgVar + " is defined as : " + value));
        } else if (bFBToEnv) {
            value = VerificationUtil.getEnv(cfgVar);
            Trace.out((String)("==== Fallback to env var '" + cfgVar + "'=" + value));
        }
        return value;
    }

    public boolean isDefined(String cfgVar) {
        if (cfgVar == null) {
            return false;
        }
        boolean isDefined = this.m_hash.containsKey(cfgVar.toLowerCase());
        Trace.out((String)("==== Is " + cfgVar + " defined? : " + isDefined));
        return isDefined;
    }
}

