/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.util.Arrays;
import java.util.List;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.util.CVUVariablesException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CVUVariableData {
    private List<String> m_installUINames;
    private List<String> m_installResponseNames;
    private List<String> m_cvuVariableNames;
    private List<String> m_rootScriptNames;
    private boolean m_forceLookUp;
    private String m_value;
    private static final String INSTALL_UI_CONTEXT_NAME = "Install UI";
    private static final String INSTALL_RESPONSE_CONTEXT_NAME = "Install Response";
    private static final String CMD_CVU_CONTEXT_NAME = "Command Line and CVU";
    private static final String ROOT_SCRIPTS_CONTEXT_NAME = "Root Scripts";
    protected static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");

    public CVUVariableData(boolean forceLookUp, String install, String response, String cvuVar, String rootScript) throws CVUVariablesException {
        if (!(VerificationUtil.isStringGood(install) || VerificationUtil.isStringGood(response) || VerificationUtil.isStringGood(cvuVar) || VerificationUtil.isStringGood(rootScript))) {
            String msg = s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"CVUVariableData-CVUVariableData-error_1"});
            Trace.out((String)msg);
            throw new CVUVariablesException(msg);
        }
        this.m_installUINames = this.processVarNames(install, INSTALL_UI_CONTEXT_NAME);
        this.m_installResponseNames = this.processVarNames(response, INSTALL_RESPONSE_CONTEXT_NAME);
        this.m_cvuVariableNames = this.processVarNames(cvuVar, CMD_CVU_CONTEXT_NAME);
        this.m_rootScriptNames = this.processVarNames(rootScript, ROOT_SCRIPTS_CONTEXT_NAME);
        this.m_forceLookUp = forceLookUp;
        Trace.out((Object)"CVUVariableData created with names:  \"%s\"", (String)this.toString());
    }

    public CVUVariableData(String install, String response, String cvuVar, String rootScript) throws CVUVariablesException {
        this(false, install, response, cvuVar, rootScript);
    }

    private List<String> processVarNames(String varNames, String contextName) {
        List<String> names = null;
        if (VerificationUtil.isStringGood(varNames)) {
            String[] namesArray = VerificationUtil.string2strArr(varNames);
            names = Arrays.asList(namesArray);
        } else {
            Trace.out((int)1, (String)("No variable names were provided for context : " + contextName));
        }
        return names;
    }

    public void setValue(String value) {
        this.m_value = value;
    }

    public String getValue() {
        return this.m_value;
    }

    public List<String> getInstallUINames() {
        return this.m_installUINames;
    }

    public List<String> getInstallResponseNames() {
        return this.m_installResponseNames;
    }

    public List<String> getCVUVariableNames() {
        return this.m_cvuVariableNames;
    }

    public List<String> getRootScriptNames() {
        return this.m_rootScriptNames;
    }

    public String toString() {
        StringBuilder varNames = new StringBuilder();
        this.addContextNames(this.m_installUINames, INSTALL_UI_CONTEXT_NAME, varNames);
        this.addContextNames(this.m_installResponseNames, INSTALL_RESPONSE_CONTEXT_NAME, varNames);
        this.addContextNames(this.m_cvuVariableNames, CMD_CVU_CONTEXT_NAME, varNames);
        this.addContextNames(this.m_rootScriptNames, ROOT_SCRIPTS_CONTEXT_NAME, varNames);
        String result = varNames.toString();
        return result;
    }

    private void addContextNames(List<String> contextNames, String context, StringBuilder varNames) {
        if (contextNames != null) {
            if (varNames.length() > 0) {
                varNames.append(",");
            }
            varNames.append(VerificationUtil.strArr2List((String[])contextNames.toArray()));
        } else {
            Trace.out((int)1, (String)("No variable names available for context:" + context));
        }
    }

    public boolean isLookUpForced() {
        return this.m_forceLookUp;
    }

    public void setForceLookUp(boolean force) {
        this.m_forceLookUp = force;
    }
}

