/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.util.RemoteExecCommand;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.sStorageUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.util.GenericUtil;

class sVXDGInfo
extends StorageInfo
implements StorageConstants {
    private static final String VXDG_LOC = "/usr/sbin/";
    private String m_dgid = null;

    sVXDGInfo(String dgname, String node, String dgid) {
        super(dgname, node, 3);
        this.m_dgid = dgid;
    }

    public void getDetails(Vector stList) {
    }

    @Override
    public String getSignature() {
        return this.m_dgid;
    }

    public static sVXDGInfo getDGByVolume(StorageInfo stInfo) throws StorageException {
        String name = stInfo.getName();
        String basename = name.substring(name.lastIndexOf(47) + 1, name.length());
        String cmdStr = "/usr/sbin/vxprint -qtG `/usr/sbin/vxprint " + basename + " | grep 'Disk group:' | cut -d ':' -f 2` ";
        String[] args = new String[]{""};
        String localHost = sStorageUtil.getLocalHost();
        RemoteExecCommand cmd = new RemoteExecCommand(cmdStr, args, null, localHost, null, (String)null, null);
        boolean cmdSucc = false;
        Command[] cmdArray = new Command[]{cmd};
        Trace.out((String)"_st_:about to get enclosing dg");
        try {
            cmdSucc = new ClusterCmd().submit(cmdArray);
        }
        catch (ClusterException e) {
            Trace.out((String)(">>ClusterException[Thread:" + Thread.currentThread().getName() + "]: " + (Object)((Object)e)));
            VerificationLogData.logError("CLUSTEREXCEPTION: " + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e));
            throw new StorageException("7001", e);
        }
        if (!cmdSucc) {
            Trace.out((String)"ClusterCmd.submit failed ");
            throw new StorageException("Failed to get shared disk groups");
        }
        sVXDGInfo foundDg = sVXDGInfo.parseGetDGByVolume(cmd, stInfo);
        if (foundDg == null) {
            Trace.out((String)("_st_: No DiskGroups found for " + stInfo.getName()));
            throw new StorageException("7008");
        }
        return foundDg;
    }

    private static sVXDGInfo parseGetDGByVolume(RemoteExecCommand cmd, StorageInfo stInfo) throws StorageException {
        String[] resultLines = cmd.getCommandResult().getResultString();
        String currLine = null;
        String name = null;
        String dgid = null;
        sVXDGInfo dginfo = null;
        Trace.out((String)("parseGetDGByVolume " + stInfo.getName()));
        if (resultLines.length != 1) {
            Trace.out((String)"_st_: More than one VG found for LV ::");
            for (int i = 0; i < resultLines.length; ++i) {
                Trace.out((String)("_st_:" + resultLines[i]));
            }
            throw new StorageException();
        }
        currLine = resultLines[0];
        StringTokenizer stLine = new StringTokenizer(currLine);
        stLine.nextToken();
        name = stLine.nextToken();
        stLine.nextToken();
        stLine.nextToken();
        stLine.nextToken();
        dgid = stLine.nextToken();
        dginfo = new sVXDGInfo(name, stInfo.getNode(), dgid);
        return dginfo;
    }

    public static Vector getSharedOnLocal() throws StorageException {
        String cmdStr = "/usr/sbin/vxprint -l | egrep -i '(Disk group:|activation:|dgid=)'";
        String[] args = new String[]{""};
        String localNode = sStorageUtil.getLocalHost();
        RemoteExecCommand cmd = new RemoteExecCommand("/usr/sbin/vxprint -l | egrep -i '(Disk group:|activation:|dgid=)'", args, null, localNode, null, (String)null, null);
        boolean cmdSucc = false;
        Command[] cmdArray = new Command[]{cmd};
        Trace.out((String)"_st_:about to get the list of shared dgs");
        try {
            cmdSucc = new ClusterCmd().submit(cmdArray);
        }
        catch (ClusterException e) {
            Trace.out((String)(">>ClusterException[Thread:" + Thread.currentThread().getName() + "]: " + (Object)((Object)e)));
            VerificationLogData.logError("CLUSTEREXCEPTION: " + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e));
            throw new StorageException("Failed to get shared disk groups", e);
        }
        if (!cmdSucc) {
            Trace.out((String)"ClusterCmd.submit failed ");
            throw new StorageException("Failed to get shared disk groups");
        }
        return sVXDGInfo.parseVXDGList(cmd);
    }

    private static Vector parseVXDGList(RemoteExecCommand cmd) throws StorageException {
        Vector<sVXDGInfo> retVector = new Vector<sVXDGInfo>();
        boolean isEnabled = false;
        boolean isShared = false;
        String currLine = null;
        String[] resultLines = cmd.getCommandResult().getResultString();
        String name = null;
        String state = null;
        String dgid = null;
        sVXDGInfo dgInfo = null;
        try {
            for (int i = 0; i < resultLines.length; ++i) {
                name = GenericUtil.getNextStrNoCase(resultLines[i], "Disk group:", null);
                dgid = GenericUtil.getNextStrNoCase(resultLines[++i], "dgid=", null);
                if ((state = GenericUtil.getNextStrNoCase(resultLines[++i], "activation:", null)) == null) {
                    Trace.out((String)("_st_: vxprint -l gave unshared dg! " + name));
                    --i;
                    continue;
                }
                if (state.indexOf("shared") == -1) continue;
                dgInfo = new sVXDGInfo(name, cmd.getNode(), dgid);
                Trace.out((String)("_st_:added " + dgInfo));
                retVector.add(dgInfo);
            }
        }
        catch (Exception e) {
            Trace.out((String)("The last line caused an exception: " + currLine));
            VerificationLogData.logError("EXCEPTION: The last line caused an exception: " + currLine + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e));
            throw new StorageException("7001", e);
        }
        Trace.out((String)("_st_: Num shared local dgs found " + retVector.size()));
        Enumeration stEnum = retVector.elements();
        int i = 0;
        while (stEnum.hasMoreElements()) {
            Trace.out((String)("in retVector" + stEnum.nextElement()));
            ++i;
        }
        return retVector;
    }

    @Override
    public String toString() {
        return this.getNode() + ":" + this.getName() + ":" + this.m_dgid;
    }
}

