/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.storage.ACFSSharedStrategy;
import oracle.ops.verification.framework.storage.ASMSharedStrategy;
import oracle.ops.verification.framework.storage.ASMSharedVerifyStrategy;
import oracle.ops.verification.framework.storage.FSSharedVerifyStrategy;
import oracle.ops.verification.framework.storage.NFSSharedStrategy;
import oracle.ops.verification.framework.storage.SharedStrategy;
import oracle.ops.verification.framework.storage.SharedVerifyStrategy;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.sDiskSharedStrategy;
import oracle.ops.verification.framework.storage.sDiskSharedVerifyStrategy;
import oracle.ops.verification.framework.storage.sStorageUtil;
import oracle.ops.verification.framework.storage.sVXDGSharedStrategy;
import oracle.ops.verification.framework.storage.sVXDGSharedVerifyStrategy;
import oracle.ops.verification.framework.storage.sVXVLSharedStrategy;
import oracle.ops.verification.framework.storage.sVXVLSharedVerifyStrategy;

class sStrategyProvider
implements StorageConstants {
    sStrategyProvider() {
    }

    static SharedStrategy getSharedStrategy(int type) throws StorageException {
        switch (type) {
            case 2: {
                return new NFSSharedStrategy();
            }
            case 3: {
                return new sVXDGSharedStrategy();
            }
            case 4: {
                return new sVXVLSharedStrategy();
            }
            case 1: {
                return new sDiskSharedStrategy();
            }
            case 14: {
                return new ACFSSharedStrategy();
            }
            case 13: {
                return new ASMSharedStrategy();
            }
        }
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Can't handle " + sStorageUtil.getTypeStr(type)));
        }
        throw new StorageException("7014", new String[]{sStorageUtil.getTypeStr(type)});
    }

    static SharedVerifyStrategy getSharedVerifyStrategy(int type) throws StorageException {
        switch (type) {
            case 5: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)"FSSharedVerifyStrategy chosen for TYPE_FILESYSTEM.");
                }
                return new FSSharedVerifyStrategy();
            }
            case 4: {
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)"sVXVLSharedVerifyStrategy chosen.");
                }
                return new sVXVLSharedVerifyStrategy();
            }
            case 3: {
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)"sVXDGSharedVerifyStrategy chosen.");
                }
                return new sVXDGSharedVerifyStrategy();
            }
            case 2: {
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)"FSSharedVerifyStrategy chosen.");
                }
                return new SharedVerifyStrategy();
            }
            case 1: {
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)"sDiskSharedVerifyStrategy chosen.");
                }
                return new sDiskSharedVerifyStrategy();
            }
            case 14: {
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)"FSSharedVerifyStrategy chosen for TYPE_ACFS.");
                }
                return new FSSharedVerifyStrategy();
            }
            case 13: {
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)"ASMSharedVerifyStrategy chosen for TYPE_ASMDISKGROUP.");
                }
                return new ASMSharedVerifyStrategy();
            }
        }
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Can't handle " + sStorageUtil.getTypeStr(type)));
        }
        throw new StorageException("7014", new String[]{sStorageUtil.getTypeStr(type)});
    }
}

