/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.StorageType;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.nodemgr.NodeManagerFactoryException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.StorageUtil;
import oracle.ops.verification.framework.storage.sDisk;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sStorageUtil
implements StorageConstants {
    private static String m_localHost = null;
    private static boolean RAW_ENABLED;
    private static int[] s_nonDiscoverableTypes;
    protected static MessageBundle s_gMsgBundle;
    private static String AFD_DISKS_LOC;

    public boolean isTypeValid(int type) {
        return type > 0;
    }

    public static int[] getDiscoveryTypes() {
        return sStorageUtil.getDiscoveryTypes(OracleFileType.RAC_DATA_FILES, "12.2", false);
    }

    public static int[] getDiscoveryTypes(OracleFileType fileType, String release, boolean considerASMStorage) {
        Trace.out((String)("fileType=" + fileType.name() + "; release=" + release + "; considerASMStorage=" + considerASMStorage + "; RAW_ENABLED=" + RAW_ENABLED));
        Object discoveryTypes = null;
        ArrayList<Integer> discoveryTypesList = new ArrayList<Integer>();
        int[] supportedTypes = sStorageUtil.getSupportedFileTypes(fileType, release, considerASMStorage);
        Trace.out((String)("s_nonDiscoverableTypes=" + StorageUtil.getTypesListByStr(s_nonDiscoverableTypes)));
        for (int supportedType : supportedTypes) {
            boolean isDiscoverable = true;
            for (int nonDiscoverableType : s_nonDiscoverableTypes) {
                if (supportedType != nonDiscoverableType) continue;
                Trace.out((String)("Removing type " + StorageUtil.getTypeStr(supportedType) + " from list of discoverable types"));
                isDiscoverable = false;
                break;
            }
            if (!isDiscoverable) continue;
            discoveryTypesList.add(new Integer(supportedType));
        }
        if (considerASMStorage && RAW_ENABLED && !VerificationUtil.isVersionPre(release, "12") && (fileType == OracleFileType.RAC_OCR_VDISK || fileType == OracleFileType.RAC_DATA_FILES)) {
            Trace.out((String)"TYPE_DISK is being added to discovery list, if not there.");
            if (!discoveryTypesList.contains(new Integer(1))) {
                discoveryTypesList.add(new Integer(1));
            }
        }
        int[] discoveryTypesArr = new int[discoveryTypesList.size()];
        int i = 0;
        for (Integer discoveryType : discoveryTypesList) {
            discoveryTypesArr[i++] = discoveryType;
        }
        Trace.out((String)("Returning discovery types=" + StorageUtil.getTypesListByStr(discoveryTypesArr)));
        return discoveryTypesArr;
    }

    public static int[] getSupportedFileTypes(OracleFileType fileType, String release, boolean considerASMStorage) {
        Trace.out((String)("fileType=" + fileType.name() + "; release=" + release + "; considerASMStorage=" + considerASMStorage));
        int[] supportedFileTypes = new int[]{};
        boolean bc = false;
        try {
            bc = NodeManagerFactory.getInstance().getNodeManager().isBigCluster();
        }
        catch (NodeManagerFactoryException e) {
            Trace.out((String)"Ignored exception: %s: %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
        }
        switch (fileType) {
            case ASM: {
                return new int[]{1, 4, 2};
            }
            case RAC_OCR_VDISK: {
                if (VerificationUtil.isVersionPre(release, "11.2")) {
                    supportedFileTypes = new int[]{2, 1, 4, 17, 15, 16};
                    break;
                }
                if (VerificationUtil.isVersionPre(release, "12")) {
                    supportedFileTypes = new int[]{2, 1, 4, 13, 17, 15, 16};
                    break;
                }
                if (!bc) {
                    supportedFileTypes = new int[]{2, 13, 17, 15, 16};
                    break;
                }
                supportedFileTypes = new int[]{2, 13};
                break;
            }
            case RAC_SOFTWARE: 
            case SI_SOFTWARE: {
                if (VerificationUtil.isVersionPre(release, "11.2")) {
                    supportedFileTypes = new int[]{2, 5};
                    break;
                }
                if (VerificationUtil.isVersionPre(release, "12")) {
                    supportedFileTypes = new int[]{2, 17, 15, 16, 14, 5};
                    break;
                }
                supportedFileTypes = new int[]{2, 14, 17, 5};
                break;
            }
            case RAC_DATA_FILES: {
                supportedFileTypes = VerificationUtil.isVersionPre(release, "11.2") ? new int[]{2, 1, 4, 13, 17} : (VerificationUtil.isVersionPre(release, "12") ? new int[]{2, 1, 4, 13, 17, 15, 16} : new int[]{2, 13, 17, 15, 16, 14});
            }
        }
        Trace.out((String)("Supported storage types for '" + fileType.name() + "' in release '" + release + "' =" + StorageUtil.getTypesListByStr(supportedFileTypes)));
        return supportedFileTypes;
    }

    public static String getTypeStr(int type) {
        return StorageUtil.getTypeStr(type);
    }

    public static StorageType getTypeEnum(int type) {
        return StorageUtil.getTypeEnum(type);
    }

    public static int getTypeByStr(String str) throws StorageException {
        return StorageUtil.getTypeByStr(str);
    }

    protected static String getLocalHost() throws StorageException {
        if (null == m_localHost) {
            m_localHost = VerificationUtil.getLocalNode();
        }
        return m_localHost;
    }

    public static int getNumDiskPartitions(StorageInfo stInfo) {
        if (stInfo.getType() == 1) {
            return ((sDisk)stInfo).getNumPartitions();
        }
        return -1;
    }

    public static Result processASMStamp(String stamp) {
        String node = VerificationUtil.getLocalNode();
        ResultSet rsltSet = sStorageUtil.processASMStamp(new String[]{node}, stamp);
        return rsltSet.getResult(node);
    }

    public static ResultSet processASMStamp(String[] nodeList, String stamp) {
        String localNode = VerificationUtil.getLocalNode();
        Result result = new Result(localNode);
        ErrorDescription errDesc = null;
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet stampDevResSet = new ResultSet();
        if (stamp == null || stamp.trim().length() == 0) {
            errDesc = new ErrorDescription(s_gMsgBundle.getMessage("10530", false, (Object[])new String[]{stamp}));
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            stampDevResSet.addResult(localNode, result);
            return stampDevResSet;
        }
        if (stamp.startsWith("/dev/oracleasm/disks/")) {
            String labelName = "";
            labelName = stamp.replaceAll("/dev/oracleasm/disks/", "");
            if (VerificationUtil.isStringGood(labelName)) {
                stamp = labelName;
            }
        }
        globalExec.checkAsmStamp(nodeList, stamp, stampDevResSet);
        for (String node : nodeList) {
            Result sdResult = (Result)stampDevResSet.getResultTable().get(node);
            if (sdResult.getStatus() == 1) continue;
            errDesc = sdResult.getStatus() == 3 ? (VerificationUtil.isPlatformLinux() ? new ErrorDescription(s_gMsgBundle.getMessage("10523", true, (Object[])new String[]{stamp})) : new ErrorDescription(s_gMsgBundle.getMessage("10520", true, (Object[])new String[]{stamp, node}), s_gMsgBundle, "10520")) : (VerificationUtil.isPlatformLinux() ? new ErrorDescription(s_gMsgBundle.getMessage("10524", true, (Object[])new String[]{stamp})) : new ErrorDescription(s_gMsgBundle.getMessage("10521", true, (Object[])new String[]{stamp, node}), s_gMsgBundle, "10521"));
            sdResult.addErrorDescription(errDesc);
        }
        return stampDevResSet;
    }

    public static List<String> getAFDLabels() {
        ArrayList<String> labels = null;
        File disksDir = new File(AFD_DISKS_LOC);
        if (disksDir.exists() && disksDir.isDirectory()) {
            labels = new ArrayList<String>(Arrays.asList(disksDir.list()));
        }
        return labels;
    }

    static {
        s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
        AFD_DISKS_LOC = "/var/opt/oracle/oracleafd/disks";
        RAW_ENABLED = StorageUtil.isRawDiscoveryEnabled();
        s_nonDiscoverableTypes = RAW_ENABLED ? new int[]{17, 5, 15, 16} : new int[]{17, 5, 15, 16, 1, 4};
    }
}

