/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.mgmt.command.util.RemoteExecCommand;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.storage.CommandHandler;
import oracle.ops.verification.framework.storage.FSInfo;
import oracle.ops.verification.framework.storage.NFSInfo;
import oracle.ops.verification.framework.storage.NonSharedFileSystemException;
import oracle.ops.verification.framework.storage.PathDiskInfo;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.sDisk;
import oracle.ops.verification.framework.storage.sStorageUtil;
import oracle.ops.verification.framework.storage.sVXDGInfo;
import oracle.ops.verification.framework.storage.sVXVLInfo;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.AccessDeniedException;
import oracle.ops.verification.util.ExecutableNotFoundException;
import oracle.ops.verification.util.GenericUtil;
import oracle.ops.verification.util.ParsingException;

class sCommandHandler
extends CommandHandler {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    static final String VXDG_LOC = "/usr/sbin/";
    static final String MOUNT_LOC = "/usr/sbin/";
    static final String IOSTAT_LOC = "/usr/bin/";
    static final String EGREP_LOC = "/usr/local/bin/";
    static final String GREP_LOC = "/usr/local/bin/";
    static final String GREP = "/bin/grep";
    static final String MTAB_LOC = "/etc/mtab";

    sCommandHandler() {
    }

    static String makeEnglishUnixCmd(String cmd) {
        String SHELL_CMD = "/bin/sh -c ";
        String LANG_VARS = "LC_ALL=C; export LC_ALL; LANG=en;export LANG;";
        return "'/bin/sh -c \"LC_ALL=C; export LC_ALL; LANG=en;export LANG;" + cmd + "\"" + "'";
    }

    @Override
    StorageInfo parseTypeResult(VerificationCommand cmd, String path) throws StorageException {
        int exitCode = cmd.getVfyCode();
        if (18 == exitCode) {
            Trace.out((String)("_st_:exitcode wasn't zero:" + String.valueOf(exitCode)));
            throw new NonSharedFileSystemException("7015");
        }
        if (0 != exitCode) {
            Trace.out((String)("_st_:exitcode wasn't zero:" + String.valueOf(exitCode)));
            throw new StorageException("7009");
        }
        try {
            String storageStr = cmd.getOutput();
            int access = -1;
            String realPath = GenericUtil.getValueByKey(storageStr, "REALPATH");
            String prefName = GenericUtil.getValueByKey(storageStr, "PREFNAME");
            String typeStr = GenericUtil.getValueByKey(storageStr, "STTYPE");
            String accessStr = GenericUtil.getValueByKey(storageStr, "ACCESS");
            if (accessStr == null) {
                accessStr = "-1";
            }
            try {
                access = Integer.parseInt(accessStr);
            }
            catch (NumberFormatException nfe) {
                Trace.out((String)("Access value unknown: '" + accessStr + "'"));
                access = -1;
            }
            Trace.out((String)("Adding Access: '" + access + "' for path '" + path + "'"));
            int type = sStorageUtil.getTypeByStr(typeStr);
            StorageInfo stInfo = new StorageInfo(prefName, cmd.getNode(), realPath, type, path, access);
            Trace.out((String)("_st_:type is --> " + stInfo));
            return stInfo;
        }
        catch (Exception e) {
            Trace.out((String)"_st_:parsing gettype failed");
            throw new StorageException(e);
        }
    }

    @Override
    public RemoteExecCommand genInfoCmd(String node, int type) throws StorageException {
        switch (type) {
            case 1: {
                return this.genDiskInfoCmd(node);
            }
            case 2: {
                return this.genNFSInfoCmd(node);
            }
            case 3: {
                return this.genVXDGInfoCmd(node);
            }
            case 4: {
                return this.genVXVLInfoCmd(node);
            }
            case 5: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                return null;
            }
        }
        Trace.out((String)("_st_:genInfoCmd: Can't handle " + sStorageUtil.getTypeStr(type)));
        throw new StorageException();
    }

    @Override
    public RemoteExecCommand genInfoCmd(String node, int type, String path) throws StorageException {
        return this.genInfoCmd(node, type, path, null);
    }

    public RemoteExecCommand genInfoCmd(String node, int type, String path, Result result) throws StorageException {
        switch (type) {
            case 1: {
                return this.genDiskInfoCmd(node, path, result);
            }
            case 2: {
                return this.genNFSInfoCmd(node, path, result);
            }
            case 3: {
                return this.genVXDGInfoCmd(node, path, result);
            }
            case 4: {
                return this.genVXVLInfoCmd(node, path, result);
            }
            case 5: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                return this.genFSInfoCmd(node, path, result);
            }
        }
        Trace.out((String)("_st_:Don't know how to handle storage type " + sStorageUtil.getTypeStr(type)));
        throw new StorageException();
    }

    @Override
    public RemoteExecCommand genInfoCmd(String node, int type, String path, String realpath, Result result) throws StorageException {
        String cmdpath = realpath != null && !path.equals(realpath) ? realpath + "%" + path : path;
        return this.genInfoCmd(node, type, cmdpath, result);
    }

    RemoteExecCommand genFSInfoCmd(String node) {
        String[] args = new String[]{"-getstinfo", "-getfsinfo"};
        return new VerificationCommand(node, args, null);
    }

    RemoteExecCommand genVXDGInfoCmd(String node) {
        String[] args = new String[]{"-getstinfo", "-getVXDGInfo"};
        return new VerificationCommand(node, args, null);
    }

    RemoteExecCommand genVXDGInfoCmd(String node, String diskgroup) {
        String[] args = new String[]{"-getstinfo", "-getVXDGInfo", diskgroup};
        return new VerificationCommand(node, args, null);
    }

    RemoteExecCommand genVXDGInfoCmd(String node, String diskgroup, Result result) {
        String[] args = new String[]{"-getstinfo", "-getVXDGInfo", diskgroup};
        return new VerificationCommand(node, args, null, result);
    }

    RemoteExecCommand genVXVLInfoCmd(String node) {
        String[] args = new String[]{"-getstinfo", "-getVXVLInfo"};
        return new VerificationCommand(node, args, null);
    }

    RemoteExecCommand genVXVLInfoCmd(String node, String vxvolume) {
        String[] args = new String[]{"-getstinfo", "-getVXVLInfo", vxvolume};
        return new VerificationCommand(node, args, null);
    }

    RemoteExecCommand genVXVLInfoCmd(String node, String vxvolume, Result result) {
        String[] args = new String[]{"-getstinfo", "-getVXVLInfo", vxvolume};
        return new VerificationCommand(node, args, null, result);
    }

    RemoteExecCommand genFSInfoCmd(String node, String path) {
        String[] args = new String[]{"-getstinfo", "-getfsinfo", path};
        return new VerificationCommand(node, args, null);
    }

    RemoteExecCommand genFSInfoCmd(String node, String path, Result result) {
        String[] args = new String[]{"-getstinfo", "-getfsinfo", path};
        return new VerificationCommand(node, args, null, result);
    }

    RemoteExecCommand genNFSInfoCmd(String node) {
        String[] args = new String[]{"-getstinfo", "-getnfsinfo"};
        return new VerificationCommand(node, args, null);
    }

    RemoteExecCommand genNFSInfoCmd(String node, String path) {
        String[] args = new String[]{"-getstinfo", "-getnfsinfo", path};
        return new VerificationCommand(node, args, null);
    }

    RemoteExecCommand genNFSInfoCmd(String node, String path, Result result) {
        String[] args = new String[]{"-getstinfo", "-getnfsinfo", path};
        return new VerificationCommand(node, args, null, result);
    }

    RemoteExecCommand genDiskInfoCmd(String node) {
        String[] args = new String[]{"-getstinfo", "-getdiskinfo"};
        VerificationCommand vfyCmd = new VerificationCommand(node, args, null);
        return vfyCmd;
    }

    RemoteExecCommand genDiskInfoCmd(String node, String path) {
        String[] args = new String[]{"-getstinfo", "-getdiskinfo", path};
        VerificationCommand vfyCmd = new VerificationCommand(node, args, null);
        return vfyCmd;
    }

    RemoteExecCommand genDiskInfoCmd(String node, String path, Result result) {
        String[] args = new String[]{"-getstinfo", "-getdiskinfo", path};
        VerificationCommand vfyCmd = new VerificationCommand(node, args, null, result);
        return vfyCmd;
    }

    @Override
    public StorageInfo parseStorageInfoResult(RemoteExecCommand remCmd, String path) throws StorageException {
        StorageInfo stinfo = null;
        String node = remCmd.getNode();
        String realPath = null;
        String prefName = null;
        String typeStr = null;
        String accessStr = null;
        int access = -1;
        VerificationCommand vfyCmd = null;
        int exitCode = 0;
        vfyCmd = (VerificationCommand)remCmd;
        exitCode = vfyCmd.getVfyCode();
        String result = vfyCmd.getOutput();
        if (18 == exitCode) {
            Trace.out((String)("_st_:exitcode wasn't zero:" + String.valueOf(exitCode)));
            throw new NonSharedFileSystemException("7015");
        }
        if (0 != exitCode) {
            Trace.out((String)("_st_:exitcode wasn't zero:" + String.valueOf(exitCode)));
            String cverrString = null;
            String osErrs = null;
            cverrString = remCmd.getCommandResult().getErrorString();
            String slosErr = VerificationUtil.fetchError(cverrString);
            try {
                osErrs = GenericUtil.getMidStrNoCase(cverrString, "SLOS_LOCINFOSTR");
            }
            catch (ParsingException pe) {
                Trace.out((String)("PARSINGEXCEPTION: " + pe.getMessage()));
                osErrs = cverrString;
            }
            Trace.out((String)("\ncverrString:'" + cverrString + "'\nslosErr:'" + slosErr + "'\nosErrs: '" + osErrs + "'"));
            String execTaskOutput = null;
            String execErrorMsg = null;
            execTaskOutput = vfyCmd.getExectaskOutput();
            Trace.out((String)("execTaskOutput=" + VerificationConstants.LSEP + execTaskOutput + VerificationConstants.LSEP));
            if (VerificationUtil.isStringGood(execTaskOutput)) {
                execErrorMsg = VerificationUtil.fetchExecutionDetailsMessage(node, execTaskOutput);
            }
            Trace.out((String)("execErrorMsg=" + execErrorMsg));
            if (VerificationUtil.isStringGood(execErrorMsg)) {
                throw new StorageException("7009", VerificationConstants.LSEP + execErrorMsg);
            }
            throw new StorageException("7009");
        }
        try {
            realPath = GenericUtil.getValueByKey(result, "REALPATH");
            prefName = GenericUtil.getValueByKey(result, "PREFNAME");
            typeStr = GenericUtil.getValueByKey(result, "STTYPE");
            accessStr = GenericUtil.getValueByKey(result, "ACCESS");
            if (accessStr == null) {
                accessStr = "-1";
            }
            try {
                access = Integer.parseInt(accessStr);
            }
            catch (NumberFormatException nfe) {
                Trace.out((String)("Access value unknown: '" + accessStr + "'"));
                access = -1;
            }
            Trace.out((String)("Adding Access: '" + access + "' for path '" + path + "'"));
        }
        catch (Exception e) {
            Trace.out((String)"_st_:parsing gettype failed");
            throw new StorageException(e);
        }
        int type = sStorageUtil.getTypeByStr(typeStr);
        stinfo = this.parseInfoResult(remCmd, type, prefName);
        if (null == stinfo) {
            Trace.out((String)("_st_:_st_:couldn't find " + path + " in : " + result));
        } else {
            stinfo.setName(prefName);
            stinfo.setPath(realPath);
            stinfo.setAccess(access);
            stinfo.setOrigPath(path);
        }
        return stinfo;
    }

    @Override
    public Vector parseInfoResult(RemoteExecCommand remCmd, int type) throws StorageException {
        Vector retVector = new Vector();
        String[] resultLines = remCmd.getCommandResult().getResultString();
        String node = remCmd.getNode();
        if (null == resultLines) {
            Trace.out((String)("_st_:remoteExecCmd" + remCmd + " on node " + node + " contained no resulting strings"));
            return null;
        }
        switch (type) {
            case 1: {
                this.parseDiskInfo(remCmd, node, retVector);
                break;
            }
            case 2: {
                this.parseNFSInfo(remCmd, node, retVector);
                break;
            }
            case 3: {
                this.parseVXDGInfo(remCmd, node, retVector);
                break;
            }
            case 4: {
                this.parseVXVLInfo(remCmd, node, retVector);
                break;
            }
            default: {
                Trace.out((String)("_st_:parseInfoResult: Can't handle " + sStorageUtil.getTypeStr(type)));
                throw new StorageException();
            }
        }
        return retVector;
    }

    @Override
    public StorageInfo parseInfoResult(RemoteExecCommand remCmd, int type, String path) throws StorageException {
        StorageInfo st;
        String node = remCmd.getNode();
        String[] resultLines = remCmd.getCommandResult().getResultString();
        Trace.out((String)("Storage type=" + type + ", Storage path=" + path));
        if (null == resultLines) {
            Trace.out((String)("_st_:remExecCmd" + remCmd + " on " + node + " had no result str"));
            return null;
        }
        switch (type) {
            case 1: {
                st = this.parseDiskByName(remCmd, node, path);
                break;
            }
            case 2: {
                st = this.parseNFSInfo(remCmd, node, path);
                break;
            }
            case 3: {
                st = this.parseVXDGInfo(remCmd, node, path);
                break;
            }
            case 4: {
                st = this.parseVXVLInfo(remCmd, node, path);
                break;
            }
            case 5: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                st = this.parseFSInfo(remCmd, node, path, type);
                break;
            }
            default: {
                Trace.out((String)("_st_:parseInfoResult: Can't handle " + sStorageUtil.getTypeStr(type)));
                throw new StorageException();
            }
        }
        if (null == st) {
            Trace.out((String)("_st_:_st_:couldn't find " + path + " in lines: "));
            for (int i = 0; i < resultLines.length; ++i) {
                Trace.out((String)("_st_:" + resultLines[i]));
            }
        }
        return st;
    }

    private void parseVXDGInfo(RemoteExecCommand cmd, String node, Vector retSet) throws StorageException {
        String currLine = null;
        String name = null;
        String dgid = null;
        sVXDGInfo dginfo = null;
        VerificationCommand vfyCmd = (VerificationCommand)cmd;
        int vfyCode = vfyCmd.getVfyCode();
        if (vfyCode != 0) {
            Trace.out((String)("parseVXVLInfo failure with VfyCode " + vfyCode));
            return;
        }
        String output = vfyCmd.getOutput();
        Trace.out((String)("Successfully executed VXVLInfo command. Output is:" + output));
        Trace.out((String)("parseVXVLInfo " + node));
        String[] resultLines = output.split("\n");
        Trace.out((String)("parseVXDGInfo " + node));
        try {
            for (int i = 0; i < resultLines.length; ++i) {
                currLine = resultLines[i];
                StringTokenizer stLine = new StringTokenizer(currLine);
                stLine.nextToken();
                name = stLine.nextToken();
                stLine.nextToken();
                stLine.nextToken();
                stLine.nextToken();
                dgid = stLine.nextToken();
                dginfo = new sVXDGInfo(name, node, dgid);
                Trace.out((String)("_st_:added " + dginfo));
                retSet.add(dginfo);
            }
        }
        catch (Exception e) {
            Trace.out((String)("The last line caused an exception: " + name));
            throw new StorageException("7001", e);
        }
    }

    private sVXDGInfo parseVXDGInfo(RemoteExecCommand cmd, String node, String name) throws StorageException {
        Vector retSet = new Vector();
        String[] resultLines = cmd.getCommandResult().getResultString();
        sVXDGInfo dginfo = null;
        Trace.out((String)("parseVXDGInfo : node=" + node + "name=" + name));
        this.parseVXDGInfo(cmd, node, retSet);
        if (retSet.size() > 1) {
            Trace.out((String)("ERROR : More than 1 DG found with name = " + name));
        }
        if ((dginfo = (sVXDGInfo)retSet.lastElement()) == null) {
            Trace.out((String)("_st_:Could not find " + name + " in resultLines: "));
            for (int i = 0; i < resultLines.length; ++i) {
                Trace.out((String)("_st_:" + resultLines[i]));
            }
        }
        return dginfo;
    }

    private void parseVXVLInfo(RemoteExecCommand cmd, String node, Vector retSet) throws StorageException {
        String currLine = null;
        String name = null;
        String vlid = null;
        sVXVLInfo vlinfo = null;
        VerificationCommand vfyCmd = (VerificationCommand)cmd;
        int vfyCode = vfyCmd.getVfyCode();
        if (vfyCode != 0) {
            Trace.out((String)("parseVXVLInfo failure with VfyCode " + vfyCode));
            return;
        }
        String output = vfyCmd.getOutput();
        Trace.out((String)("Successfully executed VXVLInfo command. Output is:" + output));
        Trace.out((String)("parseVXVLInfo " + node));
        String[] resultLines = output.split("\n");
        try {
            for (int i = 0; i < resultLines.length; ++i) {
                currLine = resultLines[i];
                StringTokenizer stLine = new StringTokenizer(currLine);
                stLine.nextToken();
                name = stLine.nextToken();
                vlid = GenericUtil.getNextStrNoCase(resultLines[i], "guid=", null);
                vlinfo = new sVXVLInfo(name, node, vlid);
                Trace.out((String)("_st_:added " + vlinfo));
                retSet.add(vlinfo);
            }
        }
        catch (Exception e) {
            Trace.out((String)("The last line caused an exception: " + name));
            throw new StorageException("7001", e);
        }
    }

    private sVXVLInfo parseVXVLInfo(RemoteExecCommand cmd, String node, String name) throws StorageException {
        Vector retSet = new Vector();
        String[] resultLines = cmd.getCommandResult().getResultString();
        sVXVLInfo vlinfo = null;
        Trace.out((String)("parseVXVLInfo by name: node=" + node + ", name=" + name));
        this.parseVXVLInfo(cmd, node, retSet);
        if (retSet.size() > 1) {
            Trace.out((String)("ERROR : Found more than one entry for " + name));
        }
        if ((vlinfo = (sVXVLInfo)retSet.lastElement()) == null) {
            Trace.out((String)("_st:could not find " + name + " in lines : "));
            for (int i = 0; i < resultLines.length; ++i) {
                Trace.out((String)("_st:" + resultLines[i]));
            }
        }
        return vlinfo;
    }

    private void parseNFSInfo(RemoteExecCommand cmd, String node, Vector retSet) throws StorageException {
        Vector nfsStrings = null;
        Trace.out((String)("ENTRY: Node: " + node));
        VerificationCommand vfyCmd = (VerificationCommand)cmd;
        int vfyCode = vfyCmd.getVfyCode();
        if (0 != vfyCode) {
            return;
        }
        String output = vfyCmd.getOutput();
        try {
            nfsStrings = GenericUtil.getAllStrByTags(output, "MOUNT");
        }
        catch (ParsingException pe) {
            Trace.out((String)("Problem parsing the string " + output));
            Trace.out((String)pe.getMessage());
            throw new StorageException();
        }
        for (String nfsStr : nfsStrings) {
            NFSInfo nfsInfo = this.parseNFSInfo(nfsStr, node, null);
            retSet.add(nfsInfo);
        }
        Trace.out((String)("Found " + retSet.size() + " NFS mount points on " + node));
    }

    private NFSInfo parseNFSInfo(RemoteExecCommand cmd, String node, String path) throws StorageException {
        NFSInfo nfsInfo = null;
        Trace.out((String)("Parsing NFSInfo for path " + path));
        VerificationCommand vfyCmd = (VerificationCommand)cmd;
        int vfyCode = vfyCmd.getVfyCode();
        if (0 == vfyCode) {
            String output = vfyCmd.getOutput();
            Trace.out((String)("Successfully executed NFSInfo command. Output is:" + output));
            nfsInfo = this.parseNFSInfo(output, node, path);
        } else {
            Trace.out((String)("VfyCode is " + vfyCode));
        }
        return nfsInfo;
    }

    private NFSInfo parseNFSInfo(String mntStr, String node, String path) throws StorageException {
        String pathOnServer;
        String server;
        Trace.out((String)"ENTRY");
        StringBuffer mntDevBuf = new StringBuffer();
        StringBuffer mntDirBuf = new StringBuffer();
        StringBuffer mntOptsBuf = new StringBuffer();
        StringBuffer fsTypeBuf = new StringBuffer();
        this.parseMount(mntStr, mntDevBuf, mntDirBuf, mntOptsBuf, fsTypeBuf);
        String strMntDevBuf = mntDevBuf.toString();
        String strMntDirBuf = mntDirBuf.toString();
        if (-1 != strMntDevBuf.indexOf(58)) {
            StringTokenizer stColon = new StringTokenizer(mntDevBuf.toString(), ":");
            try {
                server = stColon.nextToken();
                pathOnServer = stColon.nextToken();
            }
            catch (NoSuchElementException e) {
                Trace.out((String)("NOSUCHELEMENTEXCEPTION: " + e.getMessage()));
                Trace.out((String)("mntStr is" + mntStr));
                Trace.out((String)("mntDev is " + mntDevBuf));
                throw new StorageException(e);
            }
        } else if (strMntDirBuf.indexOf("/net/") != -1) {
            int srvStart = strMntDirBuf.indexOf("/net/");
            server = strMntDirBuf.substring(srvStart += 5, strMntDirBuf.lastIndexOf(47));
            pathOnServer = strMntDirBuf.substring(strMntDirBuf.lastIndexOf(47));
        } else {
            server = new String("local");
            pathOnServer = strMntDirBuf;
        }
        Trace.out((String)("server: '" + server + "' pathOnServer: '" + pathOnServer + "'"));
        FSInfo fsInfo = this.parseFSInfoInternal(mntStr, node, 2);
        String mntOpts = mntOptsBuf.toString();
        NFSInfo nfsInfo = null != path ? new NFSInfo(node, path, server, pathOnServer, mntOpts, fsInfo) : new NFSInfo(node, mntDirBuf.toString(), server, pathOnServer, mntOpts, fsInfo);
        Trace.out((String)("Found " + nfsInfo));
        return nfsInfo;
    }

    private FSInfo parseFSInfo(RemoteExecCommand cmd, String node, String path, int type) throws StorageException {
        Trace.out((String)("parseFSInfo: Node=" + node + " , Path=" + path));
        Vector retSet = new Vector();
        FSInfo fsInfo = null;
        int vfyCode = 0;
        String output = null;
        VerificationCommand vfyCmd = (VerificationCommand)cmd;
        vfyCode = vfyCmd.getVfyCode();
        if (0 == vfyCode) {
            output = vfyCmd.getOutput();
        }
        fsInfo = this.parseFSInfoInternal(output, node, type);
        return fsInfo;
    }

    private FSInfo parseFSInfoInternal(String output, String node, int type) throws StorageException {
        FSInfo fsInfo = null;
        String fsname = null;
        int fstype = 0;
        double fsbsize = 0.0;
        double fsblocks = 0.0;
        double fsbfree = 0.0;
        double fsbavail = 0.0;
        double fsfiles = 0.0;
        double fsfree = 0.0;
        int fsaccess = 0;
        Trace.out((String)("Prasing FSInfo string: " + output));
        try {
            fsname = GenericUtil.getMidStrNoCase(output, "FSNAME");
            fstype = Integer.parseInt(GenericUtil.getMidStrNoCase(output, "FSTYPE"));
            fsbsize = Double.parseDouble(GenericUtil.getMidStrNoCase(output, "FSBSIZE"));
            fsblocks = Double.parseDouble(GenericUtil.getMidStrNoCase(output, "FSBLOCKS"));
            fsbfree = Double.parseDouble(GenericUtil.getMidStrNoCase(output, "FSBFREE"));
            fsbavail = Double.parseDouble(GenericUtil.getMidStrNoCase(output, "FSBAVAIL"));
            fsfiles = Double.parseDouble(GenericUtil.getMidStrNoCase(output, "FSFILES"));
            fsfree = Double.parseDouble(GenericUtil.getMidStrNoCase(output, "FSFREE"));
            fsaccess = Integer.parseInt(GenericUtil.getMidStrNoCase(output, "FSACCESS"));
        }
        catch (ParsingException pe) {
            Trace.out((String)("Problem parsing the string " + output));
            Trace.out((Exception)pe);
            throw new StorageException();
        }
        catch (NumberFormatException nfe) {
            Trace.out((String)("Problem converting string to long in output: " + output));
            Trace.out((Exception)nfe);
            throw new StorageException();
        }
        fsInfo = new FSInfo(node, type, fsname, fstype, fsbsize, fsblocks, fsbfree, fsbavail, fsfiles, fsfree, fsaccess);
        fsInfo.setAccess(fsaccess);
        FSInfo stInfo = fsInfo;
        Trace.out((String)("\nStInfo Access: '" + stInfo.getAccess() + "' for StInfo Path '" + stInfo.getOrigPath() + "'\nFsInfo Access: '" + fsaccess + "' for FsInfo Path '" + fsname + "'"));
        return fsInfo;
    }

    private void parseMount(String mntStr, StringBuffer mntDevBuf, StringBuffer mntDirBuf, StringBuffer mntOptsBuf, StringBuffer fsTypeBuf) throws StorageException {
        String mntDev = null;
        String mntDir = null;
        String mntOpts = null;
        String fsType = null;
        try {
            mntDev = GenericUtil.getMidStrNoCase(mntStr, "MNT_DEV");
            mntDir = GenericUtil.getMidStrNoCase(mntStr, "MNT_DIR");
            mntOpts = GenericUtil.getMidStrNoCase(mntStr, "MNT_OPTS");
            fsType = GenericUtil.getMidStrNoCase(mntStr, "MNT_FSTYPE");
        }
        catch (ParsingException pe) {
            Trace.out((String)("Problem parsing the string " + mntStr));
            Trace.out((Exception)pe);
            throw new StorageException();
        }
        mntDevBuf.append(mntDev);
        mntDirBuf.append(mntDir);
        mntOptsBuf.append(mntOpts);
        fsTypeBuf.append(fsType);
    }

    sDisk parseDiskByName(RemoteExecCommand cmd, String node, String name) throws StorageException {
        sDisk disk = null;
        VerificationCommand vfyCmd = (VerificationCommand)cmd;
        int vfyCode = vfyCmd.getVfyCode();
        String output = vfyCmd.getOutput();
        if (0 == vfyCode && output != null) {
            disk = this.parseDisk(output, node);
        }
        if (10010 == vfyCode) {
            String msg = VerificationConstants.LSEP + s_msgBundle.getMessage("7017", true);
            ExecutableNotFoundException e = new ExecutableNotFoundException(msg);
            throw new StorageException("7017", node, null, e, true);
        }
        if (10013 == vfyCode) {
            String msg = VerificationConstants.LSEP + s_msgBundle.getMessage("7021", true);
            AccessDeniedException e2 = new AccessDeniedException(msg);
            throw new StorageException("7021", node, null, e2, true);
        }
        if (10011 == vfyCode || output == null) {
            Trace.out((String)"No disks found");
        }
        return disk;
    }

    private void parseDiskInfo(RemoteExecCommand cmd, String node, Vector retSet) throws StorageException {
        VerificationCommand vfyCmd = (VerificationCommand)cmd;
        int vfyCode = vfyCmd.getVfyCode();
        if (10010 == vfyCode) {
            String msg = VerificationConstants.LSEP + s_msgBundle.getMessage("7017", false);
            ExecutableNotFoundException e = new ExecutableNotFoundException(msg);
            StorageException se = new StorageException("7017", node, null, e, true);
            throw se;
        }
        if (10013 == vfyCode) {
            String msg = VerificationConstants.LSEP + s_msgBundle.getMessage("7021", false);
            AccessDeniedException e2 = new AccessDeniedException(msg);
            throw new StorageException("7021", node, null, e2, true);
        }
        if (0 != vfyCode) {
            Trace.out((String)("Warning: vfyCode =  " + String.valueOf(vfyCode)));
            return;
        }
        String output = vfyCmd.getOutput();
        if (!VerificationUtil.isStringGood(output) || !output.contains("DISK")) {
            Trace.out((String)("Tag <DISK> missing from output: contents of 'output': '" + (!VerificationUtil.isStringGood(output) ? "NULL" : output) + "'"));
            return;
        }
        try {
            Vector diskStrings = GenericUtil.getAllStrByTags(output, "DISK");
            Trace.out((String)("found " + diskStrings.size() + " disks " + "on node " + node));
            for (String diskStr : diskStrings) {
                sDisk diskInfo = this.parseDisk(diskStr, node);
                retSet.add(diskInfo);
            }
        }
        catch (ParsingException pe) {
            Trace.out((String)("Problem parsing the string " + output));
            Trace.out((Exception)pe);
            throw new StorageException();
        }
    }

    private sDisk parseDisk(String output, String node) throws StorageException {
        sDisk diskInfo;
        String[] diskTags = new String[]{"DISK_NAME", "DISK_SIGNATURE", "NUMPARTS", "DISK_STATE", "DISK_SIZE", "DISK_OWNER", "DISK_GROUP", "DISK_PERMISSIONS"};
        try {
            String[] diskFields = GenericUtil.getFieldsByTags(output, diskTags);
            diskInfo = new sDisk(diskFields[0], node, diskFields[1]);
            diskInfo.setSize(new StorageSize(Double.parseDouble(diskFields[4]) / 1024.0, StorageUnit.KBYTE));
            diskInfo.setNumPartitions(new Integer(diskFields[2]));
            diskInfo.setOwner(diskFields[5]);
            diskInfo.setGroup(diskFields[6]);
            diskInfo.setPermissions(diskFields[7]);
            for (int j = 0; j < diskFields.length; ++j) {
                Trace.out((String)("diskFields[" + j + "] = >" + diskFields[j] + "<"));
            }
            Trace.out((String)(diskInfo + " state:" + diskFields[3] + "|as int" + String.valueOf(Integer.parseInt(diskFields[3]))));
            if (1 == Integer.parseInt(diskFields[3])) {
                Trace.out((String)(diskInfo + " on node " + diskInfo.getNode() + " has a bad signature:" + diskInfo.getSignature()));
                diskInfo.setSignatureStatus(false);
            }
        }
        catch (ParsingException pe) {
            Trace.out((String)("Problem parsing the string " + output));
            Trace.out((Exception)pe);
            throw new StorageException();
        }
        return diskInfo;
    }

    @Override
    public PathDiskInfo parseDiskDetailResult(String node, VerificationCommand vfyCmd, String path) throws StorageException {
        Trace.out((String)"Not Supported on Unix");
        return null;
    }
}

