/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageType;
import oracle.ops.verification.framework.engine.Entity;
import oracle.ops.verification.framework.engine.EntityStatus;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.storage.AccessControl;
import oracle.ops.verification.framework.storage.DiskData;
import oracle.ops.verification.framework.storage.StorageCheckContext;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageData;
import oracle.ops.verification.framework.storage.StorageDataHandler;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.sStorageUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TypeFinder
implements StorageConstants {
    String LSEP = System.getProperty("line.separator");

    public StorageInfo getStorageInstance(String path) throws StorageException {
        String localNode = sStorageUtil.getLocalHost();
        return this.getStorageInstance(path, localNode);
    }

    public StorageInfo getStorageInstance(String path, String node) throws StorageException {
        String[] nodeArray = new String[]{node};
        List<StorageInfo> stList = this.getStorageInstance(path, nodeArray);
        return stList.get(0);
    }

    public List<StorageInfo> getStorageInstance(String path, String[] nodeArray) throws StorageException {
        VerificationUtil.traceAndLog("path='%s' ; nodeArray='%s'", path, VerificationUtil.strArr2List(nodeArray));
        ArrayList<StorageInfo> siList = new ArrayList<StorageInfo>();
        ArrayList errDescList = new ArrayList();
        StorageCheckContext scCtx = new StorageCheckContext();
        StorageDataHandler sdHndlr = new StorageDataHandler(scCtx);
        HashMap<String, StorageData> nodeSDmap = sdHndlr.getStorageData(path, nodeArray);
        this.nodeSDmap2SIcol(nodeSDmap, siList);
        return siList;
    }

    public void nodeSDmap2SIcol(HashMap<String, StorageData> nodeSDmap, Collection<StorageInfo> stInfoCol) throws StorageException {
        ArrayList<ErrorDescription> errDescList = new ArrayList<ErrorDescription>();
        this.nodeSDmap2SIcol(nodeSDmap, stInfoCol, errDescList);
        for (StorageInfo stInfo : stInfoCol) {
            if (stInfo.getType() != -1) continue;
            VerificationUtil.traceAndLog("Throwing StorageException with '%s' error messages", errDescList.size());
            throw new StorageException(VerificationUtil.errDescCol2errMsgStr(errDescList));
        }
    }

    public void nodeSDmap2SIcol(HashMap<String, StorageData> nodeSDmap, Collection<StorageInfo> stInfoCol, List<ErrorDescription> errDescList) {
        for (String node : nodeSDmap.keySet()) {
            StorageData stData = nodeSDmap.get(node);
            StorageInfo stInfo = this.stData2stInfo(stData, node);
            if (stData.hasErrors()) {
                errDescList.addAll(stData.getErrors());
            }
            if (stInfo == null) continue;
            stInfoCol.add(stInfo);
        }
    }

    public StorageInfo stData2stInfo(StorageData stData, String node) {
        Entity<AccessControl> stAccessEntity;
        Entity<StorageSize> stFreeSpaceEntity;
        Entity<StorageSize> stSizeEntity;
        VerificationUtil.traceAndLog("StorageData for node '" + node + "' is :" + this.LSEP + stData.toString());
        StorageInfo stInfo = new StorageInfo();
        stInfo.setNode(node);
        stInfo.setName(stData.getID());
        stInfo.setPath(stData.getEffectiveID());
        stInfo.setOrigPath(stData.getSuppliedID());
        stInfo.setSignature(stData.getSignatureString());
        Entity<StorageType> stTypeEntity = stData.getStorageType();
        if (stTypeEntity != null && stTypeEntity.getStatus() == EntityStatus.VALID) {
            stInfo.setType(StorageDataHandler.getTypeIntFromEnum(stTypeEntity.getValue()));
        }
        if ((stSizeEntity = stData.getStorageSize()) != null && stSizeEntity.getStatus() == EntityStatus.VALID) {
            stInfo.setSize(stSizeEntity.getValue());
        }
        if ((stFreeSpaceEntity = stData.getFreeSpace()) != null && stFreeSpaceEntity.getStatus() == EntityStatus.VALID) {
            stInfo.setFree(stFreeSpaceEntity.getValue());
        }
        if ((stAccessEntity = stData.getStorageAccess()) != null && stAccessEntity.getStatus() == EntityStatus.VALID) {
            AccessControl accessCtrl = stAccessEntity.getValue();
            stInfo.setOwner(accessCtrl.getOwner());
            stInfo.setGroup(accessCtrl.getGroup());
            stInfo.setPermissions(accessCtrl.getPerms());
        }
        if (stData instanceof DiskData) {
            stInfo.setPolicy(((DiskData)stData).isPolicySet());
            stInfo.setLock(((DiskData)stData).isLockSet());
            stInfo.setDiskScheduler(((DiskData)stData).getDiskScheduler());
        }
        VerificationUtil.traceAndLog("StorageInfo being returned is :" + this.LSEP + stInfo.toString());
        return stInfo;
    }
}

