/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageType;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.VerificationError;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Entity;
import oracle.ops.verification.framework.engine.EntityStatus;
import oracle.ops.verification.framework.engine.EntityType;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.factory.context.GlobalVerificationContext;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzerFactory;
import oracle.ops.verification.framework.storage.ACFSData;
import oracle.ops.verification.framework.storage.ASMDGData;
import oracle.ops.verification.framework.storage.AccessControl;
import oracle.ops.verification.framework.storage.DiskData;
import oracle.ops.verification.framework.storage.FSDetails;
import oracle.ops.verification.framework.storage.GPFSData;
import oracle.ops.verification.framework.storage.LvmDGData;
import oracle.ops.verification.framework.storage.LvmLVData;
import oracle.ops.verification.framework.storage.NFSData;
import oracle.ops.verification.framework.storage.NativeFSData;
import oracle.ops.verification.framework.storage.OCFS2Data;
import oracle.ops.verification.framework.storage.OCFSData;
import oracle.ops.verification.framework.storage.PartitionData;
import oracle.ops.verification.framework.storage.PathDiskInfo;
import oracle.ops.verification.framework.storage.QFSData;
import oracle.ops.verification.framework.storage.SAMFSData;
import oracle.ops.verification.framework.storage.StorageCheckContext;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageData;
import oracle.ops.verification.framework.storage.StorageDataHandler;
import oracle.ops.verification.framework.storage.StorageSignature;
import oracle.ops.verification.framework.storage.StorageUtil;
import oracle.ops.verification.framework.storage.TMPFSData;
import oracle.ops.verification.framework.storage.VxDGData;
import oracle.ops.verification.framework.storage.VxFSData;
import oracle.ops.verification.framework.storage.VxVLData;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.GenericUtil;
import oracle.ops.verification.util.ParsingException;

public class StorageDataParser
implements VerificationConstants,
StorageConstants {
    protected static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    protected static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    String m_errMsgExecTags = s_gMsgBundle.getMessage("0801", true);
    static final String GLOBAL_ERR = "GLOBAL";
    VerificationConstants.OSType m_osType = VerificationUtil.getSupportedOSPlatform();
    boolean m_isUnix = new SystemFactory().CreateSystem().isUnixSystem();
    GlobalVerificationContext m_gCtx = GlobalVerificationContext.getInstance();
    StorageCheckContext m_scCtx;
    boolean m_isDiscovery;

    public StorageDataParser(StorageCheckContext scCtx) {
        this.m_scCtx = scCtx;
        this.m_isDiscovery = this.m_scCtx.isDiscovery();
    }

    public void parseDataFromExectask(StorageType type, VerificationCommand vfyCmd, Result rslt, List<StorageData> sdList) {
        String node = vfyCmd.getNode();
        String discoverFailMsg = s_gMsgBundle.getMessage("0811", true, (Object[])new String[]{type.name(), node});
        List<Object> listOfErrors = new ArrayList();
        Result result = vfyCmd.getResult();
        VerificationUtil.traceAndLog("type=%s ; node=%s ; status=%s", type.name(), node, Result.resultStatusString(result.getStatus()));
        if (result.getStatus() != 1) {
            VerificationUtil.traceAndLog("exectask -getstinfo command was not executed successfully");
            rslt.setStatus(2);
            rslt.addErrorDescription(new ErrorDescription(discoverFailMsg + LSEP + this.m_errMsgExecTags));
            return;
        }
        int vfyCode = vfyCmd.getVfyCode();
        VerificationUtil.traceAndLog("vfyCode='%s'", vfyCode);
        if (vfyCode != 0) {
            List<String> msgListExec = this.getExecErrors(vfyCmd);
            if (msgListExec.size() > 0) {
                String errMsg = discoverFailMsg;
                for (String msg : msgListExec) {
                    errMsg = errMsg + LSEP + msg;
                }
                rslt.setStatus(4);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                errDesc.setWarning();
                rslt.addErrorDescription(errDesc);
                return;
            }
            rslt.setStatus(1);
            return;
        }
        String vfyOutput = vfyCmd.getOutput();
        VerificationUtil.traceAndLog("vfyOutput='%s'", vfyOutput);
        if (!VerificationUtil.isStringGood(vfyOutput)) {
            VerificationUtil.traceAndLog("No discovery output found on node '%s' for VRES==0", node);
            rslt.setStatus(1);
            return;
        }
        VerificationUtil.traceAndLog("Calling storage type specific parsing method...");
        switch (type) {
            case NFS: {
                listOfErrors = this.parseNFSData(vfyCmd, sdList);
                break;
            }
            case DISK: {
                listOfErrors = this.parseDiskData(vfyCmd, sdList);
                break;
            }
            case OCFS: {
                listOfErrors = this.parseOCFSData(vfyCmd, sdList);
                break;
            }
            case OCFS2: {
                listOfErrors = this.parseOCFS2Data(vfyCmd, sdList);
                break;
            }
            case GPFS: {
                listOfErrors = this.parseGPFSData(vfyCmd, sdList);
                break;
            }
            case LVMDG: {
                listOfErrors = this.parseLvmDGData(vfyCmd, sdList);
                break;
            }
            case LVMLV: {
                listOfErrors = this.parseLvmLVData(vfyCmd, sdList);
                break;
            }
            case VXDG: {
                listOfErrors = this.parseVxDGData(vfyCmd, sdList);
                break;
            }
            case VXVOLUME: {
                listOfErrors = this.parseVxVLData(vfyCmd, sdList);
                break;
            }
            default: {
                VerificationUtil.traceAndLog("Discovery of type '%s' is not supported", type.name());
            }
        }
        VerificationUtil.traceAndLog("Count of errors found in discovery = " + listOfErrors.size());
        if (listOfErrors.size() > 0) {
            rslt.setStatus(2);
            rslt.addErrorDescription(new ErrorDescription(discoverFailMsg + LSEP + VerificationUtil.errDescCol2errMsgStr(listOfErrors)));
        } else {
            VerificationUtil.traceAndLog("Count of StorageData items on node '%s' = %s", node, sdList.size());
            rslt.setStatus(1);
        }
    }

    List<ErrorDescription> parseDiskData(VerificationCommand vfyCmd, List<StorageData> sdList) {
        Vector diskStrings;
        ArrayList<ErrorDescription> listOfErrors = new ArrayList<ErrorDescription>();
        String node = vfyCmd.getNode();
        int vfyCode = vfyCmd.getVfyCode();
        VerificationUtil.traceAndLog("node=" + node + "; vfyCode=" + vfyCode);
        if (vfyCode != 0) {
            VerificationUtil.traceAndLog("Reached here with vfyCode='%s'; Discovery skipped", vfyCode);
            return listOfErrors;
        }
        String output = vfyCmd.getOutput();
        VerificationUtil.traceAndLog("OUTPUT:" + LSEP + output + LSEP);
        try {
            if (this.m_isUnix) {
                VerificationUtil.traceAndLog("Parsing for disks in Unix");
                diskStrings = GenericUtil.getAllStrByTags(output, "DISK");
            } else {
                VerificationUtil.traceAndLog("Parsing for disks in Windows");
                int numDisks = GenericUtil.getIntValueByKey(output, "NUMDISKS");
                VerificationUtil.traceAndLog("Number of disks = '%s'", numDisks);
                diskStrings = GenericUtil.getAllStrByTags(output, "DISKBEGIN", "DISKEND");
            }
        }
        catch (ParsingException pe) {
            VerificationUtil.traceAndLog("Problem parsing the string '" + output + "'" + LSEP + pe.getMessage());
            Trace.out((Exception)pe);
            String errMsg = this.m_errMsgExecTags + LSEP + pe.getMessage();
            listOfErrors.add(new ErrorDescription(errMsg));
            return listOfErrors;
        }
        VerificationUtil.traceAndLog("Count of elements in diskStrings = '%s'", diskStrings.size());
        for (String diskStr : diskStrings) {
            VerificationUtil.traceAndLog("Parsing DISK data from: '" + diskStr + "'");
            DiskData diskData = this.parseDiskTags(vfyCmd, "UNKNOWN", diskStr, node);
            List<ErrorDescription> diskErrList = diskData.getErrors();
            int countAllErrs = diskErrList.size();
            int countSignErrs = diskData.getStorageSignature().getErrors().size();
            if (countAllErrs > 0 && countAllErrs != countSignErrs) {
                listOfErrors.addAll(diskErrList);
                continue;
            }
            VerificationUtil.traceAndLog("Discovered DISK storage '%s' on node '%s'", diskData.getID(), node);
            sdList.add(diskData);
        }
        return listOfErrors;
    }

    List<ErrorDescription> parseGPFSData(VerificationCommand vfyCmd, List<StorageData> sdList) {
        String node = vfyCmd.getNode();
        String outputStr = vfyCmd.getOutput();
        ArrayList<ErrorDescription> listOfErrors = new ArrayList<ErrorDescription>();
        VerificationUtil.traceAndLog("node=" + node);
        Result rslt = new Result(node);
        List<GPFSData> listGPFS = this.parseGPFSDataList(outputStr, node, rslt);
        if (rslt.getStatus() != 1) {
            VerificationUtil.traceAndLog("GPFS storage information was not retrieved successfully");
            for (VerificationError vErr : rslt.getErrors()) {
                listOfErrors.add((ErrorDescription)vErr);
            }
        } else {
            for (GPFSData stData : listGPFS) {
                sdList.add(stData);
            }
        }
        return listOfErrors;
    }

    List<ErrorDescription> parseOCFSData(VerificationCommand vfyCmd, List<StorageData> sdList) {
        String node = vfyCmd.getNode();
        String outputStr = vfyCmd.getOutput();
        ArrayList<ErrorDescription> listOfErrors = new ArrayList<ErrorDescription>();
        VerificationUtil.traceAndLog("node=" + node);
        Result rslt = new Result(node);
        List<OCFSData> listOCFS = this.parseOCFSDataList(outputStr, node, rslt);
        if (rslt.getStatus() != 1) {
            VerificationUtil.traceAndLog("OCFS storage information was not retrieved successfully");
            for (VerificationError vErr : rslt.getErrors()) {
                listOfErrors.add((ErrorDescription)vErr);
            }
        } else {
            for (OCFSData stData : listOCFS) {
                sdList.add(stData);
            }
        }
        return listOfErrors;
    }

    List<ErrorDescription> parseOCFS2Data(VerificationCommand vfyCmd, List<StorageData> sdList) {
        String node = vfyCmd.getNode();
        String outputStr = vfyCmd.getOutput();
        ArrayList<ErrorDescription> listOfErrors = new ArrayList<ErrorDescription>();
        VerificationUtil.traceAndLog("node=" + node);
        Result rslt = new Result(node);
        List<OCFS2Data> listOCFS2 = this.parseOCFS2DataList(outputStr, node, rslt);
        if (rslt.getStatus() != 1) {
            VerificationUtil.traceAndLog("OCFS2 storage information was not retrieved successfully");
            for (VerificationError vErr : rslt.getErrors()) {
                listOfErrors.add((ErrorDescription)vErr);
            }
        } else {
            for (OCFS2Data stData : listOCFS2) {
                sdList.add(stData);
            }
        }
        return listOfErrors;
    }

    LvmDGData parseLvmDGData(VerificationCommand vfyCmd, String id) {
        String node = vfyCmd.getNode();
        String outputStr = vfyCmd.getOutput();
        VerificationUtil.traceAndLog("node=" + node + "; id=" + id);
        LvmDGData LvmDGData2 = new LvmDGData(id);
        Result rslt = new Result(node);
        List<LvmDGData> listLvmDG = this.parseLvmDGDataList(outputStr, node, rslt);
        if (rslt.getStatus() != 1) {
            VerificationUtil.traceAndLog("LvmDG storage information was not retrieved successfully");
            for (VerificationError vErr : rslt.getErrors()) {
                LvmDGData2.addErrDesc((ErrorDescription)vErr);
            }
            return LvmDGData2;
        }
        return listLvmDG.get(0);
    }

    List<ErrorDescription> parseLvmDGData(VerificationCommand vfyCmd, List<StorageData> sdList) {
        String node = vfyCmd.getNode();
        String outputStr = vfyCmd.getOutput();
        ArrayList<ErrorDescription> listOfErrors = new ArrayList<ErrorDescription>();
        VerificationUtil.traceAndLog("node=" + node);
        Result rslt = new Result(node);
        List<LvmDGData> listLvmDG = this.parseLvmDGDataList(outputStr, node, rslt);
        if (rslt.getStatus() != 1) {
            VerificationUtil.traceAndLog("LvmDG storage information was not retrieved successfully");
            for (VerificationError vErr : rslt.getErrors()) {
                listOfErrors.add((ErrorDescription)vErr);
            }
        } else {
            for (LvmDGData stData : listLvmDG) {
                sdList.add(stData);
            }
        }
        return listOfErrors;
    }

    List<LvmDGData> parseLvmDGDataList(String output, String node, Result rslt) {
        if (this.m_osType == VerificationConstants.OSType.AIX) {
            return this.parseLvmDGDataListAIX(output, node, rslt);
        }
        return this.parseLvmDGDataListHPUX(output, node, rslt);
    }

    List<LvmDGData> parseLvmDGDataListAIX(String output, String node, Result rslt) {
        VerificationUtil.traceAndLog("node=%s output=%s", node, output);
        ArrayList<LvmDGData> listLvmDG = new ArrayList<LvmDGData>();
        ArrayList<LvmDGData> emptyList = new ArrayList<LvmDGData>();
        String[] resultLines = output.split("\n");
        try {
            for (int i = 0; i < resultLines.length; ++i) {
                String currLine = resultLines[i];
                VerificationUtil.traceAndLog("currLine=" + currLine);
                StringTokenizer stLine = new StringTokenizer(currLine);
                String gname = stLine.nextToken();
                String dgid = stLine.nextToken();
                LvmDGData dgData = new LvmDGData(gname, dgid);
                VerificationUtil.traceAndLog("added: " + dgData);
                listLvmDG.add(dgData);
            }
        }
        catch (Exception e) {
            VerificationUtil.traceAndLog("Problem parsing the string " + LSEP + e.getMessage());
            Trace.out((Exception)e);
            rslt.setStatus(2);
            String errMsg = this.m_errMsgExecTags + LSEP + e.getMessage();
            rslt.addErrorDescription(new ErrorDescription(errMsg));
            return emptyList;
        }
        rslt.setStatus(1);
        return listLvmDG;
    }

    List<LvmDGData> parseLvmDGDataListHPUX(String output, String node, Result rslt) {
        VerificationUtil.traceAndLog("node=%s output=%s", node, output);
        ArrayList<LvmDGData> listLvmDG = new ArrayList<LvmDGData>();
        ArrayList<LvmDGData> emptyList = new ArrayList<LvmDGData>();
        LvmDGData dgData = null;
        String gnameSaved = null;
        String[] resultLines = output.split("\n");
        try {
            for (int i = 0; i < resultLines.length; ++i) {
                String currLine = resultLines[i];
                VerificationUtil.traceAndLog("currLine=" + currLine);
                if (!VerificationUtil.isStringGood(currLine) || currLine.indexOf(124) == -1) continue;
                StringTokenizer stLine = new StringTokenizer(currLine, "|");
                String gname = stLine.nextToken();
                String pvID = stLine.nextToken();
                String pvPath = stLine.nextToken();
                if (gnameSaved == null || gnameSaved != gname) {
                    if (dgData != null) {
                        VerificationUtil.traceAndLog("Completed dgData :" + dgData);
                    }
                    VerificationUtil.traceAndLog("Creating LvmDGData using VG: '%s' PV-ID: '%s' PV-PATH: '%s'", gname, pvID, pvPath);
                    dgData = new LvmDGData(gname, pvID, pvPath);
                    gnameSaved = gname;
                    listLvmDG.add(dgData);
                    continue;
                }
                VerificationUtil.traceAndLog("Adding PV details ID: '%s' PATH: '%s'", pvID, pvPath);
                dgData.addPV(pvID, pvPath);
            }
        }
        catch (Exception e) {
            VerificationUtil.traceAndLog("Problem parsing the string " + LSEP + e.getMessage());
            Trace.out((Exception)e);
            rslt.setStatus(2);
            String errMsg = this.m_errMsgExecTags + LSEP + e.getMessage();
            rslt.addErrorDescription(new ErrorDescription(errMsg));
            return emptyList;
        }
        rslt.setStatus(1);
        return listLvmDG;
    }

    LvmLVData parseLvmLVData(VerificationCommand vfyCmd, String id) {
        String node = vfyCmd.getNode();
        String outputStr = vfyCmd.getOutput();
        VerificationUtil.traceAndLog("node=" + node + "; id=" + id);
        LvmLVData LvmLVData2 = new LvmLVData(id);
        Result rslt = new Result(node);
        List<LvmLVData> listLvmLV = this.parseLvmLVDataList(outputStr, node, rslt);
        if (rslt.getStatus() != 1) {
            VerificationUtil.traceAndLog("LvmLV storage information was not retrieved successfully");
            for (VerificationError vErr : rslt.getErrors()) {
                LvmLVData2.addErrDesc((ErrorDescription)vErr);
            }
            return LvmLVData2;
        }
        return listLvmLV.get(0);
    }

    List<ErrorDescription> parseLvmLVData(VerificationCommand vfyCmd, List<StorageData> sdList) {
        String node = vfyCmd.getNode();
        String outputStr = vfyCmd.getOutput();
        ArrayList<ErrorDescription> listOfErrors = new ArrayList<ErrorDescription>();
        VerificationUtil.traceAndLog("node=" + node);
        Result rslt = new Result(node);
        List<LvmLVData> listLvmLV = this.parseLvmLVDataList(outputStr, node, rslt);
        if (rslt.getStatus() != 1) {
            VerificationUtil.traceAndLog("LvmLV storage information was not retrieved successfully");
            for (VerificationError vErr : rslt.getErrors()) {
                listOfErrors.add((ErrorDescription)vErr);
            }
        } else {
            for (LvmLVData stData : listLvmLV) {
                sdList.add(stData);
            }
        }
        return listOfErrors;
    }

    List<LvmLVData> parseLvmLVDataList(String output, String node, Result rslt) {
        if (this.m_osType == VerificationConstants.OSType.AIX) {
            return this.parseLvmLVDataListAIX(output, node, rslt);
        }
        return this.parseLvmLVDataListHPUX(output, node, rslt);
    }

    List<LvmLVData> parseLvmLVDataListAIX(String output, String node, Result rslt) {
        VerificationUtil.traceAndLog("node=%s output=%s", node, output);
        ArrayList<LvmLVData> listLvmLV = new ArrayList<LvmLVData>();
        ArrayList<LvmLVData> emptyList = new ArrayList<LvmLVData>();
        String[] resultLines = output.split("\n");
        try {
            for (int i = 0; i < resultLines.length; ++i) {
                String currLine = resultLines[i];
                VerificationUtil.traceAndLog("currLine=" + currLine);
                StringTokenizer stLine = new StringTokenizer(currLine);
                String name = stLine.nextToken();
                String uuid = stLine.nextToken();
                LvmLVData lvData = new LvmLVData(name, uuid);
                VerificationUtil.traceAndLog("added: " + lvData);
                listLvmLV.add(lvData);
            }
        }
        catch (Exception e) {
            VerificationUtil.traceAndLog("Problem parsing the string " + LSEP + e.getMessage());
            Trace.out((Exception)e);
            rslt.setStatus(2);
            String errMsg = this.m_errMsgExecTags + LSEP + e.getMessage();
            rslt.addErrorDescription(new ErrorDescription(errMsg));
            return emptyList;
        }
        rslt.setStatus(1);
        return listLvmLV;
    }

    List<LvmLVData> parseLvmLVDataListHPUX(String output, String node, Result rslt) {
        VerificationUtil.traceAndLog("node=%s output=%s", node, output);
        ArrayList<LvmLVData> listLvmLV = new ArrayList<LvmLVData>();
        ArrayList<LvmLVData> emptyList = new ArrayList<LvmLVData>();
        LvmLVData lvData = null;
        String nameSaved = null;
        String[] resultLines = output.split("\n");
        try {
            for (int i = 0; i < resultLines.length; ++i) {
                String currLine = resultLines[i];
                VerificationUtil.traceAndLog("currLine=" + currLine);
                if (!VerificationUtil.isStringGood(currLine) || currLine.indexOf(124) == -1) continue;
                StringTokenizer stLine = new StringTokenizer(currLine, "|");
                String name = stLine.nextToken();
                String pvID = stLine.nextToken();
                String pvPath = stLine.nextToken();
                if (nameSaved == null || nameSaved != name) {
                    if (lvData != null) {
                        VerificationUtil.traceAndLog("Completed lvData :" + lvData);
                    }
                    VerificationUtil.traceAndLog("Creating LvmLVData using VG: '%s' PV-ID: '%s' PV-PATH: '%s'", name, pvID, pvPath);
                    lvData = new LvmLVData(name, pvID, pvPath);
                    nameSaved = name;
                    listLvmLV.add(lvData);
                    continue;
                }
                VerificationUtil.traceAndLog("Adding PV details ID: '%s' PATH: '%s'", pvID, pvPath);
                lvData.addPV(pvID, pvPath);
            }
        }
        catch (Exception e) {
            VerificationUtil.traceAndLog("Problem parsing the string " + LSEP + e.getMessage());
            Trace.out((Exception)e);
            rslt.setStatus(2);
            String errMsg = this.m_errMsgExecTags + LSEP + e.getMessage();
            rslt.addErrorDescription(new ErrorDescription(errMsg));
            return emptyList;
        }
        rslt.setStatus(1);
        return listLvmLV;
    }

    VxDGData parseVxDGData(VerificationCommand vfyCmd, String id) {
        String node = vfyCmd.getNode();
        String outputStr = vfyCmd.getOutput();
        VerificationUtil.traceAndLog("node=" + node + "; id=" + id);
        VxDGData VxDGData2 = new VxDGData(id);
        Result rslt = new Result(node);
        List<VxDGData> listVxDG = this.parseVxDGDataList(outputStr, node, rslt);
        if (rslt.getStatus() != 1) {
            VerificationUtil.traceAndLog("VxDG storage information was not retrieved successfully");
            for (VerificationError vErr : rslt.getErrors()) {
                VxDGData2.addErrDesc((ErrorDescription)vErr);
            }
            return VxDGData2;
        }
        return listVxDG.get(0);
    }

    List<ErrorDescription> parseVxDGData(VerificationCommand vfyCmd, List<StorageData> sdList) {
        String node = vfyCmd.getNode();
        String outputStr = vfyCmd.getOutput();
        ArrayList<ErrorDescription> listOfErrors = new ArrayList<ErrorDescription>();
        VerificationUtil.traceAndLog("node=" + node);
        Result rslt = new Result(node);
        List<VxDGData> listVxDG = this.parseVxDGDataList(outputStr, node, rslt);
        if (rslt.getStatus() != 1) {
            VerificationUtil.traceAndLog("VxDG storage information was not retrieved successfully");
            for (VerificationError vErr : rslt.getErrors()) {
                listOfErrors.add((ErrorDescription)vErr);
            }
        } else {
            for (VxDGData stData : listVxDG) {
                sdList.add(stData);
            }
        }
        return listOfErrors;
    }

    List<VxDGData> parseVxDGDataList(String output, String node, Result rslt) {
        VerificationUtil.traceAndLog("node=%s output=%s", node, output);
        ArrayList<VxDGData> listVxDG = new ArrayList<VxDGData>();
        ArrayList<VxDGData> emptyList = new ArrayList<VxDGData>();
        String[] resultLines = output.split("\n");
        try {
            for (int i = 0; i < resultLines.length; ++i) {
                String currLine = resultLines[i];
                VerificationUtil.traceAndLog("currLine=" + currLine);
                StringTokenizer stLine = new StringTokenizer(currLine);
                stLine.nextToken();
                String name = stLine.nextToken();
                stLine.nextToken();
                stLine.nextToken();
                stLine.nextToken();
                String dgid = stLine.nextToken();
                VxDGData dgData = new VxDGData(name, dgid);
                VerificationUtil.traceAndLog("added: " + dgData);
                listVxDG.add(dgData);
            }
        }
        catch (Exception e) {
            VerificationUtil.traceAndLog("Problem parsing the string " + LSEP + e.getMessage());
            Trace.out((Exception)e);
            rslt.setStatus(2);
            String errMsg = this.m_errMsgExecTags + LSEP + e.getMessage();
            rslt.addErrorDescription(new ErrorDescription(errMsg));
            return emptyList;
        }
        rslt.setStatus(1);
        return listVxDG;
    }

    VxVLData parseVxVLData(VerificationCommand vfyCmd, String id) {
        String node = vfyCmd.getNode();
        String outputStr = vfyCmd.getOutput();
        VerificationUtil.traceAndLog("node=" + node + "; id=" + id);
        VxVLData VxVLData2 = new VxVLData(id);
        Result rslt = new Result(node);
        List<VxVLData> listVxVL = this.parseVxVLDataList(outputStr, node, rslt);
        if (rslt.getStatus() != 1) {
            VerificationUtil.traceAndLog("VxVL storage information was not retrieved successfully");
            for (VerificationError vErr : rslt.getErrors()) {
                VxVLData2.addErrDesc((ErrorDescription)vErr);
            }
            return VxVLData2;
        }
        return listVxVL.get(0);
    }

    List<ErrorDescription> parseVxVLData(VerificationCommand vfyCmd, List<StorageData> sdList) {
        String node = vfyCmd.getNode();
        String outputStr = vfyCmd.getOutput();
        ArrayList<ErrorDescription> listOfErrors = new ArrayList<ErrorDescription>();
        VerificationUtil.traceAndLog("node=" + node);
        Result rslt = new Result(node);
        List<VxVLData> listVxVL = this.parseVxVLDataList(outputStr, node, rslt);
        if (rslt.getStatus() != 1) {
            VerificationUtil.traceAndLog("VxVL storage information was not retrieved successfully");
            for (VerificationError vErr : rslt.getErrors()) {
                listOfErrors.add((ErrorDescription)vErr);
            }
        } else {
            for (VxVLData stData : listVxVL) {
                sdList.add(stData);
            }
        }
        return listOfErrors;
    }

    List<VxVLData> parseVxVLDataList(String output, String node, Result rslt) {
        VerificationUtil.traceAndLog("node=%s output=%s", node, output);
        ArrayList<VxVLData> listVxVL = new ArrayList<VxVLData>();
        ArrayList<VxVLData> emptyList = new ArrayList<VxVLData>();
        String[] resultLines = output.split("\n");
        try {
            for (int i = 0; i < resultLines.length; ++i) {
                String currLine = resultLines[i];
                VerificationUtil.traceAndLog("currLine=" + currLine);
                StringTokenizer stLine = new StringTokenizer(currLine);
                stLine.nextToken();
                String name = stLine.nextToken();
                String guid = GenericUtil.getNextStrNoCase(currLine, "guid=", null);
                VxVLData vlData = new VxVLData(name, guid);
                VerificationUtil.traceAndLog("added: " + vlData);
                listVxVL.add(vlData);
            }
        }
        catch (Exception e) {
            VerificationUtil.traceAndLog("Problem parsing the string " + LSEP + e.getMessage());
            Trace.out((Exception)e);
            rslt.setStatus(2);
            String errMsg = this.m_errMsgExecTags + LSEP + e.getMessage();
            rslt.addErrorDescription(new ErrorDescription(errMsg));
            return emptyList;
        }
        rslt.setStatus(1);
        return listVxVL;
    }

    List<ErrorDescription> parseNFSData(VerificationCommand vfyCmd, List<StorageData> sdList) {
        Vector nfsStrings;
        ArrayList<ErrorDescription> listOfErrors = new ArrayList<ErrorDescription>();
        String node = vfyCmd.getNode();
        int vfyCode = vfyCmd.getVfyCode();
        VerificationUtil.traceAndLog("node=" + node + "; vfyCode=" + vfyCode);
        if (vfyCode != 0) {
            VerificationUtil.traceAndLog("Reached here with vfyCode='%s'; Discovery skipped", vfyCode);
            return listOfErrors;
        }
        String output = vfyCmd.getOutput();
        try {
            nfsStrings = GenericUtil.getAllStrByTags(output, "MOUNT");
        }
        catch (ParsingException pe) {
            VerificationUtil.traceAndLog("Problem parsing the string '" + output + "'" + LSEP + pe.getMessage());
            Trace.out((Exception)pe);
            String errMsg = this.m_errMsgExecTags + LSEP + pe.getMessage();
            listOfErrors.add(new ErrorDescription(errMsg));
            return listOfErrors;
        }
        for (String nfsStr : nfsStrings) {
            VerificationUtil.traceAndLog("Parsing NFS data from: '" + nfsStr + "'");
            NFSData nfsData = this.parseNFSMountAndFSDetails(nfsStr, node, null);
            List<ErrorDescription> nfsErrList = nfsData.getErrors();
            if (nfsErrList.size() > 0) {
                listOfErrors.addAll(nfsErrList);
                continue;
            }
            VerificationUtil.traceAndLog("Discovered NFS storage '%s' on node '%s'", nfsData.getID(), node);
            sdList.add(nfsData);
        }
        return listOfErrors;
    }

    public StorageData parseDataFromExectask(String id, VerificationCommand vfyCmd) {
        String node = vfyCmd.getNode();
        StorageData stData = new StorageData(id);
        String errMsg = s_gMsgBundle.getMessage("0802", true, (Object[])new String[]{id, node});
        Result result = vfyCmd.getResult();
        VerificationUtil.traceAndLog("id=%s ; node=%s ; status=%s", id, node, Result.resultStatusString(result.getStatus()));
        if (result.getStatus() != 1) {
            VerificationUtil.traceAndLog("exectask -getstorage command was not executed successfully");
            stData.getStorageType().addErrDesc(new ErrorDescription(errMsg));
            return stData;
        }
        int vfyCode = vfyCmd.getVfyCode();
        if (vfyCode != 0) {
            VerificationUtil.traceAndLog("Storage Type could not be retrieved::vfyCode=" + vfyCode);
            List<String> msgListExec = this.getExecErrors(vfyCmd);
            for (String msg : msgListExec) {
                stData.getStorageType().addErrDesc(new ErrorDescription(msg));
            }
            return stData;
        }
        String execOutput = vfyCmd.getExectaskOutput();
        String resultVal = vfyCmd.getOutput();
        VerificationUtil.traceAndLog("execOutput=" + LSEP + execOutput);
        VerificationUtil.traceAndLog("resultVal=" + LSEP + resultVal);
        String typeStr = null;
        String realPath = null;
        String prefName = null;
        String accessStr = null;
        try {
            realPath = GenericUtil.getValueByKey(execOutput, "REALPATH");
            typeStr = GenericUtil.getValueByKey(execOutput, "STTYPE");
            if (this.m_isUnix) {
                prefName = GenericUtil.getValueByKey(execOutput, "PREFNAME");
                accessStr = GenericUtil.getValueByKey(execOutput, "ACCESS");
            }
        }
        catch (ParsingException pe) {
            VerificationUtil.traceAndLog("Parsing exception:: " + pe.getMessage());
            errMsg = this.m_errMsgExecTags + LSEP + pe.getMessage();
            stData.getStorageType().addErrDesc(new ErrorDescription(errMsg));
            return stData;
        }
        VerificationUtil.traceAndLog("typeStr=%s realPath=%s prefName=%s accessStr=%s", typeStr, realPath, prefName, accessStr);
        if (typeStr == null) {
            String execErrMsg = VerificationUtil.fetchExecutionDetailsMessage(node, execOutput);
            VerificationUtil.traceAndLog("ErrMsg=" + execErrMsg);
            errMsg = VerificationUtil.isStringGood(execErrMsg) ? errMsg + LSEP + execErrMsg : errMsg + LSEP + this.m_errMsgExecTags;
            stData.getStorageType().addErrDesc(new ErrorDescription(errMsg));
            return stData;
        }
        StorageType stType = StorageDataHandler.getTypeEnumFromStr(typeStr);
        VerificationUtil.traceAndLog("Storage Type = " + (Object)((Object)stType));
        stData = this.parseStorageData(vfyCmd, stType, this.m_isUnix ? prefName : id);
        if (this.m_isUnix) {
            stData.setID(prefName);
        }
        stData.setEffectiveID(realPath);
        stData.setSuppliedID(id);
        VerificationUtil.traceAndLog("Returning stData=" + LSEP + stData);
        return stData;
    }

    public StorageData parseStorageData(VerificationCommand vfyCmd, StorageType type, String path) {
        StorageData stData = new StorageData(path, type);
        String node = vfyCmd.getNode();
        String[] resultLines = vfyCmd.getCommandResult().getResultString();
        if (null == resultLines || resultLines.length == 0) {
            VerificationUtil.traceAndLog("No exectask results are available on node '" + node + "'");
            stData.addErrDesc(new ErrorDescription(this.m_errMsgExecTags));
            return stData;
        }
        switch (type) {
            case DISK: {
                stData = this.parseDiskData(vfyCmd, path);
                break;
            }
            case NFS: {
                stData = this.parseNFSData(vfyCmd, path);
                break;
            }
            case OCFS: {
                stData = this.parseOCFSData(vfyCmd, path);
                break;
            }
            case OCFS2: {
                stData = this.parseOCFS2Data(vfyCmd, path);
                break;
            }
            case NTFS: 
            case FILESYSTEM: {
                stData = this.parseNativeFSData(vfyCmd, path);
                break;
            }
            case VXFS: {
                stData = this.parseVxFSData(vfyCmd, path);
                break;
            }
            case ACFS: {
                stData = this.parseACFSData(vfyCmd, path);
                break;
            }
            case QFS: {
                stData = this.parseQFSData(vfyCmd, path);
                break;
            }
            case SAMFS: {
                stData = this.parseSAMFSData(vfyCmd, path);
                break;
            }
            case GPFS: {
                stData = this.parseGPFSData(vfyCmd, path);
                break;
            }
            case TMPFS: {
                stData = this.parseTMPFSData(vfyCmd, path);
                break;
            }
            case VXDG: {
                stData = this.parseVxDGData(vfyCmd, path);
                break;
            }
            case VXVOLUME: {
                stData = this.parseVxVLData(vfyCmd, path);
                break;
            }
            case LVMDG: {
                stData = this.parseLvmDGData(vfyCmd, path);
                break;
            }
            case LVMLV: {
                stData = this.parseLvmLVData(vfyCmd, path);
                break;
            }
        }
        return stData;
    }

    NFSData parseNFSData(VerificationCommand vfyCmd, String path) {
        String node = vfyCmd.getNode();
        String nfsStr = vfyCmd.getOutput();
        VerificationUtil.traceAndLog("node=" + node + "; path=" + path);
        return this.parseNFSMountAndFSDetails(nfsStr, node, path);
    }

    private NFSData parseNFSMountAndFSDetails(String mntStr, String node, String path) {
        NFSData nfsData = new NFSData(path);
        StringBuffer mntDevBuf = new StringBuffer();
        StringBuffer mntDirBuf = new StringBuffer();
        StringBuffer mntOptsBuf = new StringBuffer();
        StringBuffer fsTypeBuf = new StringBuffer();
        VerificationUtil.traceAndLog("node=" + node + "; path=" + path + "; mntStr=" + mntStr);
        List<ErrorDescription> listOfErrors = this.parseMountDetails(mntStr, mntDevBuf, mntDirBuf, mntOptsBuf, fsTypeBuf);
        if (listOfErrors.size() > 0) {
            nfsData.addErrDesc(listOfErrors);
            return nfsData;
        }
        VerificationUtil.traceAndLog("Attempt to parse File System details");
        Entity<FSDetails> fsDetails = this.parseFSDetails(mntStr, path, node);
        String mntOpts = mntOptsBuf.toString();
        String mntDev = mntDevBuf.toString();
        String mntDir = mntDirBuf.toString();
        if (null != path) {
            VerificationUtil.traceAndLog("Instantiate NFSData with '" + mntDev + "' on path: '" + path + "'");
            nfsData = new NFSData(path, mntDev, mntOpts, fsDetails);
        } else {
            VerificationUtil.traceAndLog("'path' is 'null'. Instantiate NFSData with '" + mntDev + "'on mntDir: '" + mntDir + "'");
            nfsData = new NFSData(mntDir, mntDev, mntOpts, fsDetails);
        }
        return nfsData;
    }

    private List<ErrorDescription> parseMountDetails(String mntStr, StringBuffer mntDevBuf, StringBuffer mntDirBuf, StringBuffer mntOptsBuf, StringBuffer fsTypeBuf) {
        String mntDev = null;
        String mntDir = null;
        String mntOpts = null;
        String fsType = null;
        ArrayList<ErrorDescription> listOfErrors = new ArrayList<ErrorDescription>();
        try {
            mntDev = GenericUtil.getMidStrNoCase(mntStr, "MNT_DEV");
            mntDir = GenericUtil.getMidStrNoCase(mntStr, "MNT_DIR");
            mntOpts = GenericUtil.getMidStrNoCase(mntStr, "MNT_OPTS");
            fsType = GenericUtil.getMidStrNoCase(mntStr, "MNT_FSTYPE");
            mntDevBuf.append(mntDev);
            mntDirBuf.append(mntDir);
            mntOptsBuf.append(mntOpts);
            fsTypeBuf.append(fsType);
        }
        catch (ParsingException pe) {
            VerificationUtil.traceAndLog("Parsing exception:: " + pe.getMessage());
            String errMsg = this.m_errMsgExecTags + LSEP + pe.getMessage();
            listOfErrors.add(new ErrorDescription(errMsg));
        }
        return listOfErrors;
    }

    OCFS2Data parseOCFS2Data(VerificationCommand vfyCmd, String path) {
        String node = vfyCmd.getNode();
        String outputStr = vfyCmd.getOutput();
        VerificationUtil.traceAndLog("node=" + node + "; path=" + path);
        OCFS2Data ocfs2Data = new OCFS2Data(path);
        Result rslt = new Result(node);
        List<OCFS2Data> listOCFS2 = this.parseOCFS2DataList(outputStr, node, rslt);
        if (rslt.getStatus() != 1) {
            VerificationUtil.traceAndLog("OCFS2 storage information was not retrieved successfully");
            for (VerificationError vErr : rslt.getErrors()) {
                ocfs2Data.addErrDesc((ErrorDescription)vErr);
            }
            return ocfs2Data;
        }
        return listOCFS2.get(0);
    }

    List<OCFS2Data> parseOCFS2DataList(String output, String node, Result rslt) {
        VerificationUtil.traceAndLog("node=%s m_isDiscovery=%s output=%s", node, this.m_isDiscovery, output);
        ArrayList<OCFS2Data> listOCFS2 = new ArrayList<OCFS2Data>();
        ArrayList<OCFS2Data> emptyList = new ArrayList<OCFS2Data>();
        String[] numOcfsTags = new String[]{"NUMOCFS"};
        StringBuffer mntDevBuf = new StringBuffer();
        StringBuffer mntDirBuf = new StringBuffer();
        StringBuffer mntOptsBuf = new StringBuffer();
        StringBuffer fsTypeBuf = new StringBuffer();
        try {
            int[] numOcfs = GenericUtil.getIntFieldsByTags(output, numOcfsTags);
            VerificationUtil.traceAndLog("size of numOcfs=" + numOcfs.length);
            VerificationUtil.traceAndLog("numOcfs[0]=" + numOcfs[0]);
            if (0 == numOcfs[0]) {
                if (!this.m_isDiscovery) {
                    VerificationUtil.traceAndLog("No data is available for specified OCFS2 path");
                    rslt.setStatus(2);
                    rslt.addErrorDescription(new ErrorDescription(this.m_errMsgExecTags));
                } else {
                    VerificationUtil.traceAndLog("No OCFS2 storage has been discovered");
                    rslt.setStatus(1);
                }
                return emptyList;
            }
            Vector ocfsStrings = GenericUtil.getAllStrByTags(output, "OCFSDATA");
            VerificationUtil.traceAndLog("Found " + ocfsStrings.size() + " OCFS2 volumes " + "on node " + node);
            if (ocfsStrings.size() != numOcfs[0]) {
                VerificationUtil.traceAndLog("The count of <ocfsdata> sets '" + numOcfs[0] + "' does not" + " match with the value specified in <numocfs> '" + ocfsStrings.size() + "'");
                rslt.setStatus(2);
                rslt.addErrorDescription(new ErrorDescription(this.m_errMsgExecTags));
                return emptyList;
            }
            for (String ocfsStr : ocfsStrings) {
                String mntStr = GenericUtil.getMidStrNoCase(ocfsStr, "MOUNT");
                List<ErrorDescription> listOfErrors = this.parseMountDetails(mntStr, mntDevBuf, mntDirBuf, mntOptsBuf, fsTypeBuf);
                if (listOfErrors.size() > 0) {
                    VerificationUtil.traceAndLog("Error in parsing of OCFS2 mount details");
                    rslt.setStatus(2);
                    rslt.addErrorDescription(new ErrorDescription(VerificationUtil.errDescCol2errMsgStr(listOfErrors)));
                    return emptyList;
                }
                String mntOpts = mntOptsBuf.toString();
                String mntDev = mntDevBuf.toString();
                String mntDir = mntDirBuf.toString();
                String guid = VerificationUtil.fetchTextByTags(ocfsStr, "OCFS_GUID");
                VerificationUtil.traceAndLog("guid=" + guid);
                VerificationUtil.traceAndLog("Attempt to parse File System details");
                Entity<FSDetails> fsDetails = this.parseFSDetails(ocfsStr, mntDir, node);
                if (fsDetails.getStatus() != EntityStatus.VALID) {
                    VerificationUtil.traceAndLog("Valid File System details are not available");
                    rslt.setStatus(2);
                    rslt.addErrorDescription(new ErrorDescription(VerificationUtil.errDescCol2errMsgStr(fsDetails.getErrors())));
                    return emptyList;
                }
                VerificationUtil.traceAndLog("Instantiating OCFS2Data with '%s' mounted on '%s' and GUID='%s'", mntDev, mntDir, guid);
                VerificationUtil.traceAndLog("Instantiating OCFS2Data with '" + mntDev + "' mounted on '" + mntDir + "' and GUID='" + guid + "'");
                OCFS2Data ocfs2Data = new OCFS2Data(mntDir, mntDev, guid, fsDetails);
                listOCFS2.add(ocfs2Data);
                mntDevBuf.setLength(0);
                mntOptsBuf.setLength(0);
                mntDirBuf.setLength(0);
            }
        }
        catch (ParsingException pe) {
            VerificationUtil.traceAndLog("Problem parsing the string '" + output + "'" + LSEP + pe.getMessage());
            Trace.out((Exception)pe);
            rslt.setStatus(2);
            String errMsg = this.m_errMsgExecTags + LSEP + pe.getMessage();
            rslt.addErrorDescription(new ErrorDescription(errMsg));
            return emptyList;
        }
        rslt.setStatus(1);
        return listOCFS2;
    }

    OCFSData parseOCFSData(VerificationCommand vfyCmd, String path) {
        String node = vfyCmd.getNode();
        String outputStr = vfyCmd.getOutput();
        VerificationUtil.traceAndLog("node=" + node + "; path=" + path);
        if (!this.m_isUnix) {
            Entity<FSDetails> fsDetails = this.parseFSDetails(outputStr, path, node);
            return new OCFSData(path, fsDetails);
        }
        OCFSData ocfsData = new OCFSData(path);
        Result rslt = new Result(node);
        List<OCFSData> listOCFS = this.parseOCFSDataList(outputStr, node, rslt);
        if (rslt.getStatus() != 1) {
            VerificationUtil.traceAndLog("OCFS storage information was not retrieved successfully");
            for (VerificationError vErr : rslt.getErrors()) {
                ocfsData.addErrDesc((ErrorDescription)vErr);
            }
            return ocfsData;
        }
        return listOCFS.get(0);
    }

    List<OCFSData> parseOCFSDataList(String output, String node, Result rslt) {
        VerificationUtil.traceAndLog("node=%s m_isDiscovery=%s output=%s", node, this.m_isDiscovery, output);
        ArrayList<OCFSData> listOCFS = new ArrayList<OCFSData>();
        ArrayList<OCFSData> emptyList = new ArrayList<OCFSData>();
        String[] numOcfsTags = new String[]{"NUMOCFS"};
        StringBuffer mntDevBuf = new StringBuffer();
        StringBuffer mntDirBuf = new StringBuffer();
        StringBuffer mntOptsBuf = new StringBuffer();
        StringBuffer fsTypeBuf = new StringBuffer();
        try {
            int[] numOcfs = GenericUtil.getIntFieldsByTags(output, numOcfsTags);
            VerificationUtil.traceAndLog("size of numOcfs=" + numOcfs.length);
            VerificationUtil.traceAndLog("numOcfs[0]=" + numOcfs[0]);
            if (0 == numOcfs[0]) {
                if (!this.m_isDiscovery) {
                    VerificationUtil.traceAndLog("No data is available for specified OCFS path");
                    rslt.setStatus(2);
                    rslt.addErrorDescription(new ErrorDescription(this.m_errMsgExecTags));
                } else {
                    VerificationUtil.traceAndLog("No OCFS storage has been discovered");
                    rslt.setStatus(1);
                }
                return emptyList;
            }
            Vector ocfsStrings = GenericUtil.getAllStrByTags(output, "OCFSDATA");
            VerificationUtil.traceAndLog("Found " + ocfsStrings.size() + " OCFS volumes " + "on node " + node);
            if (ocfsStrings.size() != numOcfs[0]) {
                VerificationUtil.traceAndLog("The count of <ocfsdata> sets '" + numOcfs[0] + "' does not" + " match with the value specified in <numocfs> '" + ocfsStrings.size() + "'");
                rslt.setStatus(2);
                rslt.addErrorDescription(new ErrorDescription(this.m_errMsgExecTags));
                return emptyList;
            }
            for (String ocfsStr : ocfsStrings) {
                String mntStr = GenericUtil.getMidStrNoCase(ocfsStr, "MOUNT");
                List<ErrorDescription> listOfErrors = this.parseMountDetails(mntStr, mntDevBuf, mntDirBuf, mntOptsBuf, fsTypeBuf);
                if (listOfErrors.size() > 0) {
                    VerificationUtil.traceAndLog("Error in parsing of OCFS mount details");
                    rslt.setStatus(2);
                    rslt.addErrorDescription(new ErrorDescription(VerificationUtil.errDescCol2errMsgStr(listOfErrors)));
                    return emptyList;
                }
                String mntOpts = mntOptsBuf.toString();
                String mntDev = mntDevBuf.toString();
                String mntDir = mntDirBuf.toString();
                String guid = VerificationUtil.fetchTextByTags(ocfsStr, "OCFS_GUID");
                VerificationUtil.traceAndLog("guid=" + guid);
                VerificationUtil.traceAndLog("Instantiating OCFSData with '%s' mounted on '%s' and GUID='%s'", mntDev, mntDir, guid);
                VerificationUtil.traceAndLog("Instantiating OCFSData with '" + mntDev + "' mounted on '" + mntDir + "' and GUID='" + guid + "'");
                OCFSData ocfsData = new OCFSData(mntDir, mntDev, guid);
                listOCFS.add(ocfsData);
                mntDevBuf.setLength(0);
                mntOptsBuf.setLength(0);
                mntDirBuf.setLength(0);
            }
        }
        catch (ParsingException pe) {
            VerificationUtil.traceAndLog("Problem parsing the string '" + output + "'" + LSEP + pe.getMessage());
            Trace.out((Exception)pe);
            rslt.setStatus(2);
            String errMsg = this.m_errMsgExecTags + LSEP + pe.getMessage();
            rslt.addErrorDescription(new ErrorDescription(errMsg));
            return emptyList;
        }
        rslt.setStatus(1);
        return listOCFS;
    }

    DiskData parseDiskData(VerificationCommand vfyCmd, String path) {
        String node = vfyCmd.getNode();
        DiskData diskData = new DiskData(path);
        String errMsg = s_gMsgBundle.getMessage("0805", true, (Object[])new String[]{path, node});
        Entity<StorageSignature> invalidSign = new Entity<StorageSignature>(EntityStatus.INVALID);
        int vfyCode = vfyCmd.getVfyCode();
        String output = vfyCmd.getOutput();
        VerificationUtil.traceAndLog("vfyCode=" + vfyCode);
        VerificationUtil.traceAndLog("output=" + output);
        VerificationUtil.traceAndLog("exectask output=" + vfyCmd.getExectaskOutput());
        if (0 == vfyCode && output != null) {
            diskData = this.parseDiskTags(vfyCmd, path, output, node);
        } else {
            List<String> msgListExec = this.getExecErrors(vfyCmd);
            for (String msg : msgListExec) {
                invalidSign.addErrDesc(new ErrorDescription(msg));
            }
            diskData.setStorageSignature(invalidSign);
        }
        return diskData;
    }

    private DiskData parseDiskTags(VerificationCommand vfyCmd, String path, String output, String node) {
        if (this.m_isUnix) {
            return this.parseDiskTagsUnix(vfyCmd, path, output, node);
        }
        return this.parseDiskTagsWindows(vfyCmd, path, output, node);
    }

    private DiskData parseDiskTagsWindows(VerificationCommand vfyCmd, String path, String output, String node) {
        VerificationUtil.traceAndLog("node=" + node + "; path=" + path + "; output=" + LSEP + output);
        DiskData diskData = new DiskData(path);
        Entity<StorageSignature> invalidSign = new Entity<StorageSignature>(EntityStatus.INVALID);
        int diskNum = -1;
        String diskSignature = null;
        int numParts = -1;
        long diskSize = -1L;
        String diskState = null;
        Vector partStrList = null;
        boolean isSignatureOK = false;
        String diskName = null;
        try {
            diskNum = GenericUtil.getIntValueByKey(output, "DISKNUMBER");
            diskName = "\\Device\\Harddisk" + diskNum;
            diskData.setID(diskName);
            diskSignature = GenericUtil.getValueByKey(output, "DRIVESIGNATURE");
            diskData.setStorageSignature(new StorageSignature(diskSignature));
            isSignatureOK = true;
            if (output.indexOf("DISK_STATE") != -1) {
                diskState = GenericUtil.getValueByKey(output, "DISK_STATE");
                VerificationUtil.traceAndLog("disk state is " + diskState);
                diskData.setState(diskState);
            }
            numParts = GenericUtil.getIntValueByKey(output, "NUMPARTS");
            diskSize = Long.parseLong(GenericUtil.getValueByKey(output, "DISKSIZE"));
            partStrList = GenericUtil.getAllStrByTags(output, "VOLUMEBEGIN", "VOLUMEEND");
            diskData.setStorageSize(new StorageSize((double)diskSize, StorageUnit.MBYTE));
            diskData.setFreeSpace(new StorageSize((double)diskSize, StorageUnit.MBYTE));
            diskData.setNumPartitions(numParts);
        }
        catch (ParsingException pe) {
            VerificationUtil.traceAndLog("Problem parsing the string '" + output + "'" + LSEP + pe.getMessage());
            Trace.out((Exception)pe);
            if (!isSignatureOK) {
                String errMsg = !this.m_isDiscovery ? s_gMsgBundle.getMessage("0805", true, (Object[])new String[]{path, node}) + LSEP + this.m_errMsgExecTags + LSEP + pe.getMessage() : (diskName != null ? s_gMsgBundle.getMessage("0805", true, (Object[])new String[]{path, node}) + LSEP + this.m_errMsgExecTags + LSEP + pe.getMessage() : this.m_errMsgExecTags + LSEP + pe.getMessage());
                invalidSign.addErrDesc(new ErrorDescription(errMsg));
                diskData.setStorageSignature(invalidSign);
            } else {
                String errMsg = this.m_errMsgExecTags + LSEP + pe.getMessage();
                diskData.addErrDesc(new ErrorDescription(errMsg));
            }
            return diskData;
        }
        for (String partStr : partStrList) {
            try {
                String partNum = GenericUtil.getValueByKey(partStr, "PARTITIONNUMBER");
                String fileSys = GenericUtil.getValueByKey(partStr, "FILESYSTEM");
                String vlr = GenericUtil.getValueByKey(partStr, "VLR");
                if (null == vlr) {
                    VerificationUtil.traceAndLog("WARNING: vlr is null. PartNum: " + partNum + "|FS: " + fileSys);
                    vlr = "\\Device\\Harddisk" + diskNum + "\\Partition" + partNum;
                }
                PartitionData partData = new PartitionData(vlr, partNum, fileSys);
                diskData.addPartition(partData);
                VerificationUtil.traceAndLog("added partition: " + partData);
            }
            catch (ParsingException pe) {
                VerificationUtil.traceAndLog("Problem parsing the string '" + output + "'" + LSEP + pe.getMessage());
                Trace.out((Exception)pe);
                String errMsg = this.m_errMsgExecTags + LSEP + pe.getMessage();
                invalidSign.addErrDesc(new ErrorDescription(errMsg));
                diskData.setStorageSignature(invalidSign);
                return diskData;
            }
        }
        return diskData;
    }

    private DiskData parseDiskTagsUnix(VerificationCommand vfyCmd, String path, String output, String node) {
        VerificationUtil.traceAndLog("m_isDiscovery=" + this.m_isDiscovery + "; node=" + node + "; path=" + path + "; output=" + LSEP + output);
        DiskData diskData = new DiskData(path);
        Entity<StorageSignature> invalidSign = new Entity<StorageSignature>(EntityStatus.INVALID);
        boolean isSignatureOK = false;
        String[] diskTags = null;
        switch (this.m_osType) {
            case LINUX: {
                diskTags = new String[]{"NUMPARTS", "DISK_SIZE", "DISK_OWNER", "DISK_GROUP", "DISK_PERMISSIONS", "DISK_SCHEDULER"};
                break;
            }
            case SOLARIS: {
                diskTags = new String[]{"NUMPARTS", "DISK_SIZE", "DISK_OWNER", "DISK_GROUP", "DISK_PERMISSIONS"};
                break;
            }
            case HPUX: {
                diskTags = new String[]{"DISK_SIZE", "DISK_OWNER", "DISK_GROUP", "DISK_PERMISSIONS"};
                break;
            }
            case AIX: {
                diskTags = new String[]{"DISK_VOLGRP", "disk_policy", "disk_lock", "DISK_SIZE", "DISK_OWNER", "DISK_GROUP", "DISK_PERMISSIONS"};
            }
        }
        String diskName = null;
        HashMap<String, String> tagValMap = new HashMap<String, String>();
        try {
            String diskLockStr;
            String diskPolicyStr;
            String numPartsStr;
            String diskScheduler;
            diskName = VerificationUtil.fetchTextByTags(output, "DISK_NAME");
            if (this.m_isDiscovery) {
                VerificationUtil.traceAndLog("Setting the ID in DiskData as '%s'", diskName);
                diskData.setID(diskName);
            }
            String diskSignature = VerificationUtil.fetchTextByTags(output, "DISK_SIGNATURE");
            VerificationUtil.traceAndLog("diskName=%s diskSignature=%s ", diskName, diskSignature);
            List<String> signErrors = vfyCmd.fetchExecutionErrorDetails().get("SIGNATURE");
            if (!VerificationUtil.isStringGood(diskSignature) && signErrors != null && !signErrors.isEmpty()) {
                VerificationUtil.traceAndLog("Encountered a empty signature for path '%s' on node '%s'", diskName, node);
                String errMsg = s_gMsgBundle.getMessage("0805", true, (Object[])new String[]{diskName, node});
                invalidSign.addErrDesc(new ErrorDescription(errMsg));
                for (String errorMsg : signErrors) {
                    invalidSign.addErrDesc(new ErrorDescription(errorMsg));
                }
                diskData.setStorageSignature(invalidSign);
            } else {
                diskData.setStorageSignature(new StorageSignature(diskSignature));
                isSignatureOK = true;
            }
            String[] diskFields = GenericUtil.getFieldsByTags(output, diskTags);
            for (int i = 0; i < diskTags.length; ++i) {
                VerificationUtil.traceAndLog("Value of tag '%s' is '%s'", diskTags[i], diskFields[i]);
                tagValMap.put(diskTags[i], diskFields[i]);
            }
            String diskSizeStr = (String)tagValMap.get("DISK_SIZE");
            if (diskSizeStr != null) {
                double diskSizeDbl = Double.parseDouble(diskSizeStr);
                diskSizeDbl = this.m_osType == VerificationConstants.OSType.AIX ? (diskSizeDbl /= 1024.0) : (diskSizeDbl /= 1048576.0);
                diskData.setStorageSize(new StorageSize(diskSizeDbl, StorageUnit.MBYTE));
                diskData.setFreeSpace(new StorageSize(diskSizeDbl, StorageUnit.MBYTE));
            }
            if (VerificationUtil.isStringGood(diskScheduler = (String)tagValMap.get("DISK_SCHEDULER"))) {
                diskData.setDiskScheduler(diskScheduler);
            }
            String diskOwner = (String)tagValMap.get("DISK_OWNER");
            String diskgroup = (String)tagValMap.get("DISK_GROUP");
            String diskPerm = (String)tagValMap.get("DISK_PERMISSIONS");
            if (diskOwner != null && diskgroup != null && diskPerm != null) {
                diskData.setStorageAccess(new Entity<AccessControl>(new AccessControl(diskOwner, diskgroup, diskPerm)));
            }
            if (VerificationUtil.isStringGood(numPartsStr = (String)tagValMap.get("NUMPARTS"))) {
                int numPartitions = new Integer(numPartsStr);
                diskData.setNumPartitions(numPartitions);
            }
            if (VerificationUtil.isStringGood(diskPolicyStr = (String)tagValMap.get("disk_policy"))) {
                diskData.setPolicy(diskPolicyStr.equals("1"));
            }
            if (VerificationUtil.isStringGood(diskLockStr = (String)tagValMap.get("disk_lock"))) {
                diskData.setLock(diskLockStr.equals("1"));
            }
        }
        catch (ParsingException pe) {
            VerificationUtil.traceAndLog("Problem parsing the string '" + output + "'" + LSEP + pe.getMessage());
            Trace.out((Exception)pe);
            if (!isSignatureOK) {
                String errMsg = !this.m_isDiscovery ? s_gMsgBundle.getMessage("0805", true, (Object[])new String[]{path, node}) + LSEP + this.m_errMsgExecTags + LSEP + pe.getMessage() : (diskName != null ? s_gMsgBundle.getMessage("0805", true, (Object[])new String[]{path, node}) + LSEP + this.m_errMsgExecTags + LSEP + pe.getMessage() : this.m_errMsgExecTags + LSEP + pe.getMessage());
                invalidSign.addErrDesc(new ErrorDescription(errMsg));
                diskData.setStorageSignature(invalidSign);
            }
            String errMsg = this.m_errMsgExecTags + LSEP + pe.getMessage();
            diskData.addErrDesc(new ErrorDescription(errMsg));
        }
        return diskData;
    }

    NativeFSData parseNativeFSData(VerificationCommand vfyCmd, String path) {
        String fsData = vfyCmd.getOutput();
        String node = vfyCmd.getNode();
        VerificationUtil.traceAndLog("node=" + node + "; path=" + path);
        Entity<FSDetails> fsDetails = this.parseFSDetails(fsData, path, node);
        return new NativeFSData(path, fsDetails);
    }

    ACFSData parseACFSData(VerificationCommand vfyCmd, String path) {
        String fsData = vfyCmd.getOutput();
        String node = vfyCmd.getNode();
        VerificationUtil.traceAndLog("node=" + node + "; path=" + path);
        Entity<FSDetails> fsDetails = this.parseFSDetails(fsData, path, node);
        return new ACFSData(path, fsDetails);
    }

    VxFSData parseVxFSData(VerificationCommand vfyCmd, String path) {
        String fsData = vfyCmd.getOutput();
        String node = vfyCmd.getNode();
        VerificationUtil.traceAndLog("node=" + node + "; path=" + path);
        Entity<FSDetails> fsDetails = this.parseFSDetails(fsData, path, node);
        return new VxFSData(path, fsDetails);
    }

    QFSData parseQFSData(VerificationCommand vfyCmd, String path) {
        String fsData = vfyCmd.getOutput();
        String node = vfyCmd.getNode();
        VerificationUtil.traceAndLog("node=" + node + "; path=" + path);
        Entity<FSDetails> fsDetails = this.parseFSDetails(fsData, path, node);
        return new QFSData(path, fsDetails);
    }

    SAMFSData parseSAMFSData(VerificationCommand vfyCmd, String path) {
        String fsData = vfyCmd.getOutput();
        String node = vfyCmd.getNode();
        VerificationUtil.traceAndLog("node=" + node + "; path=" + path);
        Entity<FSDetails> fsDetails = this.parseFSDetails(fsData, path, node);
        return new SAMFSData(path, fsDetails);
    }

    GPFSData parseGPFSData(VerificationCommand vfyCmd, String path) {
        String node = vfyCmd.getNode();
        String outputStr = vfyCmd.getOutput();
        VerificationUtil.traceAndLog("node=" + node + "; path=" + path);
        GPFSData gpfsData = new GPFSData(path);
        Result rslt = new Result(node);
        List<GPFSData> listGPFS = this.parseGPFSDataList(outputStr, node, rslt);
        if (rslt.getStatus() != 1) {
            VerificationUtil.traceAndLog("GPFS storage information was not retrieved successfully");
            for (VerificationError vErr : rslt.getErrors()) {
                gpfsData.addErrDesc((ErrorDescription)vErr);
            }
            return gpfsData;
        }
        return listGPFS.get(0);
    }

    List<GPFSData> parseGPFSDataList(String output, String node, Result rslt) {
        VerificationUtil.traceAndLog("node=%s m_isDiscovery=%s output=%s", node, this.m_isDiscovery, output);
        ArrayList<GPFSData> listGPFS = new ArrayList<GPFSData>();
        ArrayList<GPFSData> emptyList = new ArrayList<GPFSData>();
        String[] numGpfsTags = new String[]{"CFS_CNT"};
        StringBuffer mntDevBuf = new StringBuffer();
        StringBuffer mntDirBuf = new StringBuffer();
        StringBuffer mntOptsBuf = new StringBuffer();
        StringBuffer fsTypeBuf = new StringBuffer();
        try {
            int[] numGpfs = GenericUtil.getIntFieldsByTags(output, numGpfsTags);
            VerificationUtil.traceAndLog("size of numGpfs=" + numGpfs.length);
            VerificationUtil.traceAndLog("numGpfs[0]=" + numGpfs[0]);
            if (0 == numGpfs[0]) {
                if (!this.m_isDiscovery) {
                    VerificationUtil.traceAndLog("No data is available for specified GPFS path");
                    rslt.setStatus(2);
                    rslt.addErrorDescription(new ErrorDescription(this.m_errMsgExecTags));
                } else {
                    VerificationUtil.traceAndLog("No GPFS storage has been discovered");
                    rslt.setStatus(1);
                }
                return emptyList;
            }
            Vector gpfsStrings = GenericUtil.getAllStrByTags(output, "CFS_DATA");
            VerificationUtil.traceAndLog("Found " + gpfsStrings.size() + " GPFS volumes " + "on node " + node);
            if (gpfsStrings.size() != numGpfs[0]) {
                VerificationUtil.traceAndLog("The count of <gpfsdata> sets '" + numGpfs[0] + "' does not" + " match with the value specified in <numgpfs> '" + gpfsStrings.size() + "'");
                rslt.setStatus(2);
                rslt.addErrorDescription(new ErrorDescription(this.m_errMsgExecTags));
                return emptyList;
            }
            for (String gpfsStr : gpfsStrings) {
                String mntStr = GenericUtil.getMidStrNoCase(gpfsStr, "MOUNT");
                List<ErrorDescription> listOfErrors = this.parseMountDetails(mntStr, mntDevBuf, mntDirBuf, mntOptsBuf, fsTypeBuf);
                if (listOfErrors.size() > 0) {
                    VerificationUtil.traceAndLog("Error in parsing of GPFS mount details");
                    rslt.setStatus(2);
                    rslt.addErrorDescription(new ErrorDescription(VerificationUtil.errDescCol2errMsgStr(listOfErrors)));
                    return emptyList;
                }
                String mntOpts = mntOptsBuf.toString();
                String mntDev = mntDevBuf.toString();
                String mntDir = mntDirBuf.toString();
                String guid = VerificationUtil.fetchTextByTags(gpfsStr, "CFS_UID");
                VerificationUtil.traceAndLog("guid=" + guid);
                VerificationUtil.traceAndLog("Attempt to parse File System details");
                Entity<FSDetails> fsDetails = this.parseFSDetails(gpfsStr, mntDir, node);
                if (fsDetails.getStatus() != EntityStatus.VALID) {
                    VerificationUtil.traceAndLog("Valid File System details are not available");
                    rslt.setStatus(2);
                    rslt.addErrorDescription(new ErrorDescription(VerificationUtil.errDescCol2errMsgStr(fsDetails.getErrors())));
                    return emptyList;
                }
                VerificationUtil.traceAndLog("Instantiating GPFSData with '%s' mounted on '%s' and GUID='%s'", mntDev, mntDir, guid);
                VerificationUtil.traceAndLog("Instantiating GPFSData with '" + mntDev + "' mounted on '" + mntDir + "' and GUID='" + guid + "'");
                GPFSData gpfsData = new GPFSData(mntDir, mntDev, guid, fsDetails);
                listGPFS.add(gpfsData);
                mntDevBuf.setLength(0);
                mntOptsBuf.setLength(0);
                mntDirBuf.setLength(0);
            }
        }
        catch (ParsingException pe) {
            VerificationUtil.traceAndLog("Problem parsing the string '" + output + "'" + LSEP + pe.getMessage());
            Trace.out((Exception)pe);
            rslt.setStatus(2);
            String errMsg = this.m_errMsgExecTags + LSEP + pe.getMessage();
            rslt.addErrorDescription(new ErrorDescription(errMsg));
            return emptyList;
        }
        rslt.setStatus(1);
        return listGPFS;
    }

    TMPFSData parseTMPFSData(VerificationCommand vfyCmd, String path) {
        String fsData = vfyCmd.getOutput();
        String node = vfyCmd.getNode();
        VerificationUtil.traceAndLog("node=" + node + "; path=" + path);
        Entity<FSDetails> fsDetails = this.parseFSDetails(fsData, path, node);
        return new TMPFSData(path, fsDetails);
    }

    private Entity<FSDetails> parseFSDetails(String execStr, String path, String node) {
        FSDetails fsDetails = null;
        String fsname = null;
        int fstype = 0;
        long fsbsize = 1L;
        long fsblocks = 0L;
        long fsbfree = 0L;
        long fsbavail = 0L;
        long fsfiles = 1L;
        long fsfree = 0L;
        int fsaccess = 1;
        Entity<FSDetails> invalidFSinfo = new Entity<FSDetails>(EntityStatus.INVALID);
        String errMsg = s_gMsgBundle.getMessage("0810", true, (Object[])new String[]{path, node});
        VerificationUtil.traceAndLog("node=" + node + "; path=" + path);
        try {
            fsname = GenericUtil.getMidStrNoCase(execStr, "FSNAME");
            fstype = Integer.parseInt(GenericUtil.getMidStrNoCase(execStr, "FSTYPE"));
            if (this.m_isUnix) {
                fsbsize = Long.parseLong(GenericUtil.getMidStrNoCase(execStr, "FSBSIZE"));
                fsblocks = Long.parseLong(GenericUtil.getMidStrNoCase(execStr, "FSBLOCKS"));
                fsfiles = Long.parseLong(GenericUtil.getMidStrNoCase(execStr, "FSFILES"));
                fsaccess = Integer.parseInt(GenericUtil.getMidStrNoCase(execStr, "FSACCESS"));
                fsfree = Long.parseLong(GenericUtil.getMidStrNoCase(execStr, "FSFREE"));
            }
            fsbfree = Long.parseLong(GenericUtil.getMidStrNoCase(execStr, "FSBFREE"));
            fsbavail = Long.parseLong(GenericUtil.getMidStrNoCase(execStr, "FSBAVAIL"));
            fsDetails = new FSDetails(fsbsize, fsblocks, fsbfree, fsbavail, fsfiles, fsfree, fsaccess);
            Entity<FSDetails> validFSinfo = new Entity<FSDetails>(fsDetails);
            VerificationUtil.traceAndLog("Returning a VALID FSDetails entity" + validFSinfo);
            return validFSinfo;
        }
        catch (ParsingException pe) {
            VerificationUtil.traceAndLog("Problem parsing the string " + LSEP + pe.getMessage());
            Trace.out((Exception)pe);
            errMsg = errMsg + LSEP + this.m_errMsgExecTags + LSEP + pe.getMessage();
        }
        catch (NumberFormatException nfe) {
            VerificationUtil.traceAndLog("Problem converting string to long in output: " + execStr);
            Trace.out((Exception)nfe);
            errMsg = errMsg + LSEP + this.m_errMsgExecTags + LSEP + nfe.getMessage();
        }
        invalidFSinfo.addErrDesc(new ErrorDescription(errMsg));
        VerificationUtil.traceAndLog("Returning an INVALID FSDetails entity" + invalidFSinfo);
        return invalidFSinfo;
    }

    List<String> parseGetGroupsOutput(VerificationCommand vfyCmd, Result rslt) {
        String output = vfyCmd.getExectaskOutput();
        List<String> groupList = new ArrayList<String>();
        Result result = vfyCmd.getResult();
        if (result.getStatus() != 1) {
            VerificationUtil.traceAndLog("exectask -getgroups command was not executed successfully");
            rslt.setStatus(2);
            rslt.addErrorDescription(new ErrorDescription(this.m_errMsgExecTags));
            return groupList;
        }
        int vfyCode = vfyCmd.getVfyCode();
        if (vfyCode != 0 || !VerificationUtil.isStringGood(output)) {
            rslt.setStatus(2);
            List<String> msgListExec = this.getExecErrors(vfyCmd);
            if (msgListExec.size() != 0) {
                for (String msg : msgListExec) {
                    rslt.addErrorDescription(new ErrorDescription(msg));
                }
            } else {
                rslt.addErrorDescription(new ErrorDescription(this.m_errMsgExecTags));
            }
            return groupList;
        }
        ExecutionAnalyzer analyzer = ExecutionAnalyzerFactory.getExecutionAnalyzer();
        groupList = analyzer.parseGetGroupsOutput(output.trim());
        VerificationUtil.traceAndLog("Returning group list '%s'", VerificationUtil.strList2List(groupList));
        return groupList;
    }

    StorageType parseFSTypeOutput(VerificationCommand vfyCmd, Result rslt) {
        int[] fsTypeArr;
        String[] tags = new String[]{"FSTYPE"};
        String node = vfyCmd.getNode();
        String output = vfyCmd.getOutput();
        VerificationUtil.traceAndLog("node=" + node);
        Result result = vfyCmd.getResult();
        if (result.getStatus() != 1) {
            VerificationUtil.traceAndLog("exectask -getfstype command was not executed successfully");
            rslt.setStatus(2);
            rslt.addErrorDescription(new ErrorDescription(this.m_errMsgExecTags));
            return StorageType.UNKNOWN;
        }
        int vfyCode = vfyCmd.getVfyCode();
        VerificationUtil.traceAndLog("vfyCode='%s'", vfyCode);
        if (19 == vfyCode) {
            rslt.setStatus(3);
            return StorageType.UNKNOWN;
        }
        if (vfyCode != 0 || !VerificationUtil.isStringGood(output)) {
            rslt.setStatus(2);
            List<String> msgListExec = this.getExecErrors(vfyCmd);
            if (msgListExec.size() != 0) {
                for (String msg : msgListExec) {
                    rslt.addErrorDescription(new ErrorDescription(msg));
                }
            } else {
                rslt.addErrorDescription(new ErrorDescription(this.m_errMsgExecTags));
            }
            return StorageType.UNKNOWN;
        }
        try {
            fsTypeArr = GenericUtil.getIntFieldsByTags(output, tags);
        }
        catch (ParsingException pe) {
            VerificationUtil.traceAndLog("Problem parsing the string '" + output + "'" + LSEP + pe.getMessage());
            Trace.out((Exception)pe);
            rslt.setStatus(2);
            String errMsg = this.m_errMsgExecTags + LSEP + pe.getMessage();
            rslt.addErrorDescription(new ErrorDescription(errMsg));
            return StorageType.UNKNOWN;
        }
        int fsType = fsTypeArr[0];
        VerificationUtil.traceAndLog("fsType='%s'", fsType);
        if (fsType == 0) {
            VerificationUtil.traceAndLog("Found filesystem type as TYPE_NO_TYPE ;Treating it as file system not found");
            rslt.setStatus(3);
            return StorageType.UNKNOWN;
        }
        VerificationUtil.traceAndLog("Returning file system found...typically '%s'", new Object[]{StorageUtil.getTypeEnum(fsType)});
        return StorageUtil.getTypeEnum(fsType);
    }

    private List<String> getEntityErrors(VerificationCommand vfyCmd, EntityType entity) {
        ArrayList<String> errMsgList = new ArrayList<String>();
        HashMap<String, List<String>> execErrorsMap = this.getExecErrorsMap(vfyCmd);
        List<String> msgListExec = execErrorsMap.get(entity.name());
        if (msgListExec != null) {
            errMsgList.addAll(msgListExec);
        }
        VerificationUtil.traceAndLog("Returning '%s' error messages for entity '%s'", errMsgList.size(), entity.name());
        return errMsgList;
    }

    private List<String> getGlobalErrors(VerificationCommand vfyCmd) {
        ArrayList<String> errMsgList = new ArrayList<String>();
        HashMap<String, List<String>> execErrorsMap = this.getExecErrorsMap(vfyCmd);
        List<String> msgListExec = execErrorsMap.get(GLOBAL_ERR);
        if (msgListExec != null) {
            errMsgList.addAll(msgListExec);
        }
        VerificationUtil.traceAndLog("Returning '%s' global error messages", errMsgList.size());
        return errMsgList;
    }

    private List<String> getExecErrors(VerificationCommand vfyCmd) {
        ArrayList<String> errMsgList = new ArrayList<String>();
        HashMap<String, List<String>> execErrorsMap = this.getExecErrorsMap(vfyCmd);
        for (List<String> msgList : execErrorsMap.values()) {
            errMsgList.addAll(msgList);
        }
        VerificationUtil.traceAndLog("Returning '%s' error messages", errMsgList.size());
        return errMsgList;
    }

    HashMap<String, List<String>> getExecErrorsMap(VerificationCommand vfyCmd) {
        HashMap<String, List<String>> entityErrListMap = new HashMap<String, List<String>>();
        String node = vfyCmd.getNode();
        int vfyCode = vfyCmd.getVfyCode();
        VerificationUtil.traceAndLog("node=%s ; vfyCode=%s", node, vfyCode);
        String errMsg = "";
        String entity = GLOBAL_ERR;
        boolean okForDiscover = false;
        switch (vfyCode) {
            case 0: {
                break;
            }
            case 18: {
                errMsg = LSEP + s_msgBundle.getMessage("7015", true);
                break;
            }
            case 10010: {
                errMsg = LSEP + node + ": " + s_msgBundle.getMessage("7017", true);
                entity = EntityType.STORAGE_SIGNATURE.name();
                okForDiscover = true;
                break;
            }
            case 10013: {
                errMsg = LSEP + node + ": " + s_msgBundle.getMessage("7021", true);
                entity = EntityType.STORAGE_SIGNATURE.name();
                okForDiscover = true;
                break;
            }
            case 10019: {
                errMsg = LSEP + this.getDiskVersionErrMsg(vfyCmd);
                entity = EntityType.STORAGE_SIGNATURE.name();
                okForDiscover = true;
                break;
            }
            case 12: {
                errMsg = LSEP + node + ": " + s_msgBundle.getMessage("7016", true);
                okForDiscover = true;
                break;
            }
            case 10011: {
                break;
            }
            case 16: {
                errMsg = errMsg + LSEP + node + ": " + s_msgBundle.getMessage("7009", true);
                entity = EntityType.STORAGE_TYPE.name();
                okForDiscover = true;
                break;
            }
        }
        VerificationUtil.traceAndLog("entity=%s errMsg='%s' okForDiscover='%s'", entity, errMsg, okForDiscover);
        if (this.m_isDiscovery && !okForDiscover) {
            return entityErrListMap;
        }
        if (VerificationUtil.isStringGood(errMsg)) {
            entityErrListMap.put(entity, Arrays.asList(errMsg));
        }
        LinkedHashMap<String, List<String>> execErrorMap = vfyCmd.fetchExecutionErrorDetails();
        for (String entityName : execErrorMap.keySet()) {
            List<String> execErrList = execErrorMap.get(entityName);
            VerificationUtil.traceAndLog("execErrList has '%s' entries.", execErrList.size());
            VerificationUtil.traceAndLog("execErrList being added='%s'", VerificationUtil.strList2List(execErrList));
            List<String> entityErrList = entityErrListMap.get(entityName);
            if (entityErrList == null) {
                VerificationUtil.traceAndLog("No list exists for entity '%s'", entityName);
                entityErrListMap.put(entityName, execErrList);
                VerificationUtil.traceAndLog("Added list ='%s'", VerificationUtil.strList2List(entityErrListMap.get(entityName)));
                continue;
            }
            VerificationUtil.traceAndLog("A list already exists for enity '%s' with '%s' entries", entityName, entityErrList.size());
            ArrayList<String> newErrList = new ArrayList<String>();
            newErrList.addAll(entityErrList);
            newErrList.addAll(execErrList);
            entityErrListMap.put(entityName, newErrList);
            VerificationUtil.traceAndLog("Number of entries in the list after addition = '%s'", entityErrListMap.get(entityName).size());
        }
        VerificationUtil.traceAndLog("Returning entityErrListMap with '%s' entires", entityErrListMap.size());
        String debugTxt = vfyCmd.fetchExecutionLogDetails();
        VerificationUtil.traceAndLog(debugTxt);
        return entityErrListMap;
    }

    private String getDiskVersionErrMsg(VerificationCommand vfyCmd) {
        String error = vfyCmd.getError();
        String node = vfyCmd.getNodeName();
        VerificationUtil.traceAndLog("Error string: '" + error + "'");
        String installedVersion = VerificationUtil.fetchTextByTags(error, "<SLOS_OTHERINFO>", "</SLOS_OTHERINFO>");
        Object[] args = new Object[]{"cvuqdisk", node, "1.0.10-1", installedVersion};
        String msg = s_msgBundle.getMessage("7533", true, args);
        return msg;
    }

    public ASMDGData parseKfodOutputForDG(String output, Result rslt) {
        String sizeStr = null;
        String freeStr = null;
        String redundancyType = null;
        String dgName = null;
        String asmSID = null;
        double sizeDbl = -1.0;
        double freeDbl = -1.0;
        VerificationUtil.traceAndLog("output is ===>" + LSEP + output);
        rslt.setStatus(1);
        String[] values = output.trim().split("[ ]+");
        VerificationUtil.traceAndLog("values.length=%s", values.length);
        if (values.length < 4) {
            VerificationUtil.traceAndLog("kfod output did not contain the expected number of columns");
            rslt.setStatus(2);
            return null;
        }
        sizeStr = values[0];
        freeStr = values[1];
        redundancyType = values[2];
        dgName = values[3];
        if (values.length > 4) {
            asmSID = values[4];
        }
        ASMDGData dgData = new ASMDGData(dgName);
        try {
            sizeDbl = Double.parseDouble(sizeStr);
            dgData.setStorageSize(new StorageSize(sizeDbl, StorageUnit.MBYTE));
            freeDbl = Double.parseDouble(freeStr);
            dgData.setFreeSpace(new StorageSize(freeDbl, StorageUnit.MBYTE));
            dgData.setRedundancyType(redundancyType);
            dgData.setASMsid(asmSID);
        }
        catch (NumberFormatException e) {
            VerificationUtil.traceAndLog("Error in parsing of " + (sizeDbl == -1.0 ? "size" : "free"));
            rslt.setStatus(2);
            return null;
        }
        return dgData;
    }

    public PathDiskInfo parseDiskDetailResult(String path, VerificationCommand vfyCmd, Result rslt) {
        String node = vfyCmd.getNode();
        Result result = vfyCmd.getResult();
        String errMsg = s_gMsgBundle.getMessage("0819", true, (Object[])new String[]{path, node});
        DiskData diskData = new DiskData(path);
        int diskNum = -1;
        int partNum = -1;
        String fileSystem = null;
        String signature = null;
        String diskState = null;
        String mountPathOrigin = null;
        PathDiskInfo pathInfo = null;
        VerificationUtil.traceAndLog("path=%s ; node=%s ; status=%s", path, node, Result.resultStatusString(result.getStatus()));
        if (result.getStatus() != 1) {
            VerificationUtil.traceAndLog("'exectask -getdiskdetails <path>' command was not executedsuccessfully");
            rslt.setStatus(2);
            rslt.addErrorDescription(new ErrorDescription(errMsg));
            rslt.addErrorDescription(result.getErrors());
            return null;
        }
        int vfyCode = vfyCmd.getVfyCode();
        String output = vfyCmd.getOutput();
        VerificationUtil.traceAndLog("vfyCode='%s' output='%s'", vfyCode, output);
        if (vfyCode != 0 || !VerificationUtil.isStringGood(output)) {
            rslt.setStatus(2);
            rslt.addErrorDescription(new ErrorDescription(errMsg));
            List<String> msgListExec = this.getExecErrors(vfyCmd);
            if (msgListExec.size() != 0) {
                for (String msg : msgListExec) {
                    rslt.addErrorDescription(new ErrorDescription(msg));
                }
            } else {
                rslt.addErrorDescription(new ErrorDescription(this.m_errMsgExecTags));
            }
            return null;
        }
        try {
            diskNum = GenericUtil.getIntValueByKey(output, "DISKNUMBER");
            partNum = GenericUtil.getIntValueByKey(output, "PARTITIONNUMBER");
            fileSystem = GenericUtil.getValueByKey(output, "FSTYPE");
            signature = GenericUtil.getValueByKey(output, "DRIVESIGNATURE");
            mountPathOrigin = GenericUtil.getValueByKey(output, "REALPATH");
            if (output.indexOf("DISK_STATE") != -1) {
                diskState = GenericUtil.getValueByKey(output, "DISK_STATE");
                VerificationUtil.traceAndLog("disk state is " + diskState);
                diskData.setState(diskState);
            }
            diskData.setID("\\Device\\Harddisk" + diskNum);
            diskData.setStorageSignature(new StorageSignature(signature));
            diskData.setEffectiveID(mountPathOrigin);
            pathInfo = new PathDiskInfo(node, path, diskData, Integer.toString(partNum), signature, fileSystem, mountPathOrigin);
            rslt.setStatus(1);
            return pathInfo;
        }
        catch (ParsingException pe) {
            VerificationUtil.traceAndLog("Problem parsing the string '" + output + "'" + LSEP + pe.getMessage());
            Trace.out((Exception)pe);
            rslt.setStatus(2);
            rslt.addErrorDescription(new ErrorDescription(errMsg));
            rslt.addErrorDescription(new ErrorDescription(this.m_errMsgExecTags + LSEP + pe.getMessage()));
            return null;
        }
    }
}

