/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.KFODUtil;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageType;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.nodemgr.NoSuchNodesException;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.nodemgr.NodeManagerFactoryException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.SharedDeviceException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Entity;
import oracle.ops.verification.framework.engine.EntityStatus;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.GlobalVerificationContext;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.storage.ACFSData;
import oracle.ops.verification.framework.storage.ASMDGData;
import oracle.ops.verification.framework.storage.DiskData;
import oracle.ops.verification.framework.storage.StorageCheckContext;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageData;
import oracle.ops.verification.framework.storage.StorageDataParser;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageSignature;
import oracle.ops.verification.framework.storage.StorageUtil;
import oracle.ops.verification.framework.storage.sStorageUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.CVUAutoUpdateManager;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class StorageDataHandler
implements StorageConstants {
    protected static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    protected static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    static final String LSEP = VerificationConstants.LSEP;
    static final String FSEP = VerificationConstants.FSEP;
    boolean m_isUnix = new SystemFactory().CreateSystem().isUnixSystem();
    GlobalVerificationContext m_gCtx = GlobalVerificationContext.getInstance();
    StorageCheckContext m_scCtx;
    String m_localHost = VerificationUtil.getLocalHostName();

    public StorageDataHandler() {
        this(new StorageCheckContext());
    }

    public StorageDataHandler(StorageCheckContext scCtx) {
        this.m_scCtx = scCtx;
    }

    public void discoverStorageData(String[] nodeList, HashMap<StorageType, HashMap<String, HashMap<String, StorageData>>> typeStorageMap, HashMap<StorageType, List<String>> potentialMatchStorageMap, ResultSet rSet) {
        rSet.addResult(nodeList, 1);
        List<StorageType> stTypeList = this.getDiscoverableStorageTypes();
        for (StorageType stType : stTypeList) {
            HashMap<String, HashMap<String, StorageData>> idNodeSDmap = new HashMap<String, HashMap<String, StorageData>>();
            ArrayList<String> potentialMatchList = new ArrayList<String>();
            ResultSet locRS = new ResultSet();
            this.getIdBasedStorageData(stType, nodeList, idNodeSDmap, potentialMatchList, locRS);
            if (locRS.getStatus() != 1) {
                VerificationUtil.traceAndLog("Error is discovering storage of type '%s'", stType.name());
                rSet.addResultSetData(locRS);
                continue;
            }
            VerificationUtil.traceAndLog("Storage of type '%s' was successfully discovered[count of storage found = '%s']", stType.name(), idNodeSDmap.size());
            if (idNodeSDmap.size() != 0) {
                typeStorageMap.put(stType, idNodeSDmap);
            }
            Trace.out((String)("stType " + (Object)((Object)stType) + " potentialMatchList size " + potentialMatchList.size()));
            if (potentialMatchList.isEmpty()) continue;
            potentialMatchStorageMap.put(stType, potentialMatchList);
        }
        this.traceDiscoveredSet(typeStorageMap);
    }

    void getIdBasedStorageData(StorageType type, String[] nodeList, HashMap<String, HashMap<String, StorageData>> idNodeSDmap, List<String> potentialMatchesList, ResultSet rSet) {
        HashMap<String, List<StorageData>> nodeSDListMap = new HashMap<String, List<StorageData>>();
        rSet.addResult(nodeList, 1);
        if (!VerificationUtil.isCVUTestEnv() && (type == StorageType.DISK || type == StorageType.DISK_PARTITION) && VerificationUtil.isVirtualEnvironment()) {
            Trace.out((String)"Virtual environment detected. Skipping the sharedness check for type Disk.");
            rSet.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("1614", true)));
            rSet.addResult(nodeList, 4);
            return;
        }
        ResultSet locRS = new ResultSet();
        this.getStorageData(type, nodeList, nodeSDListMap, locRS);
        if (locRS.getStatus() != 1) {
            VerificationUtil.traceAndLog("Error encountered in getting the details for storage type '%s'", type.name());
            rSet.addResultSetData(locRS);
            return;
        }
        for (String node : nodeSDListMap.keySet()) {
            List<StorageData> sdList = nodeSDListMap.get(node);
            for (StorageData stData : sdList) {
                String id = stData.getID();
                HashMap<String, StorageData> nodeSDmap = idNodeSDmap.get(id);
                if (nodeSDmap != null) {
                    nodeSDmap.put(node, stData);
                    VerificationUtil.traceAndLog("Updated an exisiting entry for ID '%s' with node<-->SD map for node '%s'", id, node);
                    continue;
                }
                nodeSDmap = new HashMap();
                nodeSDmap.put(node, stData);
                idNodeSDmap.put(id, nodeSDmap);
                VerificationUtil.traceAndLog("Created a new entry for ID '%s' with node<-->SD map for node '%s'", id, node);
            }
        }
        if (nodeList.length > 1 && type == StorageType.DISK) {
            int nodeCount = nodeList.length;
            ArrayList<String> ignoreStorageIDs = new ArrayList<String>();
            for (String stId : idNodeSDmap.keySet()) {
                HashMap<String, StorageData> nodeSDmap = idNodeSDmap.get(stId);
                if (nodeCount != nodeSDmap.size()) continue;
                boolean potentialMatch = false;
                StorageData stData = null;
                for (String node : nodeSDmap.keySet()) {
                    stData = nodeSDmap.get(node);
                    if (!VerificationUtil.isStringGood(stData.getSignatureString()) && stData.getStorageSignature().getErrors().size() > 0) {
                        potentialMatch = true;
                        continue;
                    }
                    potentialMatch = false;
                    break;
                }
                if (!potentialMatch) continue;
                potentialMatchesList.add(stId);
                ignoreStorageIDs.add(stId);
            }
            for (String igStId : ignoreStorageIDs) {
                idNodeSDmap.remove(igStId);
            }
            Trace.out((String)("potentialMatchesList size" + potentialMatchesList.size()));
        }
        HashMap<String, HashMap<String, StorageData>> idNodeSDmapCopy = new HashMap<String, HashMap<String, StorageData>>(idNodeSDmap);
        for (String id : idNodeSDmapCopy.keySet()) {
            HashMap<String, StorageData> nodeSDmap = idNodeSDmapCopy.get(id);
            locRS = new ResultSet();
            this.checkSharedness(nodeSDmap, locRS);
            if (!locRS.allSuccess()) {
                VerificationUtil.traceAndLog("Sharedness check failed for storage ID '%s'", id);
                idNodeSDmap.remove(id);
                continue;
            }
            VerificationUtil.traceAndLog("Sharedness check passed for storage ID '%s'", id);
            locRS = new ResultSet();
            this.checkStorageAttributes(nodeSDmap, locRS);
            if (!locRS.allSuccess() || nodeSDmap.size() == 0) {
                VerificationUtil.traceAndLog("Status=%s Count=%d", ResultSet.resultsetStatusString(locRS.getStatus()), nodeSDmap.size());
                VerificationUtil.traceAndLog("Dropped storage ID '%s' because attributes check failed", id);
                idNodeSDmap.remove(id);
                continue;
            }
            VerificationUtil.traceAndLog("Attributes check passed for storage ID '%s'", id);
        }
    }

    void getStorageData(StorageType type, String[] nodeList, HashMap<String, List<StorageData>> nodeSDListMap, ResultSet rSet) {
        VerificationUtil.traceAndLog("type=%s ; nodeList=%s", type.name(), VerificationUtil.strArr2List(nodeList));
        if (type == StorageType.ACFS) {
            this.getStorageDataForACFS(nodeList, nodeSDListMap, rSet);
            return;
        }
        if (type == StorageType.ASMDG) {
            this.getStorageDataForASMDG(nodeList, nodeSDListMap, rSet);
            return;
        }
        VerificationCommand[] cmdArr = new VerificationCommand[nodeList.length];
        for (int i = 0; i < nodeList.length; ++i) {
            cmdArr[i] = this.getDiscoveryCommand(type, nodeList[i]);
        }
        if (nodeList.length == 1) {
            cmdArr[0].execute();
        } else {
            ResultSet locRS = new ResultSet();
            new GlobalHandler().submit((Command[])cmdArr, 0, locRS);
            VerificationUtil.traceAndLog("Status='%s'", ResultSet.resultsetStatusString(locRS.getStatus()));
        }
        for (VerificationCommand cmd : cmdArr) {
            String node = cmd.getNodeName();
            ArrayList<StorageData> sdList = new ArrayList<StorageData>();
            Result rslt = new Result(node);
            new StorageDataParser(this.m_scCtx).parseDataFromExectask(type, cmd, rslt, sdList);
            rSet.addResult(node, rslt);
            if (rslt.getStatus() != 1 || sdList.size() == 0) continue;
            nodeSDListMap.put(node, sdList);
        }
    }

    void getStorageDataForACFS(String[] nodeList, HashMap<String, List<StorageData>> nodeSDListMap, ResultSet rSet) {
        rSet.addResult(nodeList, 1);
        for (String node : nodeList) {
            Result rslt = new Result(node);
            ArrayList<StorageData> sdList = new ArrayList<StorageData>();
            this.getACFSDataOnNode(node, sdList, rslt);
            if (rslt.getStatus() == 1) {
                VerificationUtil.traceAndLog("Discovered '%s' ACFS storage from node '%s'", sdList.size(), node);
                if (sdList.size() == 0) continue;
                nodeSDListMap.put(node, sdList);
                continue;
            }
            VerificationUtil.traceAndLog("Error encountered in discovering ACFS on node '%s'", node);
        }
    }

    void getACFSDataOnNode(String node, List<StorageData> sdList, Result rslt) {
        ClusterwareInfo cwInfo = new ClusterwareInfo();
        String crsHAhome = null;
        String diskGrpName = null;
        long size = 0L;
        long free = 0L;
        ACFSData acfsData = null;
        rslt.setStatus(1);
        sdList.clear();
        try {
            if (cwInfo.isCRSConfiguredOnNode(node)) {
                VerificationUtil.traceAndLog("CRS is configured on node '%s'", node);
                crsHAhome = VerificationUtil.getCRSHome();
            } else if (cwInfo.isHAConfiguredOnNode(node)) {
                VerificationUtil.traceAndLog("HA is configured on node '%s'", node);
                crsHAhome = VerificationUtil.getHAHome();
            }
            if (crsHAhome == null) {
                VerificationUtil.traceAndLog("CRS or HA home could not be obtained");
                return;
            }
            if (this.m_isUnix) {
                VerificationUtil.traceAndLog("Checking for ACFS installation on Unix node '%s'", node);
                if (!cwInfo.isOFSDriversConfiguredforNode(node)) {
                    VerificationUtil.traceAndLog("No ACFS installation found on node '%s'", node);
                    return;
                }
            } else {
                VerificationUtil.traceAndLog("Checking for ACFS installation on Windows node '%s'", node);
                if (!cwInfo.isOFSDriversConfigured(crsHAhome + FSEP + "bin", node)) {
                    VerificationUtil.traceAndLog("No ACFS installation found on node '%s'", node);
                    return;
                }
            }
            List acfsMntPnts = cwInfo.getOFSMountPointsforNode(node);
            for (String location : acfsMntPnts) {
                VerificationUtil.traceAndLog("ACFS mount point: '" + location + "'");
                String actVer = cwInfo.getOFSActiveVersionforNode(node);
                diskGrpName = cwInfo.getOFSDiskGroupNameforNode(location, node);
                size = cwInfo.getOFSTotalSizeforNode(location, node);
                free = cwInfo.getOFSFreeSpaceforNode(location, node);
                acfsData = new ACFSData(location, actVer, diskGrpName, free, size);
                sdList.add(acfsData);
            }
        }
        catch (InstallException ie) {
            VerificationUtil.traceAndLog("INSTALLEXCEPTION: " + LSEP + (Object)((Object)ie));
            VerificationLogData.logError("INSTALLEXCEPTION: " + ie.getMessage() + "\n" + Trace.getStackTrace((Throwable)ie));
            return;
        }
    }

    void getStorageDataForASMDG(String[] nodeList, HashMap<String, List<StorageData>> nodeSDListMap, ResultSet rSet) {
        rSet.addResult(nodeList, 1);
        ASMDiskGroupsUtil asmdgUtl = new ASMDiskGroupsUtil();
        HashMap<String, List<ASMDGData>> nodeDGListMap = new HashMap<String, List<ASMDGData>>();
        ResultSet locRS = new ResultSet();
        asmdgUtl.getDiskGroups(nodeList, locRS, nodeDGListMap);
        VerificationUtil.traceAndLog("Status='%s'", ResultSet.resultsetStatusString(locRS.getStatus()));
        if (locRS.getStatus() == 2) {
            VerificationUtil.traceAndLog("Error encountered in discovering ASMDG");
            rSet.addResultSetData(locRS);
        } else if (nodeDGListMap.size() != 0) {
            for (String node : nodeDGListMap.keySet()) {
                List<ASMDGData> dgDataList = nodeDGListMap.get(node);
                ArrayList<ASMDGData> sdList = new ArrayList<ASMDGData>(nodeDGListMap.size());
                for (ASMDGData dgData : dgDataList) {
                    sdList.add(dgData);
                }
                nodeSDListMap.put(node, sdList);
            }
        }
    }

    public StorageData getStorageData(String id, String node) {
        return this.getStorageData(id, new String[]{node}).get(node);
    }

    public HashMap<String, StorageData> getStorageData(String id, String[] nodeList) {
        HashMap<String, StorageData> nodeSDmap = new HashMap<String, StorageData>();
        VerificationUtil.traceAndLog("id: '%s'; nodeList: '%s'", id, VerificationUtil.strArr2List(nodeList));
        this.checkStorageForASM(id, nodeList, nodeSDmap);
        if (nodeSDmap.size() != 0) {
            return nodeSDmap;
        }
        if (VerificationUtil.isPlatformLinux() && StorageUtil.isASMLibPath(id)) {
            this.checkASMLibManagedDisks(id, nodeList, nodeSDmap);
            if (nodeSDmap.size() != 0) {
                return nodeSDmap;
            }
        }
        VerificationUtil.traceAndLog("Attempting to execute 'exectask -getstorage <path>' command");
        VerificationCommand[] cmdArr = new VerificationCommand[nodeList.length];
        String[] args = new String[]{"-getstorage", id};
        for (int i = 0; i < nodeList.length; ++i) {
            cmdArr[i] = new VerificationCommand(nodeList[i], args, null);
        }
        if (nodeList.length == 1) {
            cmdArr[0].execute();
        } else {
            ResultSet locRS = new ResultSet();
            new GlobalHandler().submit((Command[])cmdArr, 0, locRS);
            VerificationUtil.traceAndLog("Status='%s'", ResultSet.resultsetStatusString(locRS.getStatus()));
        }
        for (VerificationCommand cmd : cmdArr) {
            String node = cmd.getNodeName();
            StorageData stData = new StorageDataParser(this.m_scCtx).parseDataFromExectask(id, cmd);
            nodeSDmap.put(node, stData);
        }
        return nodeSDmap;
    }

    public void checkSharedness(HashMap<String, StorageData> nodeSDmap, ResultSet rSet) {
        this.checkSharedness(nodeSDmap, nodeSDmap.size(), new ArrayList<String>(), rSet);
    }

    public void checkSharedness(HashMap<String, StorageData> nodeSDmap, int targetCount, List<String> succNodeList, ResultSet rSet) {
        StorageData stData;
        String[] nodeList = nodeSDmap.keySet().toArray(new String[0]);
        String suppliedPath = "";
        suppliedPath = nodeSDmap.values().iterator().next().getSuppliedID();
        HashMap<StorageType, Object> typeNodesMap = new HashMap<StorageType, Object>();
        HashMap<String, String> nodeValidPathMap = new HashMap<String, String>();
        VerificationUtil.traceAndLog("size of nodeSDmap=" + nodeSDmap.size() + "; path=" + suppliedPath + "; targetCount=" + targetCount);
        for (String string : nodeSDmap.keySet()) {
            stData = nodeSDmap.get(string);
            nodeValidPathMap.put(string, nodeSDmap.get(string).getID());
            Entity<StorageType> stTypeEntity = stData.getStorageType();
            VerificationUtil.traceAndLog("stTypeEntity=" + stTypeEntity);
            if (stTypeEntity == null || stTypeEntity.getStatus() != EntityStatus.VALID) {
                rSet.addResult(string, 2);
                VerificationUtil.traceAndLog("Storage type for path '" + suppliedPath + "' could not be retrieved from node '" + string + "'");
                if (stTypeEntity == null) continue;
                rSet.addErrorDescription(string, stTypeEntity.getErrors());
                continue;
            }
            StorageType storageType = stTypeEntity.getValue();
            if (typeNodesMap.containsKey((Object)storageType)) {
                ((List)typeNodesMap.get((Object)storageType)).add(string);
            } else {
                ArrayList<String> nodeListForType = new ArrayList<String>();
                nodeListForType.add(string);
                typeNodesMap.put(storageType, nodeListForType);
            }
            rSet.addResult(string, 1);
        }
        if (!rSet.allSuccess()) {
            return;
        }
        if (typeNodesMap.size() != 1) {
            VerificationUtil.traceAndLog("Different types are retrieved for path'" + suppliedPath + "'");
            String errMsg = s_gMsgBundle.getMessage("0803", true, (Object[])new String[]{suppliedPath});
            for (StorageType type : typeNodesMap.keySet()) {
                ArrayList<String> nodesWithPath = new ArrayList<String>();
                HashMap idNodeMap = new HashMap();
                for (String node : (List)typeNodesMap.get((Object)type)) {
                    String pathID = (String)nodeValidPathMap.get(node);
                    if (pathID.equals(suppliedPath)) {
                        nodesWithPath.add(node);
                        continue;
                    }
                    if (!idNodeMap.containsKey(pathID)) {
                        idNodeMap.put(pathID, new ArrayList());
                    }
                    ((List)idNodeMap.get(pathID)).add(node);
                }
                if (!nodesWithPath.isEmpty()) {
                    VerificationUtil.traceAndLog("Type '" + (Object)((Object)type) + "' obtained from nodes: " + VerificationUtil.strList2List((List)typeNodesMap.get((Object)type)));
                    errMsg = errMsg + LSEP + "   " + s_gMsgBundle.getMessage("0804", false, (Object[])new String[]{type.name(), VerificationUtil.strList2List(nodesWithPath)});
                }
                if (idNodeMap.isEmpty()) continue;
                for (String pathID : idNodeMap.keySet()) {
                    VerificationUtil.traceAndLog("Longest existing parent '" + pathID + "', Type '" + (Object)((Object)type) + "' obtained from nodes: " + VerificationUtil.strList2List((List)typeNodesMap.get((Object)type)) + " for the supplied path '" + suppliedPath + "'");
                    errMsg = errMsg + LSEP + "   " + s_gMsgBundle.getMessage("0830", false, (Object[])new String[]{suppliedPath, VerificationUtil.strList2List((List)idNodeMap.get(pathID)), pathID, type.name()});
                }
            }
            rSet.addResult(nodeList, 3);
            rSet.addErrorDescription(new ErrorDescription(errMsg));
            return;
        }
        if (nodeList.length < 2) {
            VerificationUtil.traceAndLog("Storage type based sharedness check skipped as the number of nodes is less than 2");
            rSet.addResult(nodeList, 1);
            succNodeList.add(nodeList[0]);
            return;
        }
        String string = ((StorageType)((Object)typeNodesMap.keySet().iterator().next())).toString();
        stData = nodeSDmap.values().iterator().next();
        VerificationUtil.traceAndLog("Storage Type=" + string + "; SignatureAppplicable=" + stData.isSignatureApplicable());
        if (targetCount != -1 && targetCount < nodeList.length && stData.isSignatureApplicable()) {
            StorageDataHandler.checkSignatures(nodeSDmap, targetCount, succNodeList, rSet);
        } else {
            VerificationUtil.traceAndLog("Asking StorageData object for sharedness check");
            stData.checkSharedness(nodeSDmap, rSet);
            if (rSet.getStatus() == 1) {
                succNodeList.addAll(Arrays.asList(nodeList));
            }
        }
    }

    public static void checkFileSystemSharedness(HashMap<String, StorageData> nodeSDmap, ResultSet rSet) {
        String[] nodeList = nodeSDmap.keySet().toArray(new String[0]);
        String nodeListStr = VerificationUtil.strArr2List(nodeList);
        String path = nodeSDmap.values().iterator().next().getID();
        String localNode = VerificationUtil.getLocalNode();
        VerificationUtil.traceAndLog("path='" + path + "'; nodeList='" + nodeListStr + "'");
        for (String node : nodeSDmap.keySet()) {
            StorageData stData = nodeSDmap.get(node);
            if (!stData.hasErrors()) continue;
            rSet.addResult(node, 2);
            rSet.addErrorDescription(node, stData.getErrors());
        }
        if (!rSet.allSuccess()) {
            return;
        }
        if (nodeList.length == 1) {
            rSet.addResult(nodeList, 1);
            return;
        }
        boolean retVal = false;
        String errMsg = LSEP + s_gMsgBundle.getMessage("10130", true, (Object[])new String[]{path, nodeListStr});
        try {
            retVal = Cluster.isSharedPath((String)path, (String[])nodeList, (String)localNode);
            if (retVal) {
                VerificationUtil.traceAndLog("Reporting that file system path IS shared");
                rSet.addResult(nodeList, 1);
            } else {
                VerificationUtil.traceAndLog("Reporting that file system path is NOT shared");
                rSet.addResult(nodeList, 3);
            }
        }
        catch (SharedDeviceException sde) {
            VerificationUtil.traceAndLog("SharedDeviceException: " + sde.getMessage());
            errMsg = errMsg + LSEP + sde.getMessage();
            rSet.addResult(nodeList, 2);
            rSet.addErrorDescription(new ErrorDescription(errMsg));
        }
        catch (InvalidNodeListException ine) {
            VerificationUtil.traceAndLog("InvalidNodeListException: " + ine.getMessage());
            errMsg = errMsg + LSEP + ine.getMessage();
            rSet.addResult(nodeList, 2);
            rSet.addErrorDescription(new ErrorDescription(errMsg));
        }
    }

    public static void checkSignatures(HashMap<String, StorageData> nodeSDmap, ResultSet rSet) {
        StorageDataHandler.checkSignatures(nodeSDmap, nodeSDmap.size(), new ArrayList<String>(), rSet);
    }

    public static void checkSignatures(HashMap<String, StorageData> nodeSDmap, int targetCount, List<String> succNodeList, ResultSet rSet) {
        String[] nodeArr = nodeSDmap.keySet().toArray(new String[0]);
        List<String> nodeList = Arrays.asList(nodeArr);
        String path = "";
        String suppliedPath = "";
        path = nodeSDmap.values().iterator().next().getID();
        suppliedPath = nodeSDmap.values().iterator().next().getSuppliedID();
        VerificationUtil.traceAndLog("size of nodeSDmap=" + nodeSDmap.size() + "; path=" + path);
        succNodeList.clear();
        for (String node : nodeSDmap.keySet()) {
            StorageData stData = nodeSDmap.get(node);
            if (stData.getStorageSignature().getStatus() == EntityStatus.INVALID) {
                rSet.addResult(node, 4);
                rSet.addErrorDescription(node, stData.getErrors());
                continue;
            }
            if (!stData.hasErrors()) continue;
            rSet.addResult(node, 2);
            rSet.addErrorDescription(node, stData.getErrors());
        }
        if (!rSet.allSuccess() || rSet.anyWarning()) {
            return;
        }
        HashMap signNodesMap = new HashMap();
        for (String node : nodeSDmap.keySet()) {
            StorageData stData = nodeSDmap.get(node);
            Entity<StorageSignature> signatureEntity = stData.getStorageSignature();
            VerificationUtil.traceAndLog("signatureEntity=" + signatureEntity);
            if (signatureEntity == null || signatureEntity.getStatus() != EntityStatus.VALID) {
                rSet.addResult(node, 2);
                VerificationUtil.traceAndLog("Signature for path '" + path + "' could not be retrieved from node '" + node + "'");
                if (signatureEntity == null) continue;
                rSet.addErrorDescription(node, signatureEntity.getErrors());
                continue;
            }
            String stSignature = signatureEntity.getValue().getSignature();
            if (signNodesMap.containsKey(stSignature)) {
                ((List)signNodesMap.get(stSignature)).add(node);
            } else {
                ArrayList<String> nodeListForSignature = new ArrayList<String>();
                nodeListForSignature.add(node);
                signNodesMap.put(stSignature, nodeListForSignature);
            }
            rSet.addResult(node, 1);
        }
        if (!rSet.allSuccess()) {
            return;
        }
        VerificationUtil.traceAndLog("Validating same signature");
        if (signNodesMap.size() != 1) {
            if (targetCount < nodeList.size()) {
                int maxNodeCount = -1;
                ArrayList nodeListWithMaxCount = new ArrayList();
                for (String sign : signNodesMap.keySet()) {
                    List thisNodeList = (List)signNodesMap.get(sign);
                    int thisNodeCount = thisNodeList.size();
                    if (thisNodeCount <= maxNodeCount) continue;
                    maxNodeCount = thisNodeCount;
                    nodeListWithMaxCount.clear();
                    nodeListWithMaxCount.addAll(thisNodeList);
                }
                if (maxNodeCount < targetCount) {
                    rSet.addResult(nodeList, 3);
                } else {
                    rSet.addResult(nodeList, 1);
                    succNodeList.addAll(nodeListWithMaxCount);
                }
            } else {
                VerificationUtil.traceAndLog("Different signatures are retrieved for path '" + path + "(" + suppliedPath + ")'");
                String errMsg = s_gMsgBundle.getMessage("0806", true, (Object[])new String[]{suppliedPath});
                for (String sign : signNodesMap.keySet()) {
                    VerificationUtil.traceAndLog("Sign '" + sign + "' obtained from nodes: " + VerificationUtil.strList2List((List)signNodesMap.get(sign)));
                    errMsg = errMsg + LSEP + "   " + s_gMsgBundle.getMessage("0807", false, (Object[])new String[]{sign, VerificationUtil.strList2List((List)signNodesMap.get(sign))});
                }
                rSet.addResult(nodeList, 3);
                rSet.addErrorDescription(new ErrorDescription(errMsg));
            }
        } else {
            succNodeList.addAll(nodeList);
        }
    }

    public void checkUsageCompatibility(HashMap<String, StorageData> nodeSDmap, ResultSet rSet) {
        String[] nodeList = nodeSDmap.keySet().toArray(new String[0]);
        StorageData stData = nodeSDmap.values().iterator().next();
        StorageType stTypeInEnum = stData.getStorageType().getValue();
        int stTypeInInt = StorageDataHandler.getTypeIntFromEnum(stTypeInEnum);
        String stTypeInStr = StorageUtil.getTypeStr(stTypeInInt);
        String storageID = stData.getID();
        OracleFileType usageType = this.m_scCtx.getUsageType();
        String release = this.m_scCtx.getRelease();
        boolean considerASMStorage = this.m_scCtx.considerASMStorage();
        int[] supportedStorageTypes = sStorageUtil.getSupportedFileTypes(usageType, release, considerASMStorage);
        ArrayList<String> supportedTypesStr = new ArrayList<String>();
        for (int supportStorageType : supportedStorageTypes) {
            supportedTypesStr.add(sStorageUtil.getTypeStr(supportStorageType));
        }
        boolean supported = false;
        for (int supportedType : supportedStorageTypes) {
            if (stTypeInInt != supportedType) continue;
            VerificationUtil.traceAndLog("The storage type '" + stTypeInStr + "' is found suitable for: " + usageType.name());
            supported = true;
            break;
        }
        if (!supported) {
            VerificationUtil.traceAndLog("The storage type for '" + storageID + "' is not found suitable for:" + usageType.name());
            HashMap<String, String> h = StorageDataHandler.getSuitabilityMsg(usageType);
            MessageBundle msgBundle = VerificationUtil.getMessageBundle(h.keySet().iterator().next());
            String errMsg = msgBundle.getMessage(h.values().iterator().next(), true, (Object[])new String[]{storageID, stTypeInStr, release, VerificationUtil.strCollection2String(supportedTypesStr, ", ")});
            rSet.addResult(nodeList, 3);
            rSet.addErrorDescription(new ErrorDescription(errMsg));
            return;
        }
        if (stTypeInInt == 14) {
            try {
                String[] rimNodes;
                NodeManager nm = NodeManagerFactory.getInstance().getNodeManager();
                if (nm.isBigCluster() && (rimNodes = nm.getNodes(nodeList, NodeRoleCapability.RIM)) != null) {
                    String rimNodesList = VerificationUtil.strArr2List(rimNodes);
                    VerificationUtil.traceAndLog("ACFS path '%s' is not suitable for rim nodes:'%s'", storageID, rimNodesList);
                    String errMsg = s_gMsgBundle.getMessage("11500", true, (Object[])new String[]{storageID, rimNodesList});
                    rSet.addResult(nodeList, 3);
                    rSet.addErrorDescription(new ErrorDescription(errMsg));
                    return;
                }
            }
            catch (NodeManagerFactoryException e) {
                VerificationUtil.traceAndLog("IGNORED: %s : %s", e.getClass(), e.getMessage());
            }
            catch (NoSuchNodesException e) {
                VerificationUtil.traceAndLog("IGNORED: %s : %s", e.getClass(), e.getMessage());
            }
            catch (NodeManagerException e) {
                VerificationUtil.traceAndLog("IGNORED: %s : %s", e.getClass(), e.getMessage());
            }
        }
        rSet.addResult(nodeList, 1);
    }

    public void checkStorageAttributes(HashMap<String, StorageData> nodeSDmap, ResultSet rSet) {
        nodeSDmap.values().iterator().next().checkStorageAttributes(nodeSDmap, this.m_scCtx, rSet);
    }

    public void checkVGAttributes(HashMap<String, StorageData> nodeSDmap, ResultSet rSet) {
        String errMsg;
        StorageData stData = nodeSDmap.values().iterator().next();
        StorageType type = stData.getStorageType().getValue();
        Set<String> nodeSet = nodeSDmap.keySet();
        String[] nodeList = nodeSDmap.keySet().toArray(new String[0]);
        rSet.addResult(nodeList, 1);
        String[] vendorNodeArr = null;
        try {
            String lsnodesHome = CVUAutoUpdateManager.getLSNodesHome(VerificationUtil.isAPIMode());
            ClusterInfo clusterInfo = new ClusterInfo(lsnodesHome, Version.get92Version());
            vendorNodeArr = clusterInfo.getNodeNames();
        }
        catch (ClusterInfoException e) {
            VerificationUtil.traceAndLog("Couldn't get the vendor cluster nodes" + e.getMessage());
            String errMsg2 = s_gMsgBundle.getMessage("0812", true);
            errMsg2 = errMsg2 + e.getMessage();
            rSet.addResult(nodeList, 2);
            rSet.addErrorDescription(new ErrorDescription(errMsg2));
            return;
        }
        List<String> vendorNodeList = Arrays.asList(vendorNodeArr);
        for (String node : nodeList) {
            if (vendorNodeList.contains(node)) continue;
            if (this.m_scCtx.isDiscovery()) {
                VerificationUtil.traceAndLog("Removed entry for node '%s' from nodeSDmap", node);
                nodeSDmap.remove(node);
                if (nodeSDmap.size() != 0) continue;
                return;
            }
            errMsg = s_gMsgBundle.getMessage("0813", true, (Object[])new String[]{node});
            rSet.addResult(nodeList, 3);
            rSet.addErrorDescription(new ErrorDescription(errMsg));
        }
        String localNode = VerificationUtil.getLocalNode();
        if (nodeSet.contains(localNode)) {
            return;
        }
        HashMap<String, List<StorageData>> nodeSDListMap = new HashMap<String, List<StorageData>>();
        ResultSet locRS = new ResultSet();
        this.getStorageData(type, new String[]{localNode}, nodeSDListMap, locRS);
        if (!locRS.allSuccess()) {
            errMsg = s_gMsgBundle.getMessage("0814", true, (Object[])new String[]{localNode});
            rSet.addResult(nodeList, 2);
            rSet.addErrorDescription(new ErrorDescription(errMsg));
            return;
        }
        List<StorageData> listVGonLocalNode = nodeSDListMap.get(localNode);
        String signOfSharedSet = stData.getSignatureString();
        VerificationUtil.traceAndLog("Common signature in shared set is '%s'", signOfSharedSet);
        for (StorageData stDataLocal : listVGonLocalNode) {
            String signOfLocalVG = stDataLocal.getSignatureString();
            VerificationUtil.traceAndLog("Signature of VG '%s' on local node is '%s'", stDataLocal.getID(), signOfLocalVG);
            if (signOfLocalVG == null || !signOfLocalVG.matches(signOfSharedSet)) continue;
            VerificationUtil.traceAndLog("Match found with VG '%s", stDataLocal.getID());
            return;
        }
        if (this.m_scCtx.isDiscovery()) {
            nodeSDmap.clear();
        } else {
            rSet.addResult(nodeList, 3);
            errMsg = s_gMsgBundle.getMessage("0815", true, (Object[])new String[]{signOfSharedSet, localNode});
            rSet.addErrorDescription(new ErrorDescription(errMsg));
        }
    }

    private void checkStorageForExadata(String id, String[] nodeList, HashMap<String, StorageData> nodeSDmap) {
        if (!StorageUtil.isExadataPath(id)) {
            Trace.out((String)"Storage id does not specify a cell os path");
            return;
        }
        for (String node : nodeList) {
            StorageData stData = new StorageData(id, StorageType.DISK);
            nodeSDmap.put(node, stData);
        }
    }

    private void checkASMLibManagedDisks(String id, String[] nodeList, HashMap<String, StorageData> nodeSDmap) {
        ResultSet checkStampResultSet = sStorageUtil.processASMStamp(nodeList, id);
        if (!checkStampResultSet.anySuccess()) {
            Trace.out((String)"Storage id is not managed by ASMLib");
            return;
        }
        for (String node : nodeList) {
            StorageData stData;
            Result nodeResult = checkStampResultSet.getResult(node);
            if (nodeResult.getStatus() == 1) {
                stData = new StorageData(id, StorageType.DISK);
                nodeSDmap.put(node, stData);
                continue;
            }
            stData = new StorageData(id);
            for (VerificationError ve : nodeResult.getErrors()) {
                stData.getStorageType().addErrDesc(new ErrorDescription(ve.getErrorMessage()));
            }
            nodeSDmap.put(node, stData);
        }
    }

    private void checkStorageForASM(String id, String[] nodeList, HashMap<String, StorageData> nodeSDmap) {
        block14: {
            boolean isException;
            String errMsg;
            block15: {
                Vector asmDGdata = null;
                errMsg = s_gMsgBundle.getMessage("11420", true, (Object[])new String[]{id});
                isException = false;
                VerificationUtil.traceAndLog("id='%s' ; nodeList='%s'", id, VerificationUtil.strArr2List(nodeList));
                if (id.startsWith(FSEP)) {
                    VerificationUtil.traceAndLog("Storage id does not specify an ASM DG");
                    return;
                }
                String localNode = VerificationUtil.getLocalNode();
                ArrayList<String> checkNodeList = new ArrayList<String>();
                checkNodeList.addAll(Arrays.asList(nodeList));
                if (!checkNodeList.contains(localNode)) {
                    checkNodeList.add(localNode);
                }
                try {
                    if (this.m_gCtx.isCRSConfigured() || this.m_gCtx.isHAConfigured()) {
                        VerificationUtil.traceAndLog("isCRSConfigured='%s'", this.m_gCtx.isCRSConfigured());
                        VerificationUtil.traceAndLog("isHAConfigured='%s'", this.m_gCtx.isHAConfigured());
                        ArrayList<String> runningNodeList = new ArrayList<String>();
                        ArrayList<String> failedNodeList = new ArrayList<String>();
                        new ASMDiskGroupsUtil().checkASMRunning(checkNodeList.toArray(new String[0]), runningNodeList, failedNodeList);
                        VerificationUtil.traceAndLog("runningNodeList='%s'", VerificationUtil.strList2List(runningNodeList));
                        VerificationUtil.traceAndLog("failedNodeList='%s'", VerificationUtil.strList2List(failedNodeList));
                        if (runningNodeList.size() != 0) {
                            String node = (String)runningNodeList.get(0);
                            String kfodLocation = VerificationUtil.getKFODLocation(node, false);
                            VerificationUtil.traceAndLog("kfodLocation='%s'", kfodLocation);
                            KFODUtil kfodUtil = new KFODUtil(kfodLocation);
                            VerificationUtil.traceAndLog("Calling kfodUtil.getDiskGroupData()");
                            asmDGdata = kfodUtil.getDiskGroupData(node);
                        }
                    }
                }
                catch (ASMDiskGroupsUtilException e) {
                    VerificationUtil.traceAndLog("IGNORED: %s : %s", e.getClass(), e.getMessage());
                }
                catch (CmdToolUtilException e) {
                    VerificationUtil.traceAndLog("EXCEPTION: %s : %s", ((Object)((Object)e)).getClass(), e.getMessage());
                    errMsg = errMsg + LSEP + e.getMessage();
                    isException = true;
                }
                catch (VerificationException e) {
                    VerificationUtil.traceAndLog("EXCEPTION: %s : %s", e.getClass(), e.getMessage());
                    errMsg = errMsg + LSEP + e.getMessage();
                    isException = true;
                }
                if (asmDGdata == null) break block15;
                String upperPath = id.toUpperCase();
                for (String[] asmDGarray : asmDGdata) {
                    block17: {
                        block16: {
                            VerificationUtil.traceAndLog("ASM diskgroup data: " + VerificationUtil.strArr2List(asmDGarray));
                            String upperDG = asmDGarray[3].toUpperCase();
                            if (!upperPath.contains(":") ? upperPath.equalsIgnoreCase("+" + upperDG) : upperPath.startsWith("+" + upperDG + ":")) break block16;
                            if (!upperPath.equalsIgnoreCase(upperDG) && !upperPath.startsWith("+" + upperDG + "/")) break block17;
                        }
                        VerificationUtil.traceAndLog("A DG match is found");
                        StorageSize stSize = new StorageSize(Double.parseDouble(asmDGarray[0]), StorageUnit.MBYTE);
                        StorageSize stFree = new StorageSize(Double.parseDouble(asmDGarray[1]), StorageUnit.MBYTE);
                        for (String node : nodeList) {
                            VerificationUtil.traceAndLog("Instantiating ASMDGData for node '%s'", node);
                            ASMDGData stData = new ASMDGData(id);
                            stData.setStorageSize(stSize);
                            stData.setFreeSpace(stFree);
                            nodeSDmap.put(node, stData);
                        }
                        break block14;
                    }
                    VerificationUtil.traceAndLog("NO match is found");
                }
                break block14;
            }
            VerificationUtil.traceAndLog("asmDGData is NULL");
            if (isException) {
                VerificationUtil.traceAndLog("Adding StorageData entries with error details");
                for (String node : nodeList) {
                    StorageData stData = new StorageData(id);
                    stData.getStorageType().addErrDesc(new ErrorDescription(errMsg));
                    nodeSDmap.put(node, stData);
                }
            }
        }
        VerificationUtil.traceAndLog("Returning with '%s' entries in nodeSDmap", nodeSDmap.size());
    }

    public StorageType getFileSystem(String node, String id, Result rslt) {
        String[] args = new String[]{"-getfstype", id};
        VerificationCommand cmd = new VerificationCommand(node, args, null);
        cmd.execute();
        return new StorageDataParser(this.m_scCtx).parseFSTypeOutput(cmd, rslt);
    }

    public boolean hasReadWritePerms(String node, StorageData stData, String user, Result rslt) {
        boolean retVal = true;
        if (!this.m_isUnix) {
            return true;
        }
        String stID = stData.getID();
        String stOwner = stData.getOwner();
        String stGroup = stData.getGroup();
        String stPermsStr = stData.getPerms();
        rslt.addResultInfo(stPermsStr);
        VerificationUtil.traceAndLog("Storage '%s' has owner=%s group=%s perms=%s on node '%s'", stData.getID(), stOwner, stGroup, stPermsStr, node);
        if (!VerificationUtil.isStringGood(stPermsStr)) {
            return true;
        }
        int stPerms = Integer.parseInt(stPermsStr);
        int rMask = 0;
        int wMask = 0;
        rMask = 4;
        wMask = 2;
        List<String> groupsForUser = this.getGroups(node, user, rslt);
        if (groupsForUser.contains(stGroup)) {
            rMask |= 0x20;
            wMask |= 0x10;
        }
        if (user.equals(stOwner)) {
            rMask |= 0x100;
            wMask |= 0x80;
        }
        VerificationUtil.traceAndLog("rMask = " + Integer.toString(rMask, 8) + ". wMask = " + Integer.toString(wMask, 8));
        if ((stPerms & rMask) == 0) {
            VerificationUtil.traceAndLog("Storage '%s' did not have read access on node '%s'", stID, node);
            retVal = false;
        }
        if ((stPerms & wMask) == 0) {
            VerificationUtil.traceAndLog("Storage '%s' did not have write access on node '%s'", stID, node);
            retVal = false;
        }
        return retVal;
    }

    public List<String> getGroups(String node, String user, Result rslt) {
        String[] args = new String[]{"-getgroups", user};
        VerificationCommand cmd = new VerificationCommand(node, args, null);
        cmd.execute();
        return new StorageDataParser(this.m_scCtx).parseGetGroupsOutput(cmd, rslt);
    }

    public int getNumDiskPartitions(StorageData stData) {
        if (stData.getStorageTypeEnum() == StorageType.DISK) {
            return ((DiskData)stData).getNumPartitions();
        }
        return -1;
    }

    static HashMap<String, String> getSuitabilityMsg(OracleFileType usageType) {
        HashMap<String, String> h = new HashMap<String, String>();
        switch (usageType) {
            case RAC_SOFTWARE: {
                h.put("Prvg", "11501");
                break;
            }
            case RAC_DATA_FILES: {
                h.put("Prvg", "11502");
                break;
            }
            case RAC_OCR_VDISK: {
                h.put("Prvg", "11503");
                break;
            }
            case SI_SOFTWARE: {
                h.put("Prvg", "11504");
                break;
            }
            case SI_DATA_FILES: {
                h.put("Prvg", "11505");
                break;
            }
            case ASM: {
                h.put("Prvg", "11506");
                break;
            }
            default: {
                h.put("Prvf", "7000");
            }
        }
        return h;
    }

    public List<StorageType> getDiscoverableStorageTypes() {
        OracleFileType usageType = this.m_scCtx.getUsageType();
        String release = this.m_scCtx.getRelease();
        boolean considerASMStorage = this.m_scCtx.considerASMStorage();
        VerificationUtil.traceAndLog("usageType=%s release=%s considerASMStorage=%s", new Object[]{usageType, release, considerASMStorage});
        int[] discoverableTypesInt = sStorageUtil.getDiscoveryTypes(usageType, release, considerASMStorage);
        ArrayList<StorageType> discoverableTypesEnum = new ArrayList<StorageType>();
        for (int discTypeInt : discoverableTypesInt) {
            discoverableTypesEnum.add(sStorageUtil.getTypeEnum(discTypeInt));
        }
        return discoverableTypesEnum;
    }

    public static int getTypeIntFromEnum(StorageType typeInEnum) {
        switch (typeInEnum) {
            case DISK: {
                return 1;
            }
            case DISK_PARTITION: {
                return 6;
            }
            case NFS: {
                return 2;
            }
            case FILESYSTEM: {
                return 5;
            }
            case VXDG: {
                return 3;
            }
            case VXVOLUME: {
                return 4;
            }
            case LVMDG: {
                return 11;
            }
            case LVMLV: {
                return 12;
            }
            case GPFS: {
                return 10;
            }
            case OCFS: {
                return 7;
            }
            case OCFS2: {
                return 8;
            }
            case SAMFS: {
                return 15;
            }
            case QFS: {
                return 16;
            }
            case ACFS: {
                return 14;
            }
            case ASMDG: {
                return 13;
            }
            case VXFS: {
                return 17;
            }
            case TMPFS: {
                return 19;
            }
        }
        return -1;
    }

    public VerificationCommand getDiscoveryCommand(StorageType type, String node) {
        String[] args = new String[2];
        args[0] = "-getstinfo";
        switch (type) {
            case DISK: {
                if (this.m_isUnix) {
                    List<String> listASMdisc = this.m_scCtx.getDiscoveryASMPaths();
                    if (listASMdisc == null || listASMdisc.size() == 0) {
                        args[1] = "-getdiskinfo";
                        break;
                    }
                    args = new String[3];
                    args[0] = "-getstinfo";
                    args[1] = "-getdiskinfo";
                    String strASMdisc = VerificationUtil.strCollection2String(listASMdisc);
                    args[2] = strASMdisc = VerificationUtil.getShellEscapedString(node, strASMdisc);
                    break;
                }
                args[1] = "DISK";
                break;
            }
            case NFS: {
                args[1] = "-getnfsinfo";
                break;
            }
            case GPFS: {
                args[1] = "-getGpfsInfo";
                break;
            }
            case OCFS: {
                args[1] = "-getocfsinfo";
                break;
            }
            case OCFS2: {
                args = new String[]{"-getstinfo", "-getocfs2info", VerificationUtil.isCLIMode() ? "cmdline" : "apimode"};
                break;
            }
            case LVMDG: {
                args[1] = "-getlvminfo";
                break;
            }
            case LVMLV: {
                args[1] = "-getlvminfo";
                break;
            }
            case VXDG: {
                args[1] = "-getVXDGinfo";
                break;
            }
            case VXVOLUME: {
                args[1] = "-getVXVLinfo";
            }
        }
        VerificationUtil.traceAndLog("args[0]='%s' args[1]='%s'", args[0], args[1]);
        return new VerificationCommand(node, args, null);
    }

    public static StorageType getTypeEnumFromStr(String typeInStr) {
        int typeInInt;
        try {
            typeInInt = StorageUtil.getTypeByStr(typeInStr);
        }
        catch (StorageException se) {
            return StorageType.UNKNOWN;
        }
        return StorageUtil.getTypeEnum(typeInInt);
    }

    void traceDiscoveredSet(HashMap<StorageType, HashMap<String, HashMap<String, StorageData>>> typeStorageMap) {
        if (typeStorageMap.size() == 0) {
            VerificationUtil.traceAndLog(LSEP + ">>> Nothing was discovered");
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (StorageType stType : typeStorageMap.keySet()) {
            HashMap<String, HashMap<String, StorageData>> idNodeSDmap = typeStorageMap.get((Object)stType);
            sb.append(LSEP);
            sb.append(String.format(">>>> Discovery details for storage type '%s' ...", stType.name()));
            sb.append(LSEP + "   Count of devices = " + idNodeSDmap.size());
            Iterator<String> stIter2 = idNodeSDmap.keySet().iterator();
            int inx = 1;
            while (stIter2.hasNext()) {
                String id = stIter2.next();
                HashMap<String, StorageData> nodeSDmap = idNodeSDmap.get(id);
                String[] nodeList = nodeSDmap.keySet().toArray(new String[0]);
                String nodeListStr = VerificationUtil.strArr2List(nodeList);
                sb.append(LSEP);
                sb.append(String.format("       %d. %s [%d nodes: %s]", inx++, id, nodeList.length, nodeListStr));
            }
            sb.append(LSEP);
        }
        VerificationUtil.traceAndLog(sb.toString());
    }
}

