/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageType;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.Entity;
import oracle.ops.verification.framework.engine.EntityStatus;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.storage.AccessControl;
import oracle.ops.verification.framework.storage.StorageCheckContext;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageSignature;
import oracle.ops.verification.framework.storage.StorageWithSignature;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class StorageData
implements StorageConstants {
    String m_id;
    String m_effectiveID;
    String m_suppliedID;
    Entity<StorageType> m_storageType = new Entity<EntityStatus>(EntityStatus.INVALID);
    Entity<StorageSize> m_storageSize;
    Entity<StorageSize> m_freeSpace;
    Entity<StorageSignature> m_signature;
    Entity<AccessControl> m_storageAccess;
    List<ErrorDescription> m_globalErrors = new ArrayList<ErrorDescription>();
    static final String LSEP = VerificationConstants.LSEP;
    protected static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    protected static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");

    public StorageData(String id) {
        this(id, StorageType.UNKNOWN);
    }

    public StorageData(String id, StorageType stType) {
        this.m_id = id;
        this.m_storageType = stType != StorageType.UNKNOWN ? new Entity<StorageType>(stType) : new Entity<EntityStatus>(EntityStatus.INVALID);
        this.m_signature = !this.isSignatureApplicable() ? new Entity<EntityStatus>(EntityStatus.NOT_APPLICABLE) : new Entity<EntityStatus>(EntityStatus.INVALID);
    }

    void setID(String id) {
        this.m_id = id;
    }

    void setEffectiveID(String effectiveID) {
        this.m_effectiveID = effectiveID;
    }

    void setSuppliedID(String suppliedID) {
        this.m_suppliedID = suppliedID;
    }

    void setStorageType(StorageType stType) {
        this.m_storageType = new Entity<StorageType>(stType);
    }

    void setStorageSignature(StorageSignature stSign) {
        this.m_signature = new Entity<StorageSignature>(stSign);
    }

    void setStorageSignature(Entity<StorageSignature> stSignEntity) {
        this.m_signature = stSignEntity;
    }

    void setStorageSize(StorageSize stSize) {
        this.m_storageSize = new Entity<StorageSize>(stSize);
    }

    void setStorageSize(Entity<StorageSize> stSizeEntity) {
        this.m_storageSize = stSizeEntity;
    }

    void setFreeSpace(StorageSize stFree) {
        this.m_freeSpace = new Entity<StorageSize>(stFree);
    }

    void setFreeSpace(Entity<StorageSize> stFreeEntity) {
        this.m_freeSpace = stFreeEntity;
    }

    void setStorageAccess(Entity<AccessControl> stAccessEntity) {
        this.m_storageAccess = stAccessEntity;
    }

    public void addErrDesc(ErrorDescription errorDesc) {
        this.m_globalErrors.add(errorDesc);
        VerificationLogData.logError(errorDesc.getErrorMessage());
    }

    public void addErrDesc(List<ErrorDescription> errorDescList) {
        this.m_globalErrors.addAll(errorDescList);
    }

    public void checkSharedness(HashMap<String, StorageData> nodeSDmap, ResultSet rSet) {
        rSet.addResult(nodeSDmap.keySet().toArray(new String[0]), 1);
    }

    public void checkStorageAttributes(HashMap<String, StorageData> nodeSDmap, StorageCheckContext stChkContext, ResultSet rSet) {
        rSet.addResult(nodeSDmap.keySet().toArray(new String[0]), 1);
    }

    public List<ErrorDescription> getGlobalErrors() {
        return this.m_globalErrors;
    }

    public List<ErrorDescription> getErrors() {
        ArrayList<ErrorDescription> allErrors = new ArrayList<ErrorDescription>();
        allErrors.addAll(this.m_globalErrors);
        if (this.m_storageType != null) {
            allErrors.addAll(this.m_storageType.getErrors());
        }
        if (this.m_signature != null) {
            allErrors.addAll(this.m_signature.getErrors());
        }
        if (this.m_storageSize != null) {
            allErrors.addAll(this.m_storageSize.getErrors());
        }
        if (this.m_freeSpace != null) {
            allErrors.addAll(this.m_freeSpace.getErrors());
        }
        if (this.m_storageAccess != null) {
            allErrors.addAll(this.m_storageAccess.getErrors());
        }
        allErrors.addAll(this.getEntityErrors());
        return allErrors;
    }

    public List<ErrorDescription> getEntityErrors() {
        return new ArrayList<ErrorDescription>();
    }

    public boolean hasErrors() {
        return this.getErrors().size() != 0;
    }

    public String getID() {
        return this.m_id;
    }

    public String getEffectiveID() {
        return this.m_effectiveID;
    }

    public String getSuppliedID() {
        return this.m_suppliedID;
    }

    public Entity<StorageType> getStorageType() {
        return this.m_storageType;
    }

    public StorageType getStorageTypeEnum() {
        if (this.m_storageType != null && this.m_storageType.getStatus() == EntityStatus.VALID) {
            return this.m_storageType.getValue();
        }
        return StorageType.UNKNOWN;
    }

    public String getOwner() {
        if (this.m_storageAccess != null && this.m_storageAccess.getStatus() == EntityStatus.VALID) {
            return this.m_storageAccess.getValue().getOwner();
        }
        return null;
    }

    public String getGroup() {
        if (this.m_storageAccess != null && this.m_storageAccess.getStatus() == EntityStatus.VALID) {
            return this.m_storageAccess.getValue().getGroup();
        }
        return null;
    }

    public String getPerms() {
        if (this.m_storageAccess != null && this.m_storageAccess.getStatus() == EntityStatus.VALID) {
            return this.m_storageAccess.getValue().getPerms();
        }
        return null;
    }

    public boolean isSignatureApplicable() {
        return this instanceof StorageWithSignature;
    }

    public Entity<StorageSize> getStorageSize() {
        return this.m_storageSize;
    }

    public Entity<StorageSize> getFreeSpace() {
        return this.m_freeSpace;
    }

    public Entity<StorageSignature> getStorageSignature() {
        return this.m_signature;
    }

    public String getSignatureString() {
        if (this.m_signature == null) {
            return null;
        }
        StorageSignature stSign = this.m_signature.getValue();
        if (stSign == null) {
            return null;
        }
        return stSign.getSignature();
    }

    public Entity<AccessControl> getStorageAccess() {
        return this.m_storageAccess;
    }

    public String toString() {
        StringBuilder toStrSB = new StringBuilder();
        toStrSB.append("id=" + this.m_id);
        toStrSB.append(LSEP + "effectiveID=" + this.m_effectiveID);
        toStrSB.append(LSEP + "suppliedID=" + this.m_suppliedID);
        toStrSB.append(LSEP + "Type=" + this.m_storageType);
        toStrSB.append(LSEP + "Signature=" + this.m_signature);
        toStrSB.append(LSEP + "Size=" + this.m_storageSize);
        toStrSB.append(LSEP + "FreeSpace=" + this.m_freeSpace);
        toStrSB.append(LSEP + "Access=" + this.m_storageAccess);
        toStrSB.append(LSEP + "hasErrors=" + this.hasErrors());
        if (this.hasErrors()) {
            toStrSB.append(LSEP + "Errors are:" + LSEP + VerificationUtil.errDescCol2errMsgStr(this.getErrors()));
        }
        return toStrSB.toString();
    }
}

