/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.cluster.verification.OracleFileType;
import oracle.ops.verification.framework.util.VerificationUtil;

public class StorageCheckContext {
    private boolean m_discovery;
    private boolean m_considerASMStorage;
    private OracleFileType m_usageType;
    private String m_release = "12.2";
    private int m_targetCount = -1;
    private List<String> m_discoveryASMPaths;
    private HashMap<String, List<String>> m_offlineDiskNodesMap = new HashMap();

    public StorageCheckContext() {
        this(false);
    }

    public StorageCheckContext(boolean discovery) {
        this.m_discovery = discovery;
        VerificationUtil.traceAndLog("m_release='%s'", this.m_release);
    }

    public void setDiscovery(boolean discovery) {
        this.m_discovery = discovery;
        VerificationUtil.traceAndLog("Setting with discovery='%s'", discovery);
    }

    public boolean isDiscovery() {
        return this.m_discovery;
    }

    public void setUsageType(OracleFileType usageType) {
        this.m_usageType = usageType;
        VerificationUtil.traceAndLog("Setting with usageType='%s'", usageType.name());
    }

    public OracleFileType getUsageType() {
        return this.m_usageType;
    }

    public void setTargetCount(int targetCount) {
        this.m_targetCount = targetCount;
        VerificationUtil.traceAndLog("Setting with targetCount=%d", targetCount);
    }

    public int getTargetCount() {
        return this.m_targetCount;
    }

    public void setRelease(String release) {
        this.m_release = release;
        VerificationUtil.traceAndLog("Setting with release='%s'", release);
    }

    public String getRelease() {
        return this.m_release;
    }

    public void setConsiderASMStorage(boolean considerASMStorage) {
        this.m_considerASMStorage = considerASMStorage;
        VerificationUtil.traceAndLog("Setting with considerASMStorage='%s'", considerASMStorage);
    }

    public boolean considerASMStorage() {
        return this.m_considerASMStorage;
    }

    public void setDiscoveryASMPaths(List<String> discoveryASMPaths) {
        this.m_discoveryASMPaths = discoveryASMPaths;
        VerificationUtil.traceAndLog("Setting with discoveryASMPaths='%s'", VerificationUtil.strList2List(discoveryASMPaths));
    }

    public boolean offlineDiskInfoExistsForNode(String diskName, String node) {
        List<String> offlineNodeList = this.m_offlineDiskNodesMap.get(diskName);
        if (offlineNodeList != null && offlineNodeList.contains(node)) {
            return true;
        }
        if (offlineNodeList == null) {
            offlineNodeList = new ArrayList<String>();
        }
        offlineNodeList.add(node);
        this.m_offlineDiskNodesMap.put(diskName, offlineNodeList);
        return false;
    }

    public List<String> getDiscoveryASMPaths() {
        return this.m_discoveryASMPaths;
    }
}

