/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.cluster.verification.OracleFileType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.storage.CommandHandler;
import oracle.ops.verification.framework.storage.CommandHandlerFactory;
import oracle.ops.verification.framework.storage.SharedStorageSet;
import oracle.ops.verification.framework.storage.SharedStrategy;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.sStrategyProvider;
import oracle.ops.verification.util.MultiNodeException;

class SharedVerifyStrategy {
    private static CommandHandler s_commandHandler = CommandHandlerFactory.createCommandHandler();
    private static final String s_UnreliableSignatureException = "oracle.ops.verification.util.UnreliableSignatureException";
    protected OracleFileType m_oracleFileType = OracleFileType.RAC_DATA_FILES;
    private List<String> m_discoveryASMPaths = null;

    SharedVerifyStrategy() {
    }

    public void setOracleFileType(OracleFileType fileType) {
        this.m_oracleFileType = fileType;
    }

    public void setDiscoveryASMPaths(List<String> discoveryASMPaths) {
        this.m_discoveryASMPaths = discoveryASMPaths;
    }

    protected boolean isShared(StorageInfo stInfo, String[] nodeList) throws StorageException, MultiNodeException {
        Vector stList = new Vector();
        return this.isShared(stInfo, nodeList, stList);
    }

    protected boolean isShared(Map<String, StorageInfo> nodeStorageInfo, Vector stList, int targetCount, Collection<String> succNodeList) throws StorageException, MultiNodeException {
        StorageInfo stInfo = null;
        String[] nodeList = nodeStorageInfo.keySet().toArray(new String[0]);
        boolean retVal = false;
        MultiNodeException mne = null;
        String[] pathList = new String[nodeList.length];
        for (int i = 0; i < nodeList.length; ++i) {
            stInfo = nodeStorageInfo.get(nodeList[i]);
            stList.add(stInfo);
        }
        if (stList.size() > 0) {
            SharedStrategy strategy = sStrategyProvider.getSharedStrategy(stInfo.getType());
            strategy.setCheckPath(true);
            strategy.setOracleFileType(this.m_oracleFileType);
            strategy.setDiscoveryASMPaths(this.m_discoveryASMPaths);
            Vector superSet = new Vector();
            Enumeration ev = stList.elements();
            while (ev.hasMoreElements()) {
                stInfo = (StorageInfo)ev.nextElement();
                stInfo.setOrigPath(nodeStorageInfo.get(stInfo.getNode()).getOrigPath());
            }
            try {
                strategy.findShared(stList, superSet);
            }
            catch (MultiNodeException e) {
                Trace.out((String)"MultiNodeException occured");
                mne = e;
            }
            int numStorages = 0;
            Enumeration e = superSet.elements();
            SharedStorageSet largestSharingSet = null;
            while (e.hasMoreElements()) {
                SharedStorageSet sss = (SharedStorageSet)e.nextElement();
                if (sss.getSharedSet().size() <= numStorages) continue;
                numStorages = sss.getSharedSet().size();
                largestSharingSet = sss;
            }
            Trace.out((String)("superSet size = " + superSet.size()));
            Trace.out((String)("numStorages = " + numStorages));
            Trace.out((String)("targetCount = " + targetCount));
            if (largestSharingSet != null) {
                for (Object node : largestSharingSet.getNodeCollection()) {
                    succNodeList.add(String.valueOf(node));
                }
            }
            if (numStorages >= targetCount) {
                retVal = true;
            } else {
                retVal = false;
                if (null != mne) {
                    if (superSet.size() == 0 || superSet.size() > 1) {
                        throw mne;
                    }
                    if (superSet.size() == 1) {
                        boolean badSig = false;
                        Iterator expIter = mne.getThrowables().iterator();
                        while (expIter.hasNext() && !badSig) {
                            String className = expIter.next().getClass().getName();
                            if (!s_UnreliableSignatureException.equals(className)) continue;
                            badSig = true;
                        }
                        if (!badSig) {
                            throw mne;
                        }
                    }
                }
            }
            if (!retVal) {
                Trace.out((int)5, (String)"number of shared groups: %s; sharedSet=%s", (Object[])new Object[]{superSet.size(), superSet});
            }
        } else {
            Trace.out((String)("No instances found, storage: " + nodeStorageInfo));
            throw new StorageException("7008");
        }
        return retVal;
    }

    protected boolean isShared(StorageInfo stInfo, String[] nodeList, Vector stList) throws StorageException, MultiNodeException {
        HashMap<String, StorageInfo> nodeStorageInfo = new HashMap<String, StorageInfo>(nodeList.length);
        for (String node : nodeList) {
            nodeStorageInfo.put(node, stInfo);
        }
        ArrayList<String> succNodes = new ArrayList<String>();
        return this.isShared(nodeStorageInfo, stList, nodeList.length, succNodes);
    }
}

