/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.sStorageUtil;

public class NodeStorageInfo {
    private String m_name = null;
    private int m_numStorage = 0;
    private int m_numStorageClasses = 0;
    private Result m_result;
    private Hashtable m_storageTable;
    private Vector m_allStorage;

    public NodeStorageInfo(String name) {
        this.m_name = name;
        this.m_storageTable = new Hashtable();
        this.m_result = new Result(this.m_name);
        this.m_allStorage = new Vector();
    }

    public void addStorage(StorageInfo storage) {
        int type = storage.getType();
        Integer key = new Integer(type);
        Vector<StorageInfo> typeSubgroup = (Vector<StorageInfo>)this.m_storageTable.get(key);
        if (null == typeSubgroup) {
            typeSubgroup = new Vector<StorageInfo>(5);
            this.m_storageTable.put(key, typeSubgroup);
            ++this.m_numStorageClasses;
        }
        typeSubgroup.add(storage);
        this.m_allStorage.add(storage);
        ++this.m_numStorage;
        Trace.out((String)("Added storage " + storage + " to node " + this));
    }

    public void addStorage(Vector storageList, int type) {
        Integer key = new Integer(type);
        Vector typeSubgroup = (Vector)this.m_storageTable.get(key);
        if (null == typeSubgroup) {
            typeSubgroup = new Vector();
            this.m_storageTable.put(key, typeSubgroup);
            ++this.m_numStorageClasses;
        }
        typeSubgroup.addAll(storageList);
        this.m_allStorage.addAll(storageList);
        this.m_numStorage += storageList.size();
    }

    public Vector getStorageByType(int type) {
        Integer key = new Integer(type);
        Vector stList = (Vector)this.m_storageTable.get(key);
        if (null != stList) {
            Trace.out((String)("Returning " + stList.size() + " of " + sStorageUtil.getTypeStr(type) + " from node " + this.m_name));
        }
        return stList;
    }

    public Vector getAllStorage() {
        return this.m_allStorage;
    }

    public String getName() {
        return this.m_name;
    }

    public Result getResult() {
        return this.m_result;
    }

    public void setResult(Result result) {
        this.m_result = result;
    }

    public String toString() {
        return "<" + this.m_name + "| numStorage: " + this.m_numStorage + "| numStorageClasses " + this.m_numStorageClasses + ">";
    }

    public String printAllStorage() {
        String result = "";
        result.concat("Node:" + this.m_name);
        Enumeration e = this.m_allStorage.elements();
        while (e.hasMoreElements()) {
            result.concat(e.nextElement().toString());
        }
        return result;
    }
}

