/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.PatternSyntaxException;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.StorageType;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.Entity;
import oracle.ops.verification.framework.engine.EntityStatus;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.GlobalVerificationContext;
import oracle.ops.verification.framework.storage.FSDetails;
import oracle.ops.verification.framework.storage.StorageCheckContext;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageData;
import oracle.ops.verification.framework.storage.StorageDataHandler;
import oracle.ops.verification.framework.storage.StorageSignature;
import oracle.ops.verification.framework.storage.StorageWithSignature;
import oracle.ops.verification.framework.util.VerificationUtil;

public class NFSData
extends StorageData
implements StorageConstants,
StorageWithSignature {
    private String m_mountedSystem;
    private String m_mountPoint;
    private String m_mountOptions = null;
    private boolean m_isReadOnly = false;
    private boolean m_isNoac = false;
    private boolean m_isQuorumDisk = false;
    private Entity<FSDetails> m_fsDetails = new Entity();
    private StringBuffer m_msgXmlChecks;
    private List<String> m_unsupportedMountOpts = new ArrayList<String>();
    private String m_mountOptsForParse;

    public NFSData(String id) {
        super(id, StorageType.NFS);
    }

    public NFSData(String mountPoint, String mountedSystem, String mountOptions, Entity<FSDetails> fsDetails) {
        super(mountPoint, StorageType.NFS);
        List<String> quorumDiskList;
        this.m_mountPoint = mountPoint;
        this.m_mountedSystem = VerificationUtil.isODASystem() && mountedSystem.contains(":") ? "ODA-SERVER" + mountedSystem.substring(mountedSystem.indexOf(":")) : mountedSystem;
        String quorumDisks = GlobalVerificationContext.getInstance().getASMQuorumGroupDisks();
        if (VerificationUtil.isStringGood(quorumDisks) && ((quorumDiskList = Arrays.asList(quorumDisks.split(","))).contains(mountPoint) || quorumDiskList.contains(mountedSystem))) {
            this.m_isQuorumDisk = true;
        }
        this.setStorageSignature(new StorageSignature(this.m_mountedSystem + ":" + this.m_mountPoint));
        this.m_mountOptions = mountOptions;
        this.m_isReadOnly = NFSData.isMountReadOnly(this.m_mountOptions);
        this.m_isNoac = NFSData.isMountNoac(this.m_mountOptions);
        this.m_fsDetails = fsDetails;
        if (fsDetails.getStatus() == EntityStatus.VALID) {
            this.setFreeSpace(fsDetails.getValue().getFreeSpace());
            this.setStorageSize(fsDetails.getValue().getSize());
        }
    }

    public Entity<FSDetails> getFSDetails() {
        return this.m_fsDetails;
    }

    protected String getMountPoint() {
        return this.m_mountPoint;
    }

    protected String getMountedSystem() {
        return this.m_mountedSystem;
    }

    protected boolean isReadOnly() {
        return this.m_isReadOnly;
    }

    protected boolean isNoAttribCaching() {
        return this.m_isNoac;
    }

    protected String getMountOptions() {
        return this.m_mountOptions;
    }

    private static boolean isMountNoac(String mntOpts) {
        boolean isNoac = -1 != mntOpts.indexOf("noac");
        return isNoac;
    }

    private static boolean isMountReadOnly(String mntOpts) {
        boolean isReadOnly = false;
        boolean found = false;
        StringTokenizer stComma = new StringTokenizer(mntOpts, ",");
        while (stComma.hasMoreTokens() && !found) {
            String currOpt = stComma.nextToken();
            if (currOpt.equalsIgnoreCase("ro")) {
                isReadOnly = true;
                found = true;
                continue;
            }
            if (!currOpt.equalsIgnoreCase("rw")) continue;
            isReadOnly = false;
            found = true;
        }
        return isReadOnly;
    }

    @Override
    public void checkSharedness(HashMap<String, StorageData> nodeSDmap, ResultSet rSet) {
        StorageDataHandler.checkSignatures(nodeSDmap, rSet);
    }

    @Override
    public void checkStorageAttributes(HashMap<String, StorageData> nodeSDmap, StorageCheckContext stChkContext, ResultSet rSet) {
        String[] nodeList = nodeSDmap.keySet().toArray(new String[0]);
        OracleFileType usageType = stChkContext.getUsageType();
        VerificationUtil.traceAndLog("usageType=" + (Object)((Object)usageType));
        if (usageType == null) {
            rSet.addResult(nodeList, 1);
            return;
        }
        for (String node : nodeList) {
            NFSData nfsData = (NFSData)nodeSDmap.get(node);
            this.m_mountOptsForParse = nfsData.getMountOptions();
            this.m_unsupportedMountOpts.clear();
            if (this.matchesXmlConstraints(usageType)) {
                rSet.addResult(node, 1);
                continue;
            }
            VerificationUtil.traceAndLog("XML options check message: " + this.m_msgXmlChecks);
            rSet.addResult(node, 3);
            String errMsg = s_gMsgBundle.getMessage("0809", true, (Object[])new String[]{nfsData.getMountedSystem(), nfsData.getMountPoint(), node, this.getExpectedMountOptions(usageType, false), this.m_mountOptsForParse});
            nfsData.addErrDesc(new ErrorDescription(errMsg));
            rSet.addErrorDescription(node, new ErrorDescription(errMsg));
            if (this.m_unsupportedMountOpts.isEmpty()) continue;
            errMsg = this.m_isQuorumDisk ? s_gMsgBundle.getMessage("0825", true, (Object[])new String[]{VerificationUtil.strCollection2String(this.m_unsupportedMountOpts), nfsData.getMountedSystem(), nfsData.getMountPoint(), node}) : s_gMsgBundle.getMessage("0808", true, (Object[])new String[]{VerificationUtil.strCollection2String(this.m_unsupportedMountOpts), nfsData.getMountedSystem(), nfsData.getMountPoint(), node});
            nfsData.addErrDesc(new ErrorDescription(errMsg));
            rSet.addErrorDescription(node, new ErrorDescription(errMsg));
        }
    }

    private boolean matchesXmlConstraints(OracleFileType fileType) {
        String xmlOptions = this.getExpectedMountOptions(fileType, true);
        String[] xmlOptionsArray = xmlOptions.split(",");
        for (int i = 0; i < xmlOptionsArray.length; ++i) {
            this.m_msgXmlChecks = new StringBuffer();
            if (!this.validateConstraints(xmlOptionsArray[i])) {
                VerificationUtil.traceAndLog("XML options check message: " + this.m_msgXmlChecks);
                return false;
            }
            this.m_msgXmlChecks = null;
        }
        VerificationUtil.traceAndLog("XML options check message: " + this.m_msgXmlChecks);
        return true;
    }

    private boolean validateConstraints(String xmlOptionsStr) {
        VerificationUtil.traceAndLog("Validating constraint from xml:  " + xmlOptionsStr);
        String[] condsArray = new String[2];
        if (xmlOptionsStr.indexOf("|") != -1) {
            VerificationUtil.traceAndLog("Found an OR constraint..");
            condsArray = xmlOptionsStr.split("\\|", 2);
            boolean lvalue = this.validateConstraints(condsArray[0]);
            if (lvalue) {
                return true;
            }
            this.m_msgXmlChecks.append(s_msgBundle.getMessage("7025", false));
            boolean rvalue = this.validateConstraints(condsArray[1]);
            return rvalue;
        }
        if (xmlOptionsStr.indexOf("&") != -1) {
            VerificationUtil.traceAndLog("Found an AND constraint..");
            condsArray = xmlOptionsStr.split("\\&", 2);
            boolean lvalue = this.validateConstraints(condsArray[0]);
            if (!lvalue) {
                return false;
            }
            this.m_msgXmlChecks.append(s_msgBundle.getMessage("7024", false));
            boolean rvalue = this.validateConstraints(condsArray[1]);
            return rvalue;
        }
        boolean retvalue = this.validateOptionValue(xmlOptionsStr);
        if (retvalue) {
            this.m_msgXmlChecks.append(LSEP);
        }
        return retvalue;
    }

    private boolean validateOptionValue(String xmlOption) {
        Object xmlOptionValue = null;
        Object nfsOptionValue = null;
        int comparisonResult = 0;
        boolean validateAbsence = false;
        if (VerificationUtil.isStringGood(xmlOption) && xmlOption.trim().startsWith("!")) {
            validateAbsence = true;
            xmlOption = xmlOption.substring(xmlOption.indexOf("!") + 1);
            VerificationUtil.traceAndLog("Validating the absence of option (" + xmlOption + ")");
        }
        String optionKey = this.extractOptionKey(xmlOption);
        Object[] nfsoption = new String[]{optionKey};
        this.m_msgXmlChecks.append(s_msgBundle.getMessage("7023", false, nfsoption));
        String[] mntOptionsArray = this.m_mountOptsForParse.split(",");
        boolean found = false;
        for (String mntOptionStr : mntOptionsArray) {
            if (!this.extractOptionKey(mntOptionStr).equals(optionKey)) continue;
            found = true;
            nfsOptionValue = this.extractOptionValue(mntOptionStr, optionKey, "=");
            break;
        }
        if (!found) {
            this.m_msgXmlChecks.append(s_msgBundle.getMessage("7027", false, nfsoption));
            return validateAbsence;
        }
        if (xmlOption.indexOf("<=") != -1) {
            optionKey = xmlOption.split("<=")[0].trim();
            xmlOptionValue = this.extractOptionValue(xmlOption, optionKey, "<=");
            nfsoption[0] = optionKey;
            if (nfsOptionValue == null || xmlOptionValue == null) {
                this.m_msgXmlChecks.append(s_msgBundle.getMessage("7027", false, nfsoption));
            } else {
                comparisonResult = !(nfsOptionValue instanceof Integer) || !(xmlOptionValue instanceof Integer) ? nfsOptionValue.toString().compareTo(xmlOptionValue.toString()) : ((Integer)nfsOptionValue).compareTo((Integer)xmlOptionValue);
                if (comparisonResult <= 0) {
                    this.m_msgXmlChecks.append(s_msgBundle.getMessage("7033", false, nfsoption));
                    return true;
                }
                this.m_msgXmlChecks.append(s_msgBundle.getMessage("7030", false, nfsoption));
            }
        } else if (xmlOption.indexOf(">=") != -1) {
            optionKey = xmlOption.split(">=")[0].trim();
            xmlOptionValue = this.extractOptionValue(xmlOption, optionKey, ">=");
            nfsoption[0] = optionKey;
            if (nfsOptionValue == null || xmlOptionValue == null) {
                this.m_msgXmlChecks.append(s_msgBundle.getMessage("7027", false, nfsoption));
            } else {
                comparisonResult = !(nfsOptionValue instanceof Integer) || !(xmlOptionValue instanceof Integer) ? nfsOptionValue.toString().compareTo(xmlOptionValue.toString()) : ((Integer)nfsOptionValue).compareTo((Integer)xmlOptionValue);
                if (comparisonResult >= 0) {
                    nfsoption[0] = optionKey;
                    this.m_msgXmlChecks.append(s_msgBundle.getMessage("7031", false, nfsoption));
                    return true;
                }
                this.m_msgXmlChecks.append(s_msgBundle.getMessage("7032", false, nfsoption));
            }
        } else if (xmlOption.indexOf("<") != -1) {
            optionKey = xmlOption.split("<")[0].trim();
            xmlOptionValue = this.extractOptionValue(xmlOption, optionKey, "<");
            nfsoption[0] = optionKey;
            if (nfsOptionValue == null || xmlOptionValue == null) {
                this.m_msgXmlChecks.append(s_msgBundle.getMessage("7027", false, nfsoption));
            } else {
                comparisonResult = !(nfsOptionValue instanceof Integer) || !(xmlOptionValue instanceof Integer) ? nfsOptionValue.toString().compareTo(xmlOptionValue.toString()) : ((Integer)nfsOptionValue).compareTo((Integer)xmlOptionValue);
                if (comparisonResult < 0) {
                    nfsoption[0] = optionKey;
                    this.m_msgXmlChecks.append(s_msgBundle.getMessage("7032", false, nfsoption));
                    return true;
                }
                this.m_msgXmlChecks.append(s_msgBundle.getMessage("7031", false, nfsoption));
            }
        } else if (xmlOption.indexOf(">") != -1) {
            optionKey = xmlOption.split(">")[0].trim();
            xmlOptionValue = this.extractOptionValue(xmlOption, optionKey, ">");
            nfsoption[0] = optionKey;
            if (nfsOptionValue == null || xmlOptionValue == null) {
                this.m_msgXmlChecks.append(s_msgBundle.getMessage("7027", false, nfsoption));
            } else {
                comparisonResult = !(nfsOptionValue instanceof Integer) || !(xmlOptionValue instanceof Integer) ? nfsOptionValue.toString().compareTo(xmlOptionValue.toString()) : ((Integer)nfsOptionValue).compareTo((Integer)xmlOptionValue);
                if (comparisonResult > 0) {
                    nfsoption[0] = optionKey;
                    this.m_msgXmlChecks.append(s_msgBundle.getMessage("7030", false, nfsoption));
                    return true;
                }
                this.m_msgXmlChecks.append(s_msgBundle.getMessage("7033", false, nfsoption));
            }
        } else if (xmlOption.indexOf("=") != -1) {
            optionKey = xmlOption.split("=")[0].trim();
            xmlOptionValue = this.extractOptionValue(xmlOption, optionKey, "=");
            nfsoption[0] = optionKey;
            if (nfsOptionValue == null || xmlOptionValue == null) {
                this.m_msgXmlChecks.append(s_msgBundle.getMessage("7027", false, nfsoption));
            } else {
                comparisonResult = !(nfsOptionValue instanceof Integer) || !(xmlOptionValue instanceof Integer) ? nfsOptionValue.toString().compareTo(xmlOptionValue.toString()) : ((Integer)nfsOptionValue).compareTo((Integer)xmlOptionValue);
                if (comparisonResult == 0) {
                    nfsoption[0] = optionKey;
                    this.m_msgXmlChecks.append(s_msgBundle.getMessage("7028", false, nfsoption));
                    return true;
                }
                this.m_msgXmlChecks.append(s_msgBundle.getMessage("7029", false, nfsoption));
            }
        } else {
            optionKey = xmlOption;
            VerificationUtil.traceAndLog("Checking for XML option key: " + optionKey + ", nfs options = " + this.m_mountOptsForParse);
            if (-1 != this.m_mountOptsForParse.indexOf(optionKey)) {
                this.m_msgXmlChecks.append(s_msgBundle.getMessage("7026", false, nfsoption));
                if (validateAbsence) {
                    this.m_unsupportedMountOpts.add(optionKey);
                }
                return !validateAbsence;
            }
            this.m_msgXmlChecks.append(s_msgBundle.getMessage("7027", false, nfsoption));
            return validateAbsence;
        }
        return false;
    }

    private String getExpectedMountOptions(OracleFileType usageType, boolean includeNegations) {
        String xmlOptions = VDMUtil.getNFSOptionsRegExp(usageType, includeNegations);
        if (this.m_isQuorumDisk && VerificationUtil.isStringGood(xmlOptions)) {
            if (xmlOptions.contains("hard") && !xmlOptions.contains("!hard")) {
                xmlOptions = xmlOptions.replaceAll("hard", "!hard");
            }
            if (!xmlOptions.contains("soft")) {
                xmlOptions = xmlOptions.contains("hard") ? xmlOptions.replaceAll("hard", "hard|soft") : xmlOptions + ",soft";
            }
            if (xmlOptions.contains("!soft")) {
                xmlOptions = xmlOptions.replaceAll("!soft", "soft");
            }
        }
        return xmlOptions;
    }

    private String extractOptionKey(String xmlOption) {
        String optionKey = xmlOption.split("<=|>=|<|>|=", 2)[0].trim();
        VerificationUtil.traceAndLog("Verify Option key: XML option = " + xmlOption + ", key = " + optionKey);
        return optionKey;
    }

    private Object extractOptionValue(String mntOpts, String optionKey, String condition) {
        try {
            if (-1 == mntOpts.indexOf(optionKey)) {
                return null;
            }
            Object optValue = null;
            int startIndex = mntOpts.indexOf(optionKey);
            if (startIndex == -1) {
                return null;
            }
            int endIndex = mntOpts.indexOf(44, startIndex);
            if (endIndex == -1) {
                endIndex = mntOpts.length();
            }
            String optionsString = new String(mntOpts.substring(startIndex, endIndex));
            String[] optParts = optionsString.split(condition, 2);
            try {
                optValue = new Integer(optParts[1].trim());
            }
            catch (NumberFormatException e) {
                optValue = optParts[1].trim();
            }
            VerificationUtil.traceAndLog("Found nfs option, value: option =" + optionKey + ",nfs value = " + optValue);
            return optValue;
        }
        catch (IndexOutOfBoundsException ioobe) {
            return null;
        }
        catch (PatternSyntaxException pse) {
            return null;
        }
    }

    @Override
    public List<ErrorDescription> getEntityErrors() {
        if (this.m_fsDetails != null) {
            return this.m_fsDetails.getErrors();
        }
        return new ArrayList<ErrorDescription>();
    }

    @Override
    public String toString() {
        return super.toString() + LSEP + "mountedSystem=" + this.m_mountedSystem + " | mountPoint=" + this.m_mountPoint + " | <" + this.m_mountOptions + "> | FSDetails: " + this.m_fsDetails;
    }
}

