/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.HashMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.cluster.verification.StorageType;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageData;
import oracle.ops.verification.framework.storage.StorageSignature;
import oracle.ops.verification.framework.storage.StorageWithSignature;
import oracle.ops.verification.framework.util.VerificationUtil;

class LvmLVData
extends StorageData
implements StorageConstants,
StorageWithSignature {
    private String m_uuid = null;
    private SortedMap<String, String> m_pvIDpvPathMap = new TreeMap<String, String>();

    public LvmLVData(String id) {
        super(id, StorageType.LVMLV);
    }

    LvmLVData(String lvname, String uuid) {
        super(lvname, StorageType.LVMLV);
        this.m_uuid = uuid;
        if (VerificationUtil.isStringGood(this.m_uuid)) {
            this.setStorageSignature(new StorageSignature(this.m_uuid));
        }
    }

    LvmLVData(String lvname, String pvID, String pvPath) {
        super(lvname, StorageType.LVMLV);
        this.m_pvIDpvPathMap.put(pvID, pvPath);
        this.setStorageSignature(new StorageSignature(this.createSignatureString()));
    }

    public void addPV(String pvID, String pvPath) {
        this.m_pvIDpvPathMap.put(pvID, pvPath);
        this.setStorageSignature(new StorageSignature(this.createSignatureString()));
    }

    private String createSignatureString() {
        Set<String> pvIDList = this.m_pvIDpvPathMap.keySet();
        String[] pvIDStrArr = pvIDList.toArray(new String[pvIDList.size()]);
        return VerificationUtil.strArr2String(pvIDStrArr);
    }

    @Override
    public void checkSharedness(HashMap<String, StorageData> nodeSDmap, ResultSet rSet) {
        rSet.addResult(nodeSDmap.keySet().toArray(new String[0]), 1);
    }

    public String getUID() {
        return this.m_uuid;
    }

    @Override
    public String toString() {
        return super.toString() + LSEP + "uuid=" + this.m_uuid;
    }
}

