/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.SharedDeviceException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.storage.SharedVerifyStrategy;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.sStorageUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class FSSharedVerifyStrategy
extends SharedVerifyStrategy
implements StorageConstants {
    int m_type = 5;

    @Override
    public boolean isShared(StorageInfo stInfo, String[] nodeList) throws StorageException {
        Vector stList = new Vector();
        return this.isShared(stInfo, nodeList, stList);
    }

    @Override
    public boolean isShared(StorageInfo stInfo, String[] nodeList, Vector stList) throws StorageException {
        HashMap<String, StorageInfo> nodeStorageInfo = new HashMap<String, StorageInfo>(nodeList.length);
        for (String node : nodeList) {
            nodeStorageInfo.put(node, stInfo);
        }
        return this.isShared(nodeStorageInfo, stList);
    }

    public boolean isShared(Map<String, StorageInfo> nodeStorageInfo, Vector stList) throws StorageException {
        ArrayList<String> succNodes = new ArrayList<String>();
        return this.isShared(nodeStorageInfo, stList, stList.size(), succNodes);
    }

    @Override
    protected boolean isShared(Map<String, StorageInfo> nodeStorageInfo, Vector stList, int targetCount, Collection<String> succNodeList) throws StorageException {
        boolean retVal = false;
        String[] nodeList = nodeStorageInfo.keySet().toArray(new String[0]);
        String path = null;
        String localNode = sStorageUtil.getLocalHost();
        Trace.out((String)("Check isShared LocalNode: " + localNode + " | path:" + path));
        try {
            for (int l = 0; l < nodeList.length; ++l) {
                path = nodeStorageInfo.get(nodeList[l]).getName();
                StorageInfo st = new StorageInfo(path, nodeList[l], nodeStorageInfo.get(nodeList[l]).getType());
                stList.add(st);
            }
            if (nodeList.length == 1) {
                Trace.out((String)("Cluster.isSharedPath has one 1 node in nodelist: " + nodeList[0]));
                retVal = true;
            } else {
                retVal = Cluster.isSharedPath((String)path, (String[])nodeList, (String)localNode);
            }
            if (retVal) {
                succNodeList.addAll(Arrays.asList(nodeList));
            }
            Trace.out((String)("Cluster isSharedPath returned " + retVal));
        }
        catch (SharedDeviceException sde) {
            Trace.out((String)("SharedDeviceException: " + sde.getMessage()));
            throw new StorageException("10130", true, (Object[])new String[]{path, VerificationUtil.strArr2List(nodeList)}, "Prvg", sde.getMessage());
        }
        catch (InvalidNodeListException ine) {
            Trace.out((String)("InvalidNodeListException: " + ine.getMessage()));
            throw new StorageException(ine);
        }
        return retVal;
    }
}

