/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.util.VerificationUtil;

public class FSDetails
implements VerificationConstants {
    private long m_fsbsize;
    private long m_fsblocks;
    private long m_fsbfree;
    private long m_fsbavail;
    private long m_fsfiles;
    private long m_fsfree;
    private int m_fsaccess;

    public FSDetails(long fsbsize, long fsblocks, long fsbfree, long fsbavail, long fsfiles, long fsfree, int fsaccess) {
        this.m_fsbsize = fsbsize;
        this.m_fsblocks = fsblocks;
        this.m_fsbfree = fsbfree;
        this.m_fsbavail = fsbavail;
        this.m_fsfiles = fsfiles;
        this.m_fsfree = fsfree;
        this.m_fsaccess = fsaccess;
    }

    public long getFSbsize() {
        return this.m_fsbsize;
    }

    public long getFSblocks() {
        return this.m_fsblocks;
    }

    public long getFSbfree() {
        return this.m_fsbfree;
    }

    public long getFSbavail() {
        return this.m_fsbavail;
    }

    public long getFSfiles() {
        return this.m_fsfiles;
    }

    public long getFSfree() {
        return this.m_fsfree;
    }

    public int getFSaccess() {
        return this.m_fsaccess;
    }

    public StorageSize getSize() {
        return new StorageSize((double)(this.m_fsblocks / 1024L * this.m_fsbsize), StorageUnit.KBYTE);
    }

    public StorageSize getFreeSpace() {
        if (VerificationUtil.isPlatformWindows()) {
            return new StorageSize((double)(this.m_fsbfree / 1024L), StorageUnit.KBYTE);
        }
        return new StorageSize((double)(this.m_fsbavail / 1024L * this.m_fsbsize), StorageUnit.KBYTE);
    }

    public String toString() {
        return "bsize=" + this.m_fsbsize + "| blocks=" + this.m_fsblocks + "| bfree=" + this.m_fsbfree + "| bavail=" + this.m_fsbavail + "| files=" + this.m_fsfiles + "| free=" + this.m_fsfree + "| access=" + this.m_fsaccess;
    }
}

