/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.cluster.verification.StorageType;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.storage.PartitionData;
import oracle.ops.verification.framework.storage.StorageCheckContext;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageData;
import oracle.ops.verification.framework.storage.StorageDataHandler;
import oracle.ops.verification.framework.storage.StorageWithSignature;
import oracle.ops.verification.framework.util.VerificationUtil;

class DiskData
extends StorageData
implements StorageConstants,
StorageWithSignature {
    private String m_vendor = null;
    private int m_numPartitions = 0;
    private boolean m_policy = false;
    private boolean m_lock = false;
    private boolean m_isOnASM = false;
    private String m_diskState = null;
    private String m_ioSched = null;
    private HashMap<String, PartitionData> m_partNumPartitionMap = new HashMap();
    private List<PartitionData> m_partitionList = new ArrayList<PartitionData>();

    DiskData(String id) {
        super(id, StorageType.DISK);
    }

    void setNumPartitions(int parts) {
        this.m_numPartitions = parts;
    }

    void setState(String diskState) {
        this.m_diskState = diskState;
    }

    void setDiskScheduler(String diskSched) {
        this.m_ioSched = diskSched;
    }

    protected void setPolicy(boolean policy) {
        this.m_policy = policy;
    }

    protected void setLock(boolean lock) {
        this.m_lock = lock;
    }

    protected void setIsOnASM(boolean onASM) {
        this.m_isOnASM = onASM;
    }

    void addPartition(PartitionData part) {
        String partNum = part.getPartitionNumber();
        if (null == this.m_partNumPartitionMap.get(partNum)) {
            this.m_partNumPartitionMap.put(partNum, part);
            this.m_partitionList.add(part);
        }
    }

    @Override
    public void checkSharedness(HashMap<String, StorageData> nodeSDmap, ResultSet rSet) {
        StorageDataHandler.checkSignatures(nodeSDmap, rSet);
    }

    @Override
    public void checkStorageAttributes(HashMap<String, StorageData> nodeSDmap, StorageCheckContext stChkContext, ResultSet rSet) {
        String[] nodeList = nodeSDmap.keySet().toArray(new String[0]);
        boolean isUnix = new SystemFactory().CreateSystem().isUnixSystem();
        List<String> discoveryASMPaths = stChkContext.getDiscoveryASMPaths();
        boolean isDiscovery = stChkContext.isDiscovery();
        rSet.addResult(nodeList, 1);
        for (String node : nodeList) {
            String errMsg;
            DiskData diskData = (DiskData)nodeSDmap.get(node);
            String diskName = diskData.getID();
            VerificationUtil.traceAndLog("Checking atributes for disk '%s'", diskData.toString());
            if (isUnix) {
                if (diskData.isPolicySet()) {
                    VerificationUtil.traceAndLog("Disk policy is set");
                    if (diskData.isOnASM() || discoveryASMPaths != null && discoveryASMPaths.contains(diskName)) {
                        VerificationUtil.traceAndLog("Disk policy conflicts with ASM rquirements");
                        if (isDiscovery) {
                            VerificationUtil.traceAndLog("Removed entry for node '%s' from map", node);
                            nodeSDmap.remove(node);
                        } else {
                            errMsg = s_gMsgBundle.getMessage("0817", true, (Object[])new String[]{diskName, node});
                            rSet.addResult(node, 3);
                            rSet.addErrorDescription(node, new ErrorDescription(errMsg));
                            diskData.addErrDesc(new ErrorDescription(errMsg));
                        }
                    }
                }
                if (!diskData.isLockSet()) continue;
                VerificationUtil.traceAndLog("Disk Lock is set");
                if (!diskData.isOnASM() && (discoveryASMPaths == null || !discoveryASMPaths.contains(diskName))) continue;
                VerificationUtil.traceAndLog("Disk Lock conflicts with ASM rquirements");
                if (isDiscovery) {
                    VerificationUtil.traceAndLog("Removed entry for node '%s' from map", node);
                    nodeSDmap.remove(node);
                    continue;
                }
                errMsg = s_gMsgBundle.getMessage("0816", true, (Object[])new String[]{diskName, node});
                rSet.addResult(node, 3);
                rSet.addErrorDescription(node, new ErrorDescription(errMsg));
                diskData.addErrDesc(new ErrorDescription(errMsg));
                continue;
            }
            if (diskData.isOnline()) continue;
            VerificationUtil.traceAndLog("Disk  is offline");
            if (isDiscovery) {
                VerificationUtil.traceAndLog("Removed entry for node '%s' from map", node);
                nodeSDmap.remove(node);
                continue;
            }
            if (stChkContext.offlineDiskInfoExistsForNode(diskName, node)) {
                VerificationUtil.traceAndLog("Disk '" + diskName + "' has already been reported offline on node '" + node + "'");
                return;
            }
            VerificationUtil.traceAndLog("Disk '" + diskName + "' is found offline on node '" + node + "'");
            errMsg = s_gMsgBundle.getMessage("0818", true, (Object[])new String[]{diskName, node});
            rSet.addResult(node, 3);
            rSet.addErrorDescription(node, new ErrorDescription(errMsg));
            diskData.addErrDesc(new ErrorDescription(errMsg));
        }
    }

    public int getNumPartitions() {
        return this.m_numPartitions;
    }

    public boolean isOnline() {
        if (!this.isStateCheckRequired()) {
            Trace.out((String)"state check not required on this platform");
            return true;
        }
        if ("DISK_OFFLINE".equalsIgnoreCase(this.m_diskState)) {
            Trace.out((String)(this.m_id + " disk is offline"));
            return false;
        }
        Trace.out((String)(this.m_id + " disk is online"));
        return true;
    }

    private boolean isStateCheckRequired() {
        return VerificationUtil.isVersionPost(VerificationUtil.getUniqueDistributionID(), "6.1");
    }

    public List<PartitionData> getPartitionList() {
        return this.m_partitionList;
    }

    public PartitionData getPartition(String partNum) {
        return this.m_partNumPartitionMap.get(partNum);
    }

    public boolean isPolicySet() {
        return this.m_policy;
    }

    public boolean isLockSet() {
        return this.m_lock;
    }

    protected boolean isOnASM() {
        return this.m_isOnASM;
    }

    public String getDiskScheduler() {
        return this.m_ioSched;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString() + "| vendor[" + this.m_vendor + "] | numPartitions[" + this.m_numPartitions + "] | policy[" + this.m_policy + "] | lock[" + this.m_lock + "] | diskState[" + this.m_diskState + "] | online[" + this.isOnline() + "] | isOnASM[" + this.m_isOnASM + "]");
        for (String partNum : this.m_partNumPartitionMap.keySet()) {
            sb.append(LSEP + "[Part#" + partNum + "] " + this.m_partNumPartitionMap.get(partNum));
        }
        return sb.toString();
    }
}

