/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.List;
import java.util.Vector;
import oracle.ops.mgmt.command.util.RemoteExecCommand;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzerFactory;
import oracle.ops.verification.framework.storage.NotFileSystemException;
import oracle.ops.verification.framework.storage.PathDiskInfo;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.util.GenericUtil;
import oracle.ops.verification.util.ParsingException;

public abstract class CommandHandler
implements StorageConstants {
    VerificationCommand genFSTypeCmd(String node, String path) {
        String[] arg = new String[]{"-getfstype", path};
        String[] env = null;
        return new VerificationCommand(node, arg, env);
    }

    int parseFSTypeResult(VerificationCommand vfyCmd, String path) throws StorageException {
        int[] fsType;
        String[] tags = new String[]{"FSTYPE"};
        int vfyCode = vfyCmd.getVfyCode();
        String output = vfyCmd.getOutput();
        if (19 == vfyCode) {
            NotFileSystemException se = new NotFileSystemException("7019", vfyCmd.getNode(), (Object[])new String[]{path});
            throw se;
        }
        if (0 != vfyCode) {
            Trace.out((String)("vfyCode for getfstype = " + String.valueOf(vfyCode)));
            throw new StorageException();
        }
        try {
            if (null == output) {
                Trace.out((String)"output of getfstype was null!");
                throw new StorageException();
            }
            fsType = GenericUtil.getIntFieldsByTags(output, tags);
        }
        catch (ParsingException pe) {
            Trace.out((String)("Problem parsing the string " + output));
            Trace.out((Exception)pe);
            throw new StorageException();
        }
        return fsType[0];
    }

    VerificationCommand genDiskDetailCmd(String node, String path) {
        String[] arg = new String[]{"-getdiskdetail", path};
        String[] env = null;
        return new VerificationCommand(node, arg, env);
    }

    public abstract PathDiskInfo parseDiskDetailResult(String var1, VerificationCommand var2, String var3) throws StorageException;

    public RemoteExecCommand genStorageInfoCmd(String node, String path) {
        String[] args = new String[]{"-getstorage", path};
        VerificationCommand vfyCmd = new VerificationCommand(node, args, null);
        return vfyCmd;
    }

    VerificationCommand genTypeCmd(String node, String path) {
        String[] arg = new String[]{"-getsttype", path};
        String[] env = null;
        return new VerificationCommand(node, arg, env);
    }

    VerificationCommand genGetGroupsCmd(String user) {
        String[] arg = new String[]{"-getgroups", user};
        String[] env = null;
        return new VerificationCommand("localnode", arg, env);
    }

    String[] parseGetGroupsResult(VerificationCommand vfyCmd) throws StorageException {
        int vfyCode = vfyCmd.getVfyCode();
        if (0 != vfyCode) {
            Trace.out((String)("vfyCode for getfstype = " + String.valueOf(vfyCode)));
            throw new StorageException();
        }
        String output = vfyCmd.getExectaskOutput().trim();
        ExecutionAnalyzer analyzer = ExecutionAnalyzerFactory.getExecutionAnalyzer();
        List<String> groupList = analyzer.parseGetGroupsOutput(output);
        return groupList.toArray(new String[0]);
    }

    abstract StorageInfo parseTypeResult(VerificationCommand var1, String var2) throws StorageException;

    public abstract RemoteExecCommand genInfoCmd(String var1, int var2) throws StorageException;

    public abstract RemoteExecCommand genInfoCmd(String var1, int var2, String var3) throws StorageException;

    public abstract RemoteExecCommand genInfoCmd(String var1, int var2, String var3, String var4, Result var5) throws StorageException;

    public abstract Vector parseInfoResult(RemoteExecCommand var1, int var2) throws StorageException;

    public abstract StorageInfo parseStorageInfoResult(RemoteExecCommand var1, String var2) throws StorageException;

    public abstract StorageInfo parseInfoResult(RemoteExecCommand var1, int var2, String var3) throws StorageException;
}

