/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.verification.framework.storage.FSInfo;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageInfo;

public class ACFSInfo
extends StorageInfo
implements StorageConstants {
    private String m_node;
    private int m_type;
    private String m_location;
    private String m_ver;
    private StorageSize m_free;
    private StorageSize m_size;
    private String m_diskGrpName;
    private FSInfo m_fsInfo;

    public ACFSInfo(String node, String path) {
        super(path, node, 14);
        this.m_location = path;
    }

    public ACFSInfo(String node, String path, String ver, long free, long size, String diskGrpName, FSInfo fsInfo) {
        super(path, node, 14);
        this.m_node = node;
        this.m_type = 14;
        this.m_location = path;
        this.m_ver = ver;
        this.m_free = new StorageSize((double)(free / 1024L), StorageUnit.KBYTE);
        this.m_size = new StorageSize((double)(size / 1024L), StorageUnit.KBYTE);
        this.m_diskGrpName = diskGrpName;
        this.m_fsInfo = fsInfo;
    }

    public String getLocation() {
        return this.m_location;
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    @Override
    public StorageSize getSize() {
        return this.m_size;
    }

    @Override
    public String getNode() {
        return this.m_node;
    }

    public String getVer() {
        return this.m_ver;
    }

    @Override
    public StorageSize getFree() {
        return this.m_free;
    }

    public String getDiskGrpName() {
        return this.m_diskGrpName;
    }

    @Override
    public int getAccess() {
        return this.m_fsInfo.getFSaccess();
    }

    public FSInfo getFSInfo() {
        return this.m_fsInfo;
    }
}

