/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.report.xmlreport;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtilConstants;
import oracle.ops.verification.framework.report.xmlreport.CVXMLReportReader;
import oracle.ops.verification.framework.report.xmlreport.XmlReportToolException;
import oracle.ops.verification.framework.util.VerificationUtil;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class CVXMLZipReportReader
extends CVXMLReportReader {
    protected ZipFile m_reportZipFile = null;
    private HashMap<String, List<String>> m_targetZipEntryNameHM = new LinkedHashMap<String, List<String>>();

    CVXMLZipReportReader(String reportFile) throws XmlReportToolException, FileNotFoundException {
        super(reportFile);
        try {
            this.m_reportZipFile = new ZipFile(reportFile);
        }
        catch (IOException e) {
            throw new XmlReportToolException(e.getMessage(), e);
        }
    }

    @Override
    public HashMap<String, HashMap<String, String>> getTargetList() throws XmlReportToolException {
        if (this.m_targetList != null) {
            return this.m_targetList;
        }
        this.m_targetList = new LinkedHashMap();
        Enumeration<? extends ZipEntry> entries = this.m_reportZipFile.entries();
        ArrayList<ZipEntry> zipEntries = new ArrayList<ZipEntry>();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            zipEntries.add(entry);
        }
        Comparator<ZipEntry> cmp = new Comparator<ZipEntry>(){

            @Override
            public int compare(ZipEntry o1, ZipEntry o2) {
                ZipEntry ze1 = o1;
                ZipEntry ze2 = o2;
                if (ze1 == ze2) {
                    return 0;
                }
                if (ze1 != null && ze2 != null) {
                    if (ze1.getName().indexOf("_") >= 0 && ze2.getName().indexOf("_") >= 0) {
                        int ze2EntryCount;
                        int ze1EntryCount = Integer.parseInt(ze1.getName().substring(ze1.getName().lastIndexOf("_") + 1, ze1.getName().length() - ".xml".length()));
                        if (ze1EntryCount == (ze2EntryCount = Integer.parseInt(ze2.getName().substring(ze2.getName().lastIndexOf("_") + 1, ze2.getName().length() - ".xml".length())))) {
                            return 0;
                        }
                        if (ze1EntryCount > ze2EntryCount) {
                            return 1;
                        }
                        return -1;
                    }
                    return ze1.getName().compareTo(ze2.getName());
                }
                if (ze1 != null) {
                    return 1;
                }
                return -1;
            }
        };
        Collections.sort(zipEntries, cmp);
        for (ZipEntry entry : zipEntries) {
            TargetListAttributesHandler handler = new TargetListAttributesHandler(entry.getName());
            InputStream targetIS = null;
            try {
                if ("header.xml".equals(entry.getName())) continue;
                targetIS = this.m_reportZipFile.getInputStream(entry);
                this.parseTargetList(handler, targetIS);
            }
            catch (TargetDetailsReadException e) {
                for (String targetKey : handler.m_targetList.keySet()) {
                    this.m_targetList.put(targetKey, handler.m_targetList.get(targetKey));
                    List<String> xmlFileList = this.m_targetZipEntryNameHM.get(targetKey);
                    if (xmlFileList == null) {
                        xmlFileList = new ArrayList<String>();
                        this.m_targetZipEntryNameHM.put(targetKey, xmlFileList);
                    }
                    xmlFileList.add(entry.getName());
                }
            }
            catch (IOException e) {
                Trace.out((String)"Exception encountered during parsing:");
                Trace.out((Exception)e);
                throw new XmlReportToolException(e.getMessage(), e);
            }
            catch (ParserConfigurationException e) {
                Trace.out((String)"Exception encountered during parsing:");
                Trace.out((Exception)e);
                throw new XmlReportToolException(e.getMessage(), e);
            }
            catch (SAXException e) {
                Trace.out((String)"Exception encountered during parsing:");
                Trace.out((Exception)e);
                throw new XmlReportToolException(e.getMessage(), e);
            }
        }
        Trace.out((int)1, (String)"Targets Found  : ", (Object[])new Object[]{VerificationUtil.strCollection2String(this.m_targetList.keySet())});
        return this.m_targetList;
    }

    @Override
    public List<Task> getTaskList(String targetKey) throws XmlReportToolException {
        Trace.out((String)("Retrieving tasks for : " + targetKey));
        List<String> zipEntryNameList = this.m_targetZipEntryNameHM.get(targetKey);
        if (zipEntryNameList == null) {
            this.getTargetList();
            zipEntryNameList = this.m_targetZipEntryNameHM.get(targetKey);
        }
        Enumeration<? extends ZipEntry> entries = this.m_reportZipFile.entries();
        ArrayList<Task> taskList = new ArrayList<Task>();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            try {
                if (zipEntryNameList == null || !zipEntryNameList.contains(entry.getName())) continue;
                InputStream targetIS = this.m_reportZipFile.getInputStream(entry);
                CVXMLReportReader.TaskListHandler handler = new CVXMLReportReader.TaskListHandler(taskList, targetKey);
                this.parse(new BufferedInputStream(targetIS), handler);
            }
            catch (IOException e) {
                Trace.out((String)("Exception encountered during parsing target: " + targetKey));
                Trace.out((Exception)e);
                throw new XmlReportToolException(e.getMessage(), e);
            }
        }
        return taskList;
    }

    @Override
    public ReportUtilConstants.BasicClusterWareDetails getHeader() throws XmlReportToolException {
        if (this.m_header != null) {
            return this.m_header;
        }
        Enumeration<? extends ZipEntry> entries = this.m_reportZipFile.entries();
        InputStream headerIS = null;
        ZipEntry entry = null;
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            try {
                if (!"header.xml".equals(entry.getName())) continue;
                headerIS = this.m_reportZipFile.getInputStream(entry);
                break;
            }
            catch (IOException e) {
                throw new XmlReportToolException(e.getMessage(), e);
            }
        }
        if (headerIS == null) {
            throw new XmlReportToolException(s_prvgMsgBundle.getMessage("13215", true));
        }
        CVXMLReportReader.HeaderAndTargetListHandler handler = new CVXMLReportReader.HeaderAndTargetListHandler();
        this.parse(new BufferedInputStream(headerIS), handler);
        this.m_header = handler.m_header;
        return this.m_header;
    }

    private void parseTargetList(DefaultHandler handler, InputStream xmlIS) throws ParserConfigurationException, SAXException, IOException {
        if (this.saxParser == null) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            this.saxParser = factory.newSAXParser();
            if (new File(this.m_xmlXsdURI).exists()) {
                this.saxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", this.m_xmlXsdURI);
                Trace.out((String)("Using '" + this.m_xmlXsdURI + "' for parsing"));
            } else {
                Trace.out((String)"Using DEFAULT parser.");
            }
        }
        this.saxParser.parse(xmlIS, handler);
    }

    class TargetDetailsReadException
    extends SAXParseException {
        private static final long serialVersionUID = 1L;

        public TargetDetailsReadException(String message, Locator locator) {
            super(message, locator);
        }
    }

    class TargetListAttributesHandler
    extends DefaultHandler {
        boolean headerStart = false;
        String m_targetKey = null;
        HashMap<String, HashMap<String, String>> m_targetList = null;

        TargetListAttributesHandler(String targetKey) {
            this.m_targetKey = targetKey;
            this.m_targetList = new LinkedHashMap<String, HashMap<String, String>>();
            Trace.out((int)1, (String)"Setup init'd m_targetList, m_header");
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase("TARGET_DATA")) {
                String targetName = attributes.getValue("ID");
                Trace.out((int)1, (String)("targetName: '" + targetName + "'"));
                this.m_targetList.put(CVXMLZipReportReader.this.getTargetKey(this.m_targetKey, attributes), CVXMLZipReportReader.this.getAttributes(attributes));
                Trace.out((int)1, (String)("attributes: '" + CVXMLZipReportReader.this.getAttributes(attributes) + "'"));
                throw new TargetDetailsReadException(null, null);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equalsIgnoreCase("HEADER")) {
                this.headerStart = false;
            }
        }
    }
}

