/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.report.xmlreport;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.verification.util.CollectionGroup;
import oracle.cluster.verification.util.VerificationType;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportPurgeTool;
import oracle.ops.verification.framework.report.ReportToolException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.report.ReportUtilConstants;
import oracle.ops.verification.framework.report.htmlreport.HtmlBrowserException;
import oracle.ops.verification.framework.report.htmlreport.HtmlBrowserInterface;
import oracle.ops.verification.framework.report.htmlreport.HtmlConstants;
import oracle.ops.verification.framework.report.htmlreport.HtmlFrameContainerPage;
import oracle.ops.verification.framework.report.htmlreport.HtmlInlinePopupContainerPage;
import oracle.ops.verification.framework.report.htmlreport.HtmlPage;
import oracle.ops.verification.framework.report.htmlreport.HtmlPopupPage;
import oracle.ops.verification.framework.report.htmlreport.HtmlReportToolException;
import oracle.ops.verification.framework.report.htmlreport.Table;
import oracle.ops.verification.framework.report.htmlreport.TableCell;
import oracle.ops.verification.framework.report.htmlreport.Text;
import oracle.ops.verification.framework.report.xmlreport.CVXMLReportReader;
import oracle.ops.verification.framework.report.xmlreport.XmlReportToolException;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class BaselineReportGenerator {
    private Set<CVXMLReportReader> m_reportList = new LinkedHashSet<CVXMLReportReader>();
    private MessageBundle s_rptMsgBundle = VerificationUtil.getMessageBundle("Prve");
    protected static MessageBundle s_prvgMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private List<String> m_mismatches = new ArrayList<String>();
    private int m_delta = 10;

    public BaselineReportGenerator(String xmlFileList) throws XmlReportToolException {
        String[] xmlFilePathArray;
        for (String xmlFilePath : xmlFilePathArray = xmlFileList.split(",")) {
            CVXMLReportReader reader = CVXMLReportReader.getCVXMLReportReader(xmlFilePath);
            this.m_reportList.add(reader);
        }
        String deltaString = VDMUtil.getDefaultBaselineDelta();
        if (VerificationUtil.isStringGood(deltaString)) {
            this.m_delta = Integer.parseInt(deltaString);
        }
    }

    public boolean xmlToHtml(String title, boolean showFailuresOnly, ReportUtilConstants.ReportContext context, boolean showInBrowser, String browserPath, boolean saveFile, String saveDirPath) throws ReportToolException, XmlFilePathException, HtmlBrowserException, XmlReportToolException {
        return this.xmlToHtml(title, null, showFailuresOnly, context, showInBrowser, browserPath, saveFile, saveDirPath);
    }

    public boolean xmlToHtml(String title, String author, boolean showFailuresOnly, ReportUtilConstants.ReportContext context, boolean showInBrowser, String browserPath, boolean saveFile, String saveDirPath) throws ReportToolException, XmlFilePathException, HtmlBrowserException, XmlReportToolException {
        return this.xmlToHtml(title, author, showFailuresOnly, HtmlConstants.Colors.Cornsilk, context, showInBrowser, browserPath, saveFile, saveDirPath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean xmlToHtml(String title, String author, boolean showFailuresOnly, HtmlConstants.Colors backGroundColor, ReportUtilConstants.ReportContext context, boolean showInBrowser, String browserPath, boolean saveFile, String saveDirPath) throws ReportToolException, XmlFilePathException, HtmlBrowserException, XmlReportToolException {
        LinkedHashMap<String, HashMap<String, String>> targetHM = new LinkedHashMap<String, HashMap<String, String>>();
        for (CVXMLReportReader reader : this.m_reportList) {
            targetHM.putAll(reader.getTargetList());
        }
        int cnt = -1;
        boolean atleastOneTableAdded = false;
        String htmlFilePathWithoutExt = this.getHTMLFilePath(saveDirPath);
        String htmlFilePath = htmlFilePathWithoutExt + ".html";
        ArrayList<HashMap<String, String>> tocListTextList = new ArrayList<HashMap<String, String>>();
        for (String targetKey : ((HashMap)targetHM).keySet()) {
            HashMap attributes = (HashMap)((HashMap)targetHM).get(targetKey);
            String targetStr = (String)attributes.get("ID");
            if (!VerificationUtil.isStringGood(targetStr)) {
                Trace.out((String)"skipping without adding any target because target type null");
                continue;
            }
            TargetDetails targetDetails = null;
            boolean isClusterWideCollection = this.hasClusterwideCollection(attributes);
            targetDetails = this.getTargetDetails(attributes, isClusterWideCollection);
            if (targetDetails == null) {
                Trace.out((String)"skipping without adding any target because no details werefound in the xml");
                continue;
            }
            HtmlPage targetPage = null;
            Text targetHead = new Text("");
            targetHead.setTextData(targetDetails.getTargetText());
            String htmlFramePath = htmlFilePathWithoutExt + "_" + ++cnt + ".html";
            targetPage = this.m_reportList.size() == 1 ? this.createHtmlPageForSingleBaseLine(targetHead.getTextData(), targetKey, targetDetails.getTargetType(), targetDetails.isCollectionOnly(), showFailuresOnly, author, backGroundColor, isClusterWideCollection, htmlFramePath) : this.createHtmlPageForMultipleBaseLines(targetHead.getTextData(), targetKey, targetDetails.getTargetType(), showFailuresOnly, author, backGroundColor, isClusterWideCollection, htmlFramePath);
            if (targetPage == null) continue;
            atleastOneTableAdded = true;
            HashMap<String, String> entry = new HashMap<String, String>();
            tocListTextList.add(entry);
            entry.put(targetDetails.getTargetText(), htmlFramePath);
        }
        if (atleastOneTableAdded) {
            try {
                BufferedWriter containerPageWriter = new BufferedWriter(new FileWriter(htmlFilePath));
                HtmlFrameContainerPage mainPage = new HtmlFrameContainerPage(title, author, backGroundColor, true, containerPageWriter);
                mainPage.addHtmlFrameList(tocListTextList, htmlFilePath);
                mainPage.addHTMLClose();
                ((Writer)containerPageWriter).close();
                ReportUtil.quietblankln();
                ReportUtil.quietprintln(this.s_rptMsgBundle.getMessage("10028", false, (Object[])new String[]{htmlFilePath}));
                if (!showInBrowser || !VerificationUtil.isStringGood(htmlFilePath)) return true;
                HtmlBrowserInterface.showHtmlInBrowser(htmlFilePath, browserPath);
                return true;
            }
            catch (FileNotFoundException e) {
                throw new ReportToolException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new ReportToolException(e.getMessage(), e);
            }
        } else {
            ReportUtil.quietblankln();
            if (showFailuresOnly) {
                ReportUtil.quietprintln(s_prvgMsgBundle.getMessage("11940", false));
                return true;
            } else {
                ReportUtil.quietprintln(s_prvgMsgBundle.getMessage("11925", false));
            }
        }
        return true;
    }

    protected String getHTMLFilePath(String dirPath) throws XmlFilePathException, XmlReportToolException {
        String fileName = "cvucheckreport_" + this.getTimeStampStr(Calendar.getInstance());
        String fullpath = null;
        if (VerificationUtil.isStringGood(dirPath)) {
            dirPath = dirPath.trim();
        } else {
            try {
                dirPath = ReportUtilConstants.getCvuHtmlReportDefaultDirPath();
            }
            catch (ClusterException e) {
                throw new XmlReportToolException(e.getMessage(), e);
            }
        }
        File dir = new File(dirPath);
        if (dir.exists()) {
            if (!dirPath.endsWith(VerificationConstants.FILE_SEPARATOR)) {
                dirPath = dirPath + VerificationConstants.FILE_SEPARATOR;
            }
            fullpath = dirPath + fileName;
        }
        if (VerificationUtil.isStringGood(fullpath)) {
            ReportPurgeTool tool = new ReportPurgeTool(dirPath, "cvucheckreport", ".html");
            tool.purgeOlderFiles(40);
            return fullpath;
        }
        throw new XmlFilePathException(this.s_rptMsgBundle.getMessage("10058", false));
    }

    private String getTimeStampStr(Calendar calendar) {
        SimpleDateFormat formatter = new SimpleDateFormat("MMddyyyHHmmss");
        return formatter.format(calendar.getTime());
    }

    protected String getReportDisplayKey(CVXMLReportReader reportReader) throws XmlReportToolException {
        String[] timeStamp = this.getTimeStamp(reportReader.getHeader().getTimeStamp(), "/", ":");
        String xmlFileName = new File(reportReader.getXmlFileName()).getName();
        String timeStampStr = "";
        if (timeStamp != null && timeStamp.length > 1) {
            timeStampStr = timeStamp[0] + " " + timeStamp[1];
        }
        String reportKey = timeStampStr + " [" + xmlFileName + "]";
        return reportKey;
    }

    private boolean hasClusterwideCollection(HashMap<String, String> attributes) {
        String targetStr = attributes.get("ID");
        return targetStr.trim().equalsIgnoreCase(CollectionGroup.OHASD_MODEL_COLLECTION.getID()) || targetStr.trim().equalsIgnoreCase(CollectionGroup.CRS_MODEL_COLLECTION.getID()) || targetStr.trim().equalsIgnoreCase(CollectionGroup.OCR_COLLECTION.getID());
    }

    private boolean hasNodeCollection(HashMap<String, String> attributes) {
        String targetStr = attributes.get("ID");
        return !targetStr.trim().equalsIgnoreCase(CollectionGroup.OHASD_MODEL_COLLECTION.getID()) && !targetStr.trim().equalsIgnoreCase(CollectionGroup.CRS_MODEL_COLLECTION.getID());
    }

    private TargetDetails getTargetDetails(HashMap<String, String> attributes, boolean clusterWide) {
        String targetStr = attributes.get("ID");
        if (targetStr.trim().equalsIgnoreCase(VerificationType.PREREQ_CRS_INST.getID())) {
            return new TargetDetails(ReportUtilConstants.TargetType.SYSTEM_BASED_CHECKS, s_prvgMsgBundle.getMessage("11618", false), false);
        }
        if (targetStr.trim().equalsIgnoreCase(VerificationType.POSTREQ_CRS_INST.getID())) {
            return new TargetDetails(ReportUtilConstants.TargetType.CLUSTER_BASED_CHECKS, s_prvgMsgBundle.getMessage("11620", false), false);
        }
        if (targetStr.trim().equalsIgnoreCase(VerificationType.BESTPRACTICE_PRE_CRS_INST.getID())) {
            return new TargetDetails(ReportUtilConstants.TargetType.SYSTEM_BASED_CHECKS, s_prvgMsgBundle.getMessage("11619", false), false);
        }
        if (targetStr.trim().equalsIgnoreCase(VerificationType.BESTPRACTICE_POSTREQ_CRS_INST.getID())) {
            return new TargetDetails(ReportUtilConstants.TargetType.CLUSTER_BASED_CHECKS, s_prvgMsgBundle.getMessage("11621", false), false);
        }
        if (targetStr.trim().equalsIgnoreCase(VerificationType.PREREQ_DB_CONFIG.getID()) || targetStr.trim().equalsIgnoreCase(VerificationType.PREREQ_DB_INST.getID()) || targetStr.trim().equalsIgnoreCase(VerificationType.BESTPRACTICE_POSTREQ_DB_CONFIG.getID()) || targetStr.trim().equalsIgnoreCase(VerificationType.POSTREQ_DB_CONFIG.getID())) {
            String captionMsg = null;
            String dbName = attributes.get("DATABASENAME");
            captionMsg = targetStr.trim().equalsIgnoreCase(VerificationType.BESTPRACTICE_POSTREQ_DB_CONFIG.getID()) ? s_prvgMsgBundle.getMessage("11623", false, (Object[])new String[]{dbName}) : s_prvgMsgBundle.getMessage("11622", false, (Object[])new String[]{dbName});
            return new TargetDetails(ReportUtilConstants.TargetType.DATABASE_CHECKS, captionMsg, false);
        }
        if (targetStr.trim().equalsIgnoreCase(CollectionGroup.CRS_SOFTWARE_COLLECTION.getID())) {
            return new TargetDetails(ReportUtilConstants.TargetType.CRS_SOFTWARE_CHECKS, s_prvgMsgBundle.getMessage("11625", false), false);
        }
        if (targetStr.trim().equalsIgnoreCase(CollectionGroup.DB_SOFTWARE_COLLECTION.getID())) {
            String home = attributes.get("HOME");
            String captionMsg = s_prvgMsgBundle.getMessage("11626", false, (Object[])new String[]{home});
            return new TargetDetails(ReportUtilConstants.TargetType.DB_SOFTWARE_CHECKS, captionMsg, false);
        }
        if (targetStr.trim().equalsIgnoreCase(CollectionGroup.DB_INIT_PARAMETER_COLLECTION.getID())) {
            String dbName = attributes.get("DATABASENAME");
            String captionMsg = s_prvgMsgBundle.getMessage("11627", false, (Object[])new String[]{dbName});
            return new TargetDetails(ReportUtilConstants.TargetType.DB_INIT_PARAM_BASED_CHECKS, captionMsg, false);
        }
        if (targetStr.trim().equalsIgnoreCase(CollectionGroup.OCR_COLLECTION.getID())) {
            String captionMsg = s_prvgMsgBundle.getMessage("11630", false);
            if (clusterWide) {
                captionMsg = s_prvgMsgBundle.getMessage("11648", false);
            }
            return new TargetDetails(ReportUtilConstants.TargetType.OCR_CHECKS, captionMsg, true);
        }
        if (targetStr.trim().equalsIgnoreCase(CollectionGroup.GPNP_COLLECTION.getID())) {
            String captionMsg = s_prvgMsgBundle.getMessage("11645", false);
            return new TargetDetails(ReportUtilConstants.TargetType.GPNP_CHECKS, captionMsg, true);
        }
        if (targetStr.trim().equalsIgnoreCase(CollectionGroup.OHASD_MODEL_COLLECTION.getID())) {
            String captionMsg = s_prvgMsgBundle.getMessage("11646", false);
            return new TargetDetails(ReportUtilConstants.TargetType.OHASD_MODEL_BASED_CHECKS, captionMsg, true);
        }
        if (targetStr.trim().equalsIgnoreCase(CollectionGroup.CRS_MODEL_COLLECTION.getID())) {
            String captionMsg = s_prvgMsgBundle.getMessage("11647", false);
            return new TargetDetails(ReportUtilConstants.TargetType.CRS_MODEL_BASED_CHECKS, captionMsg, true);
        }
        if (targetStr.trim().equalsIgnoreCase(CollectionGroup.OS_COLLECTIONS.getID())) {
            String captionMsg = s_prvgMsgBundle.getMessage("11649", false);
            return new TargetDetails(ReportUtilConstants.TargetType.OS_COLLECTION, captionMsg, true);
        }
        if (targetStr.trim().equalsIgnoreCase(CollectionGroup.OS_KERNEL_PARAMS.getID())) {
            String captionMsg = s_prvgMsgBundle.getMessage("11651", false);
            return new TargetDetails(ReportUtilConstants.TargetType.OS_KERNEL_PARAM_COLLECTION, captionMsg, true);
        }
        if (targetStr.trim().equalsIgnoreCase(CollectionGroup.OS_PACKAGES.getID())) {
            String captionMsg = s_prvgMsgBundle.getMessage("11650", false);
            return new TargetDetails(ReportUtilConstants.TargetType.OS_PACKAGE_COLLECTION, captionMsg, true);
        }
        if (targetStr.trim().equalsIgnoreCase(CollectionGroup.OS_PATCHES.getID())) {
            String captionMsg = s_prvgMsgBundle.getMessage("11652", false);
            return new TargetDetails(ReportUtilConstants.TargetType.OS_PATCH_COLLECTION, captionMsg, true);
        }
        if (targetStr.trim().equalsIgnoreCase(CollectionGroup.OS_RESOURCE_LIMITS.getID())) {
            String captionMsg = s_prvgMsgBundle.getMessage("11654", false);
            return new TargetDetails(ReportUtilConstants.TargetType.OS_RESOURCE_LIMITS, captionMsg, true);
        }
        if (targetStr.trim().equalsIgnoreCase(CollectionGroup.ENVIRONMENT_VARIABLES.getID())) {
            String captionMsg = s_prvgMsgBundle.getMessage("11653", false);
            return new TargetDetails(ReportUtilConstants.TargetType.ENVIRONMENT_VARIABLES, captionMsg, true);
        }
        if (targetStr.trim().equalsIgnoreCase(CollectionGroup.OS_RESOURCE_LIMITS_FOR_CRSD.getID())) {
            String captionMsg = s_prvgMsgBundle.getMessage("11657", false);
            return new TargetDetails(ReportUtilConstants.TargetType.OS_RESOURCE_LIMITS_FOR_CRSD, captionMsg, true);
        }
        if (targetStr.trim().equalsIgnoreCase(CollectionGroup.ENVIRONMENT_VARIABLES_FOR_CRSD.getID())) {
            String captionMsg = s_prvgMsgBundle.getMessage("11656", false);
            return new TargetDetails(ReportUtilConstants.TargetType.ENVIRONMENT_VARIABLES_FOR_CRSD, captionMsg, true);
        }
        if (targetStr.trim().equalsIgnoreCase(CollectionGroup.INITTAB_ENTRIES.getID())) {
            String captionMsg = s_prvgMsgBundle.getMessage("11655", false);
            return new TargetDetails(ReportUtilConstants.TargetType.INITTAB_ENTRIES, captionMsg, true);
        }
        if (targetStr.trim().equalsIgnoreCase(CollectionGroup.CRS_PATCH_COLLECTION.getID())) {
            String captionMsg = s_prvgMsgBundle.getMessage("11665", false);
            return new TargetDetails(ReportUtilConstants.TargetType.CRS_PATCH_COLLECTION, captionMsg, true);
        }
        if (targetStr.trim().equalsIgnoreCase(CollectionGroup.DB_PATCH_COLLECTION.getID())) {
            String home = attributes.get("HOME");
            String captionMsg = s_prvgMsgBundle.getMessage("11666", false, (Object[])new String[]{home});
            return new TargetDetails(ReportUtilConstants.TargetType.DB_PATCH_COLLECTION, captionMsg, true);
        }
        if (targetStr.trim().equalsIgnoreCase(CollectionGroup.COMPONENT_ASM_INTEGRITY.getID()) || targetStr.trim().equalsIgnoreCase(CollectionGroup.COMP_ASM_INTEGRITY.getID())) {
            String captionMsg = s_prvgMsgBundle.getMessage("11660", false);
            return new TargetDetails(ReportUtilConstants.TargetType.ASM_CHECKS, captionMsg, true);
        }
        if (targetStr.trim().equalsIgnoreCase(CollectionGroup.BESTPRACTICE_ASM.getID())) {
            String captionMsg = s_prvgMsgBundle.getMessage("11661", false);
            return new TargetDetails(ReportUtilConstants.TargetType.ASM_CHECKS, captionMsg, false);
        }
        if (targetStr.trim().equalsIgnoreCase(CollectionGroup.ASM_INIT_PARAMETER_COLLECTION.getID())) {
            String captionMsg = s_prvgMsgBundle.getMessage("11662", false);
            return new TargetDetails(ReportUtilConstants.TargetType.ASM_INIT_PARAM_BASED_CHECKS, captionMsg, true);
        }
        if (targetStr.trim().equalsIgnoreCase(CollectionGroup.ASM_DISK_GROUP_CONFIGURATION_COLLECTION.getID())) {
            String captionMsg = s_prvgMsgBundle.getMessage("11663", false);
            return new TargetDetails(ReportUtilConstants.TargetType.ASM_DISK_GROUP_CONFIGURATION_COLLECTION, captionMsg, true);
        }
        return null;
    }

    private HashMap<String, List<CollectionElement>> getCollectionSet(String targetKey, CVXMLReportReader reader, boolean clusterWideCollection, boolean showFailuresOnly) throws XmlReportToolException {
        List<Task> taskList = reader.getTaskList(targetKey);
        LinkedHashMap<String, List<CollectionElement>> sortedColletionHashTable = new LinkedHashMap<String, List<CollectionElement>>();
        LinkedHashMap<String, ArrayList<CollectionElement>> errorCollectionMap = new LinkedHashMap<String, ArrayList<CollectionElement>>();
        LinkedHashMap<String, ArrayList<CollectionElement>> warnCollectionMap = new LinkedHashMap<String, ArrayList<CollectionElement>>();
        LinkedHashMap<String, ArrayList<CollectionElement>> sucCollectionMap = new LinkedHashMap<String, ArrayList<CollectionElement>>();
        for (Task task : taskList) {
            List<CollectionElement> collectionList;
            LinkedHashMap<String, ArrayList<CollectionElement>> collectionHashTable = new LinkedHashMap<String, ArrayList<CollectionElement>>();
            ResultSet resultSet = task.getResultSet();
            Hashtable t = resultSet.getResultTable();
            Enumeration nodeKeys = t.keys();
            if (!clusterWideCollection) {
                while (nodeKeys.hasMoreElements()) {
                    String node = (String)nodeKeys.nextElement();
                    Result result = (Result)t.get(node);
                    for (CollectionElement element : result.getCollectionElements()) {
                        collectionList = null;
                        collectionList = (List)((HashMap)collectionHashTable).get(element.getName());
                        if (collectionList == null) {
                            collectionList = new ArrayList<CollectionElement>();
                            collectionHashTable.put(element.getName(), (ArrayList<CollectionElement>)collectionList);
                        }
                        collectionList.add(element);
                    }
                }
            } else {
                for (CollectionElement element : resultSet.getCollectionElements()) {
                    ArrayList<CollectionElement> collectionList2 = null;
                    collectionList2 = (ArrayList<CollectionElement>)((HashMap)collectionHashTable).get(element.getName());
                    if (collectionList2 == null) {
                        collectionList2 = new ArrayList<CollectionElement>();
                        collectionHashTable.put(element.getName(), collectionList2);
                    }
                    collectionList2.add(element);
                }
            }
            for (String collectionName : ((HashMap)collectionHashTable).keySet()) {
                boolean hasError = false;
                boolean hasWarn = false;
                collectionList = (ArrayList<CollectionElement>)((HashMap)collectionHashTable).get(collectionName);
                for (CollectionElement element : collectionList) {
                    if (element.getStatus() == 2 || element.getStatus() == 3) {
                        hasError = true;
                        break;
                    }
                    if (element.getStatus() != 4) continue;
                    hasWarn = true;
                }
                if (hasError) {
                    errorCollectionMap.put(collectionName, (ArrayList<CollectionElement>)collectionList);
                    continue;
                }
                if (hasWarn) {
                    warnCollectionMap.put(collectionName, (ArrayList<CollectionElement>)collectionList);
                    continue;
                }
                sucCollectionMap.put(collectionName, (ArrayList<CollectionElement>)collectionList);
            }
        }
        sortedColletionHashTable.putAll(errorCollectionMap);
        sortedColletionHashTable.putAll(warnCollectionMap);
        if (!showFailuresOnly) {
            sortedColletionHashTable.putAll(sucCollectionMap);
        }
        return sortedColletionHashTable;
    }

    protected String[] getTimeStamp(Calendar calendar, String dateSep, String timeSep) {
        String[] timeStampArray = null;
        String dateStr = null;
        String timeStr = null;
        String dateDelim = dateSep;
        String timeDelim = timeSep;
        if (calendar != null) {
            String pattern = null;
            pattern = dateDelim != null ? "dd" + dateSep + "MM" + dateSep + "yyyy" : "ddMMyyy";
            SimpleDateFormat formatter = new SimpleDateFormat(pattern);
            dateStr = formatter.format(calendar.getTime());
            pattern = timeDelim != null ? "HH" + timeDelim + "mm" + timeDelim + "ss" : "HHmmss";
            formatter = new SimpleDateFormat(pattern);
            timeStr = formatter.format(calendar.getTime());
        }
        if (VerificationUtil.isStringGood(timeStr) && VerificationUtil.isStringGood(dateStr)) {
            timeStampArray = new String[]{dateStr, timeStr};
        }
        return timeStampArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HtmlPage createHtmlPageForSingleBaseLine(String targetName, String targetKey, ReportUtilConstants.TargetType targetType, boolean collectionOnly, boolean showFailuresOnly, String author, HtmlConstants.Colors backGroundColor, boolean clusterwiseCollection, String htmlFramePath) throws ReportToolException, XmlReportToolException {
        HtmlInlinePopupContainerPage htmlPage;
        BufferedWriter htmlPageWriter = null;
        try {
            htmlPageWriter = new BufferedWriter(new FileWriter(htmlFramePath));
            htmlPage = new HtmlInlinePopupContainerPage(targetName, author, HtmlConstants.Colors.Gainsboro, true, htmlPageWriter);
        }
        catch (FileNotFoundException e) {
            throw new ReportToolException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ReportToolException(e.getMessage(), e);
        }
        String notApplicable = this.s_rptMsgBundle.getMessage("10026", false);
        String notAvailable = this.s_rptMsgBundle.getMessage("10027", false);
        CVXMLReportReader reader = this.m_reportList.iterator().next();
        String reportKey = this.getReportDisplayKey(reader);
        Text targetDefination = new Text(targetName);
        targetDefination.setFontSize(5);
        targetDefination.setBold(true);
        targetDefination.setTextColor(HtmlConstants.Colors.DarkGreen);
        HtmlConstants.Colors headerColor = HtmlConstants.Colors.LightSteelBlue;
        String captionStr = VerificationConstants.LINE_SEPARATOR + VerificationConstants.LINE_SEPARATOR + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + targetDefination.toHtmlString() + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;";
        Text caption = new Text(captionStr);
        Table table = new Table(0);
        table.setBackGroundColor(HtmlConstants.Colors.Black);
        table.setBorderColor(HtmlConstants.Colors.DarkGoldenRod);
        table.setTableBorderWidth(1);
        table.setCaption(caption);
        table.setWidth(98);
        this.createSingleBaselineTableColumnHeader(targetType, reportKey, headerColor, htmlPage, table, clusterwiseCollection, collectionOnly);
        HashMap<String, List<CollectionElement>> collectionHash = this.getCollectionSet(targetKey, reader, clusterwiseCollection, showFailuresOnly);
        if (collectionHash.size() > 0) {
            String msg = s_prvgMsgBundle.getMessage("11616", false, (Object[])new String[]{targetName});
            ReportUtil.quietprintln(msg);
        }
        Set<String> collectionKeySet = collectionHash.keySet();
        boolean atleastOneRowAdded = false;
        for (String collectionName : collectionKeySet) {
            HtmlConstants.Colors rowColor = HtmlConstants.Colors.LightGrey;
            Text collectionNameText = new Text("");
            List<CollectionElement> nodeCollectionList = collectionHash.get(collectionName);
            String str = "";
            boolean hasChildren = false;
            int nodeRowIndex = -1;
            TableCell collectionNameTableCell = null;
            TableCell expectedValueTableCell = null;
            ArrayList<TableCell[]> collectionRows = new ArrayList<TableCell[]>();
            for (int j = 0; j < nodeCollectionList.size(); ++j) {
                TableCell collectionNodeTableCell = null;
                CollectionElement collectionElement = nodeCollectionList.get(j);
                HtmlConstants.Colors collectionRowColor = null;
                collectionRowColor = HtmlConstants.Colors.LightGrey;
                if (j == 0) {
                    hasChildren = collectionElement.getChildrens().size() > 0;
                    str = collectionElement.getName();
                    if (VerificationUtil.isStringGood(str)) {
                        collectionNameText = new Text(str);
                    }
                    if (VerificationUtil.isStringGood(str = collectionElement.getDescription())) {
                        HtmlPopupPage popUpPage = this.createCollectionDescPopupPage("", str, htmlPage.getBackgroundColor());
                        collectionNameText.setInlinePopUpWindowsLink("#DESC", popUpPage);
                        collectionNameText.setTextColor(HtmlConstants.Colors.Black);
                    }
                    collectionNameTableCell = new TableCell(collectionNameText, rowColor, HtmlConstants.VeriticalAlignment.top, null);
                }
                String collectionStatus = collectionElement.getStatusString().replaceAll("_", " ").toLowerCase();
                Text collectionStatusText = new Text(collectionStatus);
                HtmlConstants.Colors verificationColor = this.getVerificationColor(collectionStatus);
                collectionStatusText.setTextColor(verificationColor);
                List<ErrorDescription> errorList = collectionElement.getErrorDescriptionList();
                if (errorList != null && errorList.size() > 0) {
                    HtmlPopupPage popUpPage = this.createCollectionErrorPopupPage("", errorList, htmlPage.getBackgroundColor());
                    collectionStatusText.setInlinePopUpWindowsLink("#DESC", popUpPage);
                }
                ArrayList<CollectionElement> collectionElementRowList = new ArrayList<CollectionElement>();
                if (hasChildren) {
                    collectionElementRowList.addAll(collectionElement.getChildrens());
                } else {
                    collectionElementRowList.add(collectionElement);
                }
                int collectionCountIndex = -1;
                for (CollectionElement currentElement : collectionElementRowList) {
                    int colStartIndex = 0;
                    ++nodeRowIndex;
                    ++collectionCountIndex;
                    Text expectedValueText = new Text("");
                    if (currentElement.getExpectedValue() != null) {
                        expectedValueText.setTextData(String.valueOf(currentElement.getExpectedValue()));
                    }
                    String actualValTxtString = "";
                    if (currentElement.getValue() != null) {
                        verificationColor = this.getVerificationColor(currentElement.getStatusString().replaceAll("_", " ").toLowerCase());
                        actualValTxtString = currentElement.getValue().toString();
                    }
                    Text actualValTxt = new Text(actualValTxtString);
                    if (!HtmlConstants.Colors.Green.equals((Object)verificationColor)) {
                        actualValTxt.setTextColor(verificationColor);
                    }
                    int colCount = 0;
                    if (nodeRowIndex == 0) {
                        if (hasChildren) {
                            colCount = clusterwiseCollection ? 5 : 6;
                        } else {
                            int n = colCount = clusterwiseCollection ? 4 : 5;
                        }
                        if (collectionOnly) {
                            colCount -= 2;
                        }
                    } else if (collectionCountIndex == 0) {
                        if (hasChildren) {
                            int n = colCount = clusterwiseCollection ? 4 : 5;
                            if (collectionOnly) {
                                colCount -= 2;
                            }
                        } else {
                            int n = colCount = clusterwiseCollection ? 2 : 3;
                            if (collectionOnly) {
                                --colCount;
                            }
                        }
                    } else if (hasChildren) {
                        colCount = 3;
                        if (collectionOnly) {
                            --colCount;
                        }
                    } else {
                        colCount = 1;
                    }
                    TableCell[] row = new TableCell[colCount];
                    if (nodeRowIndex == 0) {
                        row[colStartIndex] = collectionNameTableCell;
                        ++colStartIndex;
                    }
                    if (collectionCountIndex == 0 && !clusterwiseCollection) {
                        Text nodeNameText = new Text("");
                        if (collectionElement.getNode() != null) {
                            nodeNameText.setTextData(collectionElement.getNode());
                        }
                        collectionNodeTableCell = new TableCell(nodeNameText, collectionRowColor, HtmlConstants.VeriticalAlignment.top, null);
                        collectionNodeTableCell.setRowSpan(collectionElementRowList.size());
                        row[colStartIndex] = collectionNodeTableCell;
                        ++colStartIndex;
                    }
                    if (hasChildren) {
                        row[colStartIndex++] = new TableCell(new Text(currentElement.getName()), collectionRowColor, HtmlConstants.VeriticalAlignment.top, null);
                        row[colStartIndex++] = new TableCell(actualValTxt, collectionRowColor, HtmlConstants.VeriticalAlignment.top, null);
                    } else {
                        row[colStartIndex] = new TableCell(actualValTxt, collectionRowColor, HtmlConstants.VeriticalAlignment.top, null);
                        row[colStartIndex].setColSpan(2);
                        ++colStartIndex;
                    }
                    if ((hasChildren || nodeRowIndex == 0) && !collectionOnly) {
                        expectedValueTableCell = new TableCell(expectedValueText, collectionRowColor, HtmlConstants.VeriticalAlignment.top, null);
                        row[colStartIndex++] = expectedValueTableCell;
                    }
                    if (collectionCountIndex == 0 && !collectionOnly) {
                        row[colStartIndex] = new TableCell(collectionStatusText, collectionRowColor, HtmlConstants.VeriticalAlignment.top, null);
                        row[colStartIndex].setRowSpan(collectionElementRowList.size());
                    }
                    collectionRows.add(row);
                    atleastOneRowAdded = true;
                }
            }
            collectionNameTableCell.setRowSpan(nodeRowIndex + 1);
            if (!hasChildren && !collectionOnly) {
                expectedValueTableCell.setRowSpan(nodeRowIndex + 1);
            }
            for (TableCell[] row : collectionRows) {
                htmlPage.addTableRowToHtmlBody(row);
            }
        }
        try {
            if (atleastOneRowAdded) {
                htmlPage.addTableClose();
                htmlPage.addHTMLBodyClose();
                htmlPage.addHTMLClose();
            }
            ((Writer)htmlPageWriter).close();
            if (atleastOneRowAdded) return htmlPage;
        }
        catch (IOException e) {
            try {
                throw new XmlReportToolException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                if (atleastOneRowAdded) throw throwable;
                Trace.out((int)5, (String)"No rows added for Target %s, the html page for the target will be deleted", (Object[])new Object[]{targetName});
                new File(htmlFramePath).delete();
                htmlPage = null;
                throw throwable;
            }
        }
        Trace.out((int)5, (String)"No rows added for Target %s, the html page for the target will be deleted", (Object[])new Object[]{targetName});
        new File(htmlFramePath).delete();
        return null;
    }

    private void createSingleBaselineTableColumnHeader(ReportUtilConstants.TargetType targetType, String reportKey, HtmlConstants.Colors headerColor, HtmlPage htmlPage, Table table, boolean clusterwiseCollection, boolean collectionOnly) throws HtmlReportToolException {
        TableCell[] headers = new TableCell[2];
        String firstColumnHeader = s_prvgMsgBundle.getMessage("13150", false);
        if (ReportUtilConstants.TargetType.OCR_CHECKS.equals((Object)targetType) && clusterwiseCollection) {
            firstColumnHeader = s_prvgMsgBundle.getMessage("13151", false);
        } else if (ReportUtilConstants.TargetType.CRS_SOFTWARE_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.DB_SOFTWARE_CHECKS.equals((Object)targetType)) {
            firstColumnHeader = s_prvgMsgBundle.getMessage("13152", false);
        } else if (ReportUtilConstants.TargetType.OHASD_MODEL_BASED_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.CRS_MODEL_BASED_CHECKS.equals((Object)targetType)) {
            firstColumnHeader = s_prvgMsgBundle.getMessage("13153", false);
        } else if (ReportUtilConstants.TargetType.OHASD_MODEL_BASED_CHECKS.equals((Object)targetType)) {
            firstColumnHeader = s_prvgMsgBundle.getMessage("13154", false);
        }
        headers[0] = new TableCell(new Text(""), headerColor, null, null);
        headers[1] = new TableCell(new Text(reportKey), headerColor, null, null);
        headers[0].setWidth(20);
        headers[1].setWidth(80);
        String idTextStr = null;
        idTextStr = targetType.name().contains("DATABASE") ? this.s_rptMsgBundle.getMessage("10022", false) : (ReportUtilConstants.TargetType.ASM_CHECKS.equals((Object)targetType) ? s_prvgMsgBundle.getMessage("10486", false) : (ReportUtilConstants.TargetType.ASM_INIT_PARAM_BASED_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.ASM_DISK_GROUP_CONFIGURATION_COLLECTION.equals((Object)targetType) ? s_prvgMsgBundle.getMessage("10485", false) : this.s_rptMsgBundle.getMessage("10052", false)));
        int secondaryHeaderCol = 0;
        if (ReportUtilConstants.TargetType.OCR_CHECKS.equals((Object)targetType) && clusterwiseCollection || ReportUtilConstants.TargetType.CRS_SOFTWARE_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.DB_SOFTWARE_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.OHASD_MODEL_BASED_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.CRS_MODEL_BASED_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.GPNP_CHECKS.equals((Object)targetType)) {
            secondaryHeaderCol = clusterwiseCollection ? 5 : 6;
        } else {
            int n = secondaryHeaderCol = clusterwiseCollection ? 4 : 5;
        }
        if (collectionOnly) {
            secondaryHeaderCol -= 2;
        }
        TableCell[] secondHeaders = new TableCell[secondaryHeaderCol];
        int colIndex = 0;
        Text firstColumnHeaderTxt = new Text(firstColumnHeader);
        firstColumnHeaderTxt.setBold(true);
        secondHeaders[colIndex] = new TableCell(firstColumnHeaderTxt, headerColor, null, null);
        secondHeaders[colIndex++].setWidth(30);
        if (!clusterwiseCollection) {
            Text idText = new Text(idTextStr);
            idText.setBold(true);
            secondHeaders[colIndex] = new TableCell(idText, headerColor, null, HtmlConstants.HorizontalAlignment.center);
            secondHeaders[colIndex++].setWidth(20);
        }
        if (ReportUtilConstants.TargetType.OCR_CHECKS.equals((Object)targetType) && clusterwiseCollection || ReportUtilConstants.TargetType.CRS_SOFTWARE_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.DB_SOFTWARE_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.CRS_MODEL_BASED_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.OHASD_MODEL_BASED_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.GPNP_CHECKS.equals((Object)targetType)) {
            String nameTextStr = "";
            if (ReportUtilConstants.TargetType.OCR_CHECKS.equals((Object)targetType)) {
                nameTextStr = s_prvgMsgBundle.getMessage("13155", false);
            } else if (ReportUtilConstants.TargetType.CRS_SOFTWARE_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.DB_SOFTWARE_CHECKS.equals((Object)targetType)) {
                nameTextStr = s_prvgMsgBundle.getMessage("13156", false);
            } else if (ReportUtilConstants.TargetType.CRS_MODEL_BASED_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.OHASD_MODEL_BASED_CHECKS.equals((Object)targetType)) {
                nameTextStr = s_prvgMsgBundle.getMessage("13157", false);
            } else if (ReportUtilConstants.TargetType.GPNP_CHECKS.equals((Object)targetType)) {
                nameTextStr = s_prvgMsgBundle.getMessage("13158", false);
            }
            Text nameText = new Text(nameTextStr);
            nameText.setBold(true);
            secondHeaders[colIndex++] = new TableCell(nameText, headerColor, null, HtmlConstants.HorizontalAlignment.center);
            Text valueText = new Text(this.s_rptMsgBundle.getMessage("10004", false));
            valueText.setBold(true);
            secondHeaders[colIndex++] = new TableCell(valueText, headerColor, null, HtmlConstants.HorizontalAlignment.center);
            headers[1].setColSpan(secondaryHeaderCol - 1);
        } else {
            Text actualValueText = new Text(this.s_rptMsgBundle.getMessage("10004", false));
            actualValueText.setBold(true);
            secondHeaders[colIndex] = new TableCell(actualValueText, headerColor, null, HtmlConstants.HorizontalAlignment.center);
            secondHeaders[colIndex].setColSpan(2);
            ++colIndex;
            headers[1].setColSpan(secondaryHeaderCol);
        }
        if (!collectionOnly) {
            Text expectedValueHeaderText = new Text(this.s_rptMsgBundle.getMessage("10024", false));
            expectedValueHeaderText.setBold(true);
            secondHeaders[colIndex] = new TableCell(expectedValueHeaderText, headerColor, null, HtmlConstants.HorizontalAlignment.center);
            secondHeaders[colIndex++].setWidth(20);
            Text statusText = new Text(this.s_rptMsgBundle.getMessage("10056", false));
            statusText.setBold(true);
            secondHeaders[colIndex] = new TableCell(statusText, headerColor, null, HtmlConstants.HorizontalAlignment.center);
            secondHeaders[colIndex++].setWidth(15);
        }
        table.setHeaders(headers);
        htmlPage.addTableHeaderToHtmlBody(table, HtmlConstants.HorizontalAlignment.center);
        htmlPage.addTableRowToHtmlBody(secondHeaders);
    }

    private HtmlConstants.Colors getVerificationColor(String collectionStatus) {
        HtmlConstants.Colors verificationColor = HtmlConstants.Colors.Green;
        verificationColor = VerificationUtil.isStringGood(collectionStatus) && collectionStatus.toLowerCase().contains("success") ? HtmlConstants.Colors.Green : (VerificationUtil.isStringGood(collectionStatus) && collectionStatus.toLowerCase().contains("warning") ? HtmlConstants.Colors.Darkorange : (VerificationUtil.isStringGood(collectionStatus) && collectionStatus.toLowerCase().contains("failed") ? HtmlConstants.Colors.Red : HtmlConstants.Colors.OrangeRed));
        return verificationColor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HtmlPage createHtmlPageForMultipleBaseLines(String targetName, String targetKey, ReportUtilConstants.TargetType targetType, boolean showFailuresOnly, String author, HtmlConstants.Colors backGroundColor, boolean clusterWideCollection, String htmlFramePath) throws ReportToolException, XmlReportToolException {
        HtmlInlinePopupContainerPage htmlPage;
        BufferedWriter htmlPageWriter = null;
        try {
            htmlPageWriter = new BufferedWriter(new FileWriter(htmlFramePath));
            htmlPage = new HtmlInlinePopupContainerPage(targetName, author, HtmlConstants.Colors.Gainsboro, true, htmlPageWriter);
        }
        catch (FileNotFoundException e) {
            throw new ReportToolException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ReportToolException(e.getMessage(), e);
        }
        int numberOfColumnHeaders = (clusterWideCollection ? 1 : 2) + this.m_reportList.size();
        String notApplicable = this.s_rptMsgBundle.getMessage("10026", false);
        String notAvailable = this.s_rptMsgBundle.getMessage("10027", false);
        Text targetDefination = new Text(targetName);
        targetDefination.setFontSize(5);
        targetDefination.setBold(true);
        targetDefination.setTextColor(HtmlConstants.Colors.DarkGreen);
        HtmlConstants.Colors headerColor = HtmlConstants.Colors.LightSteelBlue;
        String captionStr = VerificationConstants.LINE_SEPARATOR + VerificationConstants.LINE_SEPARATOR + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + targetDefination.toHtmlString() + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;";
        Text caption = new Text(captionStr);
        int reportHeaderColumndWidth = Math.round(80 / this.m_reportList.size());
        int nameColumnWidth = (int)Math.round((double)reportHeaderColumndWidth * 0.3);
        int valueColumnWidth = (int)Math.round((double)reportHeaderColumndWidth * 0.7);
        Table table = new Table(0);
        table.setBackGroundColor(HtmlConstants.Colors.Black);
        table.setBorderColor(HtmlConstants.Colors.DarkGoldenRod);
        table.setTableBorderWidth(1);
        table.setCaption(caption);
        table.setWidth(99);
        this.createMutipleBaselineTableColumnHeader(htmlPage, table, targetType, clusterWideCollection, numberOfColumnHeaders, headerColor, reportHeaderColumndWidth, nameColumnWidth, valueColumnWidth);
        HashMap<CVXMLReportReader, HashMap<String, List<CollectionElement>>> baselineMap = this.getBaselines(this.m_reportList, targetKey, clusterWideCollection, false);
        LinkedHashSet<String> mismatchErrorCollectionName = new LinkedHashSet<String>();
        LinkedHashSet<String> mismatchWarningCollectionName = new LinkedHashSet<String>();
        LinkedHashSet<String> matchCollectionName = new LinkedHashSet<String>();
        this.getSortedCollectionNames(baselineMap, mismatchErrorCollectionName, mismatchWarningCollectionName, matchCollectionName, clusterWideCollection);
        ArrayList<String> collectionNames = new ArrayList<String>();
        collectionNames.addAll(mismatchErrorCollectionName);
        collectionNames.addAll(mismatchWarningCollectionName);
        if (!showFailuresOnly) {
            collectionNames.addAll(matchCollectionName);
        }
        if (collectionNames.size() > 0) {
            String msg = s_prvgMsgBundle.getMessage("11616", false, (Object[])new String[]{targetName});
            if (!"TRUE".equalsIgnoreCase(CVUVariables.getValue(CVUVariableConstants.BASELINE_PRINT_MISMATCH))) {
                ReportUtil.quietprintln(msg);
            }
        }
        boolean atleastOneRowAdded = false;
        for (String collectionName : collectionNames) {
            HashMap<CVXMLReportReader, HashMap<String, CollectionElement>> nodeWiseCollectionElements = this.getNodeWiseCollectionElements(collectionName, baselineMap, clusterWideCollection);
            ArrayList<TableCell[]> collectionRows = new ArrayList<TableCell[]>();
            HtmlConstants.Colors rowColor = HtmlConstants.Colors.LightGrey;
            String str = null;
            LinkedHashSet<String> nodes = new LinkedHashSet<String>();
            for (CVXMLReportReader baselineReader : this.m_reportList) {
                HashMap<String, CollectionElement> nodeCollectionMap = nodeWiseCollectionElements.get(baselineReader);
                if (nodeCollectionMap == null || nodeCollectionMap.size() <= 0) continue;
                nodes.addAll(nodeCollectionMap.keySet());
            }
            int rowIndex = -1;
            TableCell collectionNameTableCell = null;
            String collectionDescString = null;
            Text collectionNameText = new Text(collectionName);
            for (String node : nodes) {
                Text collectionNodeText = new Text(node);
                LinkedHashMap<String, String> referenceValueHM = new LinkedHashMap<String, String>();
                HashMap collectionNameValueByBaselineHM = new HashMap();
                for (CVXMLReportReader baselineReader : this.m_reportList) {
                    CollectionElement collectionElement = null;
                    HashMap<String, String> collectionHM = new HashMap<String, String>();
                    if (nodeWiseCollectionElements.get(baselineReader) != null) {
                        collectionElement = nodeWiseCollectionElements.get(baselineReader).get(node);
                        nodeWiseCollectionElements.get(baselineReader).remove(node);
                    }
                    if (collectionElement != null) {
                        str = collectionElement.getDescription();
                        if (VerificationUtil.isStringGood(str)) {
                            collectionDescString = str;
                        }
                        if (collectionElement.getChildrens().size() > 0) {
                            for (CollectionElement childElement : collectionElement.getChildrens()) {
                                collectionHM.put(childElement.getName(), String.valueOf(childElement.getValue()));
                                if (referenceValueHM.containsKey(childElement.getName())) continue;
                                referenceValueHM.put(childElement.getName(), String.valueOf(childElement.getValue()));
                            }
                        } else if (collectionElement.getValue() != null) {
                            collectionHM.put(collectionElement.getName(), String.valueOf(collectionElement.getValue()));
                            if (!referenceValueHM.containsKey(collectionElement.getName())) {
                                referenceValueHM.put(collectionElement.getName(), String.valueOf(collectionElement.getValue()));
                            }
                        }
                    }
                    collectionNameValueByBaselineHM.put(baselineReader, collectionHM);
                }
                TableCell collectionNodeTableCell = null;
                int attributeIndex = -1;
                int colStartIndex = 0;
                for (String referenceAttributeName : ((HashMap)referenceValueHM).keySet()) {
                    TableCell[] row = null;
                    ++rowIndex;
                    ++attributeIndex;
                    ArrayList<Text> actualValueTextList = new ArrayList<Text>();
                    boolean mismatchErrorFound = false;
                    boolean mismatchWarningFound = false;
                    for (CVXMLReportReader baselineReader : this.m_reportList) {
                        boolean displayNameValuePair;
                        HashMap collectionHM = (HashMap)collectionNameValueByBaselineHM.get(baselineReader);
                        HtmlConstants.Colors collectionRowColor = null;
                        collectionRowColor = HtmlConstants.Colors.LightGrey;
                        if (collectionNameTableCell == null) {
                            collectionNameTableCell = new TableCell(collectionNameText, rowColor, HtmlConstants.VeriticalAlignment.top, null);
                            collectionNameTableCell.setWidth(20);
                        }
                        if (collectionNodeTableCell == null) {
                            collectionNodeTableCell = new TableCell(collectionNodeText, rowColor, HtmlConstants.VeriticalAlignment.top, null);
                            collectionNodeTableCell.setRowSpan(((HashMap)referenceValueHM).keySet().size());
                            collectionNodeTableCell.setWidth(10);
                        }
                        Text actualValTxt = new Text("");
                        actualValueTextList.add(actualValTxt);
                        String valTxt = (String)collectionHM.get(referenceAttributeName);
                        String refTxt = (String)((HashMap)referenceValueHM).get(referenceAttributeName);
                        if (valTxt != null && !valTxt.equalsIgnoreCase("null")) {
                            actualValTxt.setTextData(valTxt);
                        }
                        if (!refTxt.equals(valTxt)) {
                            if (this.isWithinDelta(refTxt, valTxt)) {
                                mismatchWarningFound = true;
                            } else {
                                mismatchErrorFound = true;
                            }
                        }
                        boolean bl = displayNameValuePair = !referenceAttributeName.equals(collectionName);
                        if (row == null) {
                            int colCount = 0;
                            if (rowIndex == 0) {
                                colCount = displayNameValuePair ? (clusterWideCollection ? 1 : 2) + this.m_reportList.size() * 2 : (clusterWideCollection ? 1 : 2) + this.m_reportList.size();
                                colStartIndex = clusterWideCollection ? 1 : 2;
                            } else {
                                colCount = displayNameValuePair ? (clusterWideCollection ? 0 : 1) + this.m_reportList.size() * 2 : (clusterWideCollection ? 0 : 1) + this.m_reportList.size();
                                if (attributeIndex == 0) {
                                    colStartIndex = clusterWideCollection ? 0 : 1;
                                } else {
                                    colCount -= clusterWideCollection ? 0 : 1;
                                    colStartIndex = 0;
                                }
                            }
                            row = new TableCell[colCount];
                        }
                        if (rowIndex == 0) {
                            row[0] = collectionNameTableCell;
                            if (!clusterWideCollection) {
                                row[1] = collectionNodeTableCell;
                            }
                        } else if (attributeIndex == 0 && !clusterWideCollection) {
                            row[0] = collectionNodeTableCell;
                        }
                        if (displayNameValuePair) {
                            row[colStartIndex] = new TableCell(new Text(referenceAttributeName), collectionRowColor, HtmlConstants.VeriticalAlignment.top, null);
                            row[colStartIndex].setWidth(nameColumnWidth);
                            row[colStartIndex + 1] = new TableCell(actualValTxt, collectionRowColor, HtmlConstants.VeriticalAlignment.top, null);
                            row[colStartIndex + 1].setWidth(valueColumnWidth);
                            colStartIndex += 2;
                            continue;
                        }
                        row[colStartIndex] = new TableCell(actualValTxt, collectionRowColor, HtmlConstants.VeriticalAlignment.top, null);
                        row[colStartIndex].setWidth(nameColumnWidth + valueColumnWidth);
                        row[colStartIndex].setColSpan(2);
                        ++colStartIndex;
                    }
                    HtmlConstants.Colors actualValueColor = null;
                    if (mismatchErrorFound) {
                        actualValueColor = HtmlConstants.Colors.Red;
                    } else if (mismatchWarningFound) {
                        actualValueColor = HtmlConstants.Colors.Darkorange;
                    }
                    if (actualValueColor != null) {
                        for (Text actualValueTxt : actualValueTextList) {
                            actualValueTxt.setTextColor(actualValueColor);
                        }
                    }
                    collectionRows.add(row);
                    atleastOneRowAdded = true;
                }
            }
            if (collectionNameTableCell != null) {
                collectionNameTableCell.setRowSpan(rowIndex + 1);
            }
            if (VerificationUtil.isStringGood(collectionDescString)) {
                HtmlPopupPage popUpPage = this.createCollectionDescPopupPage("", collectionDescString, htmlPage.getBackgroundColor());
                collectionNameText.setInlinePopUpWindowsLink("#", popUpPage);
                collectionNameText.setTextColor(HtmlConstants.Colors.Black);
            }
            for (TableCell[] row : collectionRows) {
                htmlPage.addTableRowToHtmlBody(row);
            }
        }
        try {
            if (atleastOneRowAdded) {
                htmlPage.addTableClose();
                htmlPage.addHTMLBodyClose();
                htmlPage.addHTMLClose();
            }
            ((Writer)htmlPageWriter).close();
            if (atleastOneRowAdded) return htmlPage;
        }
        catch (IOException e) {
            try {
                throw new XmlReportToolException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                if (atleastOneRowAdded) throw throwable;
                Trace.out((int)5, (String)"No rows added for Target %s, the html page for the target will be deleted", (Object[])new Object[]{targetName});
                new File(htmlFramePath).delete();
                htmlPage = null;
                throw throwable;
            }
        }
        Trace.out((int)5, (String)"No rows added for Target %s, the html page for the target will be deleted", (Object[])new Object[]{targetName});
        new File(htmlFramePath).delete();
        return null;
    }

    private void createMutipleBaselineTableColumnHeader(HtmlPage htmlPage, Table table, ReportUtilConstants.TargetType targetType, boolean clusterWideCollection, int numberOfColumnHeaders, HtmlConstants.Colors headerColor, int reportHeaderColumndWidth, int nameColumnWidth, int valueColumnWidth) throws HtmlReportToolException {
        TableCell[] headers = new TableCell[numberOfColumnHeaders];
        String firstColumnHeader = this.s_rptMsgBundle.getMessage("10003", false);
        if (ReportUtilConstants.TargetType.OCR_CHECKS.equals((Object)targetType) && clusterWideCollection) {
            firstColumnHeader = s_prvgMsgBundle.getMessage("13151", false);
        } else if (ReportUtilConstants.TargetType.CRS_SOFTWARE_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.DB_SOFTWARE_CHECKS.equals((Object)targetType)) {
            firstColumnHeader = s_prvgMsgBundle.getMessage("13152", false);
        } else if (ReportUtilConstants.TargetType.OHASD_MODEL_BASED_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.CRS_MODEL_BASED_CHECKS.equals((Object)targetType)) {
            firstColumnHeader = s_prvgMsgBundle.getMessage("13153", false);
        } else if (ReportUtilConstants.TargetType.OHASD_MODEL_BASED_CHECKS.equals((Object)targetType)) {
            firstColumnHeader = s_prvgMsgBundle.getMessage("13154", false);
        }
        headers[0] = new TableCell(new Text(""), headerColor, null, null);
        headers[0].setWidth(20);
        String idTextStr = null;
        idTextStr = targetType.name().contains("DATABASE") ? this.s_rptMsgBundle.getMessage("10022", false) : (ReportUtilConstants.TargetType.ASM_CHECKS.equals((Object)targetType) ? s_prvgMsgBundle.getMessage("10486", false) : (ReportUtilConstants.TargetType.ASM_INIT_PARAM_BASED_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.ASM_DISK_GROUP_CONFIGURATION_COLLECTION.equals((Object)targetType) ? s_prvgMsgBundle.getMessage("10485", false) : this.s_rptMsgBundle.getMessage("10052", false)));
        Text idText = new Text(idTextStr);
        idText.setBold(true);
        if (!clusterWideCollection) {
            headers[1] = new TableCell(new Text(""), headerColor, null, HtmlConstants.HorizontalAlignment.center);
            headers[1].setWidth(10);
        }
        int headerStartIndex = clusterWideCollection ? 1 : 2;
        int i = -1;
        for (CVXMLReportReader reportReader : this.m_reportList) {
            ++i;
            Text actualValueText = new Text(this.s_rptMsgBundle.getMessage("10004", false));
            actualValueText.setBold(true);
            try {
                headers[headerStartIndex + i] = new TableCell(new Text(this.getReportDisplayKey(reportReader)), headerColor, null, null);
            }
            catch (XmlReportToolException e) {
                throw new HtmlReportToolException(e.getMessage(), e);
            }
            headers[headerStartIndex + i].setWidth(reportHeaderColumndWidth);
            headers[headerStartIndex + i].setColSpan(2);
        }
        table.setHeaders(headers);
        int numberOfColumns = 0;
        numberOfColumns = ReportUtilConstants.TargetType.OCR_CHECKS.equals((Object)targetType) && clusterWideCollection || ReportUtilConstants.TargetType.CRS_SOFTWARE_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.DB_SOFTWARE_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.GPNP_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.CRS_MODEL_BASED_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.OHASD_MODEL_BASED_CHECKS.equals((Object)targetType) ? (clusterWideCollection ? 1 : 2) + this.m_reportList.size() * 2 : (clusterWideCollection ? 1 : 2) + this.m_reportList.size();
        TableCell[] secondHeaders = new TableCell[numberOfColumns];
        Text firstColumnHeaderTxt = new Text(firstColumnHeader);
        firstColumnHeaderTxt.setBold(true);
        secondHeaders[0] = new TableCell(firstColumnHeaderTxt, headerColor, null, null);
        int colStartIndex = 1;
        if (!clusterWideCollection) {
            secondHeaders[1] = new TableCell(idText, headerColor, null, null);
            ++colStartIndex;
        }
        i = -1;
        for (CVXMLReportReader reportReader : this.m_reportList) {
            Text attributeNameText;
            ++i;
            if (ReportUtilConstants.TargetType.OCR_CHECKS.equals((Object)targetType) && clusterWideCollection) {
                attributeNameText = new Text("Key Attribute");
                attributeNameText.setBold(true);
                secondHeaders[colStartIndex] = new TableCell(attributeNameText, headerColor, null, HtmlConstants.HorizontalAlignment.center);
                secondHeaders[colStartIndex++].setWidth(nameColumnWidth);
            } else if (ReportUtilConstants.TargetType.CRS_SOFTWARE_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.DB_SOFTWARE_CHECKS.equals((Object)targetType)) {
                attributeNameText = new Text("File Attribute");
                attributeNameText.setBold(true);
                secondHeaders[colStartIndex] = new TableCell(attributeNameText, headerColor, null, HtmlConstants.HorizontalAlignment.center);
                secondHeaders[colStartIndex++].setWidth(nameColumnWidth);
            } else if (ReportUtilConstants.TargetType.CRS_MODEL_BASED_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.OHASD_MODEL_BASED_CHECKS.equals((Object)targetType)) {
                attributeNameText = new Text("Attribute");
                attributeNameText.setBold(true);
                secondHeaders[colStartIndex] = new TableCell(attributeNameText, headerColor, null, HtmlConstants.HorizontalAlignment.center);
                secondHeaders[colStartIndex++].setWidth(nameColumnWidth);
            } else if (ReportUtilConstants.TargetType.GPNP_CHECKS.equals((Object)targetType)) {
                attributeNameText = new Text("Attribute");
                attributeNameText.setBold(true);
                secondHeaders[colStartIndex] = new TableCell(attributeNameText, headerColor, null, HtmlConstants.HorizontalAlignment.center);
                secondHeaders[colStartIndex++].setWidth(nameColumnWidth);
            }
            Text actualValueText = new Text(this.s_rptMsgBundle.getMessage("10004", false));
            actualValueText.setBold(true);
            secondHeaders[colStartIndex] = new TableCell(actualValueText, headerColor, null, HtmlConstants.HorizontalAlignment.center);
            if (!(ReportUtilConstants.TargetType.OCR_CHECKS.equals((Object)targetType) && clusterWideCollection || ReportUtilConstants.TargetType.CRS_SOFTWARE_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.DB_SOFTWARE_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.GPNP_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.CRS_MODEL_BASED_CHECKS.equals((Object)targetType) || ReportUtilConstants.TargetType.OHASD_MODEL_BASED_CHECKS.equals((Object)targetType))) {
                secondHeaders[colStartIndex].setColSpan(2);
            }
            secondHeaders[colStartIndex++].setWidth(valueColumnWidth);
        }
        htmlPage.addTableHeaderToHtmlBody(table, HtmlConstants.HorizontalAlignment.center);
        htmlPage.addTableRowToHtmlBody(secondHeaders);
    }

    private HashMap<CVXMLReportReader, HashMap<String, List<CollectionElement>>> getBaselines(Set<CVXMLReportReader> reportList, String targetKey, boolean clusterWideCollection, boolean showFailuresOnly) throws XmlReportToolException {
        HashMap<CVXMLReportReader, HashMap<String, List<CollectionElement>>> baselineHM = new HashMap<CVXMLReportReader, HashMap<String, List<CollectionElement>>>();
        for (CVXMLReportReader reportReader : reportList) {
            HashMap<String, List<CollectionElement>> collectionHM = this.getCollectionSet(targetKey, reportReader, clusterWideCollection, showFailuresOnly);
            baselineHM.put(reportReader, collectionHM);
        }
        return baselineHM;
    }

    private HashMap<CVXMLReportReader, HashMap<String, CollectionElement>> getNodeWiseCollectionElements(String collectionName, HashMap<CVXMLReportReader, HashMap<String, List<CollectionElement>>> baselineList, boolean clusterWideCollection) {
        LinkedHashMap<CVXMLReportReader, HashMap<String, CollectionElement>> nodeWiseCollectionList = new LinkedHashMap<CVXMLReportReader, HashMap<String, CollectionElement>>();
        for (CVXMLReportReader baselineReader : baselineList.keySet()) {
            HashMap<String, List<CollectionElement>> collectionHash = baselineList.get(baselineReader);
            List<CollectionElement> nodeCollectionElementList = collectionHash.get(collectionName);
            if (nodeCollectionElementList == null || nodeCollectionElementList.size() == 0) continue;
            HashMap<String, CollectionElement> nodeWiseCollection = new HashMap<String, CollectionElement>();
            for (CollectionElement elem : nodeCollectionElementList) {
                if (clusterWideCollection) {
                    nodeWiseCollection.put("CLUSTER", elem);
                    continue;
                }
                nodeWiseCollection.put(elem.getNode(), elem);
            }
            nodeWiseCollectionList.put(baselineReader, nodeWiseCollection);
        }
        return nodeWiseCollectionList;
    }

    private void getSortedCollectionNames(HashMap<CVXMLReportReader, HashMap<String, List<CollectionElement>>> baselineMap, Set<String> mismatchErrorCollectionName, Set<String> mismatchWarningCollectionName, Set<String> matchCollectionName, boolean clusterWideCollection) {
        LinkedHashSet<String> collectionNames = new LinkedHashSet<String>();
        for (CVXMLReportReader baselineReader : baselineMap.keySet()) {
            HashMap<String, List<CollectionElement>> collectionMap = baselineMap.get(baselineReader);
            collectionNames.addAll(collectionMap.keySet());
        }
        for (String collectionName : collectionNames) {
            HashMap<CVXMLReportReader, HashMap<String, CollectionElement>> nodeWiseCollectionElements = this.getNodeWiseCollectionElements(collectionName, baselineMap, clusterWideCollection);
            LinkedHashSet<String> nodes = new LinkedHashSet<String>();
            for (CVXMLReportReader baselineReader : nodeWiseCollectionElements.keySet()) {
                HashMap<String, CollectionElement> collectionMap = nodeWiseCollectionElements.get(baselineReader);
                nodes.addAll(collectionMap.keySet());
            }
            boolean mismatchErrorFound = false;
            boolean mismatchWarningFound = false;
            boolean skipCollection = false;
            block3: for (String node : nodes) {
                HashMap<String, String> referenceValue = new HashMap<String, String>();
                boolean referenceValueSet = false;
                for (CVXMLReportReader baselineReader : baselineMap.keySet()) {
                    HashMap<String, CollectionElement> collectionMap = nodeWiseCollectionElements.get(baselineReader);
                    if (collectionMap == null) {
                        mismatchErrorFound = true;
                        break block3;
                    }
                    CollectionElement collectionElement = collectionMap.get(node);
                    if (!referenceValueSet) {
                        referenceValueSet = true;
                        if (collectionElement != null) {
                            if (collectionElement.getChildrens().size() > 0) {
                                for (CollectionElement childElement : collectionElement.getChildrens()) {
                                    referenceValue.put(childElement.getName(), String.valueOf(childElement.getValue()));
                                }
                            } else if (collectionElement.getValue() != null) {
                                referenceValue.put(collectionName, String.valueOf(collectionElement.getValue()));
                            }
                        }
                    } else if (collectionElement == null || collectionElement.getValue() == null && collectionElement.getChildrens().size() == 0) {
                        mismatchErrorFound = true;
                    } else {
                        HashMap<String, String> currentValue = new HashMap<String, String>();
                        if (collectionElement.getChildrens().size() > 0) {
                            for (CollectionElement childElement : collectionElement.getChildrens()) {
                                currentValue.put(childElement.getName(), String.valueOf(childElement.getValue()));
                            }
                        } else if (collectionElement.getValue() != null) {
                            currentValue.put(collectionName, String.valueOf(collectionElement.getValue()));
                        }
                        int analysisResult = this.analyzeValues(currentValue, referenceValue);
                        mismatchErrorFound = mismatchErrorFound || analysisResult == 3;
                        boolean bl = mismatchWarningFound = mismatchWarningFound || analysisResult == 4;
                    }
                    if (!mismatchErrorFound) continue;
                    break block3;
                }
            }
            if (skipCollection) continue;
            if (mismatchErrorFound) {
                mismatchErrorCollectionName.add(collectionName);
                this.m_mismatches.add(collectionName);
                continue;
            }
            if (mismatchWarningFound) {
                mismatchWarningCollectionName.add(collectionName);
                continue;
            }
            matchCollectionName.add(collectionName);
        }
    }

    private int analyzeValues(HashMap<String, String> currentValueHM, HashMap<String, String> referenceValueHM) {
        int retValue = 1;
        HashSet<String> keySet = new HashSet<String>();
        keySet.addAll(currentValueHM.keySet());
        keySet.addAll(referenceValueHM.keySet());
        for (String key : referenceValueHM.keySet()) {
            String currentValue = currentValueHM.get(key);
            String referenceValue = referenceValueHM.get(key);
            if (referenceValue == currentValue) continue;
            if (referenceValue == null || currentValue == null) {
                retValue = 3;
                break;
            }
            if (referenceValue.equals(currentValue)) continue;
            if (this.isWithinDelta(referenceValue, currentValue)) {
                retValue = 4;
                break;
            }
            retValue = 3;
            break;
        }
        return retValue;
    }

    private boolean isWithinDelta(String referenceValue, String string) {
        if (referenceValue == null || string == null) {
            return false;
        }
        Double referenceValueDouble = this.getNumPart(referenceValue);
        Double actualValueDouble = this.getNumPart(string);
        double differencePercentage = Math.abs(actualValueDouble - referenceValueDouble) / referenceValueDouble * 100.0;
        return differencePercentage <= (double)this.m_delta;
    }

    private Double getNumPart(String string) {
        Pattern fractionalPattern = Pattern.compile("([\\d]+)\\.([\\d]+)(.*)");
        Matcher m = fractionalPattern.matcher(string);
        if (m.matches()) {
            return Double.parseDouble(m.group(1) + "." + m.group(2));
        }
        Pattern wholeNumberPattern = Pattern.compile("([\\d]+)(.*)");
        m = wholeNumberPattern.matcher(string);
        if (m.matches()) {
            return Double.parseDouble(m.group(1));
        }
        return 0.0;
    }

    private HtmlPopupPage createCollectionDescPopupPage(String heading, String paraGraph, HtmlConstants.Colors backgroundColor) throws ReportToolException {
        HtmlPopupPage popUpPage = null;
        popUpPage = new HtmlPopupPage(heading, null, backgroundColor, false, true);
        if (VerificationUtil.isStringGood(heading)) {
            Text headingTxt = new Text(heading);
            popUpPage.addHeadingToHtmlBody(headingTxt, 3, null);
        }
        if (VerificationUtil.isStringGood(paraGraph)) {
            Text paraGraphTxt = new Text(paraGraph);
            popUpPage.addParagraphToHtmlBody(paraGraphTxt, null);
        }
        return popUpPage;
    }

    private HtmlPopupPage createCollectionErrorPopupPage(String heading, List<ErrorDescription> errorList, HtmlConstants.Colors backgroundColor) throws ReportToolException {
        HtmlPopupPage popUpPage = null;
        popUpPage = new HtmlPopupPage(heading, null, backgroundColor, false, true);
        if (VerificationUtil.isStringGood(heading)) {
            Text headingTxt = new Text(heading);
            popUpPage.addHeadingToHtmlBody(headingTxt, 3, null);
        }
        for (ErrorDescription error : errorList) {
            Text paraGraphTxt = new Text(error.getErrorMessage());
            popUpPage.addParagraphToHtmlBody(paraGraphTxt, null);
        }
        return popUpPage;
    }

    public List<String> getMismatchesFound() {
        return this.m_mismatches;
    }

    private class TargetDetails {
        private ReportUtilConstants.TargetType m_type;
        private String m_targetText;
        private boolean m_collectionOnly;

        private TargetDetails(ReportUtilConstants.TargetType type, String targetText, boolean collectionOnly) {
            this.m_type = type;
            this.m_targetText = targetText;
            this.m_collectionOnly = collectionOnly;
        }

        ReportUtilConstants.TargetType getTargetType() {
            return this.m_type;
        }

        String getTargetText() {
            return this.m_targetText;
        }

        boolean isCollectionOnly() {
            return this.m_collectionOnly;
        }
    }
}

