/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.report.htmlreport;

import java.util.HashMap;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.report.htmlreport.HtmlBuffer;
import oracle.ops.verification.framework.report.htmlreport.HtmlConstants;
import oracle.ops.verification.framework.report.htmlreport.HtmlPopupPage;
import oracle.ops.verification.framework.report.htmlreport.HtmlReportToolException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class Text
extends HtmlBuffer {
    private boolean m_isBold = false;
    private boolean m_isItalic = false;
    private boolean m_isUnderline = false;
    private boolean m_isCode = false;
    private HtmlConstants.Colors m_color = null;
    private HtmlConstants.Fonts m_font = null;
    private int m_size = 0;
    private String m_data = null;
    private String m_link = null;
    private String m_referenceName = null;
    private String m_mouseOverdescr = null;
    private String m_target = "_blank";
    private HtmlPopupPage m_popWindowPage = null;
    private HtmlPopupPage m_inlinePopWindowPage = null;
    private MessageBundle s_rptMsgBundle = VerificationUtil.getMessageBundle("Prve");

    public Text(String data) throws HtmlReportToolException {
        super(false);
        if (data == null) {
            throw new HtmlReportToolException(this.s_rptMsgBundle.getMessage("10051", false, (Object[])new String[]{"data"}));
        }
        this.m_data = data.replaceAll(VerificationConstants.LINE_SEPARATOR, "<br />");
    }

    public void setBookMarkName(String name) {
        this.m_referenceName = name;
    }

    public boolean isBookMarked() {
        return this.m_referenceName != null;
    }

    public String getBookMarkName() {
        return this.m_referenceName;
    }

    public void setTextColor(HtmlConstants.Colors color) {
        this.m_color = color;
    }

    public void setTextData(String data) {
        this.m_data = data;
    }

    public void setReferencelink(String link) {
        this.m_link = link;
    }

    public void setTarget(String target) {
        this.m_target = target;
    }

    public void setFontType(HtmlConstants.Fonts font) {
        this.m_font = font;
    }

    public void setBold(boolean bold) {
        this.m_isBold = bold;
    }

    public void setItalic(boolean italic) {
        this.m_isItalic = italic;
    }

    public void setUnderline(boolean underline) {
        this.m_isUnderline = underline;
    }

    public void setIsCode(boolean code) {
        this.m_isCode = code;
    }

    public void setFontSize(int size) {
        this.m_size = size;
    }

    public void setPopUpWindowsLink(String linkName, HtmlPopupPage page) throws HtmlReportToolException {
        if (VerificationUtil.isStringGood(linkName) && page != null) {
            this.m_link = linkName;
            this.m_popWindowPage = page;
        }
    }

    public void setInlinePopUpWindowsLink(String linkName, HtmlPopupPage page) {
        if (VerificationUtil.isStringGood(linkName) && page != null) {
            this.m_link = linkName;
            this.m_inlinePopWindowPage = page;
        }
    }

    public void setMouseOverDescription(String desc) {
        this.m_mouseOverdescr = desc;
    }

    public HtmlConstants.Colors getTextColor() {
        return this.m_color;
    }

    public String getReferenceLink() {
        return this.m_link;
    }

    public String getTarget() {
        return this.m_target;
    }

    public String getMouseOverDescription() {
        return this.m_mouseOverdescr;
    }

    public String getTextData() {
        return this.m_data;
    }

    public HtmlConstants.Fonts getFontType() {
        return this.m_font;
    }

    public int getFontSize() {
        return this.m_size;
    }

    public boolean isBold() {
        return this.m_isBold;
    }

    public boolean isItalic() {
        return this.m_isItalic;
    }

    public boolean isUnderline() {
        return this.m_isUnderline;
    }

    public boolean isCode() {
        return this.m_isCode;
    }

    public boolean isTextLinked() {
        return this.m_link != null;
    }

    public boolean hasMouseOverDescription() {
        return this.m_mouseOverdescr != null;
    }

    public String toHtmlString() throws HtmlReportToolException {
        this.finalizeText();
        return this.toString();
    }

    public StringBuffer toHtmlStringBuffer() throws HtmlReportToolException {
        this.finalizeText();
        return this.toStringBuffer();
    }

    private void finalizeText() throws HtmlReportToolException {
        boolean isFontConfigured = false;
        if (this.isBookMarked()) {
            HashMap<String, String> attributeMap = new HashMap<String, String>();
            attributeMap.put("name", this.getBookMarkName());
            this.begin("a", attributeMap);
            this.close("a");
        }
        if (this.isTextLinked() || this.hasMouseOverDescription()) {
            this.addLink();
        }
        if (this.isBold()) {
            this.begin("b");
        }
        if (this.isItalic()) {
            this.begin("i");
        }
        if (this.isUnderline()) {
            this.begin("u");
        }
        if (this.isCode()) {
            this.begin("code");
        }
        HashMap<String, String> fontAttributeMap = new HashMap<String, String>();
        if (this.getFontType() != null) {
            fontAttributeMap.put("face", this.getFontType().getID());
        }
        if (this.getFontSize() != 0) {
            fontAttributeMap.put("size", Integer.toString(this.getFontSize()));
        }
        if (this.getTextColor() != null) {
            fontAttributeMap.put("color", this.getTextColor().getID());
        }
        if (this.getTarget() != null) {
            fontAttributeMap.put("target", this.getTarget());
        }
        if (fontAttributeMap.size() > 0) {
            this.begin("font", fontAttributeMap);
            isFontConfigured = true;
        }
        this.append(this.getTextData());
        if (isFontConfigured) {
            this.close("font");
        }
        if (this.isCode()) {
            this.close("code");
        }
        if (this.isUnderline()) {
            this.close("u");
        }
        if (this.isItalic()) {
            this.close("i");
        }
        if (this.isBold()) {
            this.close("b");
        }
        if (this.isTextLinked() || this.hasMouseOverDescription()) {
            this.close("a");
        }
    }

    private void addLink() throws HtmlReportToolException {
        String contents;
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        if (!VerificationUtil.isStringGood(this.m_data)) {
            return;
        }
        if (this.m_link != null) {
            attributeMap.put("href", this.m_link);
            if (!this.m_link.startsWith("#")) {
                attributeMap.put("target", this.m_target);
            }
        }
        if (this.m_popWindowPage != null) {
            contents = this.m_popWindowPage.getHtmlContentsForPopUp();
            this.m_popWindowPage.destroy();
            attributeMap.put("onClick", "window.open('','',scrollbars='yes','height=400,width=500').document.write('" + contents + "');");
            if (this.m_mouseOverdescr != null) {
                attributeMap.put("title", this.m_mouseOverdescr);
            }
        }
        if (this.m_inlinePopWindowPage != null) {
            contents = this.m_inlinePopWindowPage.getHtmlContentsForPopUp();
            this.m_inlinePopWindowPage.destroy();
            attributeMap.put("onClick", "return displayPopup('" + contents + "');");
            attributeMap.put("style", "text-decoration: none;");
            if (this.m_mouseOverdescr != null) {
                attributeMap.put("title", this.m_mouseOverdescr);
            }
        } else if (this.m_mouseOverdescr != null) {
            attributeMap.put("title", this.m_mouseOverdescr);
        }
        if (attributeMap.size() > 0) {
            this.begin("a", attributeMap);
        } else {
            this.begin("a");
        }
    }

    protected void finalize() throws Throwable {
        if (this.m_popWindowPage != null) {
            this.m_popWindowPage.destroy();
        }
        if (this.m_inlinePopWindowPage != null) {
            this.m_inlinePopWindowPage.destroy();
        }
    }
}

