/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.report.htmlreport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.report.ReportData;
import oracle.ops.verification.framework.report.ReportObjRef;
import oracle.ops.verification.framework.report.ReportToolException;
import oracle.ops.verification.framework.report.htmlreport.HtmlBuffer;
import oracle.ops.verification.framework.report.htmlreport.HtmlConstants;
import oracle.ops.verification.framework.report.htmlreport.HtmlReportToolException;
import oracle.ops.verification.framework.util.VerificationUtil;

public abstract class HtmlPageData
extends ReportData
implements HtmlConstants {
    protected HtmlConstants.Colors m_backGroundColor;
    protected boolean m_isIndented;
    protected HtmlBuffer m_htmlBegin;
    protected HtmlBuffer m_htmlClose;
    protected HtmlBuffer m_htmlBodyBegin;
    protected HtmlBuffer m_htmlBodyClose;
    protected HtmlBuffer m_htmlHeadBegin;
    protected HtmlBuffer m_htmlHeadClose;
    protected List<ReportObjRef> m_indexedDataList;
    protected String m_title;
    protected String m_author;
    protected boolean m_useSerialization = true;
    protected Writer m_outWriter = null;

    protected HtmlPageData(String title, String author, HtmlConstants.Colors backGroundColor, boolean indent, Writer writer, boolean addBodyAndHead) throws ReportToolException {
        super(ReportData.ReportTypes.HTML);
        this.m_useSerialization = writer == null;
        this.m_outWriter = writer;
        this.init(title, author, backGroundColor, indent, addBodyAndHead);
    }

    private void init(String title, String author, HtmlConstants.Colors backGroundColor, boolean indent, boolean addBody) throws HtmlReportToolException {
        this.m_title = title;
        this.m_author = author;
        this.m_backGroundColor = backGroundColor;
        this.m_isIndented = indent;
        this.m_indexedDataList = new ArrayList<ReportObjRef>();
        this.m_htmlBegin = HtmlBuffer.createHtmlBegin(this.m_isIndented);
        this.m_htmlClose = HtmlBuffer.createClose(this.m_isIndented, "html");
        this.m_htmlBodyBegin = HtmlBuffer.createHtmlBodyBegin(this.m_isIndented, this.m_backGroundColor);
        this.m_htmlBodyClose = HtmlBuffer.createClose(this.m_isIndented, "body");
        this.m_htmlHeadBegin = HtmlBuffer.createHtmlHeadBegin(this.m_isIndented, author, title);
        this.m_htmlHeadClose = HtmlBuffer.createClose(this.m_isIndented, "head");
        if (!this.m_useSerialization) {
            this.add(this.m_htmlBegin);
            this.add(this.m_htmlHeadBegin);
            this.add(this.m_htmlHeadClose);
            if (addBody) {
                this.add(this.m_htmlBodyBegin);
            }
        }
    }

    public boolean isBackGroundColorSet() {
        return this.m_backGroundColor != null;
    }

    public HtmlConstants.Colors getBackgroundColor() {
        return this.m_backGroundColor;
    }

    protected void add(HtmlBuffer content, HtmlConstants.HtmlDataTypes type, String marker) throws HtmlReportToolException {
        if (this.m_useSerialization) {
            try {
                this.m_indexedDataList.add(this.save(content));
            }
            catch (ReportToolException rte) {
                Trace.out((String)"Caught HtmlReportToolException while adding content to HTML data index");
                throw new HtmlReportToolException(rte.getMessage(), rte);
            }
        }
        try {
            this.m_outWriter.write(content.toString());
        }
        catch (IOException e) {
            throw new HtmlReportToolException(e.getMessage(), e);
        }
    }

    protected void add(HtmlBuffer content) throws HtmlReportToolException {
        this.add(content, HtmlConstants.HtmlDataTypes.NONE, null);
    }

    public String saveToFile(String fullpath) throws HtmlReportToolException {
        String outputFilePath;
        try {
            FileOutputStream stream = new FileOutputStream(fullpath);
            stream.write(this.m_htmlBegin.toString().getBytes());
            stream.write(this.m_htmlHeadBegin.toString().getBytes());
            stream.write(this.m_htmlHeadClose.toString().getBytes());
            stream.write(this.m_htmlBodyBegin.toString().getBytes());
            for (ReportObjRef idxData : this.m_indexedDataList) {
                Object dataObj = this.load(idxData);
                String data = dataObj != null ? dataObj.toString() : null;
                if (!VerificationUtil.isStringGood(data)) continue;
                stream.write(data.getBytes());
            }
            stream.write(this.m_htmlBodyClose.toString().getBytes());
            stream.write(this.m_htmlClose.toString().getBytes());
            stream.close();
            outputFilePath = new File(fullpath).getCanonicalPath();
            this.destroy();
        }
        catch (FileNotFoundException fne) {
            throw new HtmlReportToolException(fne.getMessage());
        }
        catch (IOException ioe) {
            throw new HtmlReportToolException(ioe.getMessage());
        }
        catch (ReportToolException rue) {
            throw new HtmlReportToolException(rue.getMessage(), rue);
        }
        return outputFilePath;
    }

    @Override
    protected void finalize() throws Throwable {
        this.destroy();
    }
}

