/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.report.htmlreport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.ops.verification.framework.report.ReportToolException;
import oracle.ops.verification.framework.report.ReportUtilConstants;
import oracle.ops.verification.framework.report.htmlreport.HtmlBuffer;
import oracle.ops.verification.framework.report.htmlreport.HtmlConstants;
import oracle.ops.verification.framework.report.htmlreport.HtmlInlinePopupContainerPage;
import oracle.ops.verification.framework.report.htmlreport.HtmlPage;
import oracle.ops.verification.framework.report.htmlreport.HtmlReportToolException;
import oracle.ops.verification.framework.report.htmlreport.Text;

public class HtmlFrameContainerPage
extends HtmlPage {
    private List<HtmlPage> m_frameList = new ArrayList<HtmlPage>();
    private static final String MAIN_FRAME = "main";
    private static final String TOC_FRAME = "toc";

    public HtmlFrameContainerPage(String title, String author, HtmlConstants.Colors backGroundColor, boolean indent, Writer writer) throws ReportToolException {
        super(title, author, backGroundColor, indent, writer, false);
    }

    public HtmlFrameContainerPage(String title, String author, HtmlConstants.Colors backGroundColor, boolean indent) throws ReportToolException {
        this(title, author, backGroundColor, indent, null);
    }

    public void addHtmlFrame(HtmlPage htmlPage) {
        this.m_frameList.add(htmlPage);
    }

    public void addHtmlFrameList(List<HashMap<String, String>> tocList, String fullpath) throws HtmlReportToolException {
        if (tocList == null || tocList.size() == 0) {
            throw new HtmlReportToolException(this.s_rptMsgBundle.getMessage("10051", true, (Object[])new String[]{"frameset"}));
        }
        String pathWithoutExt = fullpath.substring(0, fullpath.length() - ".html".length());
        String firstPage = null;
        ArrayList<Text> tocListTextList = new ArrayList<Text>();
        for (HashMap<String, String> frameEntry : tocList) {
            String title = frameEntry.keySet().iterator().next();
            if (firstPage == null) {
                firstPage = new File(frameEntry.get(title)).getAbsolutePath();
            }
            Text targetHead = new Text(title);
            targetHead.setReferencelink(new File(frameEntry.get(title)).getAbsolutePath());
            targetHead.setTarget(MAIN_FRAME);
            targetHead.setTextColor(HtmlConstants.Colors.MediumBlue);
            tocListTextList.add(targetHead);
        }
        this.add(HtmlBuffer.createHtmlFrameSet(this.m_isIndented));
        HtmlPage tocHtmlPage = this.createTOCFrame(tocListTextList);
        tocHtmlPage.saveToFile(pathWithoutExt + "_" + TOC_FRAME + ".html");
        this.add(HtmlBuffer.createHtmlFrame(this.m_isIndented, TOC_FRAME, pathWithoutExt + "_" + TOC_FRAME + ".html"));
        this.add(HtmlBuffer.createClose(this.m_isIndented, "frame"));
        this.add(HtmlBuffer.createHtmlFrame(this.m_isIndented, MAIN_FRAME, firstPage));
        this.add(HtmlBuffer.createClose(this.m_isIndented, "frame"));
        this.add(HtmlBuffer.createClose(this.m_isIndented, "frameset"));
    }

    @Override
    public String saveToFile(String fullpath) throws HtmlReportToolException {
        String outputFilePath;
        String pathWithoutExt = fullpath.substring(0, fullpath.length() - ".html".length());
        try {
            FileOutputStream stream = new FileOutputStream(fullpath);
            stream.write(this.m_htmlBegin.toString().getBytes());
            stream.write(this.m_htmlHeadBegin.toString().getBytes());
            stream.write(this.m_htmlHeadClose.toString().getBytes());
            stream.write(HtmlBuffer.createHtmlFrameSet(this.m_isIndented).toString().getBytes());
            String src = null;
            String framePath = null;
            int count = 1;
            ArrayList<Text> tocListTextList = new ArrayList<Text>();
            for (HtmlPage frame : this.m_frameList) {
                framePath = pathWithoutExt + "_" + count++ + ".html";
                if (src == null) {
                    src = framePath;
                }
                frame.saveToFile(framePath);
                Text targetHead = new Text(frame.m_title);
                targetHead.setReferencelink(new File(framePath).getAbsolutePath());
                targetHead.setTarget(MAIN_FRAME);
                targetHead.setTextColor(HtmlConstants.Colors.MediumBlue);
                tocListTextList.add(targetHead);
            }
            HtmlPage tocHtmlPage = this.createTOCFrame(tocListTextList);
            tocHtmlPage.saveToFile(pathWithoutExt + "_" + TOC_FRAME + ".html");
            stream.write(HtmlBuffer.createHtmlFrame(this.m_isIndented, TOC_FRAME, pathWithoutExt + "_" + TOC_FRAME + ".html").toString().getBytes());
            stream.write(HtmlBuffer.createClose(this.m_isIndented, "frame").toString().getBytes());
            stream.write(HtmlBuffer.createHtmlFrame(this.m_isIndented, MAIN_FRAME, src).toString().getBytes());
            stream.write(HtmlBuffer.createClose(this.m_isIndented, "frame").toString().getBytes());
            stream.write(HtmlBuffer.createClose(this.m_isIndented, "frameset").toString().getBytes());
            stream.write(this.m_htmlClose.toString().getBytes());
            stream.close();
            this.destroy();
            outputFilePath = new File(fullpath).getCanonicalPath();
        }
        catch (FileNotFoundException fne) {
            throw new HtmlReportToolException(fne.getMessage());
        }
        catch (IOException ioe) {
            throw new HtmlReportToolException(ioe.getMessage());
        }
        catch (ReportToolException rue) {
            throw new HtmlReportToolException(rue.getMessage(), rue);
        }
        return outputFilePath;
    }

    private HtmlPage createTOCFrame(List<Text> list) throws HtmlReportToolException {
        HtmlInlinePopupContainerPage htmlPage;
        try {
            htmlPage = new HtmlInlinePopupContainerPage(this.m_title, this.m_author, this.m_backGroundColor, true);
            this.createHTMLHead(ReportUtilConstants.ReportContext.BEST_PRACTICE, htmlPage);
        }
        catch (ReportToolException e) {
            throw new HtmlReportToolException(e.getMessage(), e);
        }
        htmlPage.addListToHtmlBody(list.toArray(new Text[0]), true);
        return htmlPage;
    }

    private void createHTMLHead(ReportUtilConstants.ReportContext context, HtmlPage htmlDoc) throws HtmlReportToolException {
        Text heading = null;
        if (context == ReportUtilConstants.ReportContext.BEST_PRACTICE) {
            heading = new Text(this.m_title);
            heading.setBookMarkName("MAIN");
            htmlDoc.addHeadingToHtmlBody(heading, 3, HtmlConstants.HorizontalAlignment.center);
        }
    }

    @Override
    public void destroy() {
        for (HtmlPage frame : this.m_frameList) {
            frame.destroy();
        }
        this.m_frameList.clear();
        super.destroy();
    }

    @Override
    protected void finalize() throws Throwable {
        this.destroy();
    }
}

