/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.param.parser;

import java.util.List;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.util.ConsoleUtilException;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.param.parser.CLCommand;
import oracle.ops.verification.framework.param.parser.CLSyntaxValidator;
import oracle.ops.verification.framework.param.parser.InvalidCLException;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.RootAutomationUtility;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class RootUserPasswordValidator
extends CLSyntaxValidator {
    @Override
    public void isValid(List<String> clTokens, CLCommand command) throws InvalidCLException {
        String rootAutomationMethodRoot = CVUVariables.getValue(CVUVariableConstants.CONFIG_METHOD_ROOT);
        String pbRunLocPath = CVUVariables.getValue(CVUVariableConstants.SUDO_PBRUN_LOC);
        String rootUserName = CVUVariables.getValue(CVUVariableConstants.SUDO_USER);
        ConfigurationSetup.ConfigMethod configMethod = ConfigurationSetup.ConfigMethod.SUDO;
        if (VerificationUtil.isStringGood(rootAutomationMethodRoot)) {
            configMethod = ConfigurationSetup.ConfigMethod.ROOT;
        }
        try {
            RootAutomationUtility.readUserCredentialsCLI(configMethod, pbRunLocPath, rootUserName);
        }
        catch (VerificationException ve) {
            VerificationLogData.logError("VerificationException:" + ve.getMessage() + Trace.getStackTrace((Throwable)ve));
            Trace.out((String)ve.getMessage());
            Trace.stackTrace((Throwable)ve);
            String errMsg = ve.getMessage();
            throw new InvalidCLException(errMsg);
        }
        catch (ConsoleUtilException ce) {
            VerificationLogData.logError("ConsoleUtilException:" + ce.getMessage() + Trace.getStackTrace((Throwable)ce));
            Trace.stackTrace((Throwable)ce);
            String errMsg = s_gMsgBundle.getMessage("9003", true, (Object[])new String[]{configMethod.name()});
            VerificationLogData.logError(errMsg);
            throw new InvalidCLException(errMsg);
        }
    }
}

