/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.param.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.param.CLSyntax;
import oracle.ops.verification.framework.param.parser.CLCommand;
import oracle.ops.verification.framework.param.parser.CLSyntaxValidator;
import oracle.ops.verification.framework.param.parser.InvalidCLException;
import oracle.ops.verification.framework.util.Assert;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class NodeListValidator
extends CLSyntaxValidator {
    @Override
    public void isValid(List<String> clTokens, CLCommand command) throws InvalidCLException {
        String nodeListStr = command.getValue();
        nodeListStr = this.checkAndRemoveDomainPartInNodeList(nodeListStr);
        ArrayList<String> duplicateNodes = new ArrayList<String>();
        nodeListStr = this.checkAndCorrectDuplicatesInNodeList(nodeListStr, duplicateNodes);
        this.checkAndPrintDuplicateNodeListWarning(duplicateNodes, nodeListStr);
        try {
            if (!CLSyntax.STR_ALL.equals(nodeListStr)) {
                Assert.assertNodes(nodeListStr.split(CLSyntax.DELIMETER));
            }
        }
        catch (VerificationException ve) {
            System.out.println(VerificationConstants.LSEP + s_fMsgBundle.getMessage("8503", false) + VerificationConstants.LSEP + ve.getMessage());
        }
        command.setValue(nodeListStr);
        if (VerificationUtil.isStringGood(command.getSymoblicName())) {
            CVUVariables.setValue(command.getSymoblicName(), nodeListStr);
        }
        if (clTokens.contains(CLSyntax.STR_CRSINST) && clTokens.contains(CLSyntax.STR_RIM) && !clTokens.contains(CLSyntax.STR_DNS_FLAG)) {
            throw new InvalidCLException(s_gMsgBundle.getMessage("1062", true));
        }
    }

    private String checkAndRemoveDomainPartInNodeList(String nodeListStr) {
        if (!VerificationUtil.isStringGood(nodeListStr)) {
            return nodeListStr;
        }
        return VerificationUtil.printWarningAndRemoveDomainNames(nodeListStr.split(CLSyntax.DELIMETER));
    }

    private String checkAndCorrectDuplicatesInNodeList(String nodeListStr, List<String> dupNodeList) {
        HashSet<String> uniqueNodes = new HashSet<String>();
        if (!VerificationUtil.isStringGood(nodeListStr)) {
            return nodeListStr;
        }
        StringBuilder sb = new StringBuilder();
        for (String node : nodeListStr.toLowerCase().split(CLSyntax.DELIMETER)) {
            if (uniqueNodes.add(node)) {
                if (sb.length() != 0) {
                    sb.append(CLSyntax.DELIMETER);
                }
                sb.append(node);
                continue;
            }
            dupNodeList.add(node);
        }
        Trace.out((String)("returning uniquenodes " + sb.toString()));
        return sb.toString();
    }

    private void checkAndPrintDuplicateNodeListWarning(List<String> dupNodeList, String nodeList) {
        if (dupNodeList.size() == 0) {
            return;
        }
        String dupNodes = VerificationUtil.strList2List(dupNodeList);
        Trace.out((String)("Nodes " + dupNodes + " were entered multiple times ignoring the duplicate nodes"));
        System.out.println(VerificationConstants.LSEP + s_fMsgBundle.getMessage("8503", false) + VerificationConstants.LSEP + s_msgBundle.getMessage("1060", false, (Object[])new String[]{dupNodes, nodeList}));
    }
}

