/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.param.parser;

import java.util.List;
import oracle.ops.verification.framework.param.parser.CLCommand;
import oracle.ops.verification.framework.param.parser.CLSyntaxValidator;
import oracle.ops.verification.framework.param.parser.InvalidCLException;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GNSVIPAdressValidator
extends CLSyntaxValidator {
    @Override
    public void isValid(List<String> clTokens, CLCommand command) throws InvalidCLException {
        String optionValue = command.getValue();
        String[] addressArray = optionValue.split("/");
        if (addressArray.length != 3) {
            throw new InvalidCLException(s_msgBundle.getMessage("5203", true, (Object[])new String[]{optionValue, command.getDisplayText()}));
        }
        for (String addrPart : addressArray) {
            if (addrPart.trim().length() != 0) continue;
            throw new InvalidCLException(s_msgBundle.getMessage("5203", true, (Object[])new String[]{optionValue, command.getDisplayText()}));
        }
        if (VerificationUtil.isStringGood(CVUVariables.getValue(CVUVariableConstants.GNS_VIP_FULL_ADDRESS))) {
            CVUVariables.setValue(CVUVariableConstants.CONFIGURE_GNS, "TRUE");
        }
    }
}

