/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.param.parser;

import java.util.List;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.verification.framework.param.parser.CLCommand;
import oracle.ops.verification.framework.param.parser.CLSyntaxValidator;
import oracle.ops.verification.framework.param.parser.InvalidCLException;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class DHCPPortValidator
extends CLSyntaxValidator {
    @Override
    public void isValid(List<String> clTokens, CLCommand command) throws InvalidCLException {
        String dhcpPortStr = CVUVariables.getValue(CVUVariableConstants.DHCP_PORT);
        String configMethod = CVUVariables.getValue(CVUVariableConstants.CONFIG_METHOD);
        int dhcpPort = 67;
        if (VerificationUtil.isStringGood(dhcpPortStr)) {
            try {
                dhcpPort = Integer.parseInt(dhcpPortStr);
            }
            catch (NumberFormatException e) {
                throw new InvalidCLException(s_msgBundle.getMessage("1041", true, (Object[])new String[]{dhcpPortStr}));
            }
        }
        if (new SystemFactory().CreateSystem().isUnixSystem() && dhcpPort < 1024 && !VerificationUtil.isStringGood(configMethod) && !Boolean.getBoolean("CV_ROOTUSERCHECK")) {
            throw new InvalidCLException(s_msgBundle.getMessage("1052", true, (Object[])new String[]{Integer.toString(dhcpPort)}));
        }
    }
}

