/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.param;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.param.VariableFileResolverException;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariableData;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public abstract class VariableFileResolver {
    protected static MessageBundle m_msgBundle = VerificationUtil.getMessageBundle("Prvp");
    protected static String VAR_ELEM_SEP = ",";
    protected static String ELEM_FIELD_SEP = ":";
    protected static String NO_VAL = "NO_VAL";
    protected String NET_NAMSUB_SEP = "/";
    protected String NET_SUBIFTYPE_SEP = ELEM_FIELD_SEP;
    protected String IFTYPE_SEP = "-";
    protected static String CRS_NODEVIPS_SEP = "/";
    protected String INT_FIELD_SEP = ELEM_FIELD_SEP;
    protected String INT_ENTRY_SEP = VAR_ELEM_SEP;
    protected String[] NetworksInterfaceTypes = new String[]{"public", "cluster_interconnect", "", "asm"};
    protected String[] InterconnectInterfaceTypes = new String[]{"PUB", "PVT", "", "ASM"};
    protected Hashtable<String, Set<String>> m_VariablesValidOptions = new Hashtable();
    protected String m_filePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void readVariablesFromFile(List resolvedVar, List unresolvedVar) throws VariableFileResolverException {
        p = new Properties();
        ex /* !! */  = null;
        try {
            br = new BufferedReader(new FileReader(this.m_filePath));
            while ((fileLine = br.readLine()) != null) {
                if (fileLine.trim().startsWith("#")) {
                    Trace.out((String)("Ignoring comment " + fileLine));
                    continue;
                }
                nameVal = fileLine.split("=");
                if (nameVal.length <= 1) continue;
                p.put(nameVal[0].trim(), nameVal[1].trim());
            }
            ** if (ex /* !! */  == null) goto lbl-1000
        }
        catch (FileNotFoundException fex) {
            Trace.out((String)("FileNotFoundException while loading the properties. msg:" + fex.getMessage()));
            ex /* !! */  = fex;
            ** if (ex /* !! */  == null) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                errMsg = VariableFileResolver.m_msgBundle.getMessage("1044", true, (Object[])new String[]{this.m_filePath});
                throw new VariableFileResolverException(errMsg, ex /* !! */ );
            }
lbl-1000:
            // 1 sources

            {
            }
        }
        catch (IOException iex) {
            Trace.out((String)("IOException while loading the properties. msg:" + iex.getMessage()));
            ex /* !! */  = iex;
            ** if (ex /* !! */  == null) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                errMsg = VariableFileResolver.m_msgBundle.getMessage("1044", true, (Object[])new String[]{this.m_filePath});
                throw new VariableFileResolverException(errMsg, ex /* !! */ );
            }
lbl-1000:
            // 1 sources

            {
            }
            {
                catch (Throwable var8_12) {
                    if (ex /* !! */  != null) {
                        errMsg = VariableFileResolver.m_msgBundle.getMessage("1044", true, (Object[])new String[]{this.m_filePath});
                        throw new VariableFileResolverException(errMsg, ex /* !! */ );
                    }
                    throw var8_12;
                }
            }
        }
lbl-1000:
        // 1 sources

        {
            errMsg = VariableFileResolver.m_msgBundle.getMessage("1044", true, (Object[])new String[]{this.m_filePath});
            throw new VariableFileResolverException(errMsg, ex /* !! */ );
        }
lbl-1000:
        // 1 sources

        {
        }
        e = p.propertyNames();
        while (e.hasMoreElements()) {
            varName = (String)e.nextElement();
            varValue = p.getProperty(varName);
            CVUVariables.secureVariableValueTrace("VariableFileResolver reading ...", varName, varValue);
            if (!VerificationUtil.isStringGood(varName)) continue;
            if (varValue == null) {
                Trace.out((String)("Found null value for variable : " + varName));
                continue;
            }
            len = varValue.length();
            if (len > 1 && varValue.charAt(0) == '\'' && varValue.charAt(len - 1) == '\'') {
                varValue = varValue.substring(1, len - 1);
            }
            if (len > 1 && varValue.charAt(0) == '\"' && varValue.charAt(len - 1) == '\"') {
                varValue = varValue.substring(1, len - 1);
            }
            if (!VerificationUtil.isStringGood(varValue)) {
                Trace.out((String)("Variable:" + varName + " does not have any value"));
                if (unresolvedVar == null) continue;
                unresolvedVar.add(varName);
                continue;
            }
            cvuVars = CVUVariables.getCVUVariable(varName);
            if (cvuVars == null) {
                Trace.out((String)("Varriable: " + varName + " does not have associated " + "CVU var"));
                if (unresolvedVar != null) {
                    unresolvedVar.add(varName);
                }
            } else {
                Trace.out((String)("Variable:" + varName + " has and associated CVU var"));
                if (resolvedVar != null) {
                    resolvedVar.add(varName);
                }
            }
            if (varValue.equalsIgnoreCase(VariableFileResolver.NO_VAL)) continue;
            CVUVariables.setValue(varName, varValue);
        }
    }

    public void resolve(String filePath, List resolvedVar, List unresolvedVar) throws VariableFileResolverException {
        this.m_filePath = filePath;
        this.readVariablesFromFile(resolvedVar, unresolvedVar);
        this.initializeValidOptions();
        this.verifyVariableValues();
        this.populateCVUVariables();
    }

    protected abstract void initializeValidOptions();

    protected void reportInvalidVariableValueMessage(String varName, String varValue) throws VariableFileResolverException {
        String errMsg = null;
        errMsg = VerificationUtil.isStringGood(varValue) ? m_msgBundle.getMessage("5104", true, (Object[])new String[]{varValue, varName, this.m_filePath}) : m_msgBundle.getMessage("5105", true, (Object[])new String[]{varName, this.m_filePath});
        throw new VariableFileResolverException(errMsg);
    }

    protected <E extends Enum<E>> void checkValueForVariableIsEnumMember(CVUVariableConstants cvuVar, Class<E> enumClass) throws VariableFileResolverException {
        boolean isMember = false;
        String value = CVUVariables.getValue(cvuVar);
        if (VerificationUtil.isStringGood(value)) {
            String cvuVarInFileName = this.getVariableNameInFileForCVUVariable(cvuVar);
            if (this.m_VariablesValidOptions.containsKey(cvuVarInFileName)) {
                Trace.out((int)1, (String)"Using a defined valid option.");
                isMember = this.m_VariablesValidOptions.get(cvuVarInFileName).contains(value.toUpperCase());
            } else {
                Trace.out((int)1, (String)"Using current release enumerations to validate valid options.");
                isMember = this.isEnumMember(value, enumClass);
            }
            if (!isMember) {
                this.reportInvalidVariableValueMessage(this.getVariableNameInFileForCVUVariable(cvuVar), value);
            }
        }
    }

    protected <E extends Enum<E>> boolean isEnumMember(String value, Class<E> enumClass) {
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            if (!e.name().equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    protected String checkNonEmptyVariable(CVUVariableConstants cvuVar) throws VariableFileResolverException {
        String value = CVUVariables.getValue(cvuVar);
        if (!VerificationUtil.isStringGood(value)) {
            this.reportInvalidVariableValueMessage(this.getVariableNameInFileForCVUVariable(cvuVar), value);
        }
        return value;
    }

    protected String getVariableNameInFileForCVUVariable(CVUVariableConstants varName) {
        String retVal = null;
        CVUVariableData cvuVar = CVUVariables.getCVUVariable(varName.toString());
        List<String> varNames = this.getVariableNamesInFileForCVUVariable(cvuVar);
        if (varNames != null && !varNames.isEmpty()) {
            retVal = varNames.get(0);
        } else {
            Trace.out((String)"No variable name found associated with the given CVU variable name : %s for file %s ", (Object[])new Object[]{varName.toString(), this.m_filePath});
            retVal = varName.toString();
        }
        return retVal;
    }

    protected void setVariableValue(CVUVariableConstants cvuVarName, String cvuVal) {
        CVUVariables.secureVariableValueTrace("Populating variable", cvuVarName.toString(), cvuVal);
        if (VerificationUtil.isStringGood(cvuVal)) {
            CVUVariables.setValue(cvuVarName, cvuVal);
        } else {
            Trace.out((String)"Unable to obtain a valid value for variable : %s", (Object[])new Object[]{cvuVarName});
        }
    }

    protected abstract void verifyVariableValues() throws VariableFileResolverException;

    protected abstract List<String> getVariableNamesInFileForCVUVariable(CVUVariableData var1);

    protected abstract void populateCVUVariables() throws VariableFileResolverException;
}

