/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.param;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.cluster.common.ClusterType;
import oracle.cluster.common.NodeRole;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.param.VariableFileResolver;
import oracle.ops.verification.framework.param.VariableFileResolverException;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariableData;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ResponseConfigResolver
extends VariableFileResolver {
    private static Element m_rootElementTaskDef = null;
    private static Element m_currentReleaseVarDef = null;
    private static String m_releaseForResponseVarsXml = null;
    private static boolean m_isResponseVarsXmlParsed = false;
    public static final String RESPONSEVARS_ROOT_ELEMENT_TAG = "ROOT";
    public static final String RESPONSEVARS_SOFTWARE_ELEMENT_TAG = "SOFTWARE";
    public static final String RESPONSEVARS_VARIABLE_LIST_ELEMENT_TAG = "VARIABLE_LIST";
    public static final String RESPONSEVARS_VARIABLE_ELEMENT_TAG = "VARIABLE";
    public static final String RESPONSEVARS_VERSION_ELEMENT_TAG = "VERSION";
    public static final String RESPONSEVARS_NAME_ATTRIBUTE_TAG = "VALUE";
    public static final String RESPONSEVARS_INSTALL_VAR_VALUE_ELEMENT_TAG = "RESPONSE_VARIABLE";
    public static final String RESPONSEVARS_INSTALL_OPTIONS_ELEMENT_TAG = "VALID_OPTIONS";
    private boolean m_isBigCluster = false;
    private static String AUTOCONFIGVIP_TOKEN = "AUTO";
    private String m_clusterType;
    private String m_gnsOption;
    private String m_storageOption;
    private String m_clusterNodes;
    private String m_configureGNS;
    private String m_autoConfigVipsOption;

    @Override
    protected void populateCVUVariables() throws VariableFileResolverException {
        Trace.out((String)"Method Entry");
        this.m_isBigCluster = this.isEnumMember(this.m_clusterType, RSP_ISBIGCLUSTER_OPTIONS.class);
        this.setVariableValue(CVUVariableConstants.BIGCLUSTER, Boolean.toString(this.m_isBigCluster));
        this.setVariableValue(CVUVariableConstants.HUB_LIST, this.getCommaSeparatedNodesForRole(NodeRole.HUB));
        this.setVariableValue(CVUVariableConstants.RIM_LIST, this.getCommaSeparatedNodesForRole(NodeRole.RIM));
        this.setVariableValue(CVUVariableConstants.NODE_LIST, this.getCommaSeparatedNodesForRole(NodeRole.AUTO));
        if (VerificationUtil.isStringGood(this.m_storageOption)) {
            RSP_STORAGE_OPTIONS foundStorageOption = RSP_STORAGE_OPTIONS.valueOf(this.m_storageOption.toUpperCase());
            String cvuVal = null;
            switch (foundStorageOption) {
                case LOCAL_ASM_STORAGE: {
                    cvuVal = "LOCAL";
                    break;
                }
                case FLEX_ASM_STORAGE: {
                    cvuVal = "FLEX";
                    break;
                }
                case CLIENT_ASM_STORAGE: 
                case FILE_SYSTEM_STORAGE: {
                    cvuVal = "";
                }
            }
            this.setVariableValue(CVUVariableConstants.ASMCONFIG, cvuVal);
        } else {
            Trace.out((String)"There is no value for variable %s in file %s", (Object[])new Object[]{this.getVariableNameInFileForCVUVariable(CVUVariableConstants.RSP_STORAGE_OPT), this.m_filePath});
        }
        this.setVariableValue(CVUVariableConstants.INTERCONNECT_LIST, this.getInterconnectListFromRspFile());
        this.setVariableValue(CVUVariableConstants.NETWORK_LIST, this.getNetworkListFromRspFile());
        if (Boolean.valueOf(this.m_configureGNS).booleanValue()) {
            boolean useSharedGns;
            RSP_GNS_OPTIONS foundGnsOption = RSP_GNS_OPTIONS.valueOf(this.m_gnsOption.toUpperCase());
            boolean bl = useSharedGns = foundGnsOption == RSP_GNS_OPTIONS.USE_SHARED_GNS;
            if (useSharedGns) {
                this.checkNonEmptyVariable(CVUVariableConstants.GNS_CLIENT_DATA_FILE);
            }
            this.setVariableValue(CVUVariableConstants.USE_SHARED_GNS, Boolean.toString(useSharedGns));
        } else {
            Trace.out((String)"There is no value for variable %s in file %s", (Object[])new Object[]{this.getVariableNameInFileForCVUVariable(CVUVariableConstants.CONFIGURE_GNS), this.m_filePath});
        }
        this.setVariableValue(CVUVariableConstants.HOST_VIP_NAMES, this.getHostVipNames());
        String asmDisks = CVUVariables.getValue(CVUVariableConstants.ASM_DISKGROUP_DISKS);
        String asmDiscoveryString = CVUVariables.getValue(CVUVariableConstants.ASM_DISK_DISCOVERY_STRING);
        boolean asmCheckFlag = VerificationUtil.isStringGood(asmDisks) || VerificationUtil.isStringGood(asmDiscoveryString);
        this.setVariableValue(CVUVariableConstants.ASM_DEVICE_CHECKS_FLAG, Boolean.toString(asmCheckFlag));
    }

    private String getInterconnectListFromRspFile() throws VariableFileResolverException {
        return this.internalGetNetworkListFromRspFile(this.InterconnectInterfaceTypes, "-", VAR_ELEM_SEP);
    }

    private String getNetworkListFromRspFile() throws VariableFileResolverException {
        return this.internalGetNetworkListFromRspFile(this.NetworksInterfaceTypes, ",", this.NET_NAMSUB_SEP);
    }

    private String internalGetNetworkListFromRspFile(String[] networkIfTypeIDs, String ifTypeSep, String elementSeparator) throws VariableFileResolverException {
        String retVal = null;
        StringBuilder interconnectList = new StringBuilder();
        boolean invalidFormatFound = false;
        String evaluatingValue = null;
        String networkInterfaceList = CVUVariables.getValue(CVUVariableConstants.RSP_NETWORK_IFLIST);
        String rspVarName = this.getVariableNameInFileForCVUVariable(CVUVariableConstants.RSP_NETWORK_IFLIST);
        if (VerificationUtil.isStringGood(networkInterfaceList)) {
            String[] networkInterfacesInfo;
            String[] stringArray = networkInterfacesInfo = VerificationUtil.string2strArr(networkInterfaceList);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String networkInterfaceInfo;
                evaluatingValue = networkInterfaceInfo = stringArray[i];
                int ifNameIndex = networkInterfaceInfo.indexOf(ELEM_FIELD_SEP);
                int ifTypeIndex = networkInterfaceInfo.lastIndexOf(ELEM_FIELD_SEP);
                if (ifTypeIndex != ifNameIndex && ifTypeIndex != -1 && ifNameIndex != -1) {
                    String ifName = networkInterfaceInfo.substring(0, ifNameIndex);
                    String subnetAddress = networkInterfaceInfo.substring(ifNameIndex + 1, ifTypeIndex);
                    String interfaceType = networkInterfaceInfo.substring(ifTypeIndex + 1);
                    int cvuInterfaceType = -1;
                    try {
                        cvuInterfaceType = Integer.parseInt(interfaceType);
                        String useInterfaceType = null;
                        useInterfaceType = cvuInterfaceType == 5 ? networkIfTypeIDs[3] + ifTypeSep + networkIfTypeIDs[1] : networkIfTypeIDs[cvuInterfaceType - 1];
                        if (!VerificationUtil.isStringGood(useInterfaceType)) continue;
                        if (interconnectList.length() > 0) {
                            interconnectList.append(elementSeparator);
                        }
                        interconnectList.append("\"" + ifName + "\"" + ELEM_FIELD_SEP + subnetAddress + ELEM_FIELD_SEP + useInterfaceType);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        Trace.out((Object)"Invalid interface type number format for network entry %s ", (String)networkInterfaceInfo);
                        invalidFormatFound = true;
                        break;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        Trace.out((Object)"Invalid interface type number for network entry %s ", (String)networkInterfaceInfo);
                        invalidFormatFound = true;
                        break;
                    }
                }
                Trace.out((String)"Incorrect format for %s variable, in entry : %s", (Object[])new Object[]{rspVarName, networkInterfaceInfo});
                invalidFormatFound = true;
                break;
            }
            if (invalidFormatFound) {
                this.reportInvalidVariableValueMessage(rspVarName, evaluatingValue);
            }
        } else {
            Trace.out((String)"There is no value for variable < %s > in file %s", (Object[])new Object[]{rspVarName, this.m_filePath});
        }
        if (interconnectList.length() > 0) {
            retVal = interconnectList.toString();
        }
        return retVal;
    }

    private String getHostVipNames() throws VariableFileResolverException {
        Trace.out((String)"Method Entry : RSP_CLUSTER_NODES = %s, RSP_CLUSTER_TYPE = %s, AUTO_CONFIGURE_CLUSTER_NODE_VIP = %s", (Object[])new Object[]{this.m_clusterNodes, this.m_clusterType, this.m_autoConfigVipsOption});
        StringBuilder nodeVips = new StringBuilder();
        String retVal = null;
        if (this.m_isBigCluster) {
            String[] nodesInfo = VerificationUtil.string2strArr(this.m_clusterNodes);
            String rspVarName = this.getVariableNameInFileForCVUVariable(CVUVariableConstants.RSP_CLUSTER_NODES);
            block5: for (String nodeInfo : nodesInfo) {
                String[] nodeFields = nodeInfo.split(ELEM_FIELD_SEP);
                String node = nodeFields[0];
                String nodeVIP = null;
                if (nodeFields.length > 3) {
                    this.reportInvalidVariableValueMessage(rspVarName, nodeInfo);
                }
                if (nodeFields.length == 3) {
                    String nodeRole = nodeFields[2];
                    NodeRole foundRole = null;
                    try {
                        foundRole = NodeRole.getEnumMember((String)nodeRole);
                        switch (foundRole) {
                            case RIM: {
                                Trace.out((Object)"Do not add LEAF node : %s", (String)node);
                                continue block5;
                            }
                        }
                    }
                    catch (EnumConstantNotPresentException e) {
                        Trace.out((String)"%s is not a known role for node : %s", (Object[])new Object[]{nodeRole, node});
                        this.reportInvalidVariableValueMessage(rspVarName, nodeRole);
                    }
                }
                if (VerificationUtil.isStringGood(this.m_autoConfigVipsOption) && Boolean.valueOf(this.m_autoConfigVipsOption).booleanValue()) {
                    nodeVIP = AUTOCONFIGVIP_TOKEN;
                } else if (nodeFields.length > 1) {
                    nodeVIP = nodeFields[1];
                } else {
                    this.reportInvalidVariableValueMessage(rspVarName, nodeInfo);
                }
                if (nodeVips.length() > 0) {
                    nodeVips.append(VAR_ELEM_SEP);
                }
                node = VerificationUtil.getShortHostname(node);
                nodeVips.append(node + ELEM_FIELD_SEP + nodeVIP);
            }
        } else {
            Trace.out((String)"HostHubVip are only populated if cluster type is FLEX");
        }
        if (nodeVips.length() > 0) {
            retVal = nodeVips.toString();
        }
        return retVal;
    }

    private String getCommaSeparatedNodesForRole(NodeRole requestedRole) throws VariableFileResolverException {
        String[] nodesInfo;
        Trace.out((String)"Method Entry : requestedRole = %s, RSP_CLUSTER_NODES = %s", (Object[])new Object[]{requestedRole.toString(), this.m_clusterNodes});
        StringBuilder commaSeparatedNodes = new StringBuilder();
        String retVal = null;
        block7: for (String nodeInfo : nodesInfo = VerificationUtil.string2strArr(this.m_clusterNodes)) {
            String[] nodeFields = nodeInfo.split(ELEM_FIELD_SEP);
            String node = nodeFields[0];
            String nodeRole = null;
            switch (requestedRole) {
                case RIM: {
                    if (nodeFields.length != 3) {
                        Trace.out((Object)"Requested LEAF nodes, but role is not specified, skip node : %s", (String)node);
                        continue block7;
                    }
                }
                case HUB: {
                    if (nodeFields.length == 3) {
                        nodeRole = nodeFields[2];
                        NodeRole foundRole = null;
                        try {
                            foundRole = NodeRole.getEnumMember((String)nodeRole);
                            if (foundRole != requestedRole) {
                                Trace.out((String)"Node : %s , is not of requested role : %s ", (Object[])new Object[]{node, requestedRole});
                                continue block7;
                            }
                        }
                        catch (EnumConstantNotPresentException e) {
                            Trace.out((String)"%s is not a known role for node : %s", (Object[])new Object[]{nodeRole, node});
                            this.reportInvalidVariableValueMessage(this.getVariableNameInFileForCVUVariable(CVUVariableConstants.RSP_CLUSTER_NODES), nodeRole);
                        }
                    }
                }
                case AUTO: {
                    node = VerificationUtil.getShortHostname(node);
                    Trace.out((String)"Adding node : %s, with role : %s", (Object[])new Object[]{node, nodeRole});
                    if (commaSeparatedNodes.length() > 0) {
                        commaSeparatedNodes.append(VAR_ELEM_SEP);
                    }
                    commaSeparatedNodes.append(node);
                }
            }
        }
        if (commaSeparatedNodes.length() > 0) {
            retVal = commaSeparatedNodes.toString();
        }
        return retVal;
    }

    @Override
    protected List<String> getVariableNamesInFileForCVUVariable(CVUVariableData cvuVar) {
        return cvuVar.getInstallResponseNames();
    }

    @Override
    protected void verifyVariableValues() throws VariableFileResolverException {
        Trace.out((String)"Method Entry");
        this.m_clusterNodes = this.checkNonEmptyVariable(CVUVariableConstants.RSP_CLUSTER_NODES);
        this.m_clusterType = CVUVariables.getValue(CVUVariableConstants.RSP_CLUSTERTYPE_OPT);
        this.checkValueForVariableIsEnumMember(CVUVariableConstants.RSP_CLUSTERTYPE_OPT, ClusterType.class);
        this.m_storageOption = CVUVariables.getValue(CVUVariableConstants.RSP_STORAGE_OPT);
        this.checkValueForVariableIsEnumMember(CVUVariableConstants.RSP_STORAGE_OPT, RSP_STORAGE_OPTIONS.class);
        this.m_autoConfigVipsOption = CVUVariables.getValue(CVUVariableConstants.AUTO_CONFIGURE_CLUSTER_NODE_VIP);
        this.m_configureGNS = CVUVariables.getValue(CVUVariableConstants.CONFIGURE_GNS);
        if (Boolean.valueOf(this.m_configureGNS).booleanValue()) {
            this.m_gnsOption = this.checkNonEmptyVariable(CVUVariableConstants.RSP_GNS_OPT);
            this.checkValueForVariableIsEnumMember(CVUVariableConstants.RSP_GNS_OPT, RSP_GNS_OPTIONS.class);
            this.checkNonEmptyVariable(CVUVariableConstants.AUTO_CONFIGURE_CLUSTER_NODE_VIP);
        }
        this.checkValueForVariableDisksWithFailureGroupNames();
    }

    private void checkValueForVariableDisksWithFailureGroupNames() throws VariableFileResolverException {
        String disksWithFailureGroups = CVUVariables.getValue(CVUVariableConstants.ASM_DISKGROUP_DISKSWITHFAILUREGROUPNAMES);
        String failureGroups = CVUVariables.getValue(CVUVariableConstants.ASM_DISKGROUP_FAILUREGROUPS);
        Trace.out((String)("oracle.install.asm.diskGroup.disksWithFailureGroupNames=" + disksWithFailureGroups + VerificationConstants.LSEP + "oracle.install.asm.diskGroup.FailureGroups= " + failureGroups));
        if (VerificationUtil.isStringGood(failureGroups)) {
            String disks = CVUVariables.getValue(CVUVariableConstants.ASM_DISKGROUP_DISKS);
            Trace.out((String)("oracle.install.asm.diskGroup.disks=" + disks));
            String[] failureGroupArr = VerificationUtil.string2strArr(failureGroups, ",");
            String[] diskArr = VerificationUtil.string2strArr(disks, ",");
            if (failureGroupArr.length != diskArr.length) {
                String failureGroupVar = this.getVariableNameInFileForCVUVariable(CVUVariableConstants.ASM_DISKGROUP_FAILUREGROUPS);
                String diskVar = this.getVariableNameInFileForCVUVariable(CVUVariableConstants.ASM_DISKGROUP_DISKS);
                String errMsg = m_msgBundle.getMessage("5107", true, (Object[])new String[]{failureGroupVar, diskVar, this.m_filePath});
                throw new VariableFileResolverException(errMsg);
            }
        }
        if (VerificationUtil.isStringGood(disksWithFailureGroups)) {
            String[] disksWithFG = VerificationUtil.string2strArr(disksWithFailureGroups, ",", false);
            ArrayList<String> diskList = new ArrayList<String>();
            ArrayList<String> fgList = new ArrayList<String>();
            for (int i = 0; i < disksWithFG.length; ++i) {
                if (i % 2 == 0) {
                    if (!VerificationUtil.isStringGood(disksWithFG[i])) continue;
                    diskList.add(disksWithFG[i]);
                    continue;
                }
                if (!VerificationUtil.isStringGood(disksWithFG[i])) continue;
                fgList.add(disksWithFG[i]);
            }
            if (fgList.size() > 0 && fgList.size() != diskList.size()) {
                String varName = this.getVariableNameInFileForCVUVariable(CVUVariableConstants.ASM_DISKGROUP_DISKSWITHFAILUREGROUPNAMES);
                String errMsg = m_msgBundle.getMessage("5106", true, (Object[])new String[]{varName, this.m_filePath});
                throw new VariableFileResolverException(errMsg);
            }
        }
    }

    @Override
    protected void initializeValidOptions() {
        if (!m_isResponseVarsXmlParsed && !VerificationUtil.isStringGood(m_releaseForResponseVarsXml)) {
            String reqRelease = VerificationUtil.getRequestedRelease();
            if (reqRelease != null) {
                m_releaseForResponseVarsXml = reqRelease;
                Trace.out((String)("RequestedRelease is: " + reqRelease));
            } else {
                m_releaseForResponseVarsXml = "12.2";
                Trace.out((String)("using CUR_RELEASE : " + m_releaseForResponseVarsXml + ", to parse responsevars.xml"));
            }
        }
        if (!m_isResponseVarsXmlParsed) {
            try {
                Trace.out((String)"Start parse all variables from responsevars.xml...");
                this.parse(m_releaseForResponseVarsXml);
                m_isResponseVarsXmlParsed = true;
            }
            catch (SAXException e) {
                Trace.out((Exception)e);
            }
            catch (URISyntaxException e) {
                Trace.out((Exception)e);
            }
            catch (ParserConfigurationException e) {
                Trace.out((Exception)e);
            }
            catch (IOException e) {
                Trace.out((Exception)e);
            }
            catch (XmlFilePathException e) {
                Trace.out((Exception)e);
            }
        }
    }

    private void parse(String release) throws SAXException, URISyntaxException, ParserConfigurationException, IOException, XmlFilePathException {
        m_rootElementTaskDef = this.getRootElement();
        if (m_rootElementTaskDef == null) {
            Trace.out((String)"responsevars xml file not found or could not be parsed");
            return;
        }
        NodeList softwareReleaseList = m_rootElementTaskDef.getElementsByTagName(RESPONSEVARS_SOFTWARE_ELEMENT_TAG);
        String version = null;
        boolean foundRelease = false;
        for (int i = 0; i < softwareReleaseList.getLength(); ++i) {
            Element elem = (Element)softwareReleaseList.item(i);
            version = elem.getAttribute(RESPONSEVARS_VERSION_ELEMENT_TAG);
            Trace.out((String)("Version found " + version));
            if (version.equalsIgnoreCase(release)) {
                Trace.out((String)("Process variables for the release: " + version));
                foundRelease = true;
                this.processVariableListForRelease(elem);
                continue;
            }
            if (version.equalsIgnoreCase("12.2")) {
                m_currentReleaseVarDef = elem;
                Trace.out((String)("Found variable definition for the current release : " + version));
                continue;
            }
            Trace.out((String)("Not parsing variables for the release : " + version));
        }
        if (!foundRelease) {
            if (m_currentReleaseVarDef == null) {
                Trace.out((String)"Variable definitions for the current release not found");
            } else {
                Trace.out((String)("The requested release " + release + " was not found"));
                m_releaseForResponseVarsXml = "12.2";
                Trace.out((String)"Default to variable definitions of the current release");
                this.processVariableListForRelease(m_currentReleaseVarDef);
            }
        }
    }

    private void processVariableListForRelease(Element releaseElem) {
        NodeList variableList = releaseElem.getElementsByTagName(RESPONSEVARS_VARIABLE_LIST_ELEMENT_TAG);
        Element variableListElem = (Element)variableList.item(0);
        NodeList xmlVariableList = variableListElem.getElementsByTagName(RESPONSEVARS_VARIABLE_ELEMENT_TAG);
        for (int i = 0; i < xmlVariableList.getLength(); ++i) {
            Element variableElem = (Element)xmlVariableList.item(i);
            String variableId = this.getValueFromElementWithTag(variableElem, RESPONSEVARS_INSTALL_VAR_VALUE_ELEMENT_TAG);
            if (!VerificationUtil.isStringGood(variableId)) continue;
            String cs_ValidValues = this.getValueFromElementWithTag(variableElem, RESPONSEVARS_INSTALL_OPTIONS_ELEMENT_TAG);
            HashSet<String> validValues = new HashSet<String>();
            validValues.addAll(Arrays.asList(VerificationUtil.string2strArr(cs_ValidValues)));
            this.m_VariablesValidOptions.put(variableId, validValues);
            VerificationUtil.traceAndLog("Valid values for variable: %s are: %s", variableId, cs_ValidValues);
        }
    }

    private String getValueFromElementWithTag(Element variableElem, String elementTag) {
        String result = null;
        Element rootScriptElem = this.getFirstChildByTagName(variableElem, elementTag);
        if (rootScriptElem != null) {
            String value = rootScriptElem.getAttribute(RESPONSEVARS_NAME_ATTRIBUTE_TAG);
            if (VerificationUtil.isStringGood(value)) {
                result = value;
            } else {
                Trace.out((String)("The variable VALUE attribute was not found for element: " + elementTag));
            }
        }
        return result;
    }

    private Element getRootElement() throws SAXException, URISyntaxException, ParserConfigurationException, IOException, XmlFilePathException {
        DocumentBuilderFactory m_xmlFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder m_xmlParser = null;
        Document m_xmlDocument = null;
        File file_xsdURI = null;
        File file_xmlFile = null;
        String m_xmlVarFile = VerificationUtil.getResponseVarsXmlURI();
        String m_xsdVarFile = VerificationUtil.getResponseVarsXmlSchemaURI();
        Trace.out((String)("==== URIs obtained :xsd URI = " + m_xsdVarFile));
        Trace.out((String)("==== URIs obtained :xml URI = " + m_xmlVarFile));
        if (m_xsdVarFile != null) {
            file_xsdURI = new File(new URI(m_xsdVarFile));
        }
        if (file_xsdURI == null || !file_xsdURI.exists()) {
            Trace.out((String)("xmlFile: " + m_xsdVarFile + " does not exists. returning " + "null"));
            return null;
        }
        Trace.out((String)("xsdFile exists : " + m_xsdVarFile));
        if (m_xmlVarFile != null) {
            file_xmlFile = new File(new URI(m_xmlVarFile));
        }
        if (file_xmlFile == null || !file_xmlFile.exists()) {
            Trace.out((String)("xmlFile: " + m_xmlVarFile + " does not exists. returning " + "null"));
            return null;
        }
        Trace.out((String)("xmlFile exists : " + m_xmlVarFile));
        if (m_xsdVarFile != null) {
            m_xmlFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            m_xmlFactory.setNamespaceAware(true);
            m_xmlFactory.setValidating(true);
            m_xmlFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", m_xsdVarFile);
            Trace.out((String)("setting xmlFactory to use xsdFile : " + m_xsdVarFile));
        } else {
            Trace.out((String)"xsdFileVarFile is null");
        }
        m_xmlParser = m_xmlFactory.newDocumentBuilder();
        ErrorHandler handler = new ErrorHandler(){

            @Override
            public void error(SAXParseException arg0) throws SAXException {
                throw arg0;
            }

            @Override
            public void fatalError(SAXParseException arg0) throws SAXException {
                throw arg0;
            }

            @Override
            public void warning(SAXParseException arg0) throws SAXException {
                Trace.out((String)("Igonred warning while parsing: " + arg0));
            }
        };
        m_xmlParser.setErrorHandler(handler);
        m_xmlDocument = m_xmlParser.parse(file_xmlFile);
        if (m_xmlDocument != null) {
            Trace.out((String)("The xml responsevars file: " + m_xmlVarFile + ", was parsed" + " correctly"));
        } else {
            Trace.out((String)("The xml responsevars file: " + m_xmlVarFile + ", was NOT" + " parsed"));
        }
        return m_xmlDocument.getDocumentElement();
    }

    private NodeList getChildrenByTagName(Element elem, String tagName) {
        NodeList allChildren = elem.getChildNodes();
        final ArrayList<Node> _items = new ArrayList<Node>();
        NodeList immediateChildren = new NodeList(){

            @Override
            public int getLength() {
                return _items.size();
            }

            @Override
            public Node item(int paramInt) {
                return (Node)_items.get(paramInt);
            }
        };
        for (int i = 0; i < allChildren.getLength(); ++i) {
            Node toddler = allChildren.item(i);
            if (toddler == null || !toddler.getNodeName().equals(tagName)) continue;
            _items.add(toddler);
        }
        return immediateChildren;
    }

    private Element getFirstChildByTagName(Element elem, String tagName) {
        NodeList allChildren = this.getChildrenByTagName(elem, tagName);
        for (int i = 0; i < allChildren.getLength(); ++i) {
            Node toddler = allChildren.item(i);
            if (toddler == null || !toddler.getNodeName().equals(tagName)) continue;
            return (Element)toddler;
        }
        return null;
    }

    private static enum RSP_ISBIGCLUSTER_OPTIONS {
        FLEX,
        STANDALONE,
        DOMAIN,
        MEMBERDB;

    }

    private static enum RSP_STORAGE_OPTIONS {
        LOCAL_ASM_STORAGE,
        FLEX_ASM_STORAGE,
        CLIENT_ASM_STORAGE,
        FILE_SYSTEM_STORAGE;

    }

    private static enum RSP_GNS_OPTIONS {
        CREATE_NEW_GNS,
        USE_SHARED_GNS;

    }
}

