/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.param;

import java.util.HashMap;
import java.util.List;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.param.VariableFileResolver;
import oracle.ops.verification.framework.param.VariableFileResolverException;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariableData;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public final class InstallConfigResolver
extends VariableFileResolver {
    @Override
    protected void populateCVUVariables() throws VariableFileResolverException {
        Trace.out((String)"Method Entry");
        this.setVariableValue(CVUVariableConstants.INTERCONNECT_LIST, this.getInterConnectListFromCfgFile());
        this.setVariableValue(CVUVariableConstants.HOST_VIP_NAMES, this.convertCfgCrsNodeVipsToCvuValue());
        this.setVariableValue(CVUVariableConstants.AUTO_CONFIGURE_CLUSTER_NODE_VIP, Boolean.toString(this.isVIPDHCPConfigured()));
        this.setVariableValue(CVUVariableConstants.NETWORK_LIST, this.getNetworkListFromCfgFile());
        String asmDisks = CVUVariables.getValue(CVUVariableConstants.ASM_DISKGROUP_DISKS);
        String asmDiscoveryString = CVUVariables.getValue(CVUVariableConstants.ASM_DISK_DISCOVERY_STRING);
        boolean asmCheckFlag = VerificationUtil.isStringGood(asmDisks) || VerificationUtil.isStringGood(asmDiscoveryString);
        this.setVariableValue(CVUVariableConstants.ASM_DEVICE_CHECKS_FLAG, Boolean.toString(asmCheckFlag));
    }

    private String getNetworkListFromCfgFile() {
        String networks = CVUVariables.getValue(CVUVariableConstants.CFG_NETWORKS);
        if (VerificationUtil.isStringGood(networks)) {
            networks = networks.replace("/", ":");
            networks = networks.replace(",", "/");
        }
        return networks;
    }

    private boolean isVIPDHCPConfigured() {
        boolean isVipDHCPConfigured = false;
        String hostVipNames = CVUVariables.getValue(CVUVariableConstants.HOST_VIP_NAMES);
        if (VerificationUtil.isStringGood(hostVipNames)) {
            String[] hostVipNamesArray;
            for (String vipTuple : hostVipNamesArray = VerificationUtil.string2strArr(hostVipNames)) {
                String[] vip = VerificationUtil.string2strArr(vipTuple, ":");
                if (vip.length != 1 && (vip.length != 2 || !vip[1].equalsIgnoreCase("AUTO"))) continue;
                isVipDHCPConfigured = true;
                break;
            }
        }
        return isVipDHCPConfigured;
    }

    private String getInterConnectListFromCfgFile() throws VariableFileResolverException {
        StringBuilder interconnectList = new StringBuilder();
        String retVal = null;
        String networks = CVUVariables.getValue(CVUVariableConstants.CFG_NETWORKS);
        if (!VerificationUtil.isStringGood(networks)) {
            Trace.out((Object)"There is no value for NETWORKS in file %s ", (String)this.m_filePath);
        } else {
            String[] networksEntries = VerificationUtil.string2strArr(networks);
            HashMap<String, String> uniqInterfaceEntries = new HashMap<String, String>();
            for (String networkEntry : networksEntries) {
                int ifNameIndex = networkEntry.indexOf(this.NET_NAMSUB_SEP);
                int ifTypeIndex = networkEntry.lastIndexOf(this.NET_SUBIFTYPE_SEP);
                if (ifNameIndex > 0 && ifNameIndex < ifTypeIndex) {
                    String ifNameSubnetAddress = networkEntry.substring(0, ifTypeIndex);
                    String ifType = networkEntry.substring(ifTypeIndex + 1);
                    if (uniqInterfaceEntries.containsKey(ifNameSubnetAddress)) {
                        String savedIfType = (String)uniqInterfaceEntries.get(ifNameSubnetAddress);
                        ifType = savedIfType + this.IFTYPE_SEP + ifType;
                    }
                    uniqInterfaceEntries.put(ifNameSubnetAddress, ifType);
                    continue;
                }
                Trace.out((Object)"Invalid format found to NETWORKS variable in entry : %s", (String)networkEntry);
                this.reportInvalidVariableValueMessage(this.getVariableNameInFileForCVUVariable(CVUVariableConstants.CFG_NETWORKS), networkEntry);
            }
            if (uniqInterfaceEntries.size() > 0) {
                for (String networkEntry : uniqInterfaceEntries.keySet()) {
                    String ifTypeValue = (String)uniqInterfaceEntries.get(networkEntry);
                    String[] ifTypes = VerificationUtil.string2strArr(ifTypeValue, this.IFTYPE_SEP);
                    StringBuilder cvuIfTypes = new StringBuilder();
                    for (String ifType : ifTypes) {
                        if (!VerificationUtil.isStringGood(ifType)) continue;
                        String appendIfType = null;
                        if (ifType.equalsIgnoreCase(this.NetworksInterfaceTypes[0])) {
                            if (cvuIfTypes.length() == 0) {
                                appendIfType = this.InterconnectInterfaceTypes[0];
                            }
                        } else if (ifType.equalsIgnoreCase(this.NetworksInterfaceTypes[1])) {
                            if (cvuIfTypes.length() == 0 || cvuIfTypes.indexOf(this.InterconnectInterfaceTypes[3]) == 0) {
                                appendIfType = this.InterconnectInterfaceTypes[1];
                            }
                        } else if (ifType.equalsIgnoreCase(this.NetworksInterfaceTypes[3])) {
                            if (cvuIfTypes.length() == 0 || cvuIfTypes.indexOf(this.InterconnectInterfaceTypes[1]) == 0) {
                                appendIfType = this.InterconnectInterfaceTypes[3];
                            }
                        } else {
                            Trace.out((Object)"Unknown interface type found : < %s >, while populating INTERCONNECT_LIST", (String)ifType);
                            this.reportInvalidVariableValueMessage(this.getVariableNameInFileForCVUVariable(CVUVariableConstants.CFG_NETWORKS), ifType);
                        }
                        if (!VerificationUtil.isStringGood(appendIfType)) continue;
                        if (cvuIfTypes.length() > 0) {
                            cvuIfTypes.append(this.IFTYPE_SEP);
                        }
                        cvuIfTypes.append(appendIfType);
                    }
                    if (cvuIfTypes.indexOf(this.InterconnectInterfaceTypes[3]) > 0 && cvuIfTypes.indexOf(this.InterconnectInterfaceTypes[1]) == 0) {
                        cvuIfTypes = new StringBuilder(this.InterconnectInterfaceTypes[3] + this.IFTYPE_SEP + this.InterconnectInterfaceTypes[1]);
                    }
                    if (interconnectList.length() > 0) {
                        interconnectList.append(this.INT_ENTRY_SEP);
                    }
                    String[] newtorkNameSubnetAddress = VerificationUtil.string2strArr(networkEntry, this.NET_NAMSUB_SEP);
                    interconnectList.append("\"" + newtorkNameSubnetAddress[0] + "\"" + this.INT_FIELD_SEP + newtorkNameSubnetAddress[1] + this.INT_FIELD_SEP + cvuIfTypes.toString());
                }
            } else {
                Trace.out((String)"There are no unique valid entries in the NETWORKS variable to populate the INTERCONNECT_LIST");
                this.reportInvalidVariableValueMessage(this.getVariableNameInFileForCVUVariable(CVUVariableConstants.CFG_NETWORKS), networks);
            }
        }
        if (interconnectList.length() > 0) {
            retVal = interconnectList.toString();
        }
        return retVal;
    }

    private String convertCfgCrsNodeVipsToCvuValue() throws VariableFileResolverException {
        StringBuilder strCvuVal = new StringBuilder();
        String retVal = null;
        String crsNodeVips = CVUVariables.getValue(CVUVariableConstants.CFG_CRS_NODEVIPS);
        if (!VerificationUtil.isStringGood(crsNodeVips)) {
            Trace.out((Object)"There is no value for CRS_NODEVIPS in file %s", (String)this.m_filePath);
        } else {
            String[] instVips = crsNodeVips.split(",");
            for (int i = 0; i < instVips.length; ++i) {
                Trace.out((String)("Convering instVip:" + instVips[i]));
                String[] instVip = instVips[i].split("/");
                if (strCvuVal.length() > 0) {
                    strCvuVal.append(',');
                }
                if (instVip.length != 3) {
                    Trace.out((String)("Error: instVips=[" + instVips[i] + "] is not in " + "valid format. it cannot be converted to CVU val"));
                    this.reportInvalidVariableValueMessage(this.getVariableNameInFileForCVUVariable(CVUVariableConstants.CFG_CRS_NODEVIPS), crsNodeVips);
                }
                String node = null;
                node = instVip[0].endsWith("-vip") ? instVip[0].substring(0, instVip[0].indexOf("-vip")) : instVip[0];
                strCvuVal.append(node);
                strCvuVal.append(":");
                strCvuVal.append(instVip[0]);
            }
        }
        if (strCvuVal.length() > 0) {
            retVal = strCvuVal.toString();
        }
        return retVal;
    }

    @Override
    protected List<String> getVariableNamesInFileForCVUVariable(CVUVariableData cvuVar) {
        return cvuVar.getRootScriptNames();
    }

    @Override
    protected void verifyVariableValues() throws VariableFileResolverException {
        Trace.out((String)"Method Entry");
        this.checkNonEmptyVariable(CVUVariableConstants.NODE_LIST);
    }

    @Override
    protected void initializeValidOptions() {
        Trace.out((int)1, (String)"Valid options are not verified while parsing crsconfig_params file");
    }
}

