/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.network;

import oracle.cluster.verification.common.CVUException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.network.CommandHandler;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.util.VerificationUtil;

class sCommandHandler
extends CommandHandler
implements NetworkConstants {
    private static final String PING = "/usr/sbin/ping";
    private static final String PING_OPT_SRC = "-i";
    private static final String PING_OPT_IPV6 = "-A inet6";
    private static final String PING6 = "/bin/ping6";
    private static final String PING_OPT_TIMEOUT = "-w";
    private static final String PING_COUNT = "-c 1";
    private static final String PING_OPT_HINT = "-M do";
    private static final String PING_OPT_PKTSIZE = "-s";

    sCommandHandler() {
    }

    @Override
    protected VerificationCommand generateReachabilityCommand(String srcNode, String destNode) {
        String[] arg = new String[2];
        String[] env = null;
        boolean bIPV6Host = false;
        try {
            if (VerificationUtil.isIPV6Host(destNode)) {
                bIPV6Host = true;
            }
        }
        catch (CVUException cvuEx) {
            Trace.out((String)("CVUException occured while determining " + destNode + " is a ipv6 host. mesg:" + cvuEx.getMessage()));
        }
        arg[0] = "-runexe";
        arg[1] = bIPV6Host ? " /usr/sbin/ping -A inet6 " + destNode + " " + " " + sCommandHandler.getTimeOut() : " /usr/sbin/ping " + destNode + " " + " " + sCommandHandler.getTimeOut();
        return new VerificationCommand(srcNode, arg, env);
    }

    protected VerificationCommand generateIPConnectivityCommand(String srcNode, String srcIP, String destIP) {
        String[] arg = new String[2];
        String[] env = null;
        arg[0] = "-runexe";
        arg[1] = " /usr/sbin/ping -i " + srcIP + " " + destIP + " " + sCommandHandler.getTimeOut();
        return new VerificationCommand(srcNode, arg, env);
    }

    protected VerificationCommand generateIPConnectivityCommand(String srcNode, String srcIP, String destIP, int family) {
        String[] arg = new String[2];
        String[] env = null;
        arg[0] = "-runexe";
        arg[1] = family == 4 ? " /usr/sbin/ping -i " + srcIP + " " + destIP + " " + sCommandHandler.getTimeOut() : " /usr/sbin/ping -i " + srcIP + " " + PING_OPT_IPV6 + " " + destIP + " " + sCommandHandler.getTimeOut();
        return new VerificationCommand(srcNode, arg, env);
    }

    @Override
    protected VerificationCommand generateICMPCommandWithoutFragment(String srcNode, String srcIP, String destIP, int mtuSize) {
        String[] args = new String[2];
        String[] env = null;
        String pktSize = Integer.toString(mtuSize);
        args[0] = "-runexe";
        args[1] = " /usr/sbin/ping " + destIP + " " + PING_COUNT + " " + PING_OPT_TIMEOUT + " " + String.valueOf(sCommandHandler.getTimeOut()) + " " + PING_OPT_HINT + " " + PING_OPT_PKTSIZE + " " + pktSize;
        Trace.out((String)("Executing command :" + args[1]));
        return new VerificationCommand(srcNode, args, env);
    }

    protected boolean parseConnectivityCmd(VerificationCommand vfyCmd) {
        boolean expectedExitCode = false;
        boolean succ = true;
        if (0 != vfyCmd.getVfyCode()) {
            succ = false;
            Trace.out((String)("vfyCmd returned: " + vfyCmd.getVfyCode()));
            Trace.out((String)("vfyCmd output: " + vfyCmd.getOutput()));
        }
        return succ;
    }

    @Override
    protected NetworkInfo parseGetIfInfoCommandOutput(String fmtdStr, String node, ResultSet resultSet) {
        NetworkInfo network = super.parseGetIfInfoCommandOutput(fmtdStr, node, resultSet);
        network = sCommandHandler.updatePlatformSpecificNetworkDetails(network, fmtdStr, resultSet, node);
        return network;
    }

    public static NetworkInfo updatePlatformSpecificNetworkDetails(NetworkInfo network, String fmtdStr, ResultSet resultSet, String node) {
        return network;
    }

    private static int getTimeOut() {
        return 3;
    }
}

