/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import oracle.cluster.verification.command.TCPConCommand;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.network.Subnet;

public class TCPMatrix {
    private String[] m_nodeList = null;
    private String[] m_ipAddr = null;
    private int[] m_serverPID = null;
    private int[] m_serverPort = null;
    private Result[] m_rsServer = null;
    private Result[] m_rsKill = null;
    private Result[][] m_rsConnectStatus = null;

    TCPMatrix(Set<NetworkInfo> networksInSubnet) {
        Set<NetworkInfo> networks = networksInSubnet;
        int networksSize = networks.size();
        this.m_nodeList = new String[networksSize];
        this.m_ipAddr = new String[networksSize];
        this.m_serverPID = new int[networksSize];
        this.m_serverPort = new int[networksSize];
        this.m_rsServer = new Result[networksSize];
        this.m_rsConnectStatus = new Result[networksSize][networksSize];
        this.m_rsKill = new Result[networksSize];
        int i = 0;
        for (NetworkInfo network : networks) {
            this.m_nodeList[i] = network.getNodeName();
            this.m_ipAddr[i] = network.getIPAsString();
            ++i;
        }
    }

    TCPMatrix(Subnet subnet) {
        HashSet networks = new HashSet();
        Collection networksOnSubnet = subnet.getNetworks();
        networks.addAll(networksOnSubnet);
        int networksSize = networks.size();
        this.m_nodeList = new String[networksSize];
        this.m_ipAddr = new String[networksSize];
        this.m_serverPID = new int[networksSize];
        this.m_serverPort = new int[networksSize];
        this.m_rsServer = new Result[networksSize];
        this.m_rsConnectStatus = new Result[networksSize][networksSize];
        this.m_rsKill = new Result[networksSize];
        int i = 0;
        for (NetworkInfo network : networks) {
            this.m_nodeList[i] = network.getNodeName();
            this.m_ipAddr[i] = network.getIPAsString();
            ++i;
        }
    }

    void runTCPServers() {
        TCPConCommand[] cmdTCPSrvs = new TCPConCommand[this.m_ipAddr.length];
        for (int i = 0; i < this.m_ipAddr.length; ++i) {
            cmdTCPSrvs[i] = TCPConCommand.getTCPServerCommand(this.m_nodeList[i], this.m_ipAddr[i]);
        }
        ResultSet rs = new ResultSet();
        new GlobalHandler().submit((Command[])cmdTCPSrvs, 0, rs);
        for (int i = 0; i < this.m_ipAddr.length; ++i) {
            this.m_serverPID[i] = cmdTCPSrvs[i].getPid();
            this.m_serverPort[i] = cmdTCPSrvs[i].getPort();
            this.m_rsServer[i] = cmdTCPSrvs[i].getTCPServerResult();
        }
    }

    void runTCPClients() {
        int i;
        TCPConCommand[] cmdTCPClnt = new TCPConCommand[this.m_ipAddr.length];
        ArrayList<String> tcpServs = new ArrayList<String>();
        for (i = 0; i < this.m_ipAddr.length; ++i) {
            if (this.m_rsServer[i].getStatus() == 1) {
                tcpServs.add(this.m_ipAddr[i] + ":" + this.m_serverPort[i]);
                continue;
            }
            Trace.out((String)("TCP Server is not started on node " + this.m_nodeList[i] + " with ip address " + this.m_ipAddr[i]));
        }
        for (i = 0; i < this.m_ipAddr.length; ++i) {
            cmdTCPClnt[i] = TCPConCommand.getTCPClientCommand(this.m_nodeList[i], this.m_ipAddr[i], tcpServs.toArray(new String[0]));
        }
        ResultSet rs = new ResultSet();
        new GlobalHandler().submit((Command[])cmdTCPClnt, 0, rs);
        for (int i2 = 0; i2 < this.m_ipAddr.length; ++i2) {
            for (int j = 0; j < this.m_ipAddr.length; ++j) {
                this.m_rsConnectStatus[i2][j] = cmdTCPClnt[i2].getTCPConnectStatus(this.m_ipAddr[j]);
            }
        }
    }

    void killTCPServers() {
        VerificationCommand cmd = null;
        ArrayList<VerificationCommand> cmdKillList = new ArrayList<VerificationCommand>();
        for (int i = 0; i < this.m_ipAddr.length; ++i) {
            if (this.m_rsServer[i].getStatus() != 1) continue;
            Trace.out((String)("Creating kill command to kill server " + this.m_ipAddr[i] + ":" + this.m_serverPort[i] + " with pid " + this.m_serverPID[i] + " running on node " + this.m_nodeList[i]));
            cmd = new VerificationCommand(this.m_nodeList[i], new String[]{"-killproc", String.valueOf(this.m_serverPID[i])}, null);
            cmdKillList.add(cmd);
        }
        ResultSet rs = new ResultSet();
        new GlobalHandler().submit((Command[])cmdKillList.toArray(new VerificationCommand[0]), 0, rs);
    }

    public boolean isAllSuccess() {
        int i;
        for (i = 0; i < this.m_ipAddr.length; ++i) {
            if (this.m_rsServer[i] == null) {
                Trace.out((String)"looks like runServer on me is not called");
                return false;
            }
            if (this.m_rsServer[i].getStatus() == 1) continue;
            Trace.out((String)("TCP server on node " + this.m_nodeList[i] + " with ip address " + this.m_ipAddr[i] + " is failed"));
            return false;
        }
        for (i = 0; i < this.m_ipAddr.length; ++i) {
            for (int j = 0; j < this.m_ipAddr.length; ++j) {
                if (this.m_rsConnectStatus[i][j] != null && this.m_rsConnectStatus[i][j].getStatus() == 1) continue;
                Trace.out((String)(this.m_ipAddr[i] + "[" + this.m_nodeList[i] + "]-->" + this.m_ipAddr[j] + '[' + this.m_nodeList[j] + "]:" + this.m_serverPort[j] + "is failed"));
                return false;
            }
        }
        return true;
    }

    public String[] getIPAddresses() {
        return this.m_ipAddr;
    }

    public String[] getNodes() {
        return this.m_nodeList;
    }

    public Result[] getTCPServerResuls() {
        return this.m_rsServer;
    }

    public Result[][] getTCPConMatrix() {
        return this.m_rsConnectStatus;
    }

    public String toString() {
        int i;
        StringBuilder b = new StringBuilder("\nTCP Servers in the frmt: IPAddress[Node]:Port --- Result.Trace()\n");
        for (i = 0; i < this.m_ipAddr.length; ++i) {
            b.append(this.m_ipAddr[i]).append('[').append(this.m_nodeList[i]).append("]:").append(this.m_serverPort[i]).append("----");
            if (this.m_rsServer[i] == null) {
                b.append("SERVER NOT STARTED");
            } else {
                b.append(this.m_rsServer[i].traceResultInfo());
            }
            b.append("\n---------------------------------------------------------------\n");
        }
        b.append("\nConnectivity status frmt : IPAddress[Node]-->IPAddress[Node]:Port ====> Result Trace() \n");
        for (i = 0; i < this.m_ipAddr.length; ++i) {
            for (int j = 0; j < this.m_ipAddr.length; ++j) {
                b.append(this.m_ipAddr[i]).append('[').append(this.m_nodeList[i]).append("]-->");
                b.append(this.m_ipAddr[j]).append('[').append(this.m_nodeList[j]).append("]:").append(this.m_serverPort[j]).append("=====>");
                if (this.m_rsServer[j] == null) {
                    b.append("SERVER NOT STARTED");
                } else if (this.m_rsConnectStatus[i][j] == null) {
                    b.append("call runTCPClient() function on me to verify connectivity");
                } else {
                    b.append(this.m_rsConnectStatus[i][j].traceResultInfo());
                }
                b.append("\n---------------------------------------------------------------\n");
            }
        }
        return b.toString();
    }
}

