/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.network;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.OIFCFGResult;
import oracle.cluster.cmdtools.SRVCTLUtil;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.command.ICMPPingCommand;
import oracle.cluster.verification.common.CVUException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.CopyFileCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.network.ConMatrix;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkDataDiscovery;
import oracle.ops.verification.framework.network.NetworkException;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.network.Subnet;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.CommandsUtil;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class NetworkUtility
implements NetworkConstants {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static NetworkInfo m_classfiedPublicNetwork = null;
    private static Set<NetworkInfo> m_localNodeNetworkInfo = null;
    private static final long MAX_IP_DECIMAL_VALUE = 0xFFFFFFFFL;
    private static final String IPV4_LOCALHOST_IP = "127.0.0.1";
    private static final String IPV6_LOCALHOST_IP = "::1";

    public static boolean isNetworkTypeClassified(Set<NetworkInfo> clusterNetworks, NetworkConstants.NetworkType netType) {
        if (clusterNetworks == null || netType == null) {
            return false;
        }
        if (netType == NetworkConstants.NetworkType.PUBLIC && NetworkDataDiscovery.hasNetworkTypeInClusterNetworks(clusterNetworks, 2)) {
            return true;
        }
        if (netType == NetworkConstants.NetworkType.PRIVATE && NetworkDataDiscovery.hasNetworkTypeInClusterNetworks(clusterNetworks, 1)) {
            return true;
        }
        return netType == NetworkConstants.NetworkType.ALL;
    }

    public static Set<NetworkInfo> getNetworkInfo(ResultSet resultSet) throws CVUException {
        if (m_localNodeNetworkInfo == null) {
            m_localNodeNetworkInfo = NetworkDataDiscovery.getClusterNetworks(VerificationUtil.getLocalNode(), resultSet);
        } else {
            Trace.out((String)"Returning the already cached network information for local node");
        }
        return m_localNodeNetworkInfo;
    }

    public static List<String> getClassifiedSubnetList(String[] nodeList, ResultSet resultSet, boolean getPrivateSubnets) {
        ArrayList<String> subnetAddrList = new ArrayList<String>();
        Set<Object> clusterNetworks = new HashSet();
        clusterNetworks = NetworkDataDiscovery.getClusterNetworks(nodeList[0], resultSet);
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            VerificationUtil.traceAndLogError("Failed to retrieve the list of network interfaces and subnets");
            return null;
        }
        for (NetworkInfo network : clusterNetworks) {
            int requiredNetType;
            int n = requiredNetType = getPrivateSubnets ? NetworkConstants.NetworkType.PRIVATE.getValue() : NetworkConstants.NetworkType.PUBLIC.getValue();
            if (network.getNetworkType() != requiredNetType) continue;
            VerificationUtil.traceAndLog("Adding Subnet Address (" + network.getSubnetAsString() + ") to the list of " + (getPrivateSubnets ? "private" : "public") + " subnets");
            subnetAddrList.add(network.getSubnetAsString());
        }
        if (!subnetAddrList.isEmpty()) {
            resultSet.addResult(nodeList, 1);
        } else {
            resultSet.addResult(nodeList, 3);
        }
        return subnetAddrList;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static NetworkInfo getClassifiedPublicNetwork(ResultSet resultSet) throws NetworkException {
        String localNode = VerificationUtil.getLocalNode();
        if (m_classfiedPublicNetwork != null) return m_classfiedPublicNetwork;
        m_classfiedPublicNetwork = new NetworkInfo();
        Set<NetworkInfo> clusterNetworks = NetworkDataDiscovery.getClusterNetworks(localNode, resultSet);
        VerificationUtil.logNetworkInterfaces(clusterNetworks);
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            Trace.out((String)"Classified network information not available");
            throw new NetworkException(s_gMsgBundle.getMessage("1513", true, (Object[])new String[]{localNode}));
        }
        if (NetworkDataDiscovery.hasNetworkTypeInClusterNetworks(clusterNetworks, NetworkConstants.NetworkType.PUBLIC.getValue())) {
            NetworkInfo classifiedPublicNetwork = NetworkDataDiscovery.getClusterNetworksByType(clusterNetworks, NetworkConstants.NetworkType.PUBLIC).iterator().next();
            Trace.out((String)"Found classified public network");
            Trace.out((String)("Type is: " + classifiedPublicNetwork.getNetworkTypeAsString()));
            Trace.out((String)("Type is: " + classifiedPublicNetwork.getNetworkType()));
            if (classifiedPublicNetwork == null) return m_classfiedPublicNetwork;
            m_classfiedPublicNetwork = classifiedPublicNetwork;
            return m_classfiedPublicNetwork;
        }
        Trace.out((String)"Public subnet classification not available");
        throw new NetworkException(s_gMsgBundle.getMessage("1562", true));
    }

    public static Hashtable<String, List<String>> getIPList(String[] nodeList, ResultSet resultSet, boolean privateOnly) {
        Hashtable<String, List<String>> ipTable = new Hashtable<String, List<String>>();
        int requiredNetworkType = privateOnly ? NetworkConstants.NetworkType.PRIVATE.getValue() : NetworkConstants.NetworkType.PUBLIC.getValue();
        String networkType = privateOnly ? "private" : "public";
        Set<NetworkInfo> clusterNetworks = null;
        clusterNetworks = NetworkDataDiscovery.getClusterNetworks(nodeList[0], resultSet);
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            VerificationUtil.traceAndLogError("Failed to retrieve the list of network interfaces and subnets");
            resultSet.addResult(nodeList, 2);
        } else {
            HashMap<String, String> interfaceMap = new HashMap<String, String>();
            for (NetworkInfo network : clusterNetworks) {
                Trace.out((String)("Found network type " + network.getNetworkType() + " Required network type: " + requiredNetworkType));
                if (!NetworkUtility.isSameType(network.getNetworkType(), requiredNetworkType)) continue;
                interfaceMap.put(network.getInterfaceName(), network.getSubnetAsString());
            }
            if (interfaceMap.size() == 0) {
                VerificationUtil.traceAndLogError("Failed to retreive the interface details from variable in pre-install scenario");
                resultSet.addResult(nodeList, 2);
            } else {
                for (String networkName : interfaceMap.keySet()) {
                    String subnet = (String)interfaceMap.get(networkName);
                    for (String node : nodeList) {
                        Trace.out((String)("Retrieving " + networkType + " IP addresses on node " + node + " for subnet " + subnet + " and interface name " + networkName));
                        for (NetworkInfo network : NetworkDataDiscovery.getNetworksBySubnetAndName(NetworkDataDiscovery.getNodeNetworksMap(new String[]{node}, resultSet), node, subnet, networkName)) {
                            Trace.out((String)("Added " + networkType + " IP (" + network.getIP() + ") for interface '" + networkName + "' on node " + node));
                            VerificationLogData.log("Added " + networkType + " IP (" + network.getIPAsString() + ") for interface '" + networkName + "' on node " + node);
                            if (ipTable.containsKey(node)) {
                                ipTable.get(node).add(network.getIPAsString());
                            } else {
                                ArrayList<String> networkList = new ArrayList<String>();
                                networkList.add(network.getIPAsString());
                                ipTable.put(node, networkList);
                            }
                            resultSet.addResult(node, 1);
                        }
                    }
                }
            }
        }
        for (String node : nodeList) {
            if (ipTable.containsKey(node)) continue;
            Trace.out((String)("Failed to retrieve the " + networkType + " IP address list from node " + node));
            ErrorDescription errDesc = new ErrorDescription(s_gMsgBundle.getMessage(privateOnly ? "1550" : "1551", true, (Object[])new String[]{node}));
            resultSet.addErrorDescription(node, errDesc);
            resultSet.addResult(node, 2);
        }
        return ipTable;
    }

    public static Hashtable<String, List<String>> getPrivateIPList(String[] nodeList, ResultSet resultSet) {
        return NetworkUtility.getIPList(nodeList, resultSet, true);
    }

    public static Hashtable<String, List<String>> getPublicIPList(String[] nodeList, ResultSet resultSet) {
        return NetworkUtility.getIPList(nodeList, resultSet, false);
    }

    public static Hashtable<String, List<String>> getAllIPsOnSubnet(String[] nodeList, String subnetId, ResultSet resultSet) {
        Hashtable<String, List<String>> ipTable = new Hashtable<String, List<String>>();
        for (String node : nodeList) {
            Set<Object> networksOnSameSubnet = new HashSet();
            networksOnSameSubnet = NetworkDataDiscovery.getNetworksBySubnet(NetworkDataDiscovery.getNodeNetworksMap(new String[]{node}, resultSet), subnetId, node);
            for (NetworkInfo networkInfo : networksOnSameSubnet) {
                String ipAddress = networkInfo.getIPAsString();
                if (!VerificationUtil.isStringGood(ipAddress)) continue;
                if (!ipTable.containsKey(node)) {
                    ArrayList ipList = new ArrayList();
                    ipTable.put(node, ipList);
                }
                if (ipTable.get(node).contains(ipAddress)) continue;
                ipTable.get(node).add(ipAddress);
            }
        }
        return ipTable;
    }

    public static boolean checkSameIPAddresses(String ip1, String ip2) {
        boolean same = false;
        try {
            same = IPAddressUtil.sameIPAddresses((String)ip1, (String)ip2);
        }
        catch (IPAddressException ipEx) {
            Trace.out((String)("IPAddressException occured. mesg: " + ipEx.getMessage()));
        }
        return same;
    }

    public static String getConfiguredNetworksAsInterConnectList(ResultSet resSet) {
        String output = null;
        if (!VerificationUtil.isCRSConfigured()) {
            resSet.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("11902", true, (Object[])new String[]{VerificationUtil.getLocalNode()})));
            resSet.setStatus(3);
            return output;
        }
        HashSet<NetworkInfo> clusterNetworks = new HashSet();
        try {
            clusterNetworks = NetworkDataDiscovery.getClusterNetworksFromOifcfg(resSet);
            if (NetworkUtility.isNetworksSetGood(clusterNetworks)) {
                output = NetworkDataDiscovery.getClusterInterConnectList(clusterNetworks);
                resSet.setStatus(1);
            }
        }
        catch (CVUException ce) {
            Trace.out((String)("Failed to retrieve network configuration from CRS home. Error is " + ce.getMessage()));
            resSet.setStatus(2);
            resSet.addErrorDescription(new ErrorDescription(ce.getMessage()));
        }
        return output;
    }

    public static String getPrivateNetworkListVarString(boolean asmAsPrivate) {
        String value = "";
        String subnetInterfaceNameSeparator = "/";
        String networkSeparator = ",";
        String localNode = VerificationUtil.getLocalHostName();
        Set<NetworkInfo> clusterNetworks = null;
        ResultSet resultSet = new ResultSet();
        clusterNetworks = NetworkDataDiscovery.getClusterNetworks(localNode, resultSet);
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            VerificationUtil.traceAndLogError("Failed to retrieve the list of network interfaces and subnets");
            return null;
        }
        Hashtable<String, String> privateSubnetInterfaceNameTable = NetworkDataDiscovery.getPrivateInterConnectList(clusterNetworks, asmAsPrivate);
        Trace.out((String)("Got total (" + privateSubnetInterfaceNameTable.size() + ") private networks"));
        for (String subnet : privateSubnetInterfaceNameTable.keySet()) {
            value = VerificationUtil.isStringGood(value) ? value + networkSeparator : "";
            value = value + subnet + subnetInterfaceNameSeparator + "\"" + privateSubnetInterfaceNameTable.get(subnet) + "\"";
        }
        if (value != null) {
            Trace.out((String)("Returning the private network list as (" + value + ")"));
        }
        return value;
    }

    public static boolean checkIPAvailability(String node, ResultSet resultSet) {
        String nodeVIP;
        try {
            nodeVIP = InetAddress.getByName(node).getHostAddress();
        }
        catch (UnknownHostException uhe) {
            Trace.out((String)("Host " + node + " is unknown"));
            resultSet.setStatus(3);
            String errMsg = s_gMsgBundle.getMessage("5820", true, (Object[])new String[]{node});
            resultSet.addErrorDescription(new ErrorDescription(errMsg));
            ReportUtil.sureprintln(errMsg);
            return false;
        }
        String[] nodes = new String[]{nodeVIP};
        ClusterCmd cmd = new ClusterCmd();
        try {
            if (cmd.areNodesAlive(nodes, 10, null)) {
                Trace.out((String)("The host VIP address " + nodeVIP + " is already in use"));
                String errMsg = s_gMsgBundle.getMessage("5819", true, (Object[])new String[]{nodeVIP});
                resultSet.setStatus(3);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                resultSet.addErrorDescription(errDesc);
                ReportUtil.sureprintln(errMsg);
                return false;
            }
            return true;
        }
        catch (ClusterException ce) {
            Trace.out((String)ce.getMessage());
            return true;
        }
        catch (RemoteFileOperationException rfoe) {
            Trace.out((String)rfoe.getMessage());
            return true;
        }
    }

    public static Hashtable<String, List<NetworkInfo>> getNodeIfListUsingOifCfg(String crsHome, String[] nodeList) throws NetworkException {
        Hashtable<String, List<NetworkInfo>> niInfoLst = new Hashtable<String, List<NetworkInfo>>();
        try {
            ClusterwareInfo cluInfo = new ClusterwareInfo();
            String oifcfgLoc = crsHome + VerificationConstants.FILE_SEPARATOR + "bin";
            for (String node : nodeList) {
                List netIfs = cluInfo.listInterfaces(node, oifcfgLoc, false);
                ArrayList<NetworkInfo> ifList = new ArrayList<NetworkInfo>();
                for (OIFCFGResult oif : netIfs) {
                    NetworkInfo nInfo = new NetworkInfo();
                    nInfo.setSubnet(oif.getSubnet());
                    nInfo.setSubnetMask(oif.getSubnetMask());
                    nInfo.setNetworkType(oif.getInterfaceType());
                    nInfo.setInterfaceName(oif.getInterfaceName());
                    ifList.add(nInfo);
                }
                niInfoLst.put(node, ifList);
            }
        }
        catch (InstallException iex) {
            Trace.out((String)"Error while getting node interfaces");
            Trace.out((String)("exception : " + iex.getMessage()));
            throw new NetworkException(iex.getMessage(), iex);
        }
        Trace.out((String)"End of geting node network interfaces info.");
        return niInfoLst;
    }

    public static Hashtable<String, NetworkInfo> getResourceVIPList(String[] nodeList, String crsHome, Version activeCRSVersion, ResultSet resultSet) throws NetworkException {
        if (Version.isPre112((Version)activeCRSVersion)) {
            Trace.out((String)("Current active version (" + activeCRSVersion.toString() + ") of CRS is found to be pre 11.2 using 11.2 approach of VIP retrieval"));
            return NetworkUtility.getResourceVIPListPre112(nodeList, crsHome, activeCRSVersion, resultSet);
        }
        Trace.out((String)("Current active version (" + activeCRSVersion.toString() + ") of CRS is found to be post 11.2 Hence using post 11.2 approach " + "of VIP retrieval"));
        return NetworkUtility.getResourceVIPListPost112(crsHome, activeCRSVersion, resultSet);
    }

    private static Hashtable<String, NetworkInfo> getResourceVIPListPre112(String[] nodeList, String crsHome, Version activeCRSVersion, ResultSet resultSet) throws NetworkException {
        Hashtable<String, NetworkInfo> vipList = new Hashtable<String, NetworkInfo>();
        String localNode = VerificationUtil.getLocalNode();
        try {
            NetworkInfo classifiedPublicNetwork = NetworkUtility.getClassifiedPublicNetwork(resultSet);
            SRVCTLUtil srvctl = new SRVCTLUtil(crsHome);
            for (String node : nodeList) {
                String[] srvctlArguments = new String[]{"config", "nodeapps", "-n", node, "-a"};
                CommandResult result = srvctl.runCommand(localNode, srvctlArguments);
                if (!result.getBooleanResult()) {
                    String[] errorString = result.getResultString();
                    if (errorString == null || errorString.length <= 0) continue;
                    Trace.out((String)"SRVCTL config nodeapps -a command failed");
                    StringBuilder sb = new StringBuilder("");
                    for (int i = 0; i < errorString.length; ++i) {
                        sb.append(errorString[i]);
                    }
                    throw new NetworkException(s_gMsgBundle.getMessage("5834", true) + VerificationConstants.LINE_SEPARATOR + sb.toString());
                }
                String[] output = result.getResultString();
                if (output == null || output.length <= 0) continue;
                for (String line : output) {
                    String nodeVip = null;
                    String nodeVipName = null;
                    String nodeVipSubnetMask = null;
                    String nodeVipIf = null;
                    if (line.trim().length() <= 0 || line.indexOf("/") <= 0 || line.indexOf(":") <= 0) continue;
                    if ((line = line.substring(line.indexOf(":") + 1).trim()).contains(",")) {
                        String[] tmpArr;
                        String[] commaSplit = line.split(",");
                        line = commaSplit[0].trim();
                        if (commaSplit.length > 1 && (tmpArr = commaSplit[1].split("\\s+")) != null && tmpArr.length > 0) {
                            node = tmpArr[tmpArr.length - 1].trim();
                        }
                    }
                    while (line.trim().startsWith("/")) {
                        line = line.substring(line.indexOf("/") + 1);
                    }
                    String[] splitted = line.split("/");
                    if (splitted.length < 3) continue;
                    nodeVipName = splitted[0];
                    nodeVip = splitted[1];
                    nodeVipSubnetMask = splitted[2];
                    if (splitted.length > 3) {
                        nodeVipIf = splitted[3];
                    }
                    Trace.out((String)("\n\n node=(" + node + ")\nnodeVipName=(" + nodeVipName + ") \nnodeVip=(" + nodeVip + ") \nnodeVipSubnet=(" + classifiedPublicNetwork.getSubnetAsString() + ") \nnodeVipSubnetMask=(" + nodeVipSubnetMask + ") \nnodeVipIf=(" + nodeVipIf + ")"));
                    NetworkInfo niInfo = new NetworkInfo();
                    niInfo.setIP(nodeVip);
                    niInfo.setSubnet(classifiedPublicNetwork.getSubnet());
                    niInfo.setSubnetMask(nodeVipSubnetMask);
                    niInfo.setNetworkType(NetworkConstants.NetworkType.PUBLIC);
                    niInfo.setInterfaceName(nodeVipIf);
                    niInfo.setNodeName(node);
                    vipList.put(nodeVipName, niInfo);
                }
            }
        }
        catch (CmdToolUtilException cte) {
            Trace.out((String)("Caught CmdToolUtilException - while running srvctl config nodeapps command " + cte.getMessage()));
            throw new NetworkException(s_gMsgBundle.getMessage("5834", true), cte);
        }
        Trace.out((String)"Returning VIP list");
        return vipList;
    }

    private static Hashtable<String, NetworkInfo> getResourceVIPListPost112(String crsHome, Version activeCRSVersion, ResultSet resultSet) throws NetworkException {
        Hashtable<String, NetworkInfo> nodeVipList;
        block7: {
            nodeVipList = new Hashtable<String, NetworkInfo>();
            String locaNode = VerificationUtil.getLocalNode();
            String[] srvctlArguments = new String[]{};
            try {
                SRVCTLUtil srvctl = new SRVCTLUtil(crsHome);
                srvctlArguments = !Version.isPre122((Version)activeCRSVersion) ? new String[]{"config", "nodeapps", "-a", "-S", "1"} : new String[]{"config", "nodeapps", "-a"};
                CommandResult result = srvctl.runCommand(locaNode, srvctlArguments);
                if (!result.getBooleanResult()) {
                    String[] errorString = result.getResultString();
                    if (errorString != null && errorString.length > 0) {
                        Trace.out((String)"SRVCTL config nodeapps -a command failed");
                        StringBuilder sb = new StringBuilder("");
                        for (int i = 0; i < errorString.length; ++i) {
                            sb.append(errorString[i]);
                        }
                        throw new NetworkException(s_gMsgBundle.getMessage("5834", true) + VerificationConstants.LINE_SEPARATOR + sb.toString());
                    }
                    break block7;
                }
                if (Version.isPre12101((Version)activeCRSVersion)) {
                    return NetworkUtility.parseSrvctlConfigNodeAppOutputPre121(result.getResultString(), resultSet);
                }
                if (Version.isPre122((Version)activeCRSVersion)) {
                    return NetworkUtility.parseSrvctlConfigNodeAppOutput121AndPre122(result.getResultString(), resultSet);
                }
                return NetworkUtility.parseSrvctlConfigNodeAppOutput122AndAbove(result.getResultString());
            }
            catch (CmdToolUtilException cte) {
                Trace.out((String)("Caught CmdToolUtilException - while running srvctl config nodeapps command " + cte.getMessage()));
                throw new NetworkException(s_gMsgBundle.getMessage("5834", true), cte);
            }
        }
        Trace.out((String)"Returning VIP list");
        return nodeVipList;
    }

    private static Hashtable<String, NetworkInfo> parseSrvctlConfigNodeAppOutputPre121(String[] output, ResultSet resultSet) throws NetworkException {
        Hashtable<String, NetworkInfo> vipList = new Hashtable<String, NetworkInfo>();
        if (output != null && output.length > 0) {
            String subnet = null;
            String subnetMask = null;
            String interfaceName = null;
            boolean subnetAndMaskParsed = false;
            for (String line : output) {
                String node = null;
                String nodeVip = null;
                String nodeVipName = null;
                String nodeVipSubnet = null;
                String nodeVipSubnetMask = null;
                String nodeVipIf = null;
                if (line.trim().length() <= 0 || line.indexOf("/") <= 0 || line.indexOf(":") <= 0) continue;
                if ((line = line.substring(line.indexOf(":") + 1).trim()).contains(",")) {
                    String[] tmpArr;
                    String[] commaSplit = line.split(",");
                    line = commaSplit[0].trim();
                    if (commaSplit.length > 1 && (tmpArr = commaSplit[1].split("\\s+")) != null && tmpArr.length > 0) {
                        node = tmpArr[tmpArr.length - 1].trim();
                    }
                }
                while (line.trim().startsWith("/")) {
                    line = line.substring(line.indexOf("/") + 1);
                }
                String[] splitted = line.split("/");
                if (!subnetAndMaskParsed && splitted != null && splitted.length > 2) {
                    subnet = splitted[1];
                    subnetMask = splitted[2];
                    if (splitted.length > 3) {
                        interfaceName = splitted[3];
                    }
                    subnetAndMaskParsed = true;
                    continue;
                }
                if (splitted.length > 3) {
                    NetworkInfo classifiedPublicNetwork;
                    nodeVipName = splitted[0];
                    nodeVip = splitted[1];
                    nodeVipSubnet = splitted[2];
                    if (!VerificationUtil.isStringGood(nodeVipSubnet)) {
                        nodeVipSubnet = subnet;
                    }
                    if (!VerificationUtil.isStringGood(nodeVipSubnetMask = splitted[3])) {
                        nodeVipSubnetMask = subnetMask;
                    }
                    nodeVipIf = splitted.length > 4 ? splitted[4] : interfaceName;
                    Trace.out((String)("\n\n node=(" + node + ")\nnodeVipName=(" + nodeVipName + ") \nnodeVip=(" + nodeVip + ") \nnodeVipSubnet=(" + nodeVipSubnet + ") \nnodeVipSubnetMask=(" + nodeVipSubnetMask + ") \nnodeVipIf=(" + nodeVipIf + ")"));
                    if (!VerificationUtil.isStringGood(nodeVipName)) {
                        nodeVipName = nodeVip;
                    }
                    if (!(VerificationUtil.isStringGood(nodeVipSubnet) && VerificationUtil.isStringGood(nodeVipIf) || (classifiedPublicNetwork = NetworkUtility.getClassifiedPublicNetwork(resultSet)) == null)) {
                        Trace.out((String)"Using the Subnet and interface information from classified public network info");
                        if (!VerificationUtil.isStringGood(nodeVipSubnet)) {
                            nodeVipSubnet = classifiedPublicNetwork.getSubnetAsString();
                        }
                        if (!VerificationUtil.isStringGood(nodeVipIf)) {
                            nodeVipIf = classifiedPublicNetwork.getInterfaceName();
                        }
                    }
                }
                NetworkInfo niInfo = new NetworkInfo();
                niInfo.setIP(nodeVip);
                niInfo.setSubnet(nodeVipSubnet);
                niInfo.setSubnetMask(nodeVipSubnetMask);
                niInfo.setNetworkType(NetworkConstants.NetworkType.PUBLIC);
                niInfo.setInterfaceName(nodeVipIf);
                vipList.put(nodeVipName, niInfo);
            }
        }
        return vipList;
    }

    private static Hashtable<String, NetworkInfo> parseSrvctlConfigNodeAppOutput121AndPre122(String[] output, ResultSet resultSet) throws NetworkException {
        Hashtable<String, NetworkInfo> vipList = new Hashtable<String, NetworkInfo>();
        if (output != null && output.length > 0) {
            String subnetIPv4 = null;
            String subnetIPv6 = null;
            String subnetMaskIPv4 = null;
            String subnetMaskIPv6 = null;
            String interfaceNameIPv4 = null;
            String interfaceNameIPv6 = null;
            boolean addressTypeBoth = false;
            for (int cnt = 0; cnt < output.length; ++cnt) {
                NetworkInfo classifiedPublicNetwork;
                String[] splitted;
                String[] splitted2;
                String[] commaSplit;
                String line = output[cnt].trim();
                String node = null;
                String nodeVipIPv4 = null;
                String nodeVipIPv6 = null;
                String nodeVipName = null;
                addressTypeBoth = false;
                if (line.startsWith("Subnet IPv4:")) {
                    if ((line = line.substring(line.indexOf(":") + 1).trim()).contains(",")) {
                        commaSplit = line.split(",");
                        line = commaSplit[0].trim();
                    }
                    while (line.trim().startsWith("/")) {
                        line = line.substring(line.indexOf("/") + 1);
                    }
                    splitted2 = line.split("/");
                    if (splitted2 == null || splitted2.length <= 1) continue;
                    subnetIPv4 = splitted2[0];
                    subnetMaskIPv4 = splitted2[1];
                    if (splitted2.length <= 2) continue;
                    interfaceNameIPv4 = splitted2[2];
                    continue;
                }
                if (line.startsWith("Subnet IPv6:")) {
                    if ((line = line.substring(line.indexOf(":") + 1).trim()).contains(",")) {
                        commaSplit = line.split(",");
                        line = commaSplit[0].trim();
                    }
                    while (line.trim().startsWith("/")) {
                        line = line.substring(line.indexOf("/") + 1);
                    }
                    splitted2 = line.split("/");
                    if (splitted2 == null || splitted2.length <= 1) continue;
                    subnetIPv6 = splitted2[0];
                    subnetMaskIPv6 = splitted2[1];
                    if (splitted2.length <= 2) continue;
                    interfaceNameIPv6 = splitted2[2];
                    continue;
                }
                if (!line.startsWith("VIP exists:")) continue;
                if ((line = line.substring(line.indexOf(":") + 1).trim()).indexOf(",") > 0) {
                    splitted2 = line.split(",");
                    line = splitted2[splitted2.length - 1];
                    splitted2 = line.split("\\s+");
                    node = splitted2[splitted2.length - 1];
                }
                for (int vipCnt = cnt + 1; vipCnt < output.length; ++vipCnt) {
                    line = output[vipCnt].trim();
                    if (line.startsWith("VIP Name:")) {
                        nodeVipName = line.substring(line.indexOf(":") + 1).trim();
                        continue;
                    }
                    if (line.startsWith("VIP IPv4 Address:")) {
                        nodeVipIPv4 = line.substring(line.indexOf(":") + 1).trim();
                        continue;
                    }
                    if (line.startsWith("VIP IPv6 Address:")) {
                        nodeVipIPv6 = line.substring(line.indexOf(":") + 1).trim();
                        continue;
                    }
                    if (!line.startsWith("VIP exists:")) continue;
                    cnt = vipCnt - 1;
                    break;
                }
                NetworkInfo niInfo = null;
                if (VerificationUtil.isStringGood(nodeVipIPv4) && VerificationUtil.isStringGood(nodeVipIPv6)) {
                    addressTypeBoth = true;
                }
                if (VerificationUtil.isStringGood(nodeVipIPv4)) {
                    if (nodeVipIPv4.contains("-/")) {
                        splitted = nodeVipIPv4.replace("-/", "").split("/");
                        if (nodeVipName == null) {
                            nodeVipName = splitted[0];
                        }
                        nodeVipIPv4 = splitted[1];
                    }
                    Trace.out((String)("\n\nIPv4 VIP INFO for node=(" + node + ")\nnodeVipName=(" + nodeVipName + ") \nnodeVip=(" + nodeVipIPv4 + ") \nnodeVipSubnet=(" + subnetIPv4 + ") \nnodeVipSubnetMask=(" + subnetMaskIPv4 + ") \nnodeVipIf=(" + interfaceNameIPv4 + ")"));
                    if (!VerificationUtil.isStringGood(nodeVipName)) {
                        nodeVipName = nodeVipIPv4;
                    }
                    if (!VerificationUtil.isStringGood(subnetIPv4) || !VerificationUtil.isStringGood(interfaceNameIPv4)) {
                        classifiedPublicNetwork = NetworkUtility.getClassifiedPublicNetwork(resultSet);
                        if (!VerificationUtil.isStringGood(subnetIPv4)) {
                            subnetIPv4 = classifiedPublicNetwork.getSubnetAsString();
                        }
                        if (!VerificationUtil.isStringGood(interfaceNameIPv4)) {
                            interfaceNameIPv4 = classifiedPublicNetwork.getInterfaceName();
                        }
                    }
                    niInfo = new NetworkInfo();
                    niInfo.setIP(nodeVipIPv4);
                    niInfo.setSubnet(subnetIPv4);
                    niInfo.setSubnetMask(subnetMaskIPv4);
                    niInfo.setNetworkType(NetworkConstants.NetworkType.PUBLIC);
                    niInfo.setInterfaceName(interfaceNameIPv4);
                    vipList.put(nodeVipName, niInfo);
                    if (VerificationUtil.isStringGood(nodeVipName) && niInfo != null) {
                        vipList.put(nodeVipName, niInfo);
                    }
                }
                if (!VerificationUtil.isStringGood(nodeVipIPv6)) continue;
                if (nodeVipIPv6.contains("-/")) {
                    splitted = nodeVipIPv6.replace("-/", "").split("/");
                    if (nodeVipName == null) {
                        nodeVipName = splitted[0];
                    }
                    nodeVipIPv6 = splitted[1];
                }
                Trace.out((String)("\n\nIPv6 VIP INFO for node=(" + node + ")\nnodeVipName=(" + nodeVipName + ") \nnodeVip=(" + nodeVipIPv6 + ") \nnodeVipSubnet=(" + subnetIPv6 + ") \nnodeVipSubnetMask=(" + subnetMaskIPv6 + ") \nnodeVipIf=(" + interfaceNameIPv6 + ")"));
                if (!VerificationUtil.isStringGood(nodeVipName)) {
                    nodeVipName = nodeVipIPv6;
                }
                if (!VerificationUtil.isStringGood(subnetIPv6) || !VerificationUtil.isStringGood(interfaceNameIPv6)) {
                    classifiedPublicNetwork = NetworkUtility.getClassifiedPublicNetwork(resultSet);
                    Trace.out((String)"Using the Subnet and interface information from classified public network info");
                    if (!VerificationUtil.isStringGood(subnetIPv6)) {
                        subnetIPv6 = classifiedPublicNetwork.getSubnetAsString();
                    }
                    if (!VerificationUtil.isStringGood(interfaceNameIPv6)) {
                        interfaceNameIPv6 = classifiedPublicNetwork.getInterfaceName();
                    }
                }
                if (addressTypeBoth) {
                    nodeVipName = nodeVipIPv6;
                }
                niInfo = new NetworkInfo();
                niInfo.setIP(nodeVipIPv6);
                niInfo.setSubnet(subnetIPv6);
                niInfo.setSubnetMask(subnetMaskIPv6);
                niInfo.setNetworkType(NetworkConstants.NetworkType.PUBLIC);
                niInfo.setInterfaceName(interfaceNameIPv6);
                vipList.put(nodeVipName, niInfo);
                if (!VerificationUtil.isStringGood(nodeVipName) || niInfo == null) continue;
                vipList.put(nodeVipName, niInfo);
            }
        }
        return vipList;
    }

    private static Hashtable<String, NetworkInfo> parseSrvctlConfigNodeAppOutput122AndAbove(String[] output) throws NetworkException {
        Hashtable<String, NetworkInfo> nodeVipList = new Hashtable<String, NetworkInfo>();
        String subnetIPv4 = null;
        String subnetIPv6 = null;
        String subnetMaskIPv4 = null;
        String subnetMaskIPv6 = null;
        String interfaceNameIPv4 = null;
        String interfaceNameIPv6 = null;
        String vipName = null;
        String nodeName = null;
        String ipAddress = null;
        String ipv6Address = null;
        boolean isFirstEntry = true;
        if (output != null && output.length > 0) {
            for (String outputLine : output) {
                IPAddressUtil.IPAddrType addressType;
                Trace.out((String)("'srvctl config network -S 1' OUPUT Line: " + outputLine));
                if (!outputLine.startsWith("#@")) continue;
                Map<String, String> keyValueMap = NetworkUtility.getSrvctlOutputKeyValuePairs(outputLine);
                VerificationUtil.traceAndLog("VIP details from srvctl command: ");
                for (String key : keyValueMap.keySet()) {
                    VerificationUtil.traceAndLog(key + " " + keyValueMap.get(key));
                }
                if (isFirstEntry) {
                    subnetIPv4 = keyValueMap.get("subnet");
                    subnetIPv6 = keyValueMap.get("subnet6");
                    subnetMaskIPv4 = keyValueMap.get("netmask");
                    subnetMaskIPv6 = keyValueMap.get("prefixlen6");
                    isFirstEntry = false;
                    continue;
                }
                vipName = keyValueMap.get("name");
                nodeName = keyValueMap.get("node");
                ipAddress = keyValueMap.get("ip");
                ipv6Address = keyValueMap.get("ip6");
                if (VerificationUtil.isStringGood(subnetIPv4) && VerificationUtil.isStringGood(subnetIPv6)) {
                    addressType = IPAddressUtil.IPAddrType.BOTH;
                    interfaceNameIPv4 = keyValueMap.get("interfaces");
                    interfaceNameIPv6 = keyValueMap.get("interfaces");
                } else if (VerificationUtil.isStringGood(subnetIPv6) && !VerificationUtil.isStringGood(subnetIPv4)) {
                    addressType = IPAddressUtil.IPAddrType.IPv6;
                    interfaceNameIPv6 = keyValueMap.get("interfaces");
                } else {
                    addressType = IPAddressUtil.IPAddrType.IPv4;
                    interfaceNameIPv4 = keyValueMap.get("interfaces");
                }
                try {
                    String[] interfaces;
                    Inet6Address ipv6SubnetMask;
                    NetworkInfo niInfo = null;
                    if (addressType == IPAddressUtil.IPAddrType.IPv4) {
                        String[] interfaces2;
                        for (String If : interfaces2 = interfaceNameIPv4.split(",")) {
                            Trace.out((String)("\n\nAdding VIP IPv4 Public Network INFO interfaceName=(" + If + ")\n" + "interfaceSubnet=(" + subnetIPv4 + ") \n" + "interfaceSubnetMask=(" + subnetMaskIPv4 + ") \n" + "nodeName=(" + nodeName + ") \n" + "ipAddress=(" + ipAddress + ") \n" + "vipName=(" + vipName + ")"));
                            niInfo = new NetworkInfo();
                            niInfo.setSubnet(subnetIPv4);
                            niInfo.setSubnetMask(subnetMaskIPv4);
                            niInfo.setNetworkType(NetworkConstants.NetworkType.PUBLIC);
                            niInfo.setInterfaceName(If);
                            niInfo.setNodeName(nodeName);
                            niInfo.setIP(ipAddress);
                            nodeVipList.put(vipName, niInfo);
                        }
                        continue;
                    }
                    if (addressType == IPAddressUtil.IPAddrType.IPv6) {
                        ipv6SubnetMask = IPAddressUtil.getIPv6Mask((int)Integer.parseInt(subnetMaskIPv6));
                        for (String If : interfaces = interfaceNameIPv6.split(",")) {
                            Trace.out((String)("\n\nAdding VIP IPv6 Public Network INFO interfaceName=(" + If + ")\n" + "interfaceSubnet=(" + subnetIPv6 + ") \n" + "interfaceSubnetMask=(" + ipv6SubnetMask + ") \n" + "nodeName=(" + nodeName + ") \n" + "ipAddress=(" + ipv6Address + ") \n" + "vipName=(" + vipName + ")"));
                            niInfo = new NetworkInfo();
                            niInfo.setSubnet(subnetIPv6);
                            niInfo.setSubnetMask(ipv6SubnetMask);
                            niInfo.setNetworkType(NetworkConstants.NetworkType.PUBLIC);
                            niInfo.setInterfaceName(If);
                            niInfo.setNodeName(nodeName);
                            niInfo.setIP(ipv6Address);
                            nodeVipList.put(vipName, niInfo);
                        }
                        continue;
                    }
                    ipv6SubnetMask = IPAddressUtil.getIPv6Mask((int)Integer.parseInt(subnetMaskIPv6));
                    for (String If : interfaces = interfaceNameIPv6.split(",")) {
                        Trace.out((String)("\n\nIPv4 and IPv6 Public Network INFO interfaceIPv4Name=(" + If + ")\n" + "interfaceIPv4Subnet=(" + subnetIPv4 + ") \n" + "interfaceIPv4SubnetMask=(" + subnetMaskIPv4 + ")" + "interfaceIPv6Name=(" + If + ")\n" + "interfaceIPv6Subnet=(" + subnetIPv6 + ") \n" + "interfaceIPv6SubnetMask=(" + ipv6SubnetMask + ")"));
                        if (VerificationUtil.isStringGood(ipAddress)) {
                            VerificationUtil.traceAndLog("Found VIP IPv4 address " + ipAddress);
                            niInfo = new NetworkInfo();
                            niInfo.setSubnet(subnetIPv4);
                            niInfo.setSubnetMask(subnetMaskIPv4);
                            niInfo.setNetworkType(NetworkConstants.NetworkType.PUBLIC);
                            niInfo.setInterfaceName(If);
                            niInfo.setNodeName(nodeName);
                            niInfo.setIP(ipAddress);
                            nodeVipList.put(vipName, niInfo);
                        }
                        if (!VerificationUtil.isStringGood(ipv6Address)) continue;
                        VerificationUtil.traceAndLog("Found VIP IPv6 address " + ipv6Address);
                        niInfo = new NetworkInfo();
                        niInfo.setSubnet(subnetIPv6);
                        niInfo.setSubnetMask(ipv6SubnetMask);
                        niInfo.setNetworkType(NetworkConstants.NetworkType.PUBLIC);
                        niInfo.setInterfaceName(If);
                        niInfo.setNodeName(nodeName);
                        niInfo.setIP(ipv6Address);
                        nodeVipList.put(vipName, niInfo);
                    }
                }
                catch (IPAddressException ex) {
                    Trace.out((String)"Caught IPAddressException while converting IPv6 prefix length to inetAddress form");
                    Trace.out((String)("exception : " + ex.getMessage()));
                    throw new NetworkException(ex.getMessage());
                }
            }
        }
        return nodeVipList;
    }

    public static boolean areSubnetsOverlapping(HashMap<String, Set<NetworkInfo>> nodeNetworksMap, ResultSet resultSet) {
        ErrorDescription errDesc;
        String errMsg;
        boolean retVal = true;
        StringBuffer errorMsg = new StringBuffer();
        ArrayList<String> invalidNodesList = new ArrayList<String>();
        List<Object> ipRanges = new ArrayList();
        if (nodeNetworksMap == null) {
            Trace.out((String)"nodeNetworksMap is null");
            return false;
        }
        Set<Object> cluifs = new HashSet();
        try {
            cluifs = VerificationUtil.isCRSConfigured() ? NetworkDataDiscovery.getClusterNetworks(VerificationUtil.getLocalNode(), resultSet) : NetworkDataDiscovery.getClusterNetworksPreCrsInstall(VerificationUtil.getLocalNode(), resultSet);
        }
        catch (NodelistNotFoundException nodelistNotFoundException) {
            Trace.out((String)("Exception thrown while fetching cluster networks for pre CRS install msg=" + nodelistNotFoundException.getMessage()));
            errMsg = nodelistNotFoundException.getMessage();
            ReportUtil.sureprintln(errMsg);
            resultSet.addResult(VerificationUtil.getLocalNode(), 2);
            errDesc = new ErrorDescription(errMsg);
            resultSet.addErrorDescription(errDesc);
            ipRanges = null;
        }
        catch (NetworkException ne) {
            Trace.out((String)"Error while getting cluster interfaces");
            Trace.out((String)("exception : " + ne.getMessage()));
            errMsg = ne.getMessage();
            ReportUtil.sureprintln(errMsg);
            resultSet.addResult(VerificationUtil.getLocalNode(), 2);
            errDesc = new ErrorDescription(errMsg);
            resultSet.addErrorDescription(errDesc);
            ipRanges = null;
        }
        for (String node : nodeNetworksMap.keySet()) {
            ipRanges = NetworkUtility.createIpRanges(node, cluifs);
            if (ipRanges == null) {
                return false;
            }
            if (ipRanges.size() == 0) {
                Trace.out((String)"Could not find any possible overlapping subnets");
                return true;
            }
            for (int i = 0; i < ipRanges.size(); ++i) {
                SubnetIpRange ipRange2;
                SubnetIpRange ipRange1 = (SubnetIpRange)ipRanges.get(i);
                if (i + 1 >= ipRanges.size() || NetworkUtility.isSameSubnet(ipRange1, ipRange2 = (SubnetIpRange)ipRanges.get(i + 1)) || NetworkUtility.isSameInterfaceOnSameNode(ipRange1, ipRange2) || ipRange1.getEndValue() < ipRange2.getBeginValue()) continue;
                errorMsg.append(VerificationConstants.LINE_SEPARATOR + s_gMsgBundle.getMessage("11073", true, (Object[])new String[]{ipRange1.getInterfaceName(), ipRange1.getNodeName(), ipRange2.getInterfaceName(), NetworkUtility.ipLongValueToDottedDecimalFormat(ipRange1.getBeginValue()), NetworkUtility.ipLongValueToDottedDecimalFormat(ipRange1.getEndValue()), NetworkUtility.ipLongValueToDottedDecimalFormat(ipRange2.getBeginValue()), NetworkUtility.ipLongValueToDottedDecimalFormat(ipRange2.getEndValue())}));
                if (!invalidNodesList.contains(ipRange1.getNodeName())) {
                    invalidNodesList.add(ipRange1.getNodeName());
                }
                if (!invalidNodesList.contains(ipRange2.getNodeName())) {
                    invalidNodesList.add(ipRange2.getNodeName());
                }
                Trace.out((String)("Overlapping subnets Found..\nInterface " + ipRange1.getInterfaceName() + " and Interface " + ipRange2.getInterfaceName() + " have overlapping IP range.."));
                Trace.out((String)("Overlapping Interface1 :" + ipRange1.getInterfaceName()));
                Trace.out((String)("Network Ip: " + NetworkUtility.ipLongValueToDottedDecimalFormat(ipRange1.getBeginValue())));
                Trace.out((String)("Broadcast Ip: " + NetworkUtility.ipLongValueToDottedDecimalFormat(ipRange1.getEndValue())));
                Trace.out((String)("Overlapping Interface2 :" + ipRange2.getInterfaceName()));
                Trace.out((String)("Network Ip: " + NetworkUtility.ipLongValueToDottedDecimalFormat(ipRange2.getBeginValue())));
                Trace.out((String)("Broadcast Ip: " + NetworkUtility.ipLongValueToDottedDecimalFormat(ipRange2.getEndValue())));
            }
        }
        if (errorMsg.length() > 0) {
            retVal = false;
            ReportUtil.printError(errorMsg.toString());
            ErrorDescription errDesc2 = new ErrorDescription(errorMsg.toString());
            resultSet.addResult(invalidNodesList.toArray(new String[0]), 3);
            resultSet.addErrorDescription(invalidNodesList.toArray(new String[0]), errDesc2);
        }
        return retVal;
    }

    public static int getCidrValue(String subnetMask) {
        long ipLongValue = NetworkUtility.convertIpToLongValue(subnetMask);
        if (ipLongValue >= 0xFFFFFFFFL) {
            return 32;
        }
        int cidrValue = (int)ipLongValue;
        cidrValue -= cidrValue >>> 1 & 0x55555555;
        cidrValue = (cidrValue & 0x33333333) + (cidrValue >>> 2 & 0x33333333);
        cidrValue = cidrValue + (cidrValue >>> 4) & 0xF0F0F0F;
        cidrValue += cidrValue >>> 8;
        cidrValue += cidrValue >>> 16;
        return cidrValue & 0x3F;
    }

    public static final String ipLongValueToDottedDecimalFormat(long ipLongValue) {
        StringBuilder ipAddress = new StringBuilder();
        for (int i = 3; i >= 0; --i) {
            int shift = i * 8;
            ipAddress.append((ipLongValue & (long)(255 << shift)) >> shift);
            if (i <= 0) continue;
            ipAddress.append(".");
        }
        return ipAddress.toString();
    }

    public static final long convertIpToLongValue(String ipAddress) {
        long ipLongValue = 0L;
        try {
            InetAddress Address = InetAddress.getByName(ipAddress);
            for (byte b : Address.getAddress()) {
                ipLongValue = ipLongValue << 8 | (long)(b & 0xFF);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return ipLongValue;
    }

    public static String getNetworkId(String ipAddress, String subnetMask) {
        long netWorkLongValue = 0L;
        int cidrValue = NetworkUtility.getCidrValue(subnetMask);
        long netMaskValue = 0L;
        long ipLongValue = NetworkUtility.convertIpToLongValue(ipAddress);
        for (int i = 0; i < cidrValue; ++i) {
            netMaskValue |= (long)(1 << 31 - i);
        }
        netWorkLongValue = ipLongValue & netMaskValue;
        return NetworkUtility.ipLongValueToDottedDecimalFormat(netWorkLongValue);
    }

    public static String getBroadcastId(String ipAddress, String subnetMask) {
        long broadcastLongValue = 0L;
        int cidrValue = NetworkUtility.getCidrValue(subnetMask);
        long netMaskValue = 0L;
        long ipLongValue = NetworkUtility.convertIpToLongValue(ipAddress);
        for (int i = 0; i < cidrValue; ++i) {
            netMaskValue |= (long)(1 << 31 - i);
        }
        broadcastLongValue = ipLongValue | netMaskValue ^ 0xFFFFFFFFFFFFFFFFL;
        return NetworkUtility.ipLongValueToDottedDecimalFormat(broadcastLongValue);
    }

    private static List<SubnetIpRange> createIpRanges(String node, Set<NetworkInfo> cluifs) {
        ArrayList<SubnetIpRange> ipRanges = new ArrayList<SubnetIpRange>();
        if (!NetworkUtility.isNetworksSetGood(cluifs)) {
            Trace.out((String)"cluster interfaces could not be found");
            return ipRanges;
        }
        for (NetworkInfo cluif : cluifs) {
            String subnet = cluif.getSubnetAsString();
            String subnetMask = cluif.getSubnetMaskAsString();
            if (!VerificationUtil.isStringGood(subnet) || !VerificationUtil.isStringGood(subnetMask) || !IPAddressUtil.isIPv4AddressString((String)subnet)) continue;
            String networkId = NetworkUtility.getNetworkId(subnet, subnetMask);
            String broadcastId = NetworkUtility.getBroadcastId(subnet, subnetMask);
            long beginValue = NetworkUtility.convertIpToLongValue(networkId);
            long endValue = NetworkUtility.convertIpToLongValue(broadcastId);
            ipRanges.add(new SubnetIpRange(beginValue, endValue, cluif.getInterfaceName(), node, cluif.getNetworkType()));
        }
        if (ipRanges.size() == 0) {
            return ipRanges;
        }
        Collections.sort(ipRanges);
        return ipRanges;
    }

    private static boolean isSameInterfaceOnSameNode(SubnetIpRange ip1, SubnetIpRange ip2) {
        boolean retVal = false;
        if (ip1.getInterfaceName().equals(ip2.getInterfaceName())) {
            retVal = true;
        }
        return retVal;
    }

    private static boolean isSameSubnet(SubnetIpRange ip1, SubnetIpRange ip2) {
        boolean retVal = false;
        if ((ip1.getNetworkType() & ip2.getNetworkType()) != 0 && ip1.getBeginValue() == ip2.getBeginValue() && ip1.getEndValue() == ip2.getEndValue()) {
            retVal = true;
        }
        return retVal;
    }

    public static Set<NetworkInfo> getClusterNetworks(String[] nodes, ResultSet resultSet) throws NetworkException {
        Set<NetworkInfo> clusterNetworks = new HashSet<NetworkInfo>();
        Trace.out((String)"Trying to get cluster network interface info");
        try {
            ClusterwareInfo cluInfo = new ClusterwareInfo();
            List cluIfs = null;
            String crsHome = VerificationUtil.getCRSHome();
            String oifcfgLoc = crsHome + VerificationConstants.FILE_SEPARATOR + "bin";
            String strCrsVer = VerificationUtil.getCRSReleaseVersion(crsHome, false);
            try {
                Version crsVer = VerificationUtil.getVersionObject(strCrsVer);
                cluIfs = cluInfo.listClusterInterfaces(oifcfgLoc, crsVer);
            }
            catch (ConfigurationException cEx) {
                Trace.out((String)("ConfigurationException occured while getting version object. strCrsVer=" + strCrsVer + ", Msg=" + cEx.getMessage()));
                cluIfs = cluInfo.listClusterInterfaces(oifcfgLoc);
            }
            if (cluIfs.size() > 0) {
                Trace.out((String)"Network details from OIFCFG: ");
            }
            for (OIFCFGResult cluIf : cluIfs) {
                NetworkInfo network = new NetworkInfo();
                network.setInterfaceName(cluIf.getInterfaceName());
                network.setSubnet(cluIf.getSubnet());
                network.setNetworkType(cluIf.getInterfaceType());
                String scope = cluIf.getNodeScope();
                scope = scope == null ? "" : scope.trim();
                network.setIfNameGlobalLogicalInterface(scope.equalsIgnoreCase("global"));
                network.setInterfaceScope(scope);
                Trace.out((String)("ifName=" + network.getInterfaceName() + ",subnet=" + network.getSubnetAsString() + ",netType=" + network.getNetworkTypeAsString() + ",isIfNameGlobals=" + network.isIfNameGlobalLogicalInterface() + ", Scope=" + network.getInterfaceScope()));
                clusterNetworks.add(network);
            }
            if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
                VerificationUtil.traceAndLogError("Failed to retrieve the list of network networks and subnets");
            } else {
                clusterNetworks = NetworkDataDiscovery.getMissingNetworksDetailsForClusterNetworks(clusterNetworks, resultSet);
            }
        }
        catch (InstallException iex) {
            Trace.out((String)"Error while getting cluster interfaces");
            Trace.out((String)("exception : " + iex.getMessage()));
            throw new NetworkException(iex.getMessage());
        }
        Trace.out((String)"End of geting cluster network interfaces info.");
        return clusterNetworks;
    }

    public static Set<NetworkInfo> getAllPublicNetworks() throws NetworkException {
        ResultSet resultSet = new ResultSet();
        Set<NetworkInfo> publicClusterNetworks = NetworkDataDiscovery.getClusterNetworks(VerificationUtil.getLocalNode(), resultSet);
        if (resultSet.anyFailure()) {
            Trace.out((String)"Could not discover the network details successfully");
            ArrayList<String> errorStrings = new ArrayList<String>();
            for (VerificationError error : resultSet.getErrors()) {
                errorStrings.add(error.getErrorMessage());
            }
            throw new NetworkException(VerificationUtil.strList2List(errorStrings));
        }
        NetworkDataDiscovery.getClusterNetworksByType(publicClusterNetworks, NetworkConstants.NetworkType.PUBLIC);
        publicClusterNetworks.addAll(NetworkUtility.fetchSrvctlConfigNetworkIfs(VerificationUtil.getLocalHostName()));
        return publicClusterNetworks;
    }

    public static Set<NetworkInfo> createClusterNetworksBasedOnSubnets(String[] subnets) {
        HashSet<NetworkInfo> networks = new HashSet<NetworkInfo>();
        for (String subnet : subnets) {
            NetworkInfo network = new NetworkInfo();
            network.setInterfaceName("*");
            network.setNetworkType(NetworkConstants.NetworkType.PUBLIC);
            network.setSubnet(subnet);
            network.setIfNameGlobalLogicalInterface(true);
            network.setInterfaceScope("global");
            networks.add(network);
        }
        return networks;
    }

    public static Set<NetworkInfo> createClusterNetworksBasedOnNetworkNames(String[] networkNames) {
        HashSet<NetworkInfo> networks = new HashSet<NetworkInfo>();
        for (String networkName : networkNames) {
            NetworkInfo network = new NetworkInfo();
            network.setInterfaceName(networkName);
            network.setNetworkType(NetworkConstants.NetworkType.PUBLIC);
            networks.add(network);
        }
        return networks;
    }

    public static Set<NetworkInfo> fetchSrvctlConfigNetworkIfs(String node) throws NetworkException {
        HashSet<NetworkInfo> networkIfListFromSrvctl = new HashSet<NetworkInfo>();
        String crsHome = VerificationUtil.getCRSHome();
        try {
            SRVCTLUtil srvctl = new SRVCTLUtil(crsHome);
            String[] srvctlArguments = new String[]{"config", "network", "-S", "1"};
            CommandResult result = srvctl.runCommand(node, srvctlArguments);
            if (!result.getBooleanResult()) {
                String[] errorString = result.getResultString();
                if (errorString != null && errorString.length > 0) {
                    Trace.out((String)"SRVCTL config network command failed");
                    StringBuilder sb = new StringBuilder("");
                    for (int i = 0; i < errorString.length; ++i) {
                        sb.append(errorString[i]);
                    }
                    throw new NetworkException(s_gMsgBundle.getMessage("5835", true) + VerificationConstants.LINE_SEPARATOR + sb.toString());
                }
            } else {
                networkIfListFromSrvctl.addAll(NetworkUtility.getNetIfsFromSrvctlConfigNetworkCommand(result.getResultString()));
            }
        }
        catch (CmdToolUtilException cte) {
            Trace.out((String)("Caught CmdToolUtilException - while running srvctl config network command " + cte.getMessage()));
            throw new NetworkException(s_gMsgBundle.getMessage("5836", true), cte);
        }
        return networkIfListFromSrvctl;
    }

    private static Set<NetworkInfo> getNetIfsFromSrvctlConfigNetworkCommand(String[] output) throws NetworkException {
        HashSet<NetworkInfo> networkInterfaceList = new HashSet<NetworkInfo>();
        String subnetIPv4 = null;
        String subnetIPv6 = null;
        String subnetMaskIPv4 = null;
        String subnetMaskIPv6 = null;
        String interfaceNameIPv4 = null;
        String interfaceNameIPv6 = null;
        if (output != null && output.length > 0) {
            for (String outputLine : output) {
                Trace.out((String)("'srvctl config network -S 1' OUPUT Line: " + outputLine));
                if (!outputLine.startsWith("#@")) continue;
                Map<String, String> keyValueMap = NetworkUtility.getSrvctlOutputKeyValuePairs(outputLine);
                subnetIPv4 = keyValueMap.get("subnet");
                subnetIPv6 = keyValueMap.get("subnet6");
                subnetMaskIPv4 = keyValueMap.get("netmask");
                subnetMaskIPv6 = keyValueMap.get("prefixlen6");
                interfaceNameIPv4 = interfaceNameIPv6 = keyValueMap.get("interfaces");
                IPAddressUtil.IPAddrType addressType = VerificationUtil.isStringGood(subnetIPv4) && VerificationUtil.isStringGood(subnetIPv6) ? IPAddressUtil.IPAddrType.BOTH : (VerificationUtil.isStringGood(subnetIPv6) && !VerificationUtil.isStringGood(subnetIPv4) ? IPAddressUtil.IPAddrType.IPv6 : IPAddressUtil.IPAddrType.IPv4);
                try {
                    String[] interfaces;
                    Inet6Address ipv6SubnetMask;
                    NetworkInfo niInfo = null;
                    if (addressType == IPAddressUtil.IPAddrType.IPv4) {
                        String[] interfaces2;
                        for (String If : interfaces2 = interfaceNameIPv4.split(",")) {
                            Trace.out((String)("\n\nAdding IPv4 Public Network INFO interfaceName=(" + If + ")\n" + "interfaceSubnet=(" + subnetIPv4 + ") \n" + "interfaceSubnetMask=(" + subnetMaskIPv4 + ")"));
                            niInfo = new NetworkInfo();
                            niInfo.setSubnet(subnetIPv4);
                            niInfo.setSubnetMask(subnetMaskIPv4);
                            niInfo.setNetworkType(NetworkConstants.NetworkType.PUBLIC);
                            niInfo.setInterfaceName(If);
                            networkInterfaceList.add(niInfo);
                        }
                        continue;
                    }
                    if (addressType == IPAddressUtil.IPAddrType.IPv6) {
                        ipv6SubnetMask = IPAddressUtil.getIPv6Mask((int)Integer.parseInt(subnetMaskIPv6));
                        for (String If : interfaces = interfaceNameIPv6.split(",")) {
                            Trace.out((String)("\n\nAdding IPv6 Public Network INFO interfaceName=(" + If + ")\n" + "interfaceSubnet=(" + subnetIPv6 + ") \n" + "interfaceIPv6SubnetMask=(" + ipv6SubnetMask + ")"));
                            niInfo = new NetworkInfo();
                            niInfo.setSubnet(subnetIPv6);
                            niInfo.setSubnetMask(ipv6SubnetMask);
                            niInfo.setNetworkType(NetworkConstants.NetworkType.PUBLIC);
                            niInfo.setInterfaceName(If);
                            networkInterfaceList.add(niInfo);
                        }
                        continue;
                    }
                    ipv6SubnetMask = IPAddressUtil.getIPv6Mask((int)Integer.parseInt(subnetMaskIPv6));
                    for (String If : interfaces = interfaceNameIPv6.split(",")) {
                        Trace.out((String)("\n\nAdding IPv4 and IPv6 Public Network INFO interfaceIPv4Name=(" + If + ")\n" + "interfaceIPv4Subnet=(" + subnetIPv4 + ") \n" + "interfaceIPv4SubnetMask=(" + subnetMaskIPv4 + ")" + "interfaceIPv6Name=(" + If + ")\n" + "interfaceIPv6Subnet=(" + subnetIPv6 + ") \n" + "interfaceIPv6SubnetMask=(" + ipv6SubnetMask + ")"));
                        niInfo = new NetworkInfo();
                        niInfo.setSubnet(subnetIPv4);
                        niInfo.setSubnetMask(subnetMaskIPv4);
                        niInfo.setNetworkType(NetworkConstants.NetworkType.PUBLIC);
                        niInfo.setInterfaceName(If);
                        networkInterfaceList.add(niInfo);
                        niInfo = new NetworkInfo();
                        niInfo.setSubnet(subnetIPv6);
                        niInfo.setSubnetMask(ipv6SubnetMask);
                        niInfo.setNetworkType(NetworkConstants.NetworkType.PUBLIC);
                        niInfo.setInterfaceName(If);
                        networkInterfaceList.add(niInfo);
                    }
                }
                catch (IPAddressException ex) {
                    Trace.out((String)"Caught IPAddressException while converting IPv6 prefix length to inetAddress form");
                    Trace.out((String)("exception : " + ex.getMessage()));
                    throw new NetworkException(ex.getMessage());
                }
            }
        }
        return networkInterfaceList;
    }

    private static Map<String, String> getSrvctlOutputKeyValuePairs(String outputLine) {
        String[] keyValuePairs;
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        String modifiedLine = outputLine.replace("uses ssl:=", "uses_ssl=");
        for (String keyValuePair : keyValuePairs = modifiedLine.split("[\\s]+")) {
            if (keyValuePair == keyValuePairs[0]) continue;
            String[] keyValue = keyValuePair.replace("={", "=").replace("}", "").split("=");
            if (keyValue.length != 2) {
                keyValueMap.put(keyValue[0], "");
                continue;
            }
            keyValueMap.put(keyValue[0], keyValue[1]);
        }
        return keyValueMap;
    }

    public static List<NetworkInfo> getNetworkInfoListWithMatchingSubnet(List<OIFCFGResult> cluIfs, String[] nodes) throws UnknownHostException, NodelistNotFoundException, NetworkException {
        ArrayList<NetworkInfo> matchingNetworks = new ArrayList<NetworkInfo>();
        for (OIFCFGResult cluIf : cluIfs) {
            HashMap<String, Set<NetworkInfo>> nodeNetworksMap = new HashMap();
            ResultSet resultSet = new ResultSet();
            nodeNetworksMap = NetworkDataDiscovery.getNodeNetworksMap(nodes, resultSet);
            if (resultSet.anyFailure()) {
                Trace.out((String)"Could not discover the network details successfully");
                ArrayList<String> errorStrings = new ArrayList<String>();
                for (VerificationError error : resultSet.getErrors()) {
                    errorStrings.add(error.getErrorMessage());
                }
                throw new NetworkException(VerificationUtil.strList2List(errorStrings));
            }
            nodeNetworksMap = NetworkDataDiscovery.getNetworksBySubnetAndName(nodeNetworksMap, nodes, cluIf.getSubnet().getHostAddress(), cluIf.getInterfaceName());
            for (String node : nodeNetworksMap.keySet()) {
                Trace.out((String)("Cluster interface: " + cluIf.getInterfaceName() + " Cluster subnet " + cluIf.getSubnet()));
                for (NetworkInfo network : nodeNetworksMap.get(node)) {
                    Trace.out((String)("Network interface: " + network.getInterfaceName() + " Network subnet " + network.getSubnetAsString()));
                    network.setNetworkType(cluIf.getInterfaceType());
                    matchingNetworks.add(network);
                }
            }
        }
        return matchingNetworks;
    }

    public static List<NetworkInfo> getClusterIfsPreCrsInst(String node, ResultSet resultSet) throws NetworkException {
        ArrayList<NetworkInfo> networks = new ArrayList<NetworkInfo>();
        try {
            networks.addAll(NetworkDataDiscovery.getClusterNetworksFromCVUVariable(resultSet));
        }
        catch (CVUException cvuEx) {
            String errMsg = cvuEx.getMessage();
            Trace.out((String)("Exception occured while getting network information. msg=" + errMsg));
            resultSet.addResult(node, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            resultSet.addErrorDescription(node, errDesc);
            ReportUtil.sureprintln(errMsg);
            Trace.out((String)"Error while getting cluster interfaces");
            throw new NetworkException(errMsg);
        }
        return networks;
    }

    public static boolean isSameType(int netType1, int netType2) {
        return netType1 == netType2 || (netType1 & netType2) != 0;
    }

    public static boolean isIPV4(NetworkInfo network, boolean ignoreAddressTypeBoth) {
        if (ignoreAddressTypeBoth) {
            return IPAddressUtil.IPAddrType.IPv4.equals((Object)network.getIpAddressType());
        }
        return IPAddressUtil.IPAddrType.BOTH.equals((Object)network.getIpAddressType()) || IPAddressUtil.IPAddrType.IPv4.equals((Object)network.getIpAddressType());
    }

    public static boolean isIPV6(NetworkInfo network, boolean ignoreAddressTypeBoth) {
        if (ignoreAddressTypeBoth) {
            return IPAddressUtil.IPAddrType.IPv6.equals((Object)network.getIpAddressType());
        }
        return IPAddressUtil.IPAddrType.BOTH.equals((Object)network.getIpAddressType()) || IPAddressUtil.IPAddrType.IPv6.equals((Object)network.getIpAddressType());
    }

    public static boolean isIPV6PrivateNetwork(ResultSet resultSet) {
        try {
            Set<NetworkInfo> networkInfoList = NetworkUtility.getNetworkInfo(resultSet);
            Set<NetworkInfo> onlyPrivateNetworks = NetworkDataDiscovery.getClusterNetworksByType(networkInfoList, NetworkConstants.NetworkType.PRIVATE);
            if (!onlyPrivateNetworks.isEmpty()) {
                for (NetworkInfo pvtNetwork : onlyPrivateNetworks) {
                    if (!NetworkUtility.isIPV6(pvtNetwork, false)) continue;
                    Trace.out((String)("Found private network (" + pvtNetwork.toString() + ") on IPV6. Returning true."));
                    resultSet.clear();
                    resultSet.setStatus(1);
                    return true;
                }
            }
        }
        catch (CVUException e) {
            Trace.out((String)("Caught CVUException " + e.getMessage()));
            resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            resultSet.setStatus(2);
        }
        return false;
    }

    public static boolean isAddressTypeBoth(NetworkInfo netInfo) {
        return IPAddressUtil.IPAddrType.BOTH.equals((Object)netInfo.getIpAddressType());
    }

    public static NetworkConstants.NetworkType getNetworkTypeFromString(String nwType) {
        NetworkConstants.NetworkType netType = NetworkConstants.NetworkType.UNKNOWN;
        if (!VerificationUtil.isStringGood(nwType)) {
            return NetworkConstants.NetworkType.UNKNOWN;
        }
        netType = "PUBLIC".equalsIgnoreCase(nwType) || "PUB".equalsIgnoreCase(nwType) ? NetworkConstants.NetworkType.PUBLIC : ("PVT".equalsIgnoreCase(nwType) || "PRIVATE".equalsIgnoreCase(nwType) || "CLUSTER_INTERCONNECT".equalsIgnoreCase(nwType) ? NetworkConstants.NetworkType.PRIVATE : ("ASM".equalsIgnoreCase(nwType) ? NetworkConstants.NetworkType.ASM : NetworkConstants.NetworkType.UNKNOWN));
        return netType;
    }

    public static String inetAddressCollectionToString(Collection<InetAddress> collection) {
        String collectionStr = "";
        if (collection != null) {
            ArrayList<String> addressList = new ArrayList<String>();
            for (InetAddress address : collection) {
                addressList.add(address.getHostAddress());
            }
            collectionStr = VerificationUtil.strCollection2String(addressList);
        }
        return collectionStr;
    }

    public static InetAddress getInetAddressFromString(String ipAddress) {
        try {
            return InetAddress.getByName(ipAddress);
        }
        catch (UnknownHostException e) {
            Trace.out((String)("Exception thrown while getting InetAddress from " + ipAddress));
            return null;
        }
    }

    public static Set<NetworkInfo> expandSubnetIPv6Addresses(Set<NetworkInfo> networks) {
        HashSet<NetworkInfo> modifiedNetworks = new HashSet<NetworkInfo>();
        if (!NetworkUtility.isNetworksSetGood(networks)) {
            return networks;
        }
        for (NetworkInfo network : networks) {
            String subnetId = network.getSubnetAsString();
            if (VerificationUtil.isStringGood(subnetId)) {
                if (IPAddressUtil.isIPv6AddressString((String)subnetId)) {
                    try {
                        network.setSubnet(IPAddressUtil.getFullIPv6Notation((String)subnetId, (boolean)false));
                        modifiedNetworks.add(network);
                    }
                    catch (IPAddressException e) {
                        Trace.out((String)"IPAddressException while setting networks to consider");
                    }
                    continue;
                }
                modifiedNetworks.add(network);
                continue;
            }
            modifiedNetworks.add(network);
        }
        return modifiedNetworks;
    }

    public static Set<NetworkInfo> skipIPv6LinkLocalAndLoopbackAddresses(Set<NetworkInfo> networks) {
        HashSet<NetworkInfo> modifiedNetworks = new HashSet<NetworkInfo>();
        if (!NetworkUtility.isNetworksSetGood(networks)) {
            return networks;
        }
        for (NetworkInfo network : networks) {
            String subnetId = network.getSubnetAsString();
            String ipAddress = network.getIPAsString();
            if (VerificationUtil.isStringGood(subnetId)) {
                if (!NetworkUtility.checkSameIPAddresses(subnetId, IPV6_LOCALHOST_IP) && !subnetId.toLowerCase().startsWith("fe80")) {
                    modifiedNetworks.add(network);
                    continue;
                }
                Trace.out((String)("Skipping loopback/link-local IPv6 subnet " + network.getSubnetAsString()));
                continue;
            }
            if (VerificationUtil.isStringGood(ipAddress)) {
                if (!NetworkUtility.checkSameIPAddresses(ipAddress, IPV6_LOCALHOST_IP) && !ipAddress.toLowerCase().startsWith("fe80")) {
                    modifiedNetworks.add(network);
                    continue;
                }
                Trace.out((String)("Skipping loopback/link-local IPv6 addresses " + network.getSubnetAsString()));
                continue;
            }
            modifiedNetworks.add(network);
        }
        return modifiedNetworks;
    }

    public static HashMap<String, List<String[]>> getFailedNodeNetworkDetailsMap(Set<NetworkInfo> allFailedNetworks) {
        HashMap<String, List<String[]>> failedNodeNetworkDetailsMap = new HashMap<String, List<String[]>>();
        HashMap<String, Set<NetworkInfo>> nodeNetworksMap = NetworkDataDiscovery.getNodeNetworksMap(allFailedNetworks);
        for (String node : nodeNetworksMap.keySet()) {
            ArrayList<String[]> networkDetailsOnNode = new ArrayList<String[]>();
            HashSet<String> networkNames = new HashSet<String>();
            HashSet<String> subnets = new HashSet<String>();
            HashSet<String> ipAddresses = new HashSet<String>();
            HashSet<String> subnetMasks = new HashSet<String>();
            ArrayList<String> mtuValues = new ArrayList<String>();
            for (NetworkInfo network : nodeNetworksMap.get(node)) {
                networkNames.add(network.getInterfaceName());
                subnets.add(network.getSubnetAsString());
                ipAddresses.add(network.getIPAsString());
                subnetMasks.add(network.getSubnetMaskAsString());
                mtuValues.add(String.valueOf(network.getMTU()));
            }
            networkDetailsOnNode.add(networkNames.toArray(new String[0]));
            networkDetailsOnNode.add(subnets.toArray(new String[0]));
            networkDetailsOnNode.add(ipAddresses.toArray(new String[0]));
            networkDetailsOnNode.add(subnetMasks.toArray(new String[0]));
            networkDetailsOnNode.add(mtuValues.toArray(new String[0]));
            failedNodeNetworkDetailsMap.put(node, networkDetailsOnNode);
        }
        return failedNodeNetworkDetailsMap;
    }

    public static String[] getNetworkNamesFromFailedNodeNetworkDetails(List<String[]> failedNodeNetworkDetails) {
        return failedNodeNetworkDetails.get(0);
    }

    public static String[] getSubnetsFromFailedNodeNetworkDetails(List<String[]> failedNodeNetworkDetails) {
        return failedNodeNetworkDetails.get(1);
    }

    public static String[] getIPAddressesFromFailedNodeNetworkDetails(List<String[]> failedNodeNetworkDetails) {
        return failedNodeNetworkDetails.get(2);
    }

    public static String[] getSubnetMasksFromFailedNodeNetworkDetails(List<String[]> failedNodeNetworkDetails) {
        return failedNodeNetworkDetails.get(3);
    }

    public static String[] getMtuValuesFromFailedNodeNetworkDetails(List<String[]> failedNodeNetworkDetails) {
        return failedNodeNetworkDetails.get(4);
    }

    public static boolean isNetworksMapGood(HashMap<String, Set<NetworkInfo>> map) {
        return map != null && !map.isEmpty();
    }

    public static boolean isNetworksSetGood(Set<NetworkInfo> set) {
        return set != null && !set.isEmpty();
    }

    public static void reportResultSet(ResultSet networksResultSet, ResultSet resultSet, boolean uploadResultSet) {
        boolean errorFound = false;
        if (networksResultSet != null && networksResultSet.anyFailure()) {
            for (VerificationError error : networksResultSet.getErrors()) {
                errorFound = true;
                String errorMessage = error.getErrorMessage();
                Trace.out((String)("Error Message: " + errorMessage));
                ReportUtil.printError(errorMessage);
            }
            if (errorFound && uploadResultSet) {
                resultSet.addResultSetData(networksResultSet);
            }
        }
    }

    public static boolean validateNetworksArg(String node, ParamManager paramMgr, ResultSet resultSet) {
        if (CVUVariables.getValue(CVUVariableConstants.NETWORK_LIST) == null) {
            return true;
        }
        ResultSet networkResultSet = new ResultSet();
        String argInterfaceList = CVUVariables.getValue(CVUVariableConstants.NETWORK_LIST);
        Set<NetworkInfo> clusterNetworks = null;
        clusterNetworks = NetworkDataDiscovery.getClusterNetworksFromPMArgument(argInterfaceList, node, networkResultSet);
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            Trace.out((String)"Could not fetch the network details successfully from PM argument");
            NetworkUtility.reportResultSet(networkResultSet, resultSet, true);
            return false;
        }
        String strInterConnectList = NetworkDataDiscovery.getClusterInterConnectList(clusterNetworks);
        if (!VerificationUtil.isStringGood(strInterConnectList)) {
            Trace.out((String)"This should not happen.  Could not form valid interconnect list string from PM networks argument");
            String errorMessage = s_msgBundle.getMessage("7508", false);
            ResultSet.updateResultSetWithErrorDescription(errorMessage, resultSet, new String[]{node}, false, true);
            return false;
        }
        CVUVariables.setValue(CVUVariableConstants.INTERCONNECT_LIST, strInterConnectList);
        return true;
    }

    public static List<Subnet> getSubnetsFromNodeNetworksMap(HashMap<String, Set<NetworkInfo>> nodeNetworksMap, boolean onlyIpv4, ResultSet resultSet) {
        HashMap<String, Set<NetworkInfo>> subnetNetworksMap = NetworkDataDiscovery.getSubnetNetworksMap(nodeNetworksMap, resultSet);
        if (!NetworkUtility.isNetworksMapGood(subnetNetworksMap)) {
            return null;
        }
        Collection<Subnet> subnetsCollection = Subnet.classifyToSubnets(subnetNetworksMap);
        List<Subnet> subnets = new ArrayList<Subnet>(subnetsCollection);
        if (onlyIpv4) {
            subnets = Subnet.getIPv4Subnets(subnets);
        }
        return subnets;
    }

    public static boolean getPublicClusterNetworks(Set<NetworkInfo> clusterNetworks, String[] nodeList, ResultSet resultSet) {
        ResultSet networksResultSet = new ResultSet();
        try {
            clusterNetworks = NetworkDataDiscovery.getClusterNetworksFromOifcfg(networksResultSet);
        }
        catch (CVUException cvuException) {
            ResultSet.updateResultSetWithErrorDescription(cvuException.getMessage(), networksResultSet, nodeList, false, true);
            return false;
        }
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            Trace.out((String)"Could not discover cluster public network details successfully");
            for (VerificationError error : networksResultSet.getErrors()) {
                String errorMsg = error.getErrorMessage();
                Trace.out((String)errorMsg);
            }
            NetworkUtility.reportResultSet(networksResultSet, resultSet, true);
            return false;
        }
        if (!NetworkDataDiscovery.hasNetworkTypeInClusterNetworks(clusterNetworks, NetworkConstants.NetworkType.PUBLIC.getValue())) {
            Trace.out((String)"No public cluster networks found.  Hence returning success");
            return true;
        }
        clusterNetworks = NetworkDataDiscovery.getClusterNetworksByType(clusterNetworks, NetworkConstants.NetworkType.PUBLIC);
        return true;
    }

    public static void clearCache() {
        m_localNodeNetworkInfo = null;
    }

    public static List<String> getIPsOnNetworks(Set<NetworkInfo> networks) {
        ArrayList<String> allIPs = new ArrayList<String>();
        for (NetworkInfo network : networks) {
            allIPs.add(network.getIPAsString());
        }
        return allIPs;
    }

    protected static boolean copyFileOnRemoteNodes(HashMap<String, String> nodeFilesMap, ResultSet resultSet, boolean addExtension) {
        Trace.out((String)("Start copying file to the nodes " + VerificationUtil.strCollection2String(nodeFilesMap.keySet())));
        String[] nodeList = nodeFilesMap.keySet().toArray(new String[0]);
        ArrayList<String> nodeFiles = new ArrayList<String>();
        for (String node : nodeList) {
            nodeFiles.add(nodeFilesMap.get(node));
        }
        ArrayList<CopyFileCommand> copyCommands = new ArrayList<CopyFileCommand>();
        for (String node : nodeFilesMap.keySet()) {
            String fileToBeCopied = nodeFilesMap.get(node);
            if (!VerificationUtil.isStringGood(fileToBeCopied)) continue;
            Trace.out((String)("copy file " + fileToBeCopied + " to node " + node));
            copyCommands.add(new CopyFileCommand(node, fileToBeCopied, fileToBeCopied.concat(".in")));
        }
        boolean cmdResult = new GlobalHandler().submit(copyCommands.toArray(new Command[0]), 0, resultSet);
        resultSet.traceResultSet("copyFile");
        return cmdResult && 1 == resultSet.getStatus();
    }

    protected static boolean createAndCopyPingCommandInputFile(ConMatrix connectivityMatrix, ResultSet resultSet, String[] nodes) {
        HashMap<String, String> nodeFileMap = new HashMap<String, String>();
        boolean retVal = true;
        for (String node : nodes) {
            HashMap<String, Set<String>> sourceDestinationMap = connectivityMatrix.getSourceDestinationMap(node);
            Set<String> sourceIps = sourceDestinationMap.keySet();
            if (sourceDestinationMap.isEmpty()) continue;
            String fileNameForNode = ICMPPingCommand.getLocalPingFileName(node, String.valueOf(Thread.currentThread().getId()));
            VerificationUtil.traceAndLog("File name for the node " + node + " with subnet " + connectivityMatrix.getKey() + " is " + fileNameForNode);
            File pingFile = new File(fileNameForNode);
            pingFile.deleteOnExit();
            try {
                if (!pingFile.createNewFile()) {
                    pingFile.delete();
                }
                pingFile.createNewFile();
                BufferedWriter bufferWriter = new BufferedWriter(new FileWriter(pingFile, true));
                StringBuffer output = new StringBuffer();
                output.append("<SOURCE_IP_SIZE>");
                output.append(VerificationUtil.LSEP);
                output.append(String.valueOf(sourceIps.size()));
                output.append(VerificationUtil.LSEP);
                output.append("</SOURCE_IP_SIZE>");
                for (String sourceIp : sourceIps) {
                    output.append(VerificationUtil.LSEP);
                    output.append("<SOURCE_IP>");
                    output.append(VerificationUtil.LSEP);
                    output.append(sourceIp);
                    output.append(VerificationUtil.LSEP);
                    Set<String> destinationIpsForThisSource = sourceDestinationMap.get(sourceIp);
                    if (destinationIpsForThisSource.isEmpty()) {
                        output.append("</SOURCE_IP>");
                        continue;
                    }
                    output.append("<DEST_IPS>");
                    for (String destinationIp : destinationIpsForThisSource) {
                        output.append(VerificationUtil.LSEP);
                        output.append(destinationIp);
                    }
                    output.append(VerificationUtil.LSEP);
                    output.append("</DEST_IPS>");
                    output.append(VerificationUtil.LSEP);
                    output.append("</SOURCE_IP>");
                }
                output.append(VerificationUtil.LSEP);
                if (output.length() != 0) {
                    bufferWriter.write(output.toString());
                }
                bufferWriter.close();
            }
            catch (IOException e) {
                String errorMessage = s_gMsgBundle.getMessage("11096", true, (Object[])new String[]{fileNameForNode, VerificationUtil.getCVUSubDirPath(), node});
                VerificationUtil.traceAndLog("Exception caught while creating ping input file " + errorMessage);
                if (VerificationUtil.isStringGood(e.getMessage())) {
                    errorMessage = errorMessage + VerificationUtil.LSEP + e.getMessage();
                }
                ErrorDescription errorDesc = new ErrorDescription(errorMessage);
                resultSet.addErrorDescription(node, errorDesc);
                resultSet.addResult(node, 2);
                return false;
            }
            nodeFileMap.put(node, fileNameForNode);
        }
        ResultSet copyResultSet = new ResultSet();
        retVal = NetworkUtility.copyFileOnRemoteNodes(nodeFileMap, copyResultSet, true);
        if (!copyResultSet.anySuccess()) {
            resultSet.addResultSetData(copyResultSet);
        }
        VerificationUtil.traceAndLog("Deleting the ping files on the nodes " + VerificationUtil.strCollection2String(nodeFileMap.keySet()));
        for (String node : nodeFileMap.keySet()) {
            File file;
            String fileToBeDeleted = nodeFileMap.get(node);
            if (!VerificationUtil.isStringGood(fileToBeDeleted) || (file = new File(fileToBeDeleted)).delete()) continue;
            VerificationUtil.traceAndLog("Could not delete the file: " + file.getName() + " on the node " + node);
        }
        return retVal;
    }

    public static HashMap<String, Set<NetworkInfo>> discoverLoopbackNetworksOnSolaris(String[] nodeList, ResultSet networksResultSet) {
        HashMap<String, Set<NetworkInfo>> nodeNetworksMapToBeReturned = new HashMap<String, Set<NetworkInfo>>();
        if (!VerificationUtil.isPlatformSolaris()) {
            return nodeNetworksMapToBeReturned;
        }
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet commandRS = new ResultSet();
        String output = null;
        String errMsg = null;
        String loopbackIfName = "lo0";
        String command = null;
        String[] env = null;
        String[] args = null;
        String udID = VerificationUtil.getUniqueDistributionID();
        boolean isSun11OrLater = VerificationUtil.isVersionPost(udID, "5.11");
        if (isSun11OrLater) {
            String[] argsSolaris11;
            command = "/usr/sbin/ipadm";
            args = argsSolaris11 = new String[]{"show-addr", "-o", "ADDROBJ,STATE", "-p", loopbackIfName};
        } else {
            String grepCmd = new CommandsUtil().getGrep();
            String ifconfigCmd = "/usr/sbin/ifconfig -a";
            String loopbackFlag = " LOOPBACK";
            command = ifconfigCmd + " | " + grepCmd + loopbackFlag;
        }
        globalExec.runGenericCmd(nodeList, command, args, env, commandRS);
        networksResultSet.addResultSetData(commandRS);
        if (!commandRS.anySuccess()) {
            VerificationUtil.traceAndLog("command execution failed");
            StringBuilder errors = new StringBuilder();
            for (String node : nodeList) {
                List<VerificationError> errList = commandRS.getResult(node).getErrors();
                StringBuilder sb = new StringBuilder();
                for (VerificationError vfyErr : errList) {
                    sb.append(vfyErr.getErrorMessage());
                }
                errors.append(String.format("error on node %s is : %s", node, sb.toString()) + VerificationUtil.LSEP);
                ReportUtil.sureprintln(sb.toString());
            }
            VerificationUtil.traceAndLog(errors.toString());
            return nodeNetworksMapToBeReturned;
        }
        for (String node : nodeList) {
            Result result = commandRS.getResult(node);
            if (result.getStatus() == 1) {
                output = (String)commandRS.getResult(node).getResultInfoSet().get(0);
                if (VerificationUtil.isStringGood(output)) {
                    String[] outputLines;
                    for (String line : outputLines = (String[])commandRS.getResult(node).getResultInfoSet().get(1)) {
                        if (!VerificationUtil.isStringGood(line)) continue;
                        NetworkInfo network = null;
                        network = isSun11OrLater ? NetworkUtility.parseIpadmOutput(line) : NetworkUtility.parseIfconfigOutput(line);
                        if (network == null) continue;
                        if (!nodeNetworksMapToBeReturned.containsKey(node)) {
                            nodeNetworksMapToBeReturned.put(node, new HashSet());
                        }
                        nodeNetworksMapToBeReturned.get(node).add(network);
                    }
                    continue;
                }
                errMsg = s_msgBundle.getMessage("5713", true, (Object[])new String[]{command, node});
                networksResultSet.addResult(node, 2);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                networksResultSet.addErrorDescription(errDesc);
                ReportUtil.printError(errMsg);
                continue;
            }
            List<VerificationError> errList = commandRS.getResult(node).getErrors();
            String[] sb = new StringBuilder();
            for (VerificationError vfyErr : errList) {
                sb.append(vfyErr.getErrorMessage());
            }
            errMsg = s_msgBundle.getMessage("5718", true, (Object[])new String[]{command, node, ""}) + VerificationUtil.LSEP + sb.toString();
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            VerificationUtil.traceAndLog("error on node " + node + " is " + sb.toString());
            networksResultSet.addErrorDescription(node, errDesc);
            ReportUtil.sureprintln(errMsg);
        }
        return nodeNetworksMapToBeReturned;
    }

    private static NetworkInfo parseIfconfigOutput(String line) {
        String loopbackIfName;
        String[] outputColumns;
        NetworkInfo network = null;
        if (VerificationUtil.isStringGood(line) && (outputColumns = VerificationUtil.string2strArr(line, ":")) != null && outputColumns.length == 2 && VerificationUtil.isStringGood(loopbackIfName = outputColumns[0].trim())) {
            String IFCONFIG_STATUS_UP = "<UP";
            String IFCONFIG_IPV4_TYPE = "IPv4";
            String IFCONFIG_IPV6_TYPE = "IPv6";
            network = new NetworkInfo();
            network.setInterfaceName(loopbackIfName);
            String flags = outputColumns[1].trim();
            if (flags.contains(IFCONFIG_STATUS_UP)) {
                network.setStatus(22);
            } else {
                network.setStatus(8);
            }
            if (flags.contains(IFCONFIG_IPV4_TYPE)) {
                network.setIpAddressType(IPAddressUtil.IPAddrType.IPv4);
                network.setIP(IPV4_LOCALHOST_IP);
            } else if (flags.contains(IFCONFIG_IPV6_TYPE)) {
                network.setIpAddressType(IPAddressUtil.IPAddrType.IPv6);
                network.setIP(IPV6_LOCALHOST_IP);
            } else {
                VerificationUtil.traceAndLog("The ip version of interface %s is not specified", loopbackIfName);
            }
        }
        return network;
    }

    private static NetworkInfo parseIpadmOutput(String line) {
        NetworkInfo network = null;
        String IPADM_OK_STATE = "ok";
        String IPADM_DOWN_STATE = "down";
        String IPADM_IPV4_TYPE = "v4";
        String IPADM_IPV6_TYPE = "v6";
        String[] outputColumns = VerificationUtil.string2strArr(line = line.replaceAll("/", ":"), ":");
        if (outputColumns != null && outputColumns.length == 3) {
            String loopbackIfName = outputColumns[0].trim();
            network = new NetworkInfo();
            network.setInterfaceName(loopbackIfName);
            String state = outputColumns[2];
            if (state.equals(IPADM_OK_STATE)) {
                network.setStatus(22);
            } else if (state.equals(IPADM_DOWN_STATE)) {
                network.setStatus(8);
            } else {
                network.setStatus(50);
            }
            String ifType = outputColumns[1];
            if (ifType.startsWith(IPADM_IPV4_TYPE)) {
                network.setIpAddressType(IPAddressUtil.IPAddrType.IPv4);
                network.setIP(IPV4_LOCALHOST_IP);
            } else if (ifType.startsWith(IPADM_IPV6_TYPE)) {
                network.setIpAddressType(IPAddressUtil.IPAddrType.IPv6);
                network.setIP(IPV6_LOCALHOST_IP);
            } else {
                VerificationUtil.traceAndLog("The ip version of interface %s is not specified", loopbackIfName);
            }
        }
        return network;
    }

    public static boolean isPureIPv6Env(HashMap<String, Set<NetworkInfo>> nodeNetworksMap) {
        boolean isIPv6Env = true;
        if (NetworkUtility.isNetworksMapGood(nodeNetworksMap)) {
            for (String node : nodeNetworksMap.keySet()) {
                for (NetworkInfo network : nodeNetworksMap.get(node)) {
                    IPAddressUtil.IPAddrType ipType = network.getIpAddressType();
                    if (ipType != IPAddressUtil.IPAddrType.IPv4 && ipType != IPAddressUtil.IPAddrType.BOTH) continue;
                    Trace.out((String)("Found IPv4 network: " + network.getIPAsString()));
                    isIPv6Env = false;
                    break;
                }
                if (isIPv6Env) continue;
                break;
            }
        } else {
            Trace.out((String)"Networks are not available. Returning false");
            isIPv6Env = false;
        }
        VerificationUtil.traceAndLog("isPureIPv6Env ? " + isIPv6Env);
        return isIPv6Env;
    }

    public static class SubnetIpRange
    implements Comparable<SubnetIpRange> {
        private final long begin;
        private final long end;
        private String interfaceName;
        private final String nodeName;
        private final int networkType;

        public SubnetIpRange(long first, long last, String interfaceName, String nodeName, int networkType) {
            this.begin = first;
            this.end = last;
            this.interfaceName = interfaceName;
            this.nodeName = nodeName;
            this.networkType = networkType;
        }

        public long getBeginValue() {
            return this.begin;
        }

        public long getEndValue() {
            return this.end;
        }

        public String getInterfaceName() {
            return this.interfaceName;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public int getNetworkType() {
            return this.networkType;
        }

        @Override
        public int compareTo(SubnetIpRange obj2) {
            if (this.getBeginValue() < obj2.getBeginValue()) {
                return -1;
            }
            if (this.getBeginValue() > obj2.getBeginValue()) {
                return 1;
            }
            return 0;
        }
    }
}

