/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.network;

import java.net.InetAddress;
import java.util.List;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.util.VerificationUtil;

public class NetworkInfo
implements NetworkConstants {
    private String m_interfaceName = "";
    private String m_nodeName = null;
    private InetAddress m_subnet = null;
    private InetAddress m_subnetMask = null;
    private InetAddress m_ip = null;
    private int m_netType = 0;
    private IPAddressUtil.IPAddrType m_AddressType;
    private int m_status = 50;
    private String m_subnetGateway = null;
    private String m_defaultGateway = null;
    private boolean m_LogicalInterface = false;
    private float m_networkSpeedInMbps;
    private boolean m_autoNegotiationEnabled = false;
    private boolean m_deprecated = false;
    private boolean m_duplicate = false;
    private String m_hardwareAddr = null;
    private int m_mtuInBytes;
    private String m_hardwareType = null;
    private boolean m_isIfNameGlobal = false;
    private String m_ifScope = null;
    private String m_ipmpGroup;
    private boolean m_isNICConfFileExists;
    protected List<InetAddress> m_configuredSubnetsList = null;
    private boolean m_monitored = false;
    List<ErrorDescription> m_errorList;
    String UNKNOWN_STRING = "UNKNOWN";

    public NetworkInfo() {
    }

    public NetworkInfo(String interfaceName, InetAddress subnet, InetAddress subnetMask, NetworkConstants.NetworkType networkType) {
        this.m_interfaceName = interfaceName;
        this.m_subnet = subnet;
        this.m_subnetMask = subnetMask;
        this.m_netType |= networkType.getValue();
    }

    public NetworkInfo(InetAddress ip, InetAddress subnet, InetAddress subnetMask, String type) {
        this.m_ip = ip;
        this.setIpAddressType(null);
        this.m_subnet = subnet;
        this.m_subnetMask = subnetMask;
        this.m_netType = type != null ? (type.equalsIgnoreCase(NetworkConstants.NetworkType.PUBLIC.toString()) || type.equalsIgnoreCase("PUB") ? NetworkConstants.NetworkType.PUBLIC.getValue() : (type.equalsIgnoreCase(NetworkConstants.NetworkType.PRIVATE.toString()) || type.equalsIgnoreCase("PVT") || type.equalsIgnoreCase("CLUSTER_INTERCONNECT") ? NetworkConstants.NetworkType.PRIVATE.getValue() : (type.equalsIgnoreCase("ASM") || type.contains("ASM") ? NetworkConstants.NetworkType.ASM.getValue() : NetworkConstants.NetworkType.UNKNOWN.getValue()))) : NetworkConstants.NetworkType.UNKNOWN.getValue();
    }

    public void setInterfaceName(String name) {
        if (VerificationUtil.isStringGood(name)) {
            this.m_interfaceName = name;
        }
    }

    public String getInterfaceName() {
        return this.m_interfaceName;
    }

    public void setSubnet(InetAddress subnet) {
        if (subnet != null) {
            this.m_subnet = subnet;
        }
    }

    public void setSubnet(String subnet) {
        if (VerificationUtil.isStringGood(subnet)) {
            this.m_subnet = NetworkUtility.getInetAddressFromString(subnet);
        }
    }

    public InetAddress getSubnet() {
        return this.m_subnet;
    }

    public String getSubnetAsString() {
        if (this.m_subnet == null) {
            return "";
        }
        return this.m_subnet.getHostAddress();
    }

    public void setSubnetMask(InetAddress subnetMask) {
        if (subnetMask != null) {
            this.m_subnetMask = subnetMask;
        }
    }

    public void setSubnetMask(String subnetMask) {
        if (VerificationUtil.isStringGood(subnetMask)) {
            this.m_subnetMask = NetworkUtility.getInetAddressFromString(subnetMask);
        }
    }

    public InetAddress getSubnetMask() {
        return this.m_subnetMask;
    }

    public String getSubnetMaskAsString() {
        if (this.m_subnetMask != null) {
            return this.m_subnetMask.getHostAddress();
        }
        return "";
    }

    public void setIP(InetAddress ipAddress) {
        if (ipAddress != null) {
            this.m_ip = ipAddress;
            this.setIpAddressType(null);
        }
    }

    public void setIP(String ipAddress) {
        if (VerificationUtil.isStringGood(ipAddress)) {
            this.m_ip = NetworkUtility.getInetAddressFromString(ipAddress);
            this.setIpAddressType(null);
        }
    }

    public InetAddress getIP() {
        return this.m_ip;
    }

    public String getIPAsString() {
        if (this.m_ip != null) {
            return this.m_ip.getHostAddress();
        }
        return null;
    }

    public void setNetworkType(NetworkConstants.NetworkType netType) {
        if (netType != null) {
            this.m_netType = netType.getValue();
        }
    }

    public void setNetworkType(int netType) {
        this.m_netType = netType;
    }

    public void setNetworkType(String networkTypeString) {
        this.m_netType = 0;
        for (String networkType : VerificationUtil.string2strArr(networkTypeString)) {
            if (!VerificationUtil.isStringGood(networkType)) continue;
            if (networkType.equalsIgnoreCase(NetworkConstants.NetworkType.PUBLIC.toString()) || networkType.equalsIgnoreCase("PUB")) {
                this.m_netType |= NetworkConstants.NetworkType.PUBLIC.getValue();
                continue;
            }
            if (networkType.equalsIgnoreCase(NetworkConstants.NetworkType.PRIVATE.toString()) || networkType.equalsIgnoreCase("PVT") || networkType.equalsIgnoreCase("CLUSTER_INTERCONNECT")) {
                this.m_netType |= NetworkConstants.NetworkType.PRIVATE.getValue();
                continue;
            }
            if (networkType.equalsIgnoreCase("ASM") || networkType.contains("ASM")) {
                this.m_netType |= NetworkConstants.NetworkType.ASM.getValue();
                continue;
            }
            this.m_netType |= NetworkConstants.NetworkType.UNKNOWN.getValue();
        }
    }

    public int getNetworkType() {
        return this.m_netType;
    }

    public String getNetworkTypeAsString() {
        return NetworkConstants.NetworkType.getStringValue(this.m_netType);
    }

    public void setIpAddressType(IPAddressUtil.IPAddrType ipAddressType) {
        String ip = null;
        if (ipAddressType == null) {
            if (this.m_ip != null) {
                try {
                    this.m_AddressType = IPAddressUtil.getAddrTypeFromAddressOrName((String)this.m_ip.getHostAddress());
                }
                catch (IPAddressException e) {
                    Trace.out((String)("Exception while getting the address type for the address" + ip));
                }
            }
        } else {
            this.m_AddressType = ipAddressType;
        }
    }

    public IPAddressUtil.IPAddrType getIpAddressType() {
        return this.m_AddressType;
    }

    public String getIpAddressTypeAsString() {
        if (this.m_AddressType == null) {
            return this.UNKNOWN_STRING;
        }
        return this.m_AddressType.toString();
    }

    public void setStatus(int interfaceStatus) {
        this.m_status = interfaceStatus;
    }

    public int getStatus() {
        return this.m_status;
    }

    public void setSubnetGateway(InetAddress subnetGw) {
        if (subnetGw != null) {
            this.m_subnetGateway = subnetGw.getHostAddress();
        }
    }

    public void setSubnetGateway(String subnetGw) {
        if (VerificationUtil.isStringGood(subnetGw)) {
            this.m_subnetGateway = subnetGw;
        }
    }

    public InetAddress getSubnetGatewayAsInetAddress() {
        return NetworkUtility.getInetAddressFromString(this.m_subnetGateway);
    }

    public String getSubnetGatewayAsString() {
        return this.m_subnetGateway;
    }

    public void setDefaultGateway(InetAddress defaultGw) {
        if (defaultGw != null) {
            this.m_defaultGateway = defaultGw.getHostAddress();
        }
    }

    public void setDefaultGateway(String defaultGw) {
        if (VerificationUtil.isStringGood(defaultGw)) {
            this.m_defaultGateway = defaultGw;
            NetworkUtility.getInetAddressFromString(defaultGw);
        }
    }

    public InetAddress getDefaultGatewayAsInetAddress() {
        return NetworkUtility.getInetAddressFromString(this.m_defaultGateway);
    }

    public String getDefaultGatewayAsString() {
        return this.m_defaultGateway;
    }

    public void setLogicalInterface(boolean isLogicalInterface) {
        this.m_LogicalInterface = isLogicalInterface;
    }

    public boolean isLogicalInterface() {
        return this.m_LogicalInterface;
    }

    public void setNetworkSpeedInMbps(float networkSpeedInMbps) {
        this.m_networkSpeedInMbps = networkSpeedInMbps;
    }

    public float getNetworkSpeedInMbps() {
        return this.m_networkSpeedInMbps;
    }

    public void setAutoNegotiationEnabled(boolean autoNegotiationEnabled) {
        this.m_autoNegotiationEnabled = autoNegotiationEnabled;
    }

    public boolean isAutoNegotiationEnabled() {
        return this.m_autoNegotiationEnabled;
    }

    public void setDeprecated(boolean deprecated) {
        this.m_deprecated = deprecated;
    }

    public boolean isDeprecated() {
        return this.m_deprecated;
    }

    public void setDuplicate(boolean isDuplicate) {
        this.m_duplicate = isDuplicate;
    }

    public boolean isDuplicateOptionSet() {
        return this.m_duplicate;
    }

    public void setMacAddress(String hwAddress) {
        if (VerificationUtil.isStringGood(hwAddress)) {
            this.m_hardwareAddr = hwAddress;
        }
    }

    public String getMacAddress() {
        return this.m_hardwareAddr;
    }

    public void setMTU(int mtuInBytes) {
        this.m_mtuInBytes = mtuInBytes;
    }

    public int getMTU() {
        return this.m_mtuInBytes;
    }

    public void setHardwareType(String hardwareType) {
        if (VerificationUtil.isStringGood(hardwareType)) {
            this.m_hardwareType = hardwareType;
        }
    }

    public String getHardwareType() {
        return this.m_hardwareType;
    }

    public void setIfNameGlobalLogicalInterface(boolean isGlobalLogicalInterface) {
        this.m_isIfNameGlobal = isGlobalLogicalInterface;
    }

    public boolean isIfNameGlobalLogicalInterface() {
        return this.m_isIfNameGlobal;
    }

    public void setInterfaceScope(String ifScope) {
        if (VerificationUtil.isStringGood(ifScope)) {
            this.m_ifScope = ifScope;
        }
    }

    public String getInterfaceScope() {
        return this.m_ifScope;
    }

    public void setNodeName(String nodeName) {
        if (VerificationUtil.isStringGood(nodeName)) {
            this.m_nodeName = nodeName;
        }
    }

    public String getNodeName() {
        return this.m_nodeName;
    }

    public void setNICConfFileExists(boolean exists) {
        this.m_isNICConfFileExists = exists;
    }

    public boolean isNICConfFileExists() {
        return this.m_isNICConfFileExists;
    }

    public void setGroupName(String group) {
        this.m_ipmpGroup = group;
    }

    public String getGroupName() {
        return this.m_ipmpGroup;
    }

    public List<InetAddress> getConfiguredSubnets() {
        return this.m_configuredSubnetsList;
    }

    public void addConfiguredSubnet(InetAddress subnetAddress) {
        if (subnetAddress != null && !this.m_configuredSubnetsList.contains(subnetAddress)) {
            this.m_configuredSubnetsList.add(subnetAddress);
        }
    }

    public List<InetAddress> getConfiguredSubnetList() {
        return this.m_configuredSubnetsList;
    }

    public String getConfiguredSubnetListAsString() {
        if (this.m_configuredSubnetsList != null) {
            return NetworkUtility.inetAddressCollectionToString(this.m_configuredSubnetsList);
        }
        return null;
    }

    public void setMonitoredOption(boolean monitored) {
        this.m_monitored = monitored;
    }

    public boolean isMonitorOptionSet() {
        return this.m_monitored;
    }

    public String getGenericNetworkValues() {
        StringBuffer networkDetails = new StringBuffer();
        networkDetails.append("Generic Network Parameters: " + VerificationUtil.LINE_SEPARATOR);
        String value = this.getInterfaceName();
        if (!VerificationUtil.isStringGood(value)) {
            value = this.UNKNOWN_STRING;
        }
        networkDetails.append("Name: " + value + VerificationUtil.LINE_SEPARATOR);
        value = this.getIPAsString();
        if (!VerificationUtil.isStringGood(value)) {
            value = this.UNKNOWN_STRING;
        }
        networkDetails.append("IP Address: " + value + VerificationUtil.LINE_SEPARATOR);
        value = this.getIpAddressTypeAsString();
        if (!VerificationUtil.isStringGood(value)) {
            value = this.UNKNOWN_STRING;
        }
        networkDetails.append("IP Address Type: " + value + VerificationUtil.LINE_SEPARATOR);
        value = this.getSubnetAsString();
        if (!VerificationUtil.isStringGood(value)) {
            value = this.UNKNOWN_STRING;
        }
        networkDetails.append("Subnet: " + value + VerificationUtil.LINE_SEPARATOR);
        value = this.getSubnetMaskAsString();
        if (!VerificationUtil.isStringGood(value)) {
            value = this.UNKNOWN_STRING;
        }
        networkDetails.append("Subnet Mask: " + value + VerificationUtil.LINE_SEPARATOR);
        value = this.getDefaultGatewayAsString();
        if (!VerificationUtil.isStringGood(value)) {
            value = this.UNKNOWN_STRING;
        }
        networkDetails.append("Default Gateway: " + value + VerificationUtil.LINE_SEPARATOR);
        value = this.getSubnetGatewayAsString();
        if (!VerificationUtil.isStringGood(value)) {
            value = this.UNKNOWN_STRING;
        }
        networkDetails.append("Subnet Gateway: " + value + VerificationUtil.LINE_SEPARATOR);
        value = this.getNetworkTypeAsString();
        if (!VerificationUtil.isStringGood(value)) {
            value = this.UNKNOWN_STRING;
        }
        networkDetails.append("Network Type: " + value + VerificationUtil.LINE_SEPARATOR);
        value = this.getMacAddress();
        if (!VerificationUtil.isStringGood(value)) {
            value = this.UNKNOWN_STRING;
        }
        networkDetails.append("Hardware Address: " + value + VerificationUtil.LINE_SEPARATOR);
        networkDetails.append("Hardware Type: " + this.getHardwareType() + VerificationUtil.LINE_SEPARATOR);
        networkDetails.append("Status: " + this.getStatus() + VerificationUtil.LINE_SEPARATOR);
        networkDetails.append("Network Speed(Mbps): " + this.getNetworkSpeedInMbps() + VerificationUtil.LINE_SEPARATOR);
        networkDetails.append("MTU(Bytes): " + this.getMTU() + VerificationUtil.LINE_SEPARATOR);
        networkDetails.append("Is Logical?: " + this.isLogicalInterface() + VerificationUtil.LINE_SEPARATOR);
        networkDetails.append("Is Deprecated?: " + this.isDeprecated() + VerificationUtil.LINE_SEPARATOR);
        networkDetails.append("Is Duplicate?: " + this.isDuplicateOptionSet() + VerificationUtil.LINE_SEPARATOR);
        return networkDetails.toString();
    }

    public String toString() {
        StringBuffer stringValues = new StringBuffer();
        stringValues.append("< ");
        stringValues.append(this.getGenericNetworkValues());
        stringValues.append(" >");
        return stringValues.toString();
    }

    public String getIPMPNetworkValues() {
        StringBuffer networkDetails = new StringBuffer();
        networkDetails.append("IPMP Network Parameters: " + VerificationUtil.LINE_SEPARATOR);
        networkDetails.append("Is NIC Config File Exists?: " + this.isNICConfFileExists() + VerificationUtil.LINE_SEPARATOR);
        String value = this.getGroupName();
        if (!VerificationUtil.isStringGood(value)) {
            value = this.UNKNOWN_STRING;
        }
        networkDetails.append("Group Name: " + value + VerificationUtil.LINE_SEPARATOR);
        value = this.getConfiguredSubnetListAsString();
        if (!VerificationUtil.isStringGood(value)) {
            value = this.UNKNOWN_STRING;
        }
        networkDetails.append("Configured Subnet List: " + value + VerificationUtil.LINE_SEPARATOR);
        return networkDetails.toString();
    }

    public List<ErrorDescription> getAllErrorDetails() {
        return this.m_errorList;
    }

    public void addErrorDesc(ErrorDescription errDesc) {
        this.m_errorList.add(errDesc);
    }

    public void setError(List<ErrorDescription> errDescList) {
        this.m_errorList.addAll(errDescList);
    }

    public String getHostName() {
        return this.m_ip.getHostName();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof NetworkInfo)) {
            return false;
        }
        NetworkInfo network = (NetworkInfo)obj;
        return this.m_interfaceName != null && network.m_interfaceName != null && this.m_interfaceName.equalsIgnoreCase(network.m_interfaceName) && this.m_nodeName != null && network.m_nodeName != null && this.m_nodeName.equals(network.m_nodeName) && this.m_ip != null && network.m_ip != null && this.m_ip.equals(network.m_ip) && this.m_subnet != null && network.m_subnet != null && this.m_subnet.equals(network.m_subnet) && this.m_subnetMask != null && network.m_subnetMask != null && this.m_subnetMask.equals(network.m_subnetMask) && this.m_hardwareAddr != null && network.m_hardwareAddr != null && this.m_hardwareAddr.equalsIgnoreCase(network.m_hardwareAddr);
    }

    public int hashCode() {
        return 0;
    }
}

