/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.network;

import java.util.ArrayList;
import oracle.ops.verification.framework.util.VerificationUtil;

public interface NetworkConstants {
    public static final int NETREACH_TIMEOUT = 3;
    public static final int NETTYPE_PRIVATE = 1;
    public static final int NETTYPE_PUBLIC = 2;
    public static final int NETTYPE_UNKNOWN = 4;
    public static final int NETTYPE_ASM = 128;
    public static final int NETTYPE_LOCAL = 256;
    public static final int NETTYPE_ALL = 512;
    public static final int STATUS_DOWN = 8;
    public static final int STATUS_UP = 22;
    public static final int STATUS_UNKNOWN = 50;
    public static final String NETTYPE_STR_PRIVATE = "PRIVATE";
    public static final String NETTYPE_STR_PUBLIC = "PUBLIC";
    public static final String NETTYPE_STR_ASM = "ASM";
    public static final String NETTYPE_STR_LOCAL = "LOCAL";
    public static final String NETTYPE_STR_UNKNOWN = "UNKNOWN";
    public static final String NETTYPE_STR_ALL = "ALL";
    public static final String INFINIBAND = "InfiniBand";
    public static final int NT_NETREACH_TIMEOUT = 40;
    public static final int ADDRESS_TYPE_IPV4 = 4;
    public static final int ADDRESS_TYPE_IPV6 = 6;

    public static enum NetworkProtocol {
        TCP,
        UDP;

    }

    public static enum NetworkType {
        PRIVATE(1),
        PUBLIC(2),
        UNKNOWN(4),
        ASM(128),
        LOCAL(256),
        ALL(512);

        private int type;

        private NetworkType(int type) {
            this.type = type;
        }

        public int getValue() {
            return this.type;
        }

        public static String getStringValue(int type) {
            ArrayList<String> networkType = new ArrayList<String>();
            if ((type & 1) != 0) {
                networkType.add(NetworkConstants.NETTYPE_STR_PRIVATE);
            }
            if ((type & 2) != 0) {
                networkType.add(NetworkConstants.NETTYPE_STR_PUBLIC);
            }
            if ((type & 0x80) != 0) {
                networkType.add(NetworkConstants.NETTYPE_STR_ASM);
            }
            if ((type & 4) != 0) {
                networkType.add(NetworkConstants.NETTYPE_STR_UNKNOWN);
            }
            if ((type & 0x200) != 0) {
                networkType.add(NetworkConstants.NETTYPE_STR_ALL);
            }
            return VerificationUtil.strList2List(networkType);
        }
    }
}

