/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.network;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.report.ReportUtil;

public class ConMatrix {
    public static final int SUCCESSFUL = 1;
    public static final int PARTIALLY_SUCCESSFUL = 2;
    public static final int FAILED = 3;
    public static final int UNKNOWN = 4;
    public static final int FAILED_PREMATURE = 5;
    private String m_key;
    private int m_status = 1;
    private boolean m_isStatusSet = false;
    private boolean m_isPatched = false;
    private String[] m_IPList = null;
    private String[] m_nodeList = null;
    private String[] m_interfaceList = null;
    private boolean[][] m_matrix;

    private ConMatrix(String key, String[] nodeList, String[] IPList, boolean[][] matrix) {
        this.m_key = key;
        this.m_nodeList = nodeList;
        this.m_IPList = IPList;
        this.m_matrix = matrix;
        for (int i = 0; i < this.m_nodeList.length; ++i) {
            for (int j = 0; j < this.m_nodeList.length; ++j) {
                this.m_matrix[i][j] = false;
            }
        }
    }

    public ConMatrix(String key, String[] nodeList) {
        this(key, nodeList, null, new boolean[nodeList.length][nodeList.length]);
        Trace.out((String)("Created ConMatrix for " + this.m_key + "nodeLength " + nodeList.length));
    }

    public ConMatrix(String key, String[] nodeList, String[] IPList) {
        this(key, nodeList, IPList, new boolean[nodeList.length][nodeList.length]);
    }

    public ConMatrix(String key, String[] nodeList, String[] IPList, String[] interfaceList) {
        this(key, nodeList, IPList);
        this.m_interfaceList = interfaceList;
    }

    public void setInterfaceList(String[] interfaceList) {
        this.m_interfaceList = interfaceList;
    }

    public String[] getInterfaceList() {
        return this.m_interfaceList;
    }

    public void setInterface(int index, String inf) {
        this.m_interfaceList[index] = inf;
    }

    public String getInterface(int index) {
        return this.m_interfaceList[index];
    }

    public void setMatrixValue(boolean value, int sourceIpIndex, int destinationIpIndex) {
        this.m_matrix[sourceIpIndex][destinationIpIndex] = value;
    }

    public boolean setStatus(int status) {
        boolean changed = false;
        if (!this.m_isStatusSet) {
            if (this.m_status != status) {
                changed = true;
            }
            this.m_status = status;
            this.m_isStatusSet = true;
        }
        return changed;
    }

    public boolean setStatus(int status, boolean force) {
        boolean changed = false;
        if (!this.m_isStatusSet || force) {
            if (this.m_status != status) {
                changed = true;
            }
            this.m_isStatusSet = true;
            this.m_status = status;
        }
        return changed;
    }

    public int getStatus() {
        return this.m_status;
    }

    public String printStatus() {
        String str = null;
        switch (this.m_status) {
            case 1: {
                str = ReportUtil.SUCCESSFUL;
                break;
            }
            case 2: {
                str = ReportUtil.PARTIALLY_SUCCESSFUL;
                break;
            }
            case 3: {
                str = ReportUtil.FAILED;
                break;
            }
            case 4: {
                str = ReportUtil.UNKNOWN;
                break;
            }
            case 5: {
                str = ReportUtil.FAILED;
                break;
            }
            default: {
                str = "BAD CONMATRIX STATUS";
            }
        }
        return str;
    }

    public void setKey(String key) {
        this.m_key = key;
    }

    public String getKey() {
        return this.m_key;
    }

    public void setMatrix(boolean[][] matrix) {
        this.m_matrix = matrix;
    }

    public void updateMatrix(ConMatrix matrixToBeUpdated, boolean[] nodeConArray) {
        String[] ipAddresses = matrixToBeUpdated.getIPList();
        String[] nodeList = matrixToBeUpdated.getNodeList();
        for (int i = 0; i < ipAddresses.length; ++i) {
            for (int j = 0; j < ipAddresses.length; ++j) {
                if (i == j || matrixToBeUpdated.getMatrixValue(ipAddresses[i], ipAddresses[j])) {
                    this.setMatrixValue(ipAddresses[i], ipAddresses[j], true);
                    continue;
                }
                if (this.getMatrixValue(ipAddresses[i], ipAddresses[j])) continue;
                this.setMatrixValue(ipAddresses[i], ipAddresses[j], false);
                if (nodeConArray == null || nodeList[i] != this.getNodeList()[0]) continue;
                nodeConArray[j] = false;
            }
        }
    }

    public void setMatrixValue(String ipAddress1, String ipAddress2, boolean value) {
        int sourceIndex = 0;
        int destIndex = 0;
        boolean foundSource = false;
        boolean foundDest = false;
        for (int i = 0; i < this.m_IPList.length; ++i) {
            if (this.m_IPList[i].equals(ipAddress1)) {
                sourceIndex = i;
                foundSource = true;
            }
            if (!this.m_IPList[i].equals(ipAddress2)) continue;
            destIndex = i;
            foundDest = true;
        }
        if (foundSource && foundDest) {
            this.setMatrixValue(value, sourceIndex, destIndex);
        }
    }

    public boolean getMatrixValue(String ipAddress1, String ipAddress2) {
        boolean value = false;
        int sourceIndex = 0;
        int destIndex = 0;
        boolean foundSource = false;
        boolean foundDest = false;
        for (int i = 0; i < this.m_IPList.length; ++i) {
            if (this.m_IPList[i].equals(ipAddress1)) {
                sourceIndex = i;
                foundSource = true;
            }
            if (!this.m_IPList[i].equals(ipAddress2)) continue;
            destIndex = i;
            foundDest = true;
        }
        if (foundSource && foundDest) {
            value = this.m_matrix[sourceIndex][destIndex];
        }
        return value;
    }

    private String getNodeNameForIP(String ip) {
        int length = this.getIPList().length;
        String[] nodeList = this.getNodeList();
        String[] ipList = this.getIPList();
        String nodeName = null;
        for (int i = 0; i < length; ++i) {
            if (!ip.equals(ipList[i])) continue;
            return nodeList[i];
        }
        return nodeName;
    }

    protected void setNodeList(String[] nodeList) {
        this.m_nodeList = nodeList;
    }

    protected void setIPList(String[] IPList) {
        this.m_IPList = IPList;
        Trace.out((String)("Created ConMatrix for the subnet " + this.m_key + " node length:" + this.m_nodeList.length + " IP address length:" + this.m_IPList.length));
    }

    public String[] getNodeList() {
        return this.m_nodeList;
    }

    public String[] getUniqueNodeList() {
        Vector<String> vNodes = new Vector<String>(this.m_nodeList.length);
        for (int i = 0; i < this.m_nodeList.length; ++i) {
            if (vNodes.contains(this.m_nodeList[i])) continue;
            vNodes.addElement(this.m_nodeList[i]);
        }
        Object[] uniqueNodes = new String[vNodes.size()];
        vNodes.copyInto(uniqueNodes);
        return uniqueNodes;
    }

    public String[] getIPList() {
        return this.m_IPList;
    }

    public HashMap<String, Set<String>> getNodeIPMap() {
        String[] nodeList;
        HashMap<String, Set<String>> nodeIPMap = new HashMap<String, Set<String>>();
        for (String node : nodeList = this.getUniqueNodeList()) {
            HashSet<String> ipAddressesOnNode = new HashSet<String>();
            for (int i = 0; i < this.m_IPList.length; ++i) {
                if (!this.m_nodeList[i].equals(node)) continue;
                ipAddressesOnNode.add(this.m_IPList[i]);
            }
            nodeIPMap.put(node, ipAddressesOnNode);
        }
        return nodeIPMap;
    }

    public Set<String> getIPsOnNode(String node) {
        HashSet<String> ipAddressesOnNode = new HashSet<String>();
        for (int i = 0; i < this.m_IPList.length; ++i) {
            if (!this.m_nodeList[i].equals(node)) continue;
            ipAddressesOnNode.add(this.m_IPList[i]);
        }
        return ipAddressesOnNode;
    }

    public Set<String> getOtherIPsOnTheNode(String node, String ipAddressOnNode) {
        HashSet<String> otherIpAddressesOnNode = new HashSet<String>();
        for (String ipAddress : this.getIPsOnNode(node)) {
            if (ipAddress.equals(ipAddressOnNode)) continue;
            otherIpAddressesOnNode.add(ipAddress);
        }
        return otherIpAddressesOnNode;
    }

    protected void setNodeName(int index, String name) {
        this.m_nodeList[index] = name;
    }

    protected void setIP(int index, String address) {
        if (this.m_IPList != null) {
            this.m_IPList[index] = address;
        }
    }

    public String getNodeName(int index) {
        return this.m_nodeList[index];
    }

    public String getIP(int index) {
        if (this.m_IPList != null) {
            return this.m_IPList[index];
        }
        return null;
    }

    public void patchMatrix() {
        int i;
        for (i = 0; i < this.m_matrix[0].length; ++i) {
            this.m_matrix[i][0] = this.m_matrix[0][i];
        }
        for (i = 0; i < this.m_matrix[0].length; ++i) {
            for (int j = 0; j < this.m_matrix[0].length; ++j) {
                if (!this.m_matrix[0][i] || !this.m_matrix[0][j]) continue;
                this.m_matrix[j][i] = true;
                this.m_matrix[i][j] = true;
            }
        }
        this.m_isPatched = true;
    }

    public boolean[][] getMatrixForOutput() {
        if (!this.m_isStatusSet || this.m_status == 5 || this.m_status == 4) {
            Trace.out((String)("isStatusSet " + this.m_isStatusSet));
            Trace.out((String)("Status " + this.m_status));
            return null;
        }
        if (!this.m_isPatched) {
            this.patchMatrix();
        }
        return this.m_matrix;
    }

    public boolean[][] getMatrixForChange() {
        this.m_isPatched = false;
        return this.m_matrix;
    }

    public String toString() {
        StringBuffer sBuf = new StringBuffer(this.m_key + ":\n");
        if (this.m_IPList == null || this.m_nodeList == null) {
            sBuf.append("\tError\n");
            return sBuf.toString();
        }
        for (int i = 0; i < this.m_nodeList.length; ++i) {
            for (int j = 0; j < this.m_nodeList.length; ++j) {
                if (this.m_IPList[i].equals("127.0.0.1")) {
                    sBuf.append("Can't connect from loop back interface to " + this.m_IPList[j] + "\n");
                    continue;
                }
                if (this.m_matrix[i][j]) {
                    if (i == j) continue;
                    sBuf.append(this.m_nodeList[i] + ":" + this.m_IPList[i] + " ----> " + this.m_nodeList[j] + ":" + this.m_IPList[j] + "\n");
                    continue;
                }
                if (i == j) {
                    sBuf.append("Make sure ip address:" + this.m_IPList[i] + " is a valid IP address on node: " + this.m_nodeList[i] + "\n");
                    continue;
                }
                sBuf.append(this.m_nodeList[i] + ":" + this.m_IPList[i] + " -XX-> " + this.m_nodeList[j] + ":" + this.m_IPList[j] + "\n");
            }
        }
        return sBuf.toString();
    }

    public HashMap<String, Set<String>> getSourceDestinationMap(String node) {
        HashMap<String, Set<String>> sourceDestinationMap = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> getNodeIPMap = this.getNodeIPMap();
        Set<String> nodes = getNodeIPMap.keySet();
        Set<Object> ipAddressesOnNode = new HashSet();
        HashSet ipAddressesOnOtherNodes = new HashSet();
        for (String string : nodes) {
            if (string.equals(node)) continue;
            ipAddressesOnOtherNodes.addAll(getNodeIPMap.get(string));
        }
        ipAddressesOnNode = getNodeIPMap.get(node);
        for (String string : ipAddressesOnNode) {
            HashSet<String> destinationIpAddresses = new HashSet<String>();
            Set<String> otherIpAddressesOnNode = this.getOtherIPsOnTheNode(node, string);
            if (!otherIpAddressesOnNode.isEmpty()) {
                destinationIpAddresses.addAll(otherIpAddressesOnNode);
            }
            if (!ipAddressesOnOtherNodes.isEmpty()) {
                destinationIpAddresses.addAll(ipAddressesOnOtherNodes);
            }
            if (destinationIpAddresses.isEmpty()) continue;
            sourceDestinationMap.put(string, destinationIpAddresses);
        }
        return sourceDestinationMap;
    }
}

