/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.network;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.verification.command.ICMPPingCommand;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.network.ConMatrix;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkDataDiscovery;
import oracle.ops.verification.framework.network.NetworkException;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.GenericUtil;
import oracle.ops.verification.util.ParsingException;

abstract class CommandHandler
implements NetworkConstants {
    private static final String TAG_ADAPTER = "ADAPTER";
    private static final String TAG_NIC = "NIC";
    private static final String IP_KEY = "IP";
    private static final String MASK_KEY = "MASK";
    private static final String NAME_KEY = "NAME";
    private static final String SUBNET_KEY = "SUBNET";
    private static final String TYPE_KEY = "TYPE";
    private static final String NETTYPE_KEY = "NETTYPE";
    private static final String UPSTATUS_KEY = "UPSTATUS";
    private static final String DEF_GATEWAY_KEY = "DEFAULT GATEWAY";
    private static final String SUB_GATEWAY_KEY = "SUBNET GATEWAY";
    private static final String HW_ADDRESS_KEY = "HARDWARE ADDR";
    private static final String HARDWARE_TYPE_KEY = "HARDWARE_TYPE";
    private static final String MTU_KEY = "MTU";
    private static final String IPMP_GROUP_KEY = "IPMP_GROUP";
    private static final String NIC_CONF_FILE_EXISTS_KEY = "NIC_CONF_FILE_EXIST";
    private static final String DEPRECATED_KEY = "DEPRECATED";
    private static final String INTERFACE_KEY = "INTERFACE";
    private static final String NETWORK_SPEED_KEY = "SPEED";
    private static final String AUTO_NEGOTIATION_KEY = "AUTO";
    private static final String DUPLICATE_KEY = "DUPLICATE";
    private static final String STATUS_STR_UP = "UP";
    private static final String STATUS_STR_DOWN = "DOWN";
    private static final String STATUS_STR_UNKNOWN = "UNKNOWN";
    private static final String YES = "YES";
    private static final String TRUE = "TRUE";
    private static final String TYPE_IPV6 = "IPV6";
    protected static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    protected static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");

    CommandHandler() {
    }

    protected abstract VerificationCommand generateReachabilityCommand(String var1, String var2);

    protected abstract VerificationCommand generateICMPCommandWithoutFragment(String var1, String var2, String var3, int var4);

    protected boolean parseConnectivityCommandOutput(VerificationCommand vfyCommand) {
        boolean expectedExitCode = false;
        boolean succ = true;
        if (0 != vfyCommand.getVfyCode()) {
            succ = false;
            Trace.out((String)("vfyCommand returned: " + vfyCommand.getVfyCode()));
            Trace.out((String)("vfyCommand output: " + vfyCommand.getOutput()));
        }
        return succ;
    }

    protected VerificationCommand generateGetIfInfoCommand(String destNode) {
        String[] arg = new String[]{"-getIfInfo"};
        String[] env = null;
        return new VerificationCommand(destNode, arg, env);
    }

    protected VerificationCommand generateGetIfInfoByNameCommand(String destNode, String inf) {
        String[] arg = new String[]{"-getIfInfo", inf};
        String[] env = null;
        return new VerificationCommand(destNode, arg, env);
    }

    protected VerificationCommand generateGetIPMPInfoCommand(String destNode) {
        String[] arg = new String[]{"-getIfInfo", "-ipmpinfo"};
        String[] env = null;
        return new VerificationCommand(destNode, arg, env);
    }

    protected VerificationCommand generateGetNICBindOrderCommand(String destNode) {
        String[] arg = new String[]{"-getIfInfo", "-nicBindOrder"};
        String[] env = null;
        return new VerificationCommand(destNode, arg, env);
    }

    protected NetworkInfo parseGetIfInfoCommandOutput(String fmtdStr, String node, ResultSet resultSet) {
        NetworkInfo network = new NetworkInfo();
        try {
            boolean isWindows;
            String interfaceName = GenericUtil.getValueByKey(fmtdStr, NAME_KEY);
            if (VerificationUtil.isStringGood(interfaceName)) {
                network.setInterfaceName(interfaceName);
            }
            network.setNodeName(node);
            String value = GenericUtil.getValueByKey(fmtdStr, SUBNET_KEY);
            if (VerificationUtil.isStringGood(value)) {
                network.setSubnet(value);
            }
            if (VerificationUtil.isStringGood(value = GenericUtil.getValueByKey(fmtdStr, MASK_KEY))) {
                network.setSubnetMask(value);
            }
            if (VerificationUtil.isStringGood(value = GenericUtil.getValueByKey(fmtdStr, IP_KEY))) {
                network.setIP(value);
            }
            if (VerificationUtil.isStringGood(value = GenericUtil.getValueByKey(fmtdStr, TYPE_KEY))) {
                if (TYPE_IPV6.equalsIgnoreCase(value)) {
                    network.setIpAddressType(IPAddressUtil.IPAddrType.IPv6);
                } else {
                    network.setIpAddressType(IPAddressUtil.IPAddrType.IPv4);
                }
            }
            if (VerificationUtil.isStringGood(value = GenericUtil.getValueByKey(fmtdStr, UPSTATUS_KEY))) {
                network.setStatus(this.convertStatusToInteger(value, node, interfaceName, resultSet));
            }
            if (VerificationUtil.isStringGood(value = GenericUtil.getValueByKey(fmtdStr, NETTYPE_KEY))) {
                network.setNetworkType(CommandHandler.convertNetworkTypeToInteger(value));
            }
            value = GenericUtil.getValueByKey(fmtdStr, SUB_GATEWAY_KEY);
            NativeSystem nativeSys = new SystemFactory().CreateSystem();
            boolean bl = isWindows = !nativeSys.isUnixSystem();
            if (isWindows) {
                if (VerificationUtil.isStringGood(value)) {
                    network.setSubnetGateway("");
                }
            } else if (VerificationUtil.isStringGood(value)) {
                network.setSubnetGateway(value);
            }
            if (VerificationUtil.isStringGood(value = GenericUtil.getValueByKey(fmtdStr, DEF_GATEWAY_KEY))) {
                network.setDefaultGateway(value);
            }
            if (VerificationUtil.isStringGood(value = GenericUtil.getValueByKey(fmtdStr, NETWORK_SPEED_KEY))) {
                network.setNetworkSpeedInMbps(this.getSpeedInMbps(value));
            }
            if (VerificationUtil.isStringGood(value = GenericUtil.getValueByKey(fmtdStr, AUTO_NEGOTIATION_KEY))) {
                network.setAutoNegotiationEnabled(this.convertStringToBoolean(value));
            }
            if (VerificationUtil.isStringGood(value = GenericUtil.getValueByKey(fmtdStr, DEPRECATED_KEY))) {
                network.setDeprecated(this.convertStringToBoolean(value));
            }
            if (VerificationUtil.isStringGood(value = GenericUtil.getValueByKey(fmtdStr, DUPLICATE_KEY))) {
                network.setDuplicate(this.convertStringToBoolean(value));
            }
            if (VerificationUtil.isStringGood(value = GenericUtil.getValueByKey(fmtdStr, HW_ADDRESS_KEY))) {
                network.setMacAddress(value);
            } else {
                value = "00:00:00:00:00:00";
                network.setMacAddress(value);
            }
            value = GenericUtil.getValueByKey(fmtdStr, HARDWARE_TYPE_KEY);
            if (VerificationUtil.isStringGood(value)) {
                network.setHardwareType(value);
            }
            if (VerificationUtil.isStringGood(value = GenericUtil.getValueByKey(fmtdStr, MTU_KEY))) {
                network.setMTU(Integer.parseInt(value));
            }
            if (VerificationUtil.isStringGood(interfaceName) && value.contains(":") && NetworkDataDiscovery.m_nodeNetworksMap != null && NetworkDataDiscovery.m_nodeNetworksMap.get(node) != null && NetworkDataDiscovery.m_nodeNetworksMap.get(node).contains(network)) {
                network.setLogicalInterface(true);
            }
        }
        catch (ParsingException parsingException) {
            ErrorDescription errorDescription = new ErrorDescription();
            errorDescription.setErrorMessage(parsingException.getMessage());
            resultSet.addErrorDescription(node, errorDescription);
            resultSet.setStatus(2);
            Trace.out((String)("Exception parseGetIfInfoCommandOutput " + fmtdStr));
            Trace.out((String)("Exception caught during parsing interface info: " + parsingException.getMessage()));
            return null;
        }
        if (!this.hasValidNetworkInfo(network, node, resultSet)) {
            return null;
        }
        return network;
    }

    Set<NetworkInfo> parseGetIfInfoCommandOutput(VerificationCommand cmd, ResultSet resultSet) {
        return this.parseGetIfInfoCommandOutput(cmd, resultSet, false);
    }

    Set<NetworkInfo> parseGetIfInfoCommandOutput(VerificationCommand cmd, ResultSet resultSet, boolean includeLoopback) {
        String output = cmd.getOutput();
        HashSet<NetworkInfo> networks = new HashSet<NetworkInfo>();
        Vector infStrs = null;
        try {
            infStrs = GenericUtil.getAllStrByTags(output, TAG_ADAPTER);
        }
        catch (ParsingException parsingException) {
            ErrorDescription errorDescription = new ErrorDescription(parsingException.getMessage());
            resultSet.addErrorDescription(cmd.getNodeName(), errorDescription);
            resultSet.setStatus(2);
            Trace.out((String)("Exception parseGetIfInfoCommandOutput " + output));
            Trace.out((String)("Exception caught during parsing interface info: " + parsingException.getMessage()));
            return null;
        }
        for (String str : infStrs) {
            NetworkInfo network = new NetworkInfo();
            network = this.parseGetIfInfoCommandOutput(str, cmd.getNode(), resultSet);
            if (network == null) continue;
            String subnetId = network.getSubnetAsString();
            String ipAddress = network.getIPAsString();
            if (!NetworkUtility.checkSameIPAddresses(subnetId, "127.0.0.0") && !NetworkUtility.checkSameIPAddresses(subnetId, "0.0.0.0") && !NetworkUtility.checkSameIPAddresses(subnetId, "::1") && !ipAddress.toLowerCase().startsWith("fe80") || includeLoopback) {
                networks.add(network);
                continue;
            }
            Trace.out((String)("Ignoring network " + network.getInterfaceName() + " having Subnet address " + subnetId + " and IP address " + ipAddress + " because either subnet is " + "invalid(127.0.0.0 or 0.0.0.0 or ::1) or IPv6 address " + "having link local address(fe80) "));
        }
        return networks;
    }

    List<NetworkInfo> parseIPMPInfoOutput(VerificationCommand cmd, String node, ResultSet resultSet) {
        String output = cmd.getOutput();
        Vector infoStrings = null;
        ArrayList<NetworkInfo> ipmpNetworks = new ArrayList<NetworkInfo>();
        try {
            infoStrings = GenericUtil.getAllStrByTags(output, INTERFACE_KEY);
        }
        catch (ParsingException parsingException) {
            ErrorDescription errorDescription = new ErrorDescription();
            errorDescription.setErrorMessage(parsingException.getMessage());
            resultSet.addErrorDescription(node, errorDescription);
            resultSet.setStatus(2);
            Trace.out((String)("Exception while parsing IPMP Info output " + output));
            Trace.out((String)("Exception error message: " + parsingException.getMessage()));
            return null;
        }
        if (infoStrings.isEmpty()) {
            return ipmpNetworks;
        }
        for (String ipmpInfo : infoStrings) {
            ErrorDescription errorDescription;
            String errorMessage;
            try {
                String addrTypeStr;
                String interfaceName = GenericUtil.getValueByKey(ipmpInfo, NAME_KEY);
                String ipmpGroup = GenericUtil.getValueByKey(ipmpInfo, IPMP_GROUP_KEY);
                String deprecatedStatusStr = GenericUtil.getValueByKey(ipmpInfo, DEPRECATED_KEY);
                String nicConfFileExistStatusStr = GenericUtil.getValueByKey(ipmpInfo, NIC_CONF_FILE_EXISTS_KEY);
                String subnet = GenericUtil.getValueByKey(ipmpInfo, SUBNET_KEY);
                InetAddress subnetAddress = InetAddress.getByName(subnet);
                String hardwareAddr = GenericUtil.getValueByKey(ipmpInfo, HW_ADDRESS_KEY);
                String netTypeStr = GenericUtil.getValueByKey(ipmpInfo, NETTYPE_KEY);
                if (!this.hasValidIPMPNetworkInfo(node, interfaceName, ipmpGroup, deprecatedStatusStr, nicConfFileExistStatusStr, netTypeStr, addrTypeStr = GenericUtil.getValueByKey(ipmpInfo, TYPE_KEY), subnet, resultSet)) continue;
                if (VerificationUtil.isStringGood(interfaceName)) {
                    boolean ifAlreadyAdded = false;
                    if (!ipmpNetworks.isEmpty()) {
                        for (NetworkInfo ipmpNetwork : ipmpNetworks) {
                            if (!ipmpNetwork.getInterfaceName().equals(interfaceName) || !ipmpNetwork.getMacAddress().equals(hardwareAddr)) continue;
                            ifAlreadyAdded = true;
                            Trace.out((String)("The interface " + interfaceName + " is already " + "added, Just updating the subnet list for it..."));
                            ipmpNetwork.setSubnet(subnetAddress);
                            break;
                        }
                    }
                    if (ifAlreadyAdded) {
                        Trace.out((String)("The interface " + interfaceName + " is already added, Skipping..."));
                        continue;
                    }
                    if (interfaceName.contains(":")) {
                        Trace.out((String)(" Skipping sub interface " + interfaceName + " as we have already added main interface for it"));
                        continue;
                    }
                } else {
                    String errorMsg = s_gMsgBundle.getMessage("11080", false, (Object[])new String[]{node});
                    Trace.out((String)"Empty or null value found in interface information");
                    ErrorDescription errorDescription2 = new ErrorDescription();
                    errorDescription2.setErrorMessage(errorMsg);
                    resultSet.addErrorDescription(errorDescription2);
                    resultSet.setStatus(3);
                    continue;
                }
                NetworkInfo network = new NetworkInfo();
                network.setInterfaceName(interfaceName);
                network.setNodeName(node);
                network.setSubnet(subnetAddress);
                network.setGroupName(ipmpGroup);
                if (TYPE_IPV6.equalsIgnoreCase(addrTypeStr)) {
                    network.setIpAddressType(IPAddressUtil.IPAddrType.IPv6);
                } else {
                    network.setIpAddressType(IPAddressUtil.IPAddrType.IPv4);
                }
                network.setDeprecated(this.convertStringToBoolean(deprecatedStatusStr));
                network.setNetworkType(CommandHandler.convertNetworkTypeToInteger(netTypeStr));
                network.setNICConfFileExists(this.convertStringToBoolean(nicConfFileExistStatusStr));
                if (!VerificationUtil.isStringGood(hardwareAddr)) {
                    hardwareAddr = "00:00:00:00:00:00";
                }
                network.setMacAddress(hardwareAddr);
                ipmpNetworks.add(network);
                Trace.out((String)("Added Interface " + interfaceName + " To IPMP list of interfaces"));
                Trace.out((String)network.getGenericNetworkValues());
                Trace.out((String)network.getIPMPNetworkValues());
                VerificationLogData.logInfo(network.getGenericNetworkValues());
                VerificationLogData.logInfo(network.getIPMPNetworkValues());
            }
            catch (ParsingException parsingException) {
                Trace.out((String)("ParsingException while parsing IPMP Info output " + ipmpInfo));
                errorMessage = parsingException.getMessage();
                errorDescription = new ErrorDescription(errorMessage);
                resultSet.addErrorDescription(errorDescription);
                resultSet.setStatus(3);
            }
            catch (UnknownHostException unknownHostException) {
                Trace.out((String)("UnknownHostException while parsing IPMP Info output " + ipmpInfo));
                errorMessage = unknownHostException.getMessage();
                errorDescription = new ErrorDescription(errorMessage);
                resultSet.addErrorDescription(errorDescription);
                resultSet.setStatus(3);
            }
        }
        return ipmpNetworks;
    }

    public Vector<String> parseNICBindOrderInfoOutput(VerificationCommand vCommand) throws NetworkException {
        String output = vCommand.getOutput();
        Vector infoStrings = null;
        try {
            infoStrings = GenericUtil.getAllStrByTags(output, TAG_NIC);
        }
        catch (ParsingException p) {
            Trace.out((String)("Parsing Exception, while parsing: " + output));
            throw new NetworkException(NetworkException.DEFAULT_MSG, p);
        }
        if (infoStrings.isEmpty()) {
            throw new NetworkException("NIC bind order information is empty");
        }
        return infoStrings;
    }

    public boolean convertStringToBoolean(String value) {
        return VerificationUtil.isStringGood(value) && (value.equalsIgnoreCase(YES) || value.equalsIgnoreCase(TRUE));
    }

    public int convertStatusToInteger(String value, String node, String interfaceName, ResultSet resultSet) {
        int status = 50;
        if (!VerificationUtil.isStringGood(value)) {
            return status;
        }
        if (STATUS_STR_UP.equalsIgnoreCase(value)) {
            status = 22;
        } else if (STATUS_STR_DOWN.equalsIgnoreCase(value)) {
            status = 8;
        } else if (STATUS_STR_UNKNOWN.equalsIgnoreCase(value)) {
            status = 50;
        } else {
            String errorMsg = s_gMsgBundle.getMessage("11088", false, (Object[])new String[]{interfaceName, value, UPSTATUS_KEY, node});
            Trace.out((String)("Status value for the interface " + interfaceName + " is null or empty on the node " + node));
            Trace.out((String)("Unsupported Status value " + value + " found in " + "interface information of the interface " + interfaceName));
            ErrorDescription errorDescription = new ErrorDescription(errorMsg);
            resultSet.addErrorDescription(errorDescription);
            resultSet.setStatus(4);
        }
        return status;
    }

    public float getSpeedInMbps(String speed) {
        String kb = "[kK]";
        String gb = "[gG]";
        String mb = "[mM]";
        float value = 0.0f;
        if (VerificationUtil.isStringGood(speed)) {
            value = speed.contains(kb) ? Float.valueOf(speed.split(kb)[0]).floatValue() * 1024.0f : (speed.contains(gb) ? Float.valueOf(speed.split(gb)[0]).floatValue() / 1024.0f : Float.valueOf(speed.split(mb)[0]).floatValue());
        }
        return value;
    }

    public boolean hasValidNetworkInfo(NetworkInfo network, String node, ResultSet resultSet) {
        boolean retValue = true;
        HashSet<String> errorMessages = new HashSet<String>();
        String interfaceName = network.getInterfaceName();
        if (!VerificationUtil.isStringGood(interfaceName)) {
            String errorMsg = s_gMsgBundle.getMessage("11080", false, (Object[])new String[]{node});
            Trace.out((String)"Interface name is Empty or null");
            ErrorDescription errorDescription = new ErrorDescription(errorMsg);
            Trace.out((String)errorMsg);
            resultSet.setStatus(3);
            resultSet.addErrorDescription(errorDescription);
            return false;
        }
        String value = network.getSubnetAsString();
        if (!VerificationUtil.isStringGood(value) || !IPAddressUtil.isIPAddressString((String)value)) {
            if (value == null) {
                value = "null";
            }
            errorMessages.add(s_gMsgBundle.getMessage("11088", false, (Object[])new String[]{interfaceName, value, SUBNET_KEY, node}));
            Trace.out((String)("Subnet value " + value + " for the interface " + interfaceName + " is invalid the node " + node));
            retValue = false;
        }
        if (!VerificationUtil.isStringGood(value = network.getSubnetMaskAsString()) || !IPAddressUtil.isIPAddressString((String)value)) {
            if (value == null) {
                value = "null";
            }
            errorMessages.add(s_gMsgBundle.getMessage("11088", false, (Object[])new String[]{interfaceName, value, MASK_KEY, node}));
            Trace.out((String)("Subnet mask value " + value + " for the interface " + interfaceName + " is invalid the node " + node));
            resultSet.setStatus(3);
            retValue = false;
        }
        if (!VerificationUtil.isStringGood(value = network.getIPAsString()) || !IPAddressUtil.isIPAddressString((String)value)) {
            if (value == null) {
                value = "null";
            }
            errorMessages.add(s_gMsgBundle.getMessage("11088", false, (Object[])new String[]{interfaceName, value, IP_KEY, node}));
            Trace.out((String)("IP value " + value + "for the interface " + interfaceName + " is invalid on the node " + node));
            resultSet.setStatus(3);
            retValue = false;
        }
        if (!VerificationUtil.isStringGood(value = String.valueOf(network.getStatus()))) {
            errorMessages.add(s_gMsgBundle.getMessage("11088", false, (Object[])new String[]{interfaceName, value, UPSTATUS_KEY, node}));
            Trace.out((String)("Status value for the interface " + interfaceName + " is null or empty on the node " + node));
            retValue = false;
        }
        if (!VerificationUtil.isStringGood(value = String.valueOf(network.getMacAddress()))) {
            errorMessages.add(s_gMsgBundle.getMessage("11088", false, (Object[])new String[]{interfaceName, value, HW_ADDRESS_KEY, node}));
            Trace.out((String)("Hardware address for the interface " + interfaceName + " is null or empty on the node " + node));
        }
        for (String errorMsg : errorMessages) {
            ErrorDescription errorDescription = new ErrorDescription(errorMsg);
            Trace.out((String)errorMsg);
            resultSet.addErrorDescription(errorDescription);
            if (!retValue) {
                resultSet.setStatus(3);
                continue;
            }
            resultSet.setStatus(4);
        }
        return retValue;
    }

    public boolean hasValidIPMPNetworkInfo(String node, String interfaceName, String ipmpGroup, String deprecatedStatusStr, String nicConfFileExistStatusStr, String netTypeStr, String addrTypeStr, String subnet, ResultSet resultSet) {
        HashSet<String> errorMessages = new HashSet<String>();
        boolean retValue = true;
        if (!VerificationUtil.isStringGood(interfaceName)) {
            String errorMsg = s_gMsgBundle.getMessage("11080", false, (Object[])new String[]{node});
            Trace.out((String)"Interface name is Empty or null");
            ErrorDescription errorDescription = new ErrorDescription(errorMsg);
            Trace.out((String)errorMsg);
            resultSet.setStatus(3);
            resultSet.addErrorDescription(errorDescription);
            return false;
        }
        String value = ipmpGroup;
        if (!VerificationUtil.isStringGood(value)) {
            if (value == null) {
                value = "null";
            }
            errorMessages.add(s_gMsgBundle.getMessage("11088", false, (Object[])new String[]{interfaceName, value, IPMP_GROUP_KEY, node}));
            Trace.out((String)("IPMP group value " + value + " for the interface " + interfaceName + " is invalid the node " + node));
        }
        if (!VerificationUtil.isStringGood(value = deprecatedStatusStr)) {
            if (value == null) {
                value = "null";
            }
            errorMessages.add(s_gMsgBundle.getMessage("11088", false, (Object[])new String[]{interfaceName, value, DEPRECATED_KEY, node}));
            Trace.out((String)("Deprecated value value " + value + " for the interface " + interfaceName + " is invalid the node " + node));
        }
        if (!VerificationUtil.isStringGood(value = nicConfFileExistStatusStr)) {
            if (value == null) {
                value = "null";
            }
            errorMessages.add(s_gMsgBundle.getMessage("11088", false, (Object[])new String[]{interfaceName, value, NIC_CONF_FILE_EXISTS_KEY, node}));
            Trace.out((String)("IPMP Config file exists value " + value + " for the interface " + interfaceName + " is invalid the node " + node));
        }
        value = netTypeStr;
        if (!VerificationUtil.isStringGood(netTypeStr)) {
            if (value == null) {
                value = "null";
            }
            errorMessages.add(s_gMsgBundle.getMessage("11088", false, (Object[])new String[]{interfaceName, value, NETTYPE_KEY, node}));
            Trace.out((String)("Network Type value " + value + " for the interface " + interfaceName + " is invalid on the node " + node));
        }
        if (!VerificationUtil.isStringGood(value = subnet) || !IPAddressUtil.isIPAddressString((String)value)) {
            if (value == null) {
                value = "null";
            }
            errorMessages.add(s_gMsgBundle.getMessage("11088", false, (Object[])new String[]{interfaceName, value, SUBNET_KEY, node}));
            Trace.out((String)("Subnet value " + value + " for the interface " + interfaceName + " is invalid on the node " + node));
        }
        for (String errorMsg : errorMessages) {
            ErrorDescription errorDescription = new ErrorDescription(errorMsg);
            Trace.out((String)errorMsg);
            resultSet.addErrorDescription(errorDescription);
            if (!retValue) {
                resultSet.setStatus(3);
                continue;
            }
            resultSet.setStatus(4);
        }
        return retValue;
    }

    public static ICMPPingCommand getICMPPingCommand(String node, ConMatrix matrix, boolean isRDSPingCheck) {
        String key = String.valueOf(Thread.currentThread().getId());
        String pingInputFile = ICMPPingCommand.getPingInputFileName(node, key);
        String outputFile = ICMPPingCommand.getPingOutputFileName(node, key);
        String[] args = new String[]{"-chkICMPPing", pingInputFile, outputFile, String.valueOf(VerificationUtil.getDefaultPingMaxTimeout()), isRDSPingCheck ? "1" : "0"};
        ICMPPingCommand icmpPingCmd = new ICMPPingCommand(node, args, matrix);
        return icmpPingCmd;
    }

    public static int convertNetworkTypeToInteger(String value) {
        if (!VerificationUtil.isStringGood(value)) {
            return 4;
        }
        int netType = 4;
        if ("PRIVATE".equalsIgnoreCase(value)) {
            netType = 1;
        } else if ("PUBLIC".equalsIgnoreCase(value)) {
            netType = 2;
        } else if ("ASM".equalsIgnoreCase(value)) {
            netType = 128;
        } else if (STATUS_STR_UNKNOWN.equalsIgnoreCase(value)) {
            netType = 4;
        } else if ("LOCAL".equalsIgnoreCase(value)) {
            netType = 256;
        }
        return netType;
    }
}

