/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.global;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.install.UserInfo;
import oracle.cluster.remote.NodeProgressListener;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.fixup.FixupSessionData;
import oracle.ops.mgmt.cluster.RemoteShellException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nativesystem.sUnixCommands;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.CheckASMStampCommand;
import oracle.ops.verification.framework.command.CheckArchitectureCommand;
import oracle.ops.verification.framework.command.CheckAvailMemoryCommand;
import oracle.ops.verification.framework.command.CheckCRShealthCommand;
import oracle.ops.verification.framework.command.CheckDaemonAliveCommand;
import oracle.ops.verification.framework.command.CheckDirStructure;
import oracle.ops.verification.framework.command.CheckDiskAFDCapableCommand;
import oracle.ops.verification.framework.command.CheckFileCommand;
import oracle.ops.verification.framework.command.CheckFileInSysPathCommand;
import oracle.ops.verification.framework.command.CheckFileLinkCommand;
import oracle.ops.verification.framework.command.CheckGroupCommand;
import oracle.ops.verification.framework.command.CheckHostnameLengthCommand;
import oracle.ops.verification.framework.command.CheckHostsFileCommand;
import oracle.ops.verification.framework.command.CheckIsLocalOnlyCommand;
import oracle.ops.verification.framework.command.CheckKernelParamCommand;
import oracle.ops.verification.framework.command.CheckKernelVerCommand;
import oracle.ops.verification.framework.command.CheckMemoryCommand;
import oracle.ops.verification.framework.command.CheckMultUIDCommand;
import oracle.ops.verification.framework.command.CheckOCRIntegrityCommand;
import oracle.ops.verification.framework.command.CheckOCRLocationCommand;
import oracle.ops.verification.framework.command.CheckOSPatchCommand;
import oracle.ops.verification.framework.command.CheckOSVerCommand;
import oracle.ops.verification.framework.command.CheckPackageCommand;
import oracle.ops.verification.framework.command.CheckPortCommand;
import oracle.ops.verification.framework.command.CheckProcessAliveCommand;
import oracle.ops.verification.framework.command.CheckRootGidConsistencyCommand;
import oracle.ops.verification.framework.command.CheckRunlevelCommand;
import oracle.ops.verification.framework.command.CheckSameTimeZoneCommand;
import oracle.ops.verification.framework.command.CheckSwapSpaceCommand;
import oracle.ops.verification.framework.command.CheckUserCommand;
import oracle.ops.verification.framework.command.CheckUserEquivCommand;
import oracle.ops.verification.framework.command.CheckUserEquivRemoteCommand;
import oracle.ops.verification.framework.command.CheckUserMaskCommand;
import oracle.ops.verification.framework.command.CheckUsrInGrpCommand;
import oracle.ops.verification.framework.command.CopyFileCommand;
import oracle.ops.verification.framework.command.DeleteFileCommand;
import oracle.ops.verification.framework.command.GetBugSymbolCommand;
import oracle.ops.verification.framework.command.GetCVUSubDirectoryInfoCommand;
import oracle.ops.verification.framework.command.GetDirSizeCommand;
import oracle.ops.verification.framework.command.GetExectaskVerCommand;
import oracle.ops.verification.framework.command.GetFileInfoCommand;
import oracle.ops.verification.framework.command.GetFileVerCommand;
import oracle.ops.verification.framework.command.GetKernelParamCommand;
import oracle.ops.verification.framework.command.GetKernelVerCommand;
import oracle.ops.verification.framework.command.GetLoginShellCommand;
import oracle.ops.verification.framework.command.GetLongestValidPathCommand;
import oracle.ops.verification.framework.command.GetNumProcessorCommand;
import oracle.ops.verification.framework.command.GetPackageCommand;
import oracle.ops.verification.framework.command.GetRLimitCommand;
import oracle.ops.verification.framework.command.GetRegKeyCommand;
import oracle.ops.verification.framework.command.GetServiceConfigCommand;
import oracle.ops.verification.framework.command.GetSpaceAvailCommand;
import oracle.ops.verification.framework.command.GetSpaceCommand;
import oracle.ops.verification.framework.command.GetSysParamCommand;
import oracle.ops.verification.framework.command.GetUniqueIDCommand;
import oracle.ops.verification.framework.command.RunExeCommand;
import oracle.ops.verification.framework.command.RunGenericCommand;
import oracle.ops.verification.framework.command.RunGenericRootCommand;
import oracle.ops.verification.framework.command.RunKillProcCommand;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.config.PackageConstraint;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzerFactory;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CommandsUtil;
import oracle.ops.verification.framework.util.CustomCommandsUtil;
import oracle.ops.verification.framework.util.RootAutomationNotConfiguredException;
import oracle.ops.verification.framework.util.RootUserCredentials;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GlobalExecution {
    private static final String LSEP = System.getProperty("line.separator");
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");

    public boolean getFreeSpace(String[] nodeList, String location, ResultSet resultSet) {
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new GetSpaceCommand(nodeList[i], location);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        if (cmdResult) {
            Enumeration e = resultSet.getResultTable().keys();
            while (e.hasMoreElements()) {
                String node = (String)e.nextElement();
                Trace.out((String)("--------- Execution Trace for GetSpaceCommand from node: " + node + " ------------"));
                Result result = (Result)resultSet.getResultTable().get(node);
                Vector traceSet = result.getTraceInfoSet();
                Enumeration t = traceSet.elements();
                while (t.hasMoreElements()) {
                    Trace.out((String)((String)t.nextElement()));
                }
            }
        }
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkUserEquiv(String[] nodeList, ResultSet resultSet) {
        return this.checkUserEquiv(nodeList, false, true, resultSet);
    }

    public boolean checkUserEquiv(String[] nodeList, boolean overrideXWinCheckConfigSettings, boolean xwinCheck, ResultSet resultSet) {
        int nodeCount = nodeList.length;
        int cmdCount = 0;
        for (int i = 0; i < nodeCount; ++i) {
            if (VerificationUtil.isLocalNode(nodeList[i])) continue;
            ++cmdCount;
        }
        Command[] cmdArray = new Command[cmdCount];
        int cmdIndex = 0;
        for (int i = 0; i < nodeCount; ++i) {
            if (VerificationUtil.isLocalNode(nodeList[i])) {
                resultSet.addResult(nodeList[i], 1);
                continue;
            }
            cmdArray[cmdIndex] = overrideXWinCheckConfigSettings ? new CheckUserEquivCommand(nodeList[i], xwinCheck) : new CheckUserEquivCommand(nodeList[i]);
            ++cmdIndex;
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        Enumeration e = resultSet.getResultTable().keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Trace.out((String)("--------- Execution Trace for CheckUserEquivCommand from node: " + node + " ------------"));
            Result result = (Result)resultSet.getResultTable().get(node);
            Vector traceSet = result.getTraceInfoSet();
            Enumeration t = traceSet.elements();
            while (t.hasMoreElements()) {
                Trace.out((String)((String)t.nextElement()));
            }
        }
        Hashtable t = resultSet.getResultTable();
        e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                Trace.out((String)("User Equivalence exists on node: " + node));
                resultSet.addResult(node, 1);
                continue;
            }
            Trace.out((String)("User Equivalence doesn't exist on node: " + node));
            resultSet.addResult(node, 3);
        }
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkRemoteUserEquiv(String[] nodeList, String sshCmd, ResultSet resultSet) {
        int cmdCount = nodeList.length;
        int nodeCount = nodeList.length;
        boolean isLocalNodeFound = false;
        for (int i = 0; i < nodeCount; ++i) {
            if (!VerificationUtil.isLocalNode(nodeList[i])) continue;
            isLocalNodeFound = true;
            break;
        }
        if (isLocalNodeFound) {
            --cmdCount;
        }
        Command[] cmdArray = new Command[cmdCount];
        int cmdIndex = 0;
        for (int i = 0; i < nodeCount; ++i) {
            if (VerificationUtil.isLocalNode(nodeList[i])) {
                resultSet.addResult(nodeList[i], 1);
                continue;
            }
            StringBuilder nodeSB = new StringBuilder();
            boolean isFirst = true;
            for (int j = 0; j < nodeCount; ++j) {
                if (i == j) continue;
                if (!isFirst) {
                    nodeSB.append(",");
                } else {
                    isFirst = false;
                }
                nodeSB.append(nodeList[j]);
            }
            cmdArray[cmdIndex] = new CheckUserEquivRemoteCommand(nodeList[i], nodeSB.toString(), sshCmd);
            ++cmdIndex;
        }
        boolean cmdResult = true;
        int batchSize = VerificationUtil.getRemoteSSHBatchSize();
        int batchCount = cmdArray.length / batchSize + 1;
        int remainingCmds = cmdArray.length % batchSize;
        for (int i = 0; i < batchCount; ++i) {
            Command[] tempCmdArr;
            int copySize = batchSize;
            if (i + 1 != batchCount) {
                tempCmdArr = new Command[batchSize];
            } else {
                copySize = remainingCmds;
                tempCmdArr = new Command[remainingCmds];
            }
            System.arraycopy(cmdArray, batchSize * i, tempCmdArr, 0, copySize);
            ResultSet tempRS = new ResultSet();
            cmdResult &= new GlobalHandler().submit(tempCmdArr, 0, tempRS);
            resultSet.addResultSetData(tempRS);
        }
        if (cmdResult) {
            Enumeration e = resultSet.getResultTable().keys();
            while (e.hasMoreElements()) {
                String node = (String)e.nextElement();
                Trace.out((String)("------ exec trace for CheckUserEquivRemoteCommand from node: " + node + " --------"));
                Result result = (Result)resultSet.getResultTable().get(node);
                Vector traceSet = result.getTraceInfoSet();
                Enumeration t = traceSet.elements();
                while (t.hasMoreElements()) {
                    Trace.out((String)((String)t.nextElement()));
                }
            }
        }
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkOCRIntegrity(String[] nodeList, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution: inside checkOCRIntegrity...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckOCRIntegrityCommand(nodeList[i]);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("checkOCRIntegrity", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkOCRIntegrity(String[] nodeList, RootUserCredentials rootCreds, int timeout, ResultSet resultSet) throws RootAutomationNotConfiguredException {
        Trace.out((String)"GlobalExecution: inside checkOCRIntegrity as root...");
        CheckOCRIntegrityCommand ocrIntegrityCmd = new CheckOCRIntegrityCommand(nodeList, rootCreds, timeout, resultSet);
        boolean cmdResult = ocrIntegrityCmd.runCmdAsRoot();
        this.dumpTraceInfo("checkOCRIntegrity", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkOCRLocation(String[] nodeList, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution: inside checkOCRLocation...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckOCRLocationCommand(nodeList[i]);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("checkOCRLocation", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkIsLocalOnly(String[] nodeList, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution: inside checkIsLocalOnly...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckIsLocalOnlyCommand(nodeList[i]);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("checkIsLocalOnly", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkMultipleUID(String[] nodeList, String uid, ResultSet resultSet) {
        Trace.out((int)2, (String)"GlobalExecution: inside checkMultipleUID...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckMultUIDCommand(nodeList[i], uid);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("checkMultipleUID", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public ResultSet checkDiskAFDCapable(Hashtable<String, List<String>> nodewiseDiskListTable) {
        Trace.out((int)2, (String)"GlobalExecution: inside checkDiskAFDCapable...");
        ResultSet resultSet = new ResultSet();
        Hashtable nodewiseDiskCmdListTable = new Hashtable();
        for (String node : nodewiseDiskListTable.keySet()) {
            for (String string : nodewiseDiskListTable.get(node)) {
                CheckDiskAFDCapableCommand nodeDiskCmd = new CheckDiskAFDCapableCommand(node, string);
                if (nodewiseDiskCmdListTable.containsKey(node)) {
                    ((List)nodewiseDiskCmdListTable.get(node)).add(nodeDiskCmd);
                    continue;
                }
                ArrayList<CheckDiskAFDCapableCommand> nodeDiskCmdList = new ArrayList<CheckDiskAFDCapableCommand>();
                nodeDiskCmdList.add(nodeDiskCmd);
                nodewiseDiskCmdListTable.put(node, nodeDiskCmdList);
            }
        }
        int diskCmdCnt = 0;
        ArrayList iterationList = new ArrayList();
        while (true) {
            ArrayList cmdList = new ArrayList();
            for (String node : nodewiseDiskCmdListTable.keySet()) {
                if (((List)nodewiseDiskCmdListTable.get(node)).size() <= diskCmdCnt) continue;
                cmdList.add(((List)nodewiseDiskCmdListTable.get(node)).get(diskCmdCnt));
            }
            if (cmdList.isEmpty()) break;
            iterationList.add(cmdList);
            ++diskCmdCnt;
        }
        for (List list : iterationList) {
            ResultSet iterationResSet = new ResultSet();
            Command[] commandArray = list.toArray(new Command[0]);
            new GlobalHandler().submit(commandArray, 0, iterationResSet);
            this.dumpTraceInfo("checkDiskAFDCapable", iterationResSet);
            Hashtable<String, String> operationFailedNodeDiskTable = new Hashtable<String, String>();
            Hashtable ht = iterationResSet.getResultTable();
            for (Command cmd : commandArray) {
                String node = cmd.getNode();
                String nodeDiskPath = ((CheckDiskAFDCapableCommand)cmd).getDiskPath();
                Result afdResult = (Result)ht.get(node);
                if (afdResult.getStatus() == 1) {
                    Trace.out((String)("The disk (" + nodeDiskPath + ") was found AFD capable on node " + node));
                    continue;
                }
                if (afdResult.getStatus() == 3) {
                    Trace.out((String)("The disk (" + nodeDiskPath + ") was NOT found AFD capable on node " + node));
                    iterationResSet.addErrorDescription(node, new ErrorDescription(s_gMsgBundle.getMessage("12805", true, (Object[])new String[]{nodeDiskPath, node})));
                    continue;
                }
                Trace.out((String)("Failed to determine if the disk (" + nodeDiskPath + ") is AFD capable on node " + node));
                operationFailedNodeDiskTable.put(node, nodeDiskPath);
            }
            if (!operationFailedNodeDiskTable.isEmpty()) {
                iterationResSet.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("12806", true, (Object[])new String[]{VerificationUtil.strCollection2String(operationFailedNodeDiskTable.values()), VerificationUtil.strCollection2String(operationFailedNodeDiskTable.keySet())})));
            }
            resultSet.uploadResultSet(iterationResSet);
        }
        return resultSet;
    }

    public boolean timeZoneConsistency(String[] nodeList, ResultSet resultSet, Hashtable cfgFilePaths) {
        Trace.out((int)2, (String)"GlobalExecution: inside timeZoneConsistency...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckSameTimeZoneCommand(nodeList[i], (String)cfgFilePaths.get(nodeList[i]));
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("sameTimeZone", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean timeZoneConsistency(String[] nodeList, ResultSet resultSet) {
        Trace.out((int)2, (String)"GlobalExecution: inside timeZoneConsistency...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckSameTimeZoneCommand(nodeList[i]);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("sameTimeZone", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkCRShealth(String[] nodeList, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution: inside checkCRShealth...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckCRShealthCommand(nodeList[i]);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("checkCRShealth", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkUser(String[] nodeList, String userName, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution: inside checkUser...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckUserCommand(nodeList[i], userName);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("checkUser", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkGroup(String[] nodeList, String groupName, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution: inside checkGroup...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckGroupCommand(nodeList[i], groupName);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("checkGroup", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkHostsFile(String[] nodeList, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution: inside checkHostsFile...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckHostsFileCommand(nodeList[i]);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("checkHostsFile", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkUsrInGrp(String[] nodeList, String userName, String groupName, int chkprim, ResultSet resultSet) {
        return this.checkUsrInGrp(nodeList, userName, groupName, chkprim, false, resultSet);
    }

    public boolean checkUsrInGrp(String[] nodeList, String userName, String groupName, int chkprim, boolean useEtcGroup, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution: inside checkUsrInGrp...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = useEtcGroup ? new CheckUsrInGrpCommand(nodeList[i], userName, groupName, chkprim, useEtcGroup) : new CheckUsrInGrpCommand(nodeList[i], userName, groupName, chkprim);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("checkUsrInGrp", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean getUserGroups(String[] nodeList, String userName, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution: inside getUserGroups...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckUsrInGrpCommand(nodeList[i], userName, "", 3, false, true);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("getUserGroup", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean getExectaskVer(String[] nodeList, ResultSet resultSet, boolean isCopy) {
        Trace.out((String)"GlobalExecution: inside getExectaskVer...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = !isCopy ? new GetExectaskVerCommand(nodeList[i]) : new GetExectaskVerCommand(nodeList[i], true);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("getExectaskVer", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean getLoginShell(String[] nodeList, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution: inside getLoginShell...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new GetLoginShellCommand(nodeList[i]);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("getLoginShell", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean getLongestValidPath(String[] nodeList, String location, boolean isWritable, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution: inside getLongestValidPath...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new GetLongestValidPathCommand(nodeList[i], location, isWritable);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("getLongestValidPath", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkMemory(String[] nodeList, long memReqd, ResultSet resultSet) {
        return this.checkMemory(nodeList, new StorageSize((double)memReqd, StorageUnit.BYTE), resultSet);
    }

    public boolean checkMemory(String[] nodeList, long memReqd, ResultSet resultSet, boolean forSwapCalc) {
        return this.checkMemory(nodeList, new StorageSize((double)memReqd, StorageUnit.BYTE), resultSet, forSwapCalc);
    }

    public boolean checkMemory(String[] nodeList, StorageSize memReqd, ResultSet resultSet) {
        return this.checkMemory(nodeList, memReqd, resultSet, false);
    }

    public boolean checkMemory(String[] nodeList, StorageSize memReqd, ResultSet resultSet, boolean forSwapCalc) {
        Trace.out((String)"GlobalExecution: inside checkMemory...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckMemoryCommand(nodeList[i], memReqd, forSwapCalc);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("checkMemory", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkAvailMemory(String[] nodeList, long memReqd, ResultSet resultSet) {
        return this.checkAvailMemory(nodeList, new StorageSize((double)memReqd, StorageUnit.BYTE), resultSet);
    }

    public boolean checkAvailMemory(String[] nodeList, StorageSize memReqd, ResultSet resultSet) {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"GlobalExecution: inside checkAvailMemory...");
        }
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckAvailMemoryCommand(nodeList[i], memReqd);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        if (Trace.isTraceEnabled()) {
            this.dumpTraceInfo("checkAvailMemory", resultSet);
        }
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkRunlevel(String[] nodeList, int runLvlReqd, ResultSet resultSet) {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"GlobalExecution: inside checkRunlevel...");
        }
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckRunlevelCommand(nodeList[i], runLvlReqd);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        if (Trace.isTraceEnabled()) {
            this.dumpTraceInfo("checkRunlevel", resultSet);
        }
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkProcessAlive(String[] nodeList, String procName, ResultSet resultSet) {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"GlobalExecution: inside checkProcessAlive...");
        }
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckProcessAliveCommand(nodeList[i], procName);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        if (Trace.isTraceEnabled()) {
            this.dumpTraceInfo("checkProcessAlive", resultSet);
        }
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkDaemonConfigured(String[] nodeList, String dmnName, ResultSet resultSet) {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"GlobalExecution: inside checkDaemonConfigured...");
        }
        boolean cmdResult = true;
        HashMap<String, String> nodeRunlevelMap = new HashMap<String, String>();
        ResultSet runLevelresultSet = new ResultSet();
        cmdResult = this.checkRunlevel(nodeList, 3, runLevelresultSet);
        for (String node : nodeList) {
            Result nodeRslt = runLevelresultSet.getResult(node);
            String runLevelOnNode = null;
            if (nodeRslt == null) continue;
            if ((nodeRslt.getStatus() == 1 || nodeRslt.getStatus() == 3) && nodeRslt.getResultInfoSet().size() > 0) {
                runLevelOnNode = (String)nodeRslt.getResultInfoSet().elementAt(0);
                Trace.out((String)("Run Level retrieved from node " + node + " is " + runLevelOnNode));
                nodeRunlevelMap.put(node, runLevelOnNode);
                continue;
            }
            ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("7565", false, (Object[])new String[]{node}), s_msgBundle.getCause("7565", false), s_msgBundle.getAction("7565", false));
            nodeRslt.addErrorDescription(errDesc);
            resultSet.addResult(node, nodeRslt);
        }
        int nodeCount = nodeRunlevelMap.keySet().size();
        if (nodeCount > 0) {
            ResultSet checkDmnCfgresultSet = new ResultSet();
            cmdResult = this.runGenericCmd(nodeRunlevelMap.keySet().toArray(new String[0]), new CustomCommandsUtil().getDaemonConfigCommand(dmnName), null, checkDmnCfgresultSet);
            ExecutionAnalyzer analyzer = ExecutionAnalyzerFactory.getExecutionAnalyzer();
            for (String node : nodeRunlevelMap.keySet()) {
                Result nodeResult = checkDmnCfgresultSet.getResult(node);
                if (nodeResult != null) {
                    if (nodeResult.getStatus() == 2) continue;
                    String reoutput = (String)nodeResult.getResultInfoSet().firstElement();
                    Result dmnCfgResultNode = new Result(node);
                    analyzer.verifyDaemonConfigured(dmnName, reoutput, (String)nodeRunlevelMap.get(node), dmnCfgResultNode);
                    resultSet.addResult(node, dmnCfgResultNode);
                    continue;
                }
                resultSet.addResult(node, 2);
            }
        }
        if (Trace.isTraceEnabled()) {
            this.dumpTraceInfo("checkDaemonConfigured", resultSet);
        }
        return cmdResult && 1 == resultSet.getStatus();
    }

    private void dumpTraceInfo(String methodName, ResultSet rset) {
        Enumeration e = rset.getResultTable().keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Trace.out((String)("---- Execution Trace for " + methodName + " from node: " + node + " -----"));
            Result result = (Result)rset.getResultTable().get(node);
            Vector traceSet = result.getTraceInfoSet();
            Enumeration t = traceSet.elements();
            while (t.hasMoreElements()) {
                Trace.out((String)((String)t.nextElement()));
            }
        }
    }

    public boolean checkArchitecture(String[] nodeList, String archVal, ResultSet resultSet) {
        return this.checkArchitecture(nodeList, Arrays.asList(archVal), resultSet);
    }

    public boolean checkArchitecture(String[] nodeList, List<String> archVals, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside checkArchitecture...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckArchitectureCommand(nodeList[i], archVals);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("checkArchitecture", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkUserMask(String[] nodeList, String umask, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside checkUserMask...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            if (VerificationUtil.isLocalNode(nodeList[i])) {
                String remoteNodeToUse = null;
                if (i > 0) {
                    remoteNodeToUse = nodeList[i - 1];
                } else if (nodeCount > 1) {
                    remoteNodeToUse = nodeList[i + 1];
                }
                cmdArray[i] = new CheckUserMaskCommand(nodeList[i], umask);
                this.runVerificationCommandOnLocalNodeRemotely(remoteNodeToUse, (VerificationCommand)cmdArray[i]);
                Result localNodeRes = ((VerificationCommand)cmdArray[i]).getResult();
                if (localNodeRes == null || localNodeRes.getStatus() != 2) continue;
                VerificationUtil.traceAndLog("The remote as well as local SSH approach failed for the local node UMASK retrieval. Falling back to plain exectask approach.");
                cmdArray[i] = new CheckUserMaskCommand(nodeList[i], umask);
                continue;
            }
            cmdArray[i] = new CheckUserMaskCommand(nodeList[i], umask);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("checkUserMask", resultSet);
        if (!cmdResult) return false;
        if (1 != resultSet.getStatus()) return false;
        return true;
    }

    public Result runVerificationCommandOnLocalNodeRemotely(String remoteNodeToUse, VerificationCommand vrfCommand) {
        String[] arguments = vrfCommand.getArguments();
        Result result = this.runExectaskOnLocalNodeRemotely(remoteNodeToUse, arguments);
        vrfCommand.setResult(result);
        return result;
    }

    public Result runExectaskOnLocalNodeRemotely(String remoteNodeToUse, String[] arguments) {
        String output = null;
        String localNode = VerificationUtil.getLocalNode();
        Result result = new Result(localNode);
        String remoteShellCommand = null;
        try {
            remoteShellCommand = new SystemFactory().CreateSystem().getRemoteShellCmd();
        }
        catch (RemoteShellException rse) {
            Trace.out((String)rse.getMessage());
            remoteShellCommand = "/usr/bin/ssh" + sUnixCommands.NO_FALLBACK_TO_RSH + sUnixCommands.NO_PW_AUTHENTICATION + " -o StrictHostKeyChecking=yes " + " -o NumberOfPasswordPrompts=0 ";
            VerificationUtil.traceAndLogError("The remote shell is not yet set. Trying with SSH command [" + remoteShellCommand + "]");
        }
        String nodeToRunSSHCommand = localNode;
        String command = remoteShellCommand + nodeToRunSSHCommand + " -n " + VerificationUtil.getPathToExectask();
        for (String arg : arguments) {
            command = command + " " + arg;
        }
        ResultSet localNodeLimitResSet = new ResultSet();
        Hashtable ht = this.runExeWithOutput(new String[]{nodeToRunSSHCommand}, command, localNodeLimitResSet);
        if (!localNodeLimitResSet.allSuccess() && VerificationUtil.isStringGood(remoteNodeToUse)) {
            Trace.out((String)"Local node SSH approach did not succeed. Trying to SSH from remote node to run exectask on the local node");
            nodeToRunSSHCommand = remoteNodeToUse;
            localNodeLimitResSet.clear();
            ht = this.runExeWithOutput(new String[]{nodeToRunSSHCommand}, command, localNodeLimitResSet);
        }
        if (ht.containsKey(nodeToRunSSHCommand)) {
            output = (String)ht.get(nodeToRunSSHCommand);
            Trace.out((String)("Output for the exectask command ran on local node via SSH from remote node is (" + output + ")"));
            result.setExectaskOutput(output);
            result.setStatus(1);
        } else {
            result.setStatus(2);
        }
        return result;
    }

    public boolean checkOSVersion(String[] nodeList, String osver, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside checkOSVersion...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckOSVerCommand(nodeList[i], osver);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("checkOSVersion", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkPackage(String[] nodeList, PackageConstraint pkgCon, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside checkPackage...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckPackageCommand(nodeList[i], pkgCon);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("checkPackage", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean getPackage(String[] nodeList, String pkgName, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside getPackage...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new GetPackageCommand(nodeList[i], pkgName);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("getPackage", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkKernelVersion(String[] nodeList, String krnver, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside checkKernelVersion...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckKernelVerCommand(nodeList[i], krnver);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("checkKernelVersion", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean getKernelVersion(String[] nodeList, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside getKernelVersion...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new GetKernelVerCommand(nodeList[i]);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("getKernelVersion", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkKerParam(String[] nodeList, String param, long reqval, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside checkKerParam...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckKernelParamCommand(nodeList[i], param, reqval);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("checkKerParam", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean getKerParam(String[] nodeList, String param, ResultSet resultSet) {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new GetKernelParamCommand(nodeList[i], param);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.dumpTraceInfo("getKerParam", resultSet);
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean getConfigKerParam(String[] nodeList, String param, ResultSet resultSet) {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new GetKernelParamCommand(nodeList[i], param, true);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.dumpTraceInfo("getConfigKerParam", resultSet);
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
        return cmdResult && 1 == resultSet.getStatus();
    }

    public Result getLocalNodeResourceLimit(String remoteNodeToUse, String userName, String limitType, String resourceType) {
        GetRLimitCommand vCmd = new GetRLimitCommand(VerificationUtil.getLocalNode(), userName, limitType, resourceType);
        Result result = this.runVerificationCommandOnLocalNodeRemotely(remoteNodeToUse, vCmd);
        if (result.getStatus() == 1) {
            String output = result.getExectaskOutput();
            Trace.out((String)("Output for the command ran to retrieve local node's " + resourceType + " limits via SSH from remote node is (" + output + ")"));
            if (output.contains("<CV_VAL>") && output.contains("</CV_VAL>")) {
                String localNodeOutput = output.substring(output.indexOf("<CV_VAL>") + "<CV_VAL>".length(), output.lastIndexOf("</CV_VAL>"));
                Trace.out((String)("Local node output is (" + localNodeOutput + " )"));
                String limitValue = VerificationUtil.fetchVerificationValue(localNodeOutput);
                Trace.out((String)("CV_VAL for local node is (" + limitValue + ")"));
                if (VerificationUtil.isStringGood(limitValue)) {
                    Vector<String> values;
                    if (limitValue.contains("ULIMIT") && (values = VerificationUtil.tagHashFilter(limitValue, "ULIMIT")).size() > 0) {
                        limitValue = values.elementAt(0);
                    }
                    if (VerificationUtil.isStringGood(limitValue)) {
                        Trace.out((String)("Limit on local node is (" + limitValue + ")"));
                        result.setStatus(1);
                        result.addResultInfo(limitValue.trim());
                    }
                }
                if (!VerificationUtil.isStringGood(limitValue)) {
                    Trace.out((String)("Failed to parse the output for local node limit value. Output is (" + localNodeOutput + " )"));
                    result.setStatus(2);
                }
            } else {
                String error = VerificationUtil.fetchError(output);
                if (VerificationUtil.isStringGood(error)) {
                    result.addErrorDescription(new ErrorDescription(error));
                }
                result.setStatus(2);
            }
        } else {
            result.setStatus(2);
        }
        return result;
    }

    public boolean getRLimit(String[] nodeList, String userName, String limitType, String resourceType, ResultSet resultSet) {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new GetRLimitCommand(nodeList[i], userName, limitType, resourceType);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.dumpTraceInfo("getRLimit", resultSet);
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkSwapSpace(String[] nodeList, long swspace, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside checkSwapSpace...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckSwapSpaceCommand(nodeList[i], swspace);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("checkSwapSpace", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkSwapSpace(String[] nodeList, StorageSize swspace, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside checkSwapSpace...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckSwapSpaceCommand(nodeList[i], swspace);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("checkSwapSpace", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkDirStructure(String[] nodeList, String oraBase, String crsHome, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside checkDirStructure...");
        int numOfNodes = nodeList.length;
        Command[] cmdArray = new Command[numOfNodes];
        for (int i = 0; i < numOfNodes; ++i) {
            cmdArray[i] = new CheckDirStructure(nodeList[i], oraBase, crsHome);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("checkDirStructure", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean getSysParam(String[] nodeList, String param, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside getSysParam...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new GetSysParamCommand(nodeList[i], param);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("getSysParam", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkOSPatch(String[] nodeList, String patch, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside checkOSPatch...");
        String[] patches = VerificationUtil.string2strArr(patch, "|");
        ArrayList<String> nodesToCheckPatch = new ArrayList<String>();
        nodesToCheckPatch.addAll(Arrays.asList(nodeList));
        ResultSet patchResultSet = new ResultSet();
        for (String patchName : patches) {
            patchResultSet = new ResultSet();
            int nodeCount = nodesToCheckPatch.size();
            Command[] cmdArray = new Command[nodeCount];
            for (int i = 0; i < nodeCount; ++i) {
                cmdArray[i] = new CheckOSPatchCommand((String)nodesToCheckPatch.get(i), patchName);
            }
            new GlobalHandler().submit(cmdArray, 0, patchResultSet);
            this.dumpTraceInfo("checkOSPatch (" + patchName + ")", patchResultSet);
            ArrayList<String> patchAbsentNodes = new ArrayList<String>();
            for (String node : nodesToCheckPatch) {
                Result nodeResult = patchResultSet.getResult(node);
                if (nodeResult.getStatus() == 1) {
                    Trace.out((String)("Patch (" + patchName + ") was found installed on node (" + node + ")"));
                    resultSet.addResult(node, nodeResult);
                    continue;
                }
                patchAbsentNodes.add(node);
            }
            if (patchAbsentNodes.isEmpty()) {
                Trace.out((String)("One of the patches (" + patch + ") was found installed" + " on all the nodes"));
                nodesToCheckPatch.clear();
                break;
            }
            nodesToCheckPatch = patchAbsentNodes;
        }
        if (!nodesToCheckPatch.isEmpty()) {
            resultSet.uploadResultSet(patchResultSet);
            return false;
        }
        return true;
    }

    public boolean getNumProcessor(String[] nodeList, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside getNumProcessor...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new GetNumProcessorCommand(nodeList[i]);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("getNumProcessor", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkPort(String[] nodeList, List<String> subnetList, String port, NetworkConstants.NetworkProtocol protocol, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside checkPort...");
        ArrayList<CheckPortCommand> cmdList = new ArrayList<CheckPortCommand>();
        for (String node : nodeList) {
            String subnetListStr = null;
            if (!subnetList.isEmpty()) {
                subnetListStr = VerificationUtil.strList2List(subnetList);
            }
            cmdList.add(new CheckPortCommand(node, port, protocol, subnetListStr));
        }
        boolean cmdResult = new GlobalHandler().submit(cmdList.toArray(new Command[0]), 0, resultSet);
        this.dumpTraceInfo("checkPort", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkPortNumber(String[] nodeList, String port, NetworkConstants.NetworkProtocol protocol, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside checkPort...");
        ArrayList<CheckPortCommand> cmdList = new ArrayList<CheckPortCommand>();
        for (String node : nodeList) {
            cmdList.add(new CheckPortCommand(node, port, protocol));
        }
        boolean cmdResult = new GlobalHandler().submit(cmdList.toArray(new Command[0]), 0, resultSet);
        this.dumpTraceInfo("checkPortNumber", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkDaemonLiveliness(String[] nodeList, String dmnname, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside checkDaemonLiveliness...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckDaemonAliveCommand(nodeList[i], dmnname);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("checkDaemonLiveliness", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean runExe(String[] nodeList, String cmd, ResultSet resultSet) {
        return this.runExe(nodeList, cmd, resultSet, false);
    }

    public boolean runExe(String[] nodeList, String cmd, ResultSet resultSet, boolean discardErrOut) {
        return this.runExe(nodeList, cmd, null, resultSet, discardErrOut);
    }

    public boolean runExe(String[] nodeList, String cmd, String[] env, ResultSet resultSet, boolean discardErrOut) {
        Trace.out((String)"GlobalExecution::inside runExe...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new RunExeCommand(nodeList[i], cmd, env, discardErrOut);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("runExe", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public Hashtable runExeWithOutput(String[] nodeList, String cmd, ResultSet resultSet) {
        return this.runExeWithOutput(nodeList, cmd, resultSet, false);
    }

    public Hashtable runExeWithOutput(String[] nodeList, String cmd, ResultSet resultSet, boolean discardErrOut) {
        return this.runExeWithOutput(nodeList, cmd, null, resultSet, discardErrOut);
    }

    public Hashtable runExeWithOutput(String[] nodeList, String cmd, String[] env, ResultSet resultSet, boolean discardErrOut) {
        Trace.out((String)"Inside runExeWithOutput...");
        int nodeCount = nodeList.length;
        String[] cmdList = new String[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdList[i] = new String(cmd);
        }
        Hashtable ht = new Hashtable(nodeCount);
        ht = this.runExeWithOutput(nodeList, cmdList, env, resultSet, discardErrOut);
        Trace.out((String)"Exiting runExeWithOutput");
        return ht;
    }

    public Hashtable runExeWithOutput(String[] nodeList, String[] cmdList, ResultSet resultSet) {
        return this.runExeWithOutput(nodeList, cmdList, null, resultSet, false);
    }

    public Hashtable runExeWithOutput(String[] nodeList, String[] cmdList, String[] env, ResultSet resultSet) {
        return this.runExeWithOutput(nodeList, cmdList, env, resultSet, false);
    }

    public Hashtable runExeWithOutput(String[] nodeList, String[] cmdList, String[] env, ResultSet resultSet, boolean discardErrOut) {
        Trace.out((String)"GlobalExecution::inside runExeWithOutput[cmdarray]...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new RunExeCommand(nodeList[i], cmdList[i], env, discardErrOut);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("runExeWithOutput", resultSet);
        Hashtable<String, String> ht = new Hashtable<String, String>(nodeCount);
        for (int i = 0; i < nodeCount; ++i) {
            String[] rsltStr = cmdArray[i].getCommandResult().getResultString();
            String reoutput = VerificationUtil.strArr2List(rsltStr, System.getProperty("line.separator"));
            ht.put(nodeList[i], reoutput);
            Trace.out((String)("==== ET output[" + nodeList[i] + "]: " + reoutput));
        }
        Trace.out((String)"Exiting runExeWithOutput[cmdarray]");
        return ht;
    }

    public Hashtable<String, String[]> runExeWithOutput(String[] nodeList, Hashtable<String, String[]> cmdList, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside runExeWithOutput[hash.cmdarray]...");
        Command[] cmdArray = null;
        int totalCmd = 0;
        for (int i = 0; i < nodeList.length; ++i) {
            String[] cmds = cmdList.get(nodeList[i]);
            totalCmd += cmds.length;
        }
        cmdArray = new Command[totalCmd];
        int cmdPos = 0;
        for (int i = 0; i < nodeList.length; ++i) {
            String[] cmds = cmdList.get(nodeList[i]);
            for (int z = 0; z < cmds.length; ++z) {
                cmdArray[cmdPos++] = new RunExeCommand(nodeList[i], cmds[z], false);
            }
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("runExeWithOutput", resultSet);
        Hashtable<String, String[]> ht = new Hashtable<String, String[]>(nodeList.length);
        cmdPos = 0;
        for (int i = 0; i < nodeList.length; ++i) {
            String[] cmds = cmdList.get(nodeList[i]);
            String[] cmdOutput = new String[cmds.length];
            for (int z = 0; z < cmds.length; ++z) {
                String[] rsltStr = cmdArray[cmdPos++].getCommandResult().getResultString();
                cmdOutput[z] = VerificationUtil.strArr2List(rsltStr, System.getProperty("line.separator"));
            }
            ht.put(nodeList[i], cmdOutput);
            Trace.out((String)("==== ET output[" + nodeList[i] + "]: " + cmdOutput.length));
        }
        Trace.out((String)"Exiting runExeWithOutput[hash.cmdarray]");
        return ht;
    }

    public boolean getRegKeyData(String[] nodeList, String key, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside getRegKeyData...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new GetRegKeyCommand(nodeList[i], key);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("getRegKeyData", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkFileVersion(String[] nodeList, String filename, String filever, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside checkFileVersion...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new GetFileVerCommand(nodeList[i], filename, filever);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("checkFileVersion", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkFileExistence(String[] nodeList, String filename, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside checkFileExistence...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckFileCommand(nodeList[i], filename);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("checkFileExistence", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkFileLink(String[] nodeList, String filename, String linkname, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside checkFileLink...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckFileLinkCommand(nodeList[i], filename, linkname);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("checkFileLink", resultSet);
        Trace.out((String)("GlobalExecution:: Command result " + cmdResult + " result set status " + resultSet.getStatus()));
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkFileInSysPath(String[] nodeList, String filename, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside checkFileInSysPath...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckFileInSysPathCommand(nodeList[i], filename);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("checkFileInSysPath", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean runGenericCmd(String[] nodeList, String command, ResultSet resultSet) {
        return this.runGenericCmd(nodeList, command, null, null, resultSet);
    }

    public boolean runGenericCmd(String[] nodeList, String command, String[] env, ResultSet resultSet) {
        return this.runGenericCmd(nodeList, command, null, env, resultSet);
    }

    public boolean runGenericCmd(String[] nodeList, String command, String[] args, String[] env, ResultSet resultSet) {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("Node list: " + VerificationUtil.strArr2List(nodeList)));
            Trace.out((String)("Command: " + command));
        }
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new RunGenericCommand(nodeList[i], command, null, args, env);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        if (Trace.isLevelEnabled((int)3)) {
            this.dumpTraceInfo("RunGenericCommand", resultSet);
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean runGenericCmdAsRoot(String[] nodeList, String command, String[] env, String[] args, RootUserCredentials rootCreds, int timeout, ResultSet resultSet) throws RootAutomationNotConfiguredException {
        return this.runGenericCmdAsRoot(nodeList, command, env, args, rootCreds.getRootUserCredentials(), rootCreds.getRootExecutionMode(), rootCreds.getSudoPbrunLocation(), timeout, null, resultSet);
    }

    public boolean runGenericCmdAsRoot(String[] nodeList, String command, String[] env, String[] args, RootUserCredentials rootCreds, int timeout, NodeProgressListener listener, ResultSet resultSet) throws RootAutomationNotConfiguredException {
        return this.runGenericCmdAsRoot(nodeList, command, env, args, rootCreds.getRootUserCredentials(), rootCreds.getRootExecutionMode(), rootCreds.getSudoPbrunLocation(), timeout, listener, resultSet);
    }

    public boolean runGenericCmdAsRoot(String[] nodeList, String command, String[] env, String[] args, UserInfo userInfo, ConfigurationSetup.ConfigMethod mode, String location, int timeout, ResultSet resultSet) {
        return this.runGenericCmdAsRoot(nodeList, command, env, args, userInfo, mode, location, timeout, null, resultSet);
    }

    public boolean runGenericCmdAsRoot(String[] nodeList, String command, String[] env, String[] args, UserInfo userInfo, ConfigurationSetup.ConfigMethod mode, String location, int timeout, NodeProgressListener listener, ResultSet resultSet) {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("Node list: " + VerificationUtil.strArr2List(nodeList)));
            Trace.out((String)("Command: " + command));
        }
        RunGenericRootCommand runRoot = new RunGenericRootCommand(nodeList, command, env, args, userInfo, mode, location, timeout, listener);
        boolean cmdResult = runRoot.execute();
        resultSet.uploadResultSet(runRoot.getResultSet());
        if (Trace.isLevelEnabled((int)3)) {
            this.dumpTraceInfo("RunGenericRootCommand", resultSet);
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
        return cmdResult;
    }

    public boolean runExeFromCRSHome(String[] nodeList, String exeWithOptions, String[] env, ResultSet resultSet) {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("Node list: " + VerificationUtil.strArr2List(nodeList)));
            Trace.out((String)("exeWithOptions: " + exeWithOptions));
        }
        Hashtable<String, String> nodeCrsHomePair = new Hashtable<String, String>();
        for (int i = 0; i < nodeList.length; ++i) {
            String node = nodeList[i];
            Result result = new Result(node);
            String crsHome = VerificationUtil.getCRSHome(node, result);
            if (result.getStatus() == 1 && VerificationUtil.isStringGood(crsHome)) {
                nodeCrsHomePair.put(node, crsHome);
                continue;
            }
            resultSet.addResult(node, result);
        }
        int nodeCount = nodeCrsHomePair.size();
        if (nodeCount == 0) {
            return false;
        }
        Command[] cmdArray = new Command[nodeCount];
        int cmdCnt = 0;
        for (int i = 0; i < nodeList.length && cmdCnt < nodeCount; ++i) {
            if (!nodeCrsHomePair.containsKey(nodeList[i])) continue;
            String crsHome = (String)nodeCrsHomePair.get(nodeList[i]);
            String completeCommandPath = crsHome + VerificationConstants.FILE_SEPARATOR + "bin" + VerificationConstants.FILE_SEPARATOR + exeWithOptions;
            cmdArray[cmdCnt] = new RunGenericCommand(nodeList[i], completeCommandPath, null, env);
            ++cmdCnt;
        }
        ResultSet runExeCrsHomeResSet = new ResultSet();
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, runExeCrsHomeResSet);
        if (Trace.isLevelEnabled((int)3)) {
            this.dumpTraceInfo("runExeFromCRSHome", runExeCrsHomeResSet);
        }
        resultSet.uploadResultSet(runExeCrsHomeResSet);
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean getSpaceCmd(String[] nodeList, String location, ResultSet resultSet) {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("Node list: " + VerificationUtil.strArr2List(nodeList)));
            Trace.out((String)("Location: " + location));
        }
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new GetSpaceAvailCommand(nodeList[i], location);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        if (Trace.isLevelEnabled((int)3)) {
            this.dumpTraceInfo("getSpaceAvailCommand", resultSet);
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean copyFile(String[] nodeList, String sourceFile, String destinationfile, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside copyFile...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CopyFileCommand(nodeList[i], sourceFile, destinationfile);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("copyFile", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean deleteFile(String[] nodeList, String filename, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside checkFileExistence...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new DeleteFileCommand(nodeList[i], filename);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("copyFile", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean killProc(String pid) {
        return this.killProc("localnode", pid);
    }

    public boolean killProc(String node, String pid) {
        ResultSet resultSet = new ResultSet();
        return this.killProc(node, pid, resultSet);
    }

    public boolean killProc(String node, String pid, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside killProc...");
        Command[] cmdArray = new Command[]{new RunKillProcCommand(node, pid)};
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("copyFile", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean getBugSym(String[] nodeList, String oracleHome, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution: inside getBugSym...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new GetBugSymbolCommand(nodeList[i], oracleHome);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("getBugSym", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean getCVUSubDirectoryInfo(String[] nodeList, List<String> fileList, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution: inside getCVUSubDirectoryInfo...");
        String destfileName = this.setupGetFileInfo(nodeList, fileList, resultSet);
        if (VerificationUtil.isStringGood(destfileName)) {
            Trace.out((String)("Destination file is " + destfileName));
            String[] copySuccefulNodes = resultSet.getSuccessfulNodes().toArray(new String[0]);
            int nodeCount = copySuccefulNodes.length;
            GetCVUSubDirectoryInfoCommand[] fileInfoCmdArray = new GetCVUSubDirectoryInfoCommand[copySuccefulNodes.length];
            for (int j = 0; j < nodeCount; ++j) {
                fileInfoCmdArray[j] = new GetCVUSubDirectoryInfoCommand(copySuccefulNodes[j], destfileName);
            }
            ResultSet fileInfoRS = new ResultSet();
            new GlobalHandler().submit((Command[])fileInfoCmdArray, 0, fileInfoRS);
            resultSet.uploadResultSet(fileInfoRS);
            ResultSet tmpfileDeleteRS = new ResultSet();
            this.deleteFile(copySuccefulNodes, destfileName, tmpfileDeleteRS);
            resultSet.uploadResultSet(tmpfileDeleteRS);
            return true;
        }
        return false;
    }

    public boolean getFileInfo(String[] nodeList, List<String> fileList, ResultSet resultSet) {
        return this.getFileInfo(nodeList, fileList, false, resultSet);
    }

    public boolean getFileInfo(String[] nodeList, List<String> fileList, boolean recurse, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution: inside getFileInfo...");
        String destfileName = this.setupGetFileInfo(nodeList, fileList, resultSet);
        if (VerificationUtil.isStringGood(destfileName)) {
            String[] copySuccessfulNodes = resultSet.getSuccessfulNodes().toArray(new String[0]);
            int nodeCount = copySuccessfulNodes.length;
            GetFileInfoCommand[] fileInfoCmdArray = new GetFileInfoCommand[copySuccessfulNodes.length];
            for (int j = 0; j < nodeCount; ++j) {
                fileInfoCmdArray[j] = new GetFileInfoCommand(copySuccessfulNodes[j], destfileName, recurse);
            }
            ResultSet fileInfoRS = new ResultSet();
            new GlobalHandler().submit((Command[])fileInfoCmdArray, 0, fileInfoRS);
            resultSet.uploadResultSet(fileInfoRS);
            ResultSet tmpfileDeleteRS = new ResultSet();
            this.deleteFile(copySuccessfulNodes, destfileName, tmpfileDeleteRS);
            resultSet.uploadResultSet(tmpfileDeleteRS);
            return true;
        }
        return false;
    }

    private String setupGetFileInfo(String[] nodeList, List<String> fileList, ResultSet resultSet) {
        String destinationfileName = null;
        String sourceFile = null;
        String FILE_LIST_SUFFIX = ".txt";
        String FILE_LIST_PREFIX = "getfileinfoconfigfile_";
        MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
        try {
            String tempDir = VerificationUtil.getCVUSubDirPath();
            if (!new File(tempDir).exists()) {
                tempDir = VerificationUtil.getDestLoc();
            }
            File tmpFile = File.createTempFile(FILE_LIST_PREFIX, FILE_LIST_SUFFIX, new File(tempDir));
            tmpFile.deleteOnExit();
            FileWriter tmpFileWriter = new FileWriter(tmpFile);
            BufferedWriter writer = new BufferedWriter(tmpFileWriter);
            for (int i = 0; i < fileList.size(); ++i) {
                writer.write(fileList.get(i) + System.getProperty("line.separator"));
            }
            writer.close();
            sourceFile = tmpFile.getAbsolutePath();
            File destFile = File.createTempFile(FILE_LIST_PREFIX, FILE_LIST_SUFFIX, new File(tempDir));
            destFile.deleteOnExit();
            destinationfileName = destFile.getAbsolutePath();
        }
        catch (IOException e) {
            resultSet.addResult(nodeList, 2);
            ErrorDescription errorDesc = new ErrorDescription(s_msgBundle.getMessage("5000", false));
            resultSet.addErrorDescription(nodeList, errorDesc);
            ReportUtil.printError(e.getMessage());
            Trace.out((String)("==== Error while reading software distribution configuration: " + e));
            return null;
        }
        ResultSet copyRS = new ResultSet();
        this.copyFile(nodeList, sourceFile, destinationfileName, copyRS);
        resultSet.uploadResultSet(copyRS);
        if (!resultSet.anySuccess()) {
            String message = s_msgBundle.getMessage("5001", false);
            ErrorDescription errorDesc = new ErrorDescription(message);
            resultSet.addErrorDescription(nodeList, errorDesc);
            ReportUtil.printError(message);
            return null;
        }
        return destinationfileName;
    }

    public boolean checkNTPPort(String ntpCfg, ResultSet rs, String[] nodeList) {
        Trace.out((String)"GlobalExecution: inside CheckNTPPort..");
        String remoteNodeCmdStr = new CommandsUtil().getGrep() + " \\\\\\\"\\^ntp\\\\\\\" " + ntpCfg;
        String localNodeCmdStr = new CommandsUtil().getGrep() + " \\\"\\^ntp\\\" " + ntpCfg;
        int nodeCount = nodeList.length;
        RunGenericCommand[] cmdArray = new RunGenericCommand[nodeCount];
        for (int i = 0; i < nodeList.length; ++i) {
            String cmdStr = !nodeList[i].equals("localnode") && !VerificationUtil.isLocalNode(nodeList[i]) ? remoteNodeCmdStr : localNodeCmdStr;
            cmdArray[i] = new RunGenericCommand(nodeList[i], cmdStr);
        }
        boolean cmdResult = new GlobalHandler().submit((Command[])cmdArray, 0, rs);
        String toCompare = "123/udp";
        for (int i = 0; i < nodeList.length; ++i) {
            Result r = cmdArray[i].getResult();
            if (r.getStatus() != 1) continue;
            String op = (String)r.getResultInfoSet().firstElement();
            Trace.out((String)("op=" + op));
            if (op != null && op.length() != 0 && op.contains(toCompare)) continue;
            rs.addResult(nodeList[i], 3);
        }
        Trace.out((String)"GlobalExecution: Leaving CheckNTPPort..");
        return cmdResult && 1 == rs.getStatus();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkHostnameLength(String[] nodeList, ResultSet rs) {
        Trace.out((String)"GlobalExecution: Begin checkHostnameLength.. ");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckHostnameLengthCommand(nodeList[i]);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, rs);
        this.dumpTraceInfo("checkHostnameLength", rs);
        if (!cmdResult) return false;
        if (1 != rs.getStatus()) return false;
        return true;
    }

    public boolean checkAsmStamp(String[] nodeList, String stamp, ResultSet resultSet) {
        return this.checkAsmStamp(nodeList, stamp, false, resultSet);
    }

    public boolean checkAsmStamp(String[] nodeList, String stamp, boolean discover, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution: inside discoverDevices...");
        int nodeCount = nodeList.length;
        CheckASMStampCommand[] checkASMStampCmd = new CheckASMStampCommand[nodeCount];
        for (int cnt = 0; cnt < nodeCount; ++cnt) {
            checkASMStampCmd[cnt] = discover ? new CheckASMStampCommand(nodeList[cnt], stamp, true) : new CheckASMStampCommand(nodeList[cnt], stamp);
        }
        ResultSet checkStampResSet = new ResultSet();
        new GlobalHandler().submit((Command[])checkASMStampCmd, 0, checkStampResSet);
        resultSet.uploadResultSet(checkStampResSet);
        return resultSet.allSuccess();
    }

    public boolean checkRootGidConsistency(String[] nodeList, ResultSet rs, boolean useg) {
        Trace.out((String)"GlobalExecution:: Inside checkRootConsistency");
        String refPGID = "";
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new CheckRootGidConsistencyCommand(nodeList[i]);
            if (!useg) continue;
            ((CheckRootGidConsistencyCommand)cmdArray[i]).setUseGroupsCmd(useg);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, rs);
        return cmdResult;
    }

    public List<String> getUniqueUID(String[] nodeList, int numOfIDS, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside getUniqueUID...");
        return this.getUniqueID(nodeList, 1000, numOfIDS, resultSet, GetUniqueIDCommand.IDType.UID);
    }

    public List<String> getUniqueGID(String[] nodeList, int numOfIDS, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside getUniqueGID...");
        return this.getUniqueID(nodeList, 100, numOfIDS, resultSet, GetUniqueIDCommand.IDType.GID);
    }

    private List<String> getUniqueID(String[] nodeList, int idStartingFrom, int numOfIDS, ResultSet resultSet, GetUniqueIDCommand.IDType type) {
        Trace.out((String)"GlobalExecution::inside getUniqueID...");
        int numberOfIDSInOneAttempt = 5;
        if (numOfIDS > numberOfIDSInOneAttempt) {
            numberOfIDSInOneAttempt = numOfIDS;
        }
        int nodeCount = nodeList.length;
        GetUniqueIDCommand[] cmdArray = new GetUniqueIDCommand[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new GetUniqueIDCommand(nodeList[i], idStartingFrom, numberOfIDSInOneAttempt, type);
        }
        boolean cmdResult = new GlobalHandler().submit((Command[])cmdArray, 0, resultSet);
        this.dumpTraceInfo("getUniqueID", resultSet);
        ArrayList<String> uniqueIDList = new ArrayList<String>();
        HashMap idNodeListMap = new HashMap();
        if (resultSet.allSuccess()) {
            for (int i = 0; i < nodeCount; ++i) {
                Result result = cmdArray[i].getResult();
                String[] availableIDs = (String[])result.getResultInfoSet().elementAt(0);
                Trace.out((String)("Available " + type.toString() + " on node " + result.getNode() + " are " + (String)availableIDs));
                VerificationLogData.logInfo("Available " + type.toString() + " on node " + result.getNode() + " are " + (String)availableIDs);
                if (!VerificationUtil.isStringGood((String)availableIDs)) continue;
                String[] stringArray = availableIDs.split(",");
                int n = stringArray.length;
                for (int j = 0; j < n; ++j) {
                    String id = stringArray[j];
                    if (idNodeListMap.containsKey(id)) {
                        ((List)idNodeListMap.get(id)).add(result.getNode());
                        continue;
                    }
                    ArrayList<String> idNodeList = new ArrayList<String>();
                    idNodeList.add(result.getNode());
                    idNodeListMap.put(id, idNodeList);
                }
            }
            int biggestID = 0;
            String[] idList = idNodeListMap.keySet().toArray(new String[0]);
            if (idList != null) {
                for (String id : idList) {
                    int intID = Integer.parseInt(id);
                    if (intID > biggestID) {
                        biggestID = intID;
                    }
                    if (!((List)idNodeListMap.get(id)).containsAll(Arrays.asList(nodeList))) {
                        idNodeListMap.remove(id);
                        continue;
                    }
                    if (GetUniqueIDCommand.IDType.GID == type && FixupSessionData.isGIDAlreadyUsed(id)) {
                        idNodeListMap.remove(id);
                        continue;
                    }
                    if (GetUniqueIDCommand.IDType.UID != type || !FixupSessionData.isUIDAlreadyUsed(id)) continue;
                    idNodeListMap.remove(id);
                }
            }
            if (idNodeListMap.size() < numOfIDS) {
                uniqueIDList.addAll(idNodeListMap.keySet());
                List<String> moreIDs = this.getUniqueID(nodeList, biggestID, numOfIDS - uniqueIDList.size(), resultSet, type);
                if (moreIDs.size() > 0) {
                    uniqueIDList.addAll(moreIDs);
                }
            } else {
                for (String id : idNodeListMap.keySet()) {
                    uniqueIDList.add(id);
                    if (GetUniqueIDCommand.IDType.UID == type) {
                        FixupSessionData.addIDToUsedUserIDList(id);
                    }
                    if (GetUniqueIDCommand.IDType.GID == type) {
                        FixupSessionData.addIDToUsedGroupIDList(id);
                    }
                    if (uniqueIDList.size() < numOfIDS) continue;
                    break;
                }
            }
        } else {
            Trace.out((String)("Failed to retrieve the unique " + type.toString() + " from one or more nodes."));
            VerificationLogData.logError("Failed to retrieve the unique " + type.toString() + " from one or more nodes.");
        }
        if (uniqueIDList.size() > 0) {
            Trace.out((String)("returning unique " + type.toString() + " list as " + uniqueIDList));
            VerificationLogData.logInfo("returning unique " + type.toString() + " list as " + uniqueIDList);
        }
        Trace.out((String)"Exiting getUniqueID");
        return uniqueIDList;
    }

    public boolean getDirSize(String[] nodeList, String path, ResultSet resultSet) {
        Trace.out((String)"GlobalExecution::inside getDirSize...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new GetDirSizeCommand(nodeList[i], path);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
        this.dumpTraceInfo("getDirSize", resultSet);
        return cmdResult && 1 == resultSet.getStatus();
    }

    public boolean checkService(String[] nodeList, String serviceName, ResultSet resultSetOut) {
        Trace.out((String)"GlobalExecution: inside checkService...");
        int nodeCount = nodeList.length;
        Command[] cmdArray = new Command[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = new GetServiceConfigCommand(nodeList[i], serviceName);
        }
        boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSetOut);
        this.dumpTraceInfo("checkService", resultSetOut);
        return cmdResult && 1 == resultSetOut.getStatus();
    }
}

