/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.cluster.cmdtools.ASMCMDUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.KFODUtil;
import oracle.cluster.verification.VerificationError;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.TypeFinder;
import oracle.ops.verification.framework.util.ASMUtils;
import oracle.ops.verification.framework.util.ASMUtilsException;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskUpgCheckASMDiscoveryString
extends Task {
    final String ASMCMD_DSGET_CMD = "asmcmd dsget --normal";
    final String ASMCMD_LSDSK_CMD = "asmcmd lsdsk -k";
    final String ASMCMD_DSGET_PROF = "profile:";
    final String ASMCMD_DSGET_PARAM = "parameter:";
    final String ASM_LSDSK_LIB_WARN_VALUE = "SYSTEM";
    final String ASMCMD_ERR_STR = "ASMCMD-";
    final String ASMCMD_LSDKS_SPLIT_PATTERN = "[\\s]+";
    final String ASM_MEMBER_PERMISSION = VDMUtil.getDefaultAsmDisksPermissions();
    private final String EXE_LOC = "bin";
    private boolean m_isSIHA = false;
    private final String m_dfltDiscStrPre12c = VerificationUtil.strArr2List(VerificationUtil.getDefaultDiscoveryDevice("11.2"));
    private final String m_dfltDiscStrPost12c = VerificationUtil.strArr2List(VerificationUtil.getDefaultDiscoveryDevice("12.1"));

    public sTaskUpgCheckASMDiscoveryString(String[] nodeList) {
        super(nodeList);
    }

    @Override
    public boolean performTask() {
        Version kfodVersion;
        KFODUtil kfodcmd;
        String crsHome;
        ResultSet pkgRsltSet;
        boolean status;
        boolean cvuqdiskAvailable;
        block36: {
            ErrorDescription errDesc;
            String msg;
            cvuqdiskAvailable = false;
            status = true;
            pkgRsltSet = new ResultSet();
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("4652", false));
            crsHome = null;
            crsHome = !this.m_isSIHA ? VerificationUtil.getCRSHome() : VerificationUtil.getHAHome();
            if (crsHome == null) {
                Trace.out((String)"crshome is null");
                String errMsg = null;
                errMsg = !this.m_isSIHA ? s_msgBundle.getMessage("5301", true) : s_msgBundle.getMessage("5307", true);
                ErrorDescription errorDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
                ReportUtil.printError(errMsg);
                return false;
            }
            Trace.out((String)("crsHome = '" + crsHome + "'"));
            String version = null;
            version = !this.m_isSIHA ? VerificationUtil.getCRSActiveVersion() : VerificationUtil.getSIHAReleaseVersion(true);
            if (version != null) {
                Trace.out((String)("crs version = " + version));
            } else {
                Trace.out((String)"crs version couldn't be determined");
                ErrorDescription errDesc2 = null;
                errDesc2 = !this.m_isSIHA ? new ErrorDescription("5300", s_msgBundle) : new ErrorDescription("5325", s_msgBundle);
                ReportUtil.sureprintln(errDesc2.getErrorMessage());
                this.m_resultSet.addErrorDescription(errDesc2);
                this.m_resultSet.addResult(this.m_nodeList, 2);
            }
            kfodcmd = null;
            kfodVersion = new Version();
            if (VerificationUtil.isVersionPre(version, "11.2")) {
                Trace.out((String)"running check for pre 11.2 home");
                Result result = new Result(this.m_nodeList[0]);
                String asmHome = CVUHelperUtil.getASMhome(result);
                kfodVersion = VerificationUtil.isVersionPre(version, "11.1") ? Version.get102Version() : Version.get111Version();
                if (asmHome == null) {
                    Trace.out((String)"asm home couldn't be determined by cvuhelper");
                    List<VerificationError> errDescList = result.getErrors();
                    String errMesg = "";
                    for (VerificationError errDesc3 : errDescList) {
                        errMesg = errMesg + errDesc3.getErrorMessage() + LSEP;
                    }
                    VerificationLogData.logError(errMesg);
                    ReportUtil.sureprintln(errMesg);
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    ErrorDescription errDesc4 = new ErrorDescription(errMesg);
                    this.m_resultSet.addErrorDescription(errDesc4);
                    return false;
                }
                Trace.out((String)("asm home is " + asmHome));
                try {
                    kfodcmd = new KFODUtil(asmHome + FSEP + "bin");
                }
                catch (CmdToolUtilException e) {
                    Trace.out((String)("exception while trying to get kfod object" + e.getMessage()));
                    VerificationLogData.logError(e.getMessage());
                    String msg2 = e.getMessage();
                    ReportUtil.sureprintln(msg2);
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    ErrorDescription errDesc5 = new ErrorDescription(msg2);
                    this.m_resultSet.addErrorDescription(errDesc5);
                    return false;
                }
                HashMap<String, Boolean> discoveryStringHM = null;
                try {
                    discoveryStringHM = ASMUtils.getASMDiscoveryStringInfo();
                    Iterator<Map.Entry<String, Boolean>> it = discoveryStringHM.entrySet().iterator();
                    boolean isDefaultStringUsed = false;
                    String discoveryString = null;
                    while (it.hasNext()) {
                        Map.Entry<String, Boolean> entry = it.next();
                        discoveryString = entry.getKey();
                        isDefaultStringUsed = entry.getValue();
                        Trace.out((String)("discovery string is " + discoveryString + " is it default " + isDefaultStringUsed));
                        if (discoveryString != null && !"".equalsIgnoreCase(discoveryString.trim())) continue;
                        isDefaultStringUsed = true;
                    }
                    if (!isDefaultStringUsed) {
                        Trace.out((String)"default discovery string is not in use");
                        this.m_resultSet.addResult(this.m_nodeList, 1);
                        ReportUtil.sureprintln(s_gMsgBundle.getMessage("4653", false, (Object[])new String[]{discoveryString}));
                        return true;
                    }
                    break block36;
                }
                catch (ASMUtilsException e) {
                    Trace.out((String)("exception while trying to get asm discovery string" + e.getMessage()));
                    VerificationLogData.logError(e.getMessage());
                    String msg3 = e.getMessage();
                    ReportUtil.sureprintln(msg3);
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    ErrorDescription errDesc6 = new ErrorDescription(msg3);
                    this.m_resultSet.addErrorDescription(errDesc6);
                    return false;
                }
            }
            ASMCMDUtil asmcmd = null;
            List discoveryStringList = null;
            List diskList = null;
            try {
                Trace.out((String)"creating instance of ascmcmdutil");
                asmcmd = new ASMCMDUtil(crsHome);
                discoveryStringList = asmcmd.getAllDiscoveryStrings();
                diskList = asmcmd.getASMDisks();
                kfodcmd = new KFODUtil(crsHome + FSEP + "bin");
                Trace.out((String)"got all data");
            }
            catch (CmdToolUtilException e) {
                Trace.out((String)("exception while trying to get discovery string " + e.getMessage()));
                VerificationLogData.logError(e.getMessage());
                String msg4 = e.getMessage();
                ReportUtil.sureprintln(msg4);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                ErrorDescription errDesc7 = new ErrorDescription(msg4);
                this.m_resultSet.addErrorDescription(errDesc7);
                return false;
            }
            if (discoveryStringList == null || discoveryStringList.size() == 0) {
                Trace.out((String)"discovery string list is empty");
                VerificationLogData.logError("empty discovery string list");
                String msg5 = s_msgBundle.getMessage("5713", true, (Object[])new String[]{"asmcmd dsget --normal", this.m_nodeList[0]});
                ReportUtil.sureprintln(msg5);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                ErrorDescription errDesc8 = new ErrorDescription(msg5);
                this.m_resultSet.addErrorDescription(errDesc8);
                return false;
            }
            if (discoveryStringList.size() > 2 && ((String)discoveryStringList.get(0)).startsWith("ASMCMD-")) {
                Trace.out((String)"discovery string list conatins errors");
                String discErrList = VerificationUtil.strList2List(discoveryStringList, LSEP);
                VerificationLogData.logError("discovery String list contains errors " + discErrList);
                String msg6 = s_gMsgBundle.getMessage("4655", true, (Object[])new String[]{"asmcmd dsget --normal"}) + LSEP + discErrList;
                ReportUtil.sureprintln(msg6);
                this.m_resultSet.addResult(this.m_nodeList, 3);
                ErrorDescription errDesc9 = new ErrorDescription(msg6);
                this.m_resultSet.addErrorDescription(errDesc9);
                return false;
            }
            if (discoveryStringList.size() > 2) {
                Trace.out((String)("discoveryString list size is larger than expected " + discoveryStringList.size()));
                VerificationLogData.logError("discoveryString list size is larger than expected " + discoveryStringList.size());
                for (String line : discoveryStringList) {
                    VerificationLogData.logError(line);
                }
                String msg7 = s_msgBundle.getMessage("5714", true, (Object[])new String[]{"asmcmd dsget --normal", VerificationUtil.strList2List(discoveryStringList, LSEP)});
                ReportUtil.sureprintln(msg7);
                this.m_resultSet.addResult(this.m_nodeList, 3);
                ErrorDescription errDesc10 = new ErrorDescription(msg7);
                this.m_resultSet.addErrorDescription(errDesc10);
                return false;
            }
            String profileString = null;
            String paramString = null;
            ArrayList<String> errList = new ArrayList<String>();
            for (int i = 0; i < discoveryStringList.size(); ++i) {
                int beginIndex;
                String line = (String)discoveryStringList.get(i);
                Trace.out((String)("dsget output line = " + line));
                VerificationLogData.logInfo(line);
                if (line.startsWith("ASMCMD-")) {
                    errList.add(line);
                    continue;
                }
                if (line.startsWith("profile:")) {
                    beginIndex = "profile:".length();
                    if (line.length() <= beginIndex) continue;
                    profileString = line.substring(beginIndex);
                    continue;
                }
                if (line.startsWith("parameter:")) {
                    beginIndex = "parameter:".length();
                    if (line.length() <= beginIndex) continue;
                    paramString = line.substring(beginIndex);
                    continue;
                }
                errList.add(line);
            }
            if (errList.size() != 0) {
                String msg8 = s_gMsgBundle.getMessage("4655", true, (Object[])new String[]{"asmcmd dsget --normal"}) + LSEP + VerificationUtil.strList2List(errList, LSEP);
                ReportUtil.sureprintln(msg8);
                this.m_resultSet.addResult(this.m_nodeList, 3);
                ErrorDescription errDesc11 = new ErrorDescription(msg8);
                this.m_resultSet.addErrorDescription(errDesc11);
                return false;
            }
            boolean nullDiscCoveryString = false;
            Trace.out((String)("profile string = " + profileString + " parameter string = " + paramString));
            if (paramString == null) {
                if (profileString != null) {
                    this.displayDiscoveryStringNotSame(profileString, paramString);
                    return false;
                }
                nullDiscCoveryString = true;
            }
            if (!nullDiscCoveryString) {
                String modifiedParamString = paramString.replaceAll(", ", ",");
                if (!modifiedParamString.equals(profileString)) {
                    this.displayDiscoveryStringNotSame(profileString, paramString);
                    return false;
                }
                Trace.out((String)"discovery string is not null");
                this.m_resultSet.addResult(this.m_nodeList, 1);
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("4653", false, (Object[])new String[]{paramString}));
                return true;
            }
            if (diskList == null || diskList.size() == 0) {
                Trace.out((String)"disk list is empty");
                VerificationLogData.logError("empty disk list");
                String msg9 = s_msgBundle.getMessage("5713", true, (Object[])new String[]{"asmcmd lsdsk -k", this.m_nodeList[0]});
                ReportUtil.sureprintln(msg9);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                ErrorDescription errDesc12 = new ErrorDescription(msg9);
                this.m_resultSet.addErrorDescription(errDesc12);
                return false;
            }
            Trace.out((String)"parsing lsdsk output for LIBRARY column");
            ArrayList<String> parseErrList = new ArrayList<String>();
            ArrayList<String> systemDiskList = new ArrayList<String>();
            for (String line : diskList) {
                Trace.out((String)("lsdisk output line : " + line));
                VerificationLogData.logInfo(" lsdisk output line" + line);
                if (line.startsWith("ASMCMD-")) {
                    errList.add(line);
                    continue;
                }
                String[] lineArr = line.split("[\\s]+");
                Trace.out((String)("length = " + lineArr.length));
                if (lineArr.length < 9) {
                    Trace.out((String)"lsdsk output not in correct format");
                    parseErrList.add(line);
                    continue;
                }
                int libField = lineArr.length - 3;
                if (!"SYSTEM".equalsIgnoreCase(lineArr[libField])) continue;
                systemDiskList.add(lineArr[lineArr.length - 1]);
            }
            if (errList.size() != 0) {
                msg = s_gMsgBundle.getMessage("4656", true, (Object[])new String[]{"asmcmd lsdsk -k"}) + LSEP + VerificationUtil.strList2List(errList, LSEP);
                ReportUtil.sureprintln(msg);
                this.m_resultSet.addResult(this.m_nodeList, 3);
                errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(errDesc);
                return false;
            }
            if (parseErrList.size() != 0) {
                msg = s_msgBundle.getMessage("5714", true, (Object[])new String[]{"asmcmd lsdsk -k", VerificationUtil.strList2List(parseErrList, LSEP)});
                ReportUtil.sureprintln(msg);
                this.m_resultSet.addResult(this.m_nodeList, 3);
                errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(errDesc);
                return false;
            }
            if (systemDiskList.size() == 0) {
                msg = s_gMsgBundle.getMessage("4658", false);
                this.m_resultSet.addResult(this.m_nodeList, 1);
                ReportUtil.sureprintln(msg);
                return true;
            }
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("4668", false, (Object[])new String[]{this.m_dfltDiscStrPre12c}));
        }
        cvuqdiskAvailable = VerificationUtil.isCVUQDiskAvailable(this.m_nodeList, pkgRsltSet, this);
        this.m_resultSet.uploadResultSet(pkgRsltSet);
        if (cvuqdiskAvailable) {
            Trace.out((String)"performing disk permission check");
            status = this.performDiskPermissionCheck(crsHome, kfodcmd, kfodVersion);
        } else {
            Trace.out((String)"cvuqdisk rpm is not installed. Skipping validation of ASM disk permissions");
            status = cvuqdiskAvailable;
        }
        return status;
    }

    private boolean performDiskPermissionCheck(String crshome, KFODUtil kfodcmd, Version kfodVersion) {
        boolean status = true;
        ArrayList<ASMMemberDiskData> diskDataList = new ArrayList<ASMMemberDiskData>();
        List diskList = null;
        HashMap nodeBlockDeviceMap = new HashMap();
        Result crsUserResult = new Result(this.m_nodeList[0]);
        String crsUser = null;
        crsUser = VerificationUtil.getCRSUser(crsUserResult, this.m_isSIHA);
        String crsUserGroup = VerificationUtil.getOraInventoryGroup();
        if (crsUser == null || crsUserResult.getStatus() != 1) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            String errMsg = s_msgBundle.getMessage("5322", true, (Object[])new String[]{crshome});
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
        if (crsUserGroup == null) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            String errMsg = s_msgBundle.getMessage("0049", true);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
        Trace.out((String)("crsuser = " + crsUser + " crsGroup = " + crsUserGroup));
        for (String node : this.m_nodeList) {
            ArrayList<String> blockList = new ArrayList<String>();
            try {
                diskList = kfodcmd.getASMMemberDiskList(node, kfodVersion);
                Trace.out((String)("kfod returned " + diskList.size() + " disks on node " + node));
                for (String rawDisk : diskList) {
                    ASMMemberDiskData diskData = new ASMMemberDiskData(node, rawDisk);
                    diskDataList.add(diskData);
                    if (diskData.isStorageException()) continue;
                    blockList.add(diskData.getBlockDevicePath());
                }
            }
            catch (CmdToolUtilException e) {
                Trace.out((String)("exception while trying to get member disk list: " + e.getMessage()));
                VerificationLogData.logError(e.getMessage());
                String msg = e.getMessage();
                ReportUtil.sureprintln(msg);
                this.m_resultSet.addResult(node, 2);
                ErrorDescription errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(errDesc);
                status = false;
                continue;
            }
            nodeBlockDeviceMap.put(node, blockList);
        }
        String rawPathHdr = s_gMsgBundle.getMessage("4659", false);
        String blockPathHdr = s_gMsgBundle.getMessage("4660", false);
        String permissionHdr = s_gMsgBundle.getMessage("4661", false);
        String ownerHdr = s_gMsgBundle.getMessage("4662", false);
        String groupHdr = s_gMsgBundle.getMessage("4663", false);
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, rawPathHdr, blockPathHdr, permissionHdr, ownerHdr, groupHdr, ReportUtil.COMMENT);
        StringBuffer exceptMsg = new StringBuffer();
        StringBuffer permissionMsg = new StringBuffer();
        StringBuffer ownerMsg = new StringBuffer();
        StringBuffer groupMsg = new StringBuffer();
        for (ASMMemberDiskData asmdd : diskDataList) {
            String errMsg;
            String node = asmdd.getNode();
            String rawPath = asmdd.getRawDiskPath();
            if (asmdd.isStorageException()) {
                String errMsg2 = s_gMsgBundle.getMessage("4664", true, (Object[])new String[]{rawPath, node}) + LSEP + asmdd.getStrorageException().getMessage();
                this.m_resultSet.addResult(node, 2);
                this.m_resultSet.setStatus();
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMsg2));
                if (exceptMsg.length() != 0) {
                    exceptMsg.append(LSEP);
                }
                exceptMsg.append(errMsg2);
                status = false;
                continue;
            }
            String blockPath = asmdd.getBlockDevicePath();
            if (VerificationUtil.isStringGood(blockPath) && !blockPath.startsWith("/dev/sd")) {
                String errMsg3 = s_gMsgBundle.getMessage("4671", true, (Object[])new String[]{blockPath});
                ReportUtil.sureprintln(errMsg3);
                this.m_resultSet.addResult(node, 3);
                this.m_resultSet.setStatus();
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMsg3));
                return false;
            }
            String blockPermission = asmdd.getBlockDevicePermission();
            String blockOwner = asmdd.getBlockDeviceOwner();
            String blockGroup = asmdd.getBlockDeviceGroup();
            String comment = ReportUtil.PASSED;
            Trace.out((String)("checking permission for device " + blockPath + " Permission = " + blockPermission));
            if (!this.ASM_MEMBER_PERMISSION.equalsIgnoreCase(blockPermission)) {
                errMsg = s_gMsgBundle.getMessage("4657", true, (Object[])new String[]{blockPath, node, this.ASM_MEMBER_PERMISSION, blockPermission});
                this.m_resultSet.addResult(node, 3);
                this.m_resultSet.setStatus();
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMsg));
                if (permissionMsg.length() != 0) {
                    permissionMsg.append(LSEP);
                }
                permissionMsg.append(errMsg);
                comment = ReportUtil.FAILED;
                status = false;
            }
            Trace.out((String)("owner = " + blockOwner));
            if (!crsUser.equalsIgnoreCase(blockOwner)) {
                errMsg = s_gMsgBundle.getMessage("4665", true, (Object[])new String[]{blockPath, node, crsUser, blockOwner});
                this.m_resultSet.addResult(node, 3);
                this.m_resultSet.setStatus();
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMsg));
                if (ownerMsg.length() != 0) {
                    ownerMsg.append(LSEP);
                }
                ownerMsg.append(errMsg);
                comment = ReportUtil.FAILED;
                status = false;
            }
            Trace.out((String)("group = " + blockGroup));
            if (!crsUserGroup.equalsIgnoreCase(blockGroup)) {
                errMsg = s_gMsgBundle.getMessage("4666", true, (Object[])new String[]{blockPath, node, crsUserGroup, blockGroup});
                this.m_resultSet.addResult(node, 3);
                this.m_resultSet.setStatus();
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMsg));
                if (groupMsg.length() != 0) {
                    groupMsg.append(LSEP);
                }
                groupMsg.append(errMsg);
                comment = ReportUtil.FAILED;
                status = false;
            }
            if (comment.equalsIgnoreCase(ReportUtil.PASSED)) {
                this.m_resultSet.addResult(node, 1);
                this.m_resultSet.setStatus();
            }
            ReportUtil.writeRecord(node, rawPath, blockPath, blockPermission, blockOwner, blockGroup, comment);
        }
        if (exceptMsg.length() != 0) {
            ReportUtil.sureprintln(exceptMsg.toString());
        }
        if (permissionMsg.length() != 0) {
            ReportUtil.sureprintln(permissionMsg.toString());
        }
        if (ownerMsg.length() != 0) {
            ReportUtil.sureprintln(ownerMsg.toString());
        }
        if (groupMsg.length() != 0) {
            ReportUtil.sureprintln(groupMsg.toString());
        }
        if (status) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("4667", false));
        }
        return status;
    }

    private void displayDiscoveryStringNotSame(String profileString, String paramString) {
        String msg = s_gMsgBundle.getMessage("4654", true, (Object[])new String[]{profileString, paramString});
        ReportUtil.sureprintln(msg);
        this.m_resultSet.addResult(this.m_nodeList, 3);
        ErrorDescription errDesc = new ErrorDescription(msg);
        this.m_resultSet.addErrorDescription(errDesc);
    }

    void setSIHAMode() {
        this.m_isSIHA = true;
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("4651", false, (Object[])new String[]{this.m_dfltDiscStrPre12c, this.m_dfltDiscStrPost12c});
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("4673", false);
    }

    class ASMMemberDiskData {
        String m_rawDisk;
        String m_node;
        StorageInfo m_blockDeviceInfo = null;
        String m_realPath;
        StorageException m_storageException = null;

        ASMMemberDiskData(String node, String rawDisk) {
            this.m_rawDisk = rawDisk;
            this.m_node = node;
            try {
                StorageInfo sInfo = new TypeFinder().getStorageInstance(rawDisk, node);
                this.m_realPath = sInfo.getPath();
                this.m_blockDeviceInfo = new TypeFinder().getStorageInstance(this.m_realPath, node);
            }
            catch (StorageException e1) {
                Trace.out((String)("StorageException encountered: " + e1.getMessage() + VerificationConstants.LSEP + "Path does not exist " + rawDisk + " on node " + node));
                this.m_storageException = e1;
                VerificationLogData.logError(e1.getMessage());
            }
        }

        String getRawDiskPath() {
            return this.m_rawDisk;
        }

        String getNode() {
            return this.m_node;
        }

        StorageException getStrorageException() {
            return this.m_storageException;
        }

        boolean isStorageException() {
            return this.m_storageException != null;
        }

        String getBlockDevicePath() {
            return this.m_realPath;
        }

        String getBlockDeviceOwner() {
            return this.m_blockDeviceInfo.getOwner();
        }

        String getBlockDevicePermission() {
            return this.m_blockDeviceInfo.getPermissions();
        }

        String getBlockDeviceGroup() {
            return this.m_blockDeviceInfo.getGroup();
        }
    }
}

