/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.VerificationError;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.NslookupThread;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskResolvConfData;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.network.NetworkDataDiscovery;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.CommandsUtil;
import oracle.ops.verification.framework.util.CvunetQueryData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskResolvConfIntegrity
extends Task {
    boolean m_preCheck = false;
    private static final String CRSTXT_SUC = "CRS-10024:";
    final String m_resolvConfLocation = "/etc/resolv.conf";
    final String m_domainLine = "^domain[\\s]+.*";
    final String m_domainField = "^domain[\\s]+";
    final String m_nameserverLine = "^nameserver[\\s]+.*";
    final String m_nameserverField = "^nameserver[\\s]+";
    final String m_searchOrderLine = "^search[\\s]+.*";
    final String m_searchOrderField = "^search[\\s]+";
    final String m_timeoutAttemptsOptionLine = "^options[\\s]+.*";
    private String m_solarisOptions = "retrans:([0-9]+)|retrans:\\s*([0-9]+)|retry:([0-9]+)|retry:\\s*([0-9]+)|";
    private String m_timeoutAttemptsRegex = "^options[\\s]+((timeout:([0-9]+)|timeout:\\s*([0-9]+)|attempts:([0-9]+)|attempts:\\s*([0-9]+)|rotate|debug|ndots:([0-9]+)|ndots:\\s*([0-9]+)|inet6|ip6\\-dotint|no\\-ip6\\-dotint|edns0|single\\-request|single\\-request\\-reopen)\\s*)+$";
    private StringBuffer m_timeoutAttemptsOptionValidLine = new StringBuffer(this.m_timeoutAttemptsRegex);
    private String m_timeoutOptionField = "timeout:";
    private String m_retransOptionField = "retrans:";
    private String m_attemptsOptionField = "attempts:";
    private String m_retryOptionField = "retry:";
    String m_timeoutOptionValueFieldRegex = "(timeout:([0-9])+|timeout:\\s*([0-9])+)";
    StringBuffer m_timeoutOptionValueField = new StringBuffer(this.m_timeoutOptionValueFieldRegex);
    String m_retransOptionValueField = "|retrans:([0-9])+|retrans:\\s*([0-9])+";
    String m_attemptsOptionValueFieldRegex = "(attempts:([0-9])+|attempts:\\s*([0-9]+))";
    StringBuffer m_attemptsOptionValueField = new StringBuffer(this.m_attemptsOptionValueFieldRegex);
    String m_retryOptionValueField = "|retry:([0-9])+|retry:\\s*([0-9]+)";
    private final String TIMEOUT_FLAG = "timeout";
    private final String RETRANS_FLAG = "retrans";
    private final String ATTEMPTS_FLAG = "attempts";
    private final String RETRY_FLAG = "retry";
    String m_timeoutDisplay = "options timeout";
    String m_retryDisplay = "options attempts";
    final String m_nslookup = new CommandsUtil().getNslookup();
    Map<String, TaskResolvConfData> m_allNodeResolvConf;
    List<String> m_confOKVector;
    boolean m_resolvConfMissingAllNodes = false;
    boolean m_isCvunetquery = false;
    private final int TIMEOUT_ATTEMPTS_MAX = 90;
    private final int TIMEOUT_DEFAULT_VALUE = 5;
    private final int TIMEOUT_CAPPED_VALUE = 30;
    private final int ATTEMPTS_DEFAULT_VALUE = 2;
    private final int ATTEMPTS_CAPPED_VALUE = 5;
    private static final String CRSCTL_LITE_CMD = "cvunetquery";
    private static final String CRSCTL_CMD = "crsctl";
    int m_maxNS = 3;
    long m_dnsAcceptableTime = 15000L;

    public sTaskResolvConfIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
        this.init();
    }

    @Override
    protected void init() {
        this.m_allNodeResolvConf = new HashMap<String, TaskResolvConfData>();
        this.m_confOKVector = new ArrayList<String>();
        this.m_preCheck = this.m_globalContext.isPreCRS();
    }

    @Override
    public boolean performTask() {
        boolean status = true;
        String operatingSystem = VerificationUtil.getCurrentOS();
        Trace.out((String)("operatingSystem [" + operatingSystem + "]"));
        if (operatingSystem.equalsIgnoreCase("Solaris") || operatingSystem.equalsIgnoreCase("SunOS")) {
            this.m_timeoutAttemptsOptionValidLine.insert(this.m_timeoutAttemptsOptionValidLine.indexOf("timeout"), this.m_solarisOptions);
            this.m_timeoutOptionField = this.m_timeoutOptionField + "|" + this.m_retransOptionField;
            this.m_attemptsOptionField = this.m_attemptsOptionField + "|" + this.m_retryOptionField;
            this.m_timeoutOptionValueField.insert(this.m_timeoutOptionValueField.length() - 1, this.m_retransOptionValueField);
            this.m_attemptsOptionValueField.insert(this.m_attemptsOptionValueField.length() - 1, this.m_retryOptionValueField);
        }
        if (!this.prepareNodeResolvConfMap()) {
            return false;
        }
        if (this.m_resolvConfMissingAllNodes) {
            return true;
        }
        if (this.m_confOKVector.size() > 0 && !this.performSearchAndDomainCheck()) {
            status = false;
        }
        if (this.m_confOKVector.size() > 0) {
            if (!this.performDomainFieldValidation()) {
                status = false;
            }
            if (!this.performSearchOrderValidation()) {
                status = false;
            }
            if (!this.performTimeOutRetryAttempsValidation()) {
                status = false;
            }
            if (this.performOptionValidation("timeout") && this.performOptionValidation("retrans") && this.performOptionValidation("attempts") && this.performOptionValidation("retry")) {
                if (!this.performTimeoutAttemptsValidation()) {
                    status = false;
                }
            } else {
                status = false;
            }
            status &= this.performNsLookup();
        }
        return status;
    }

    public boolean performDomainFieldValidation() {
        ErrorDescription errDesc;
        ResultSet locRes = new ResultSet();
        boolean toRejectAllConfigFiles = false;
        boolean status = true;
        ReportUtil.println(s_msgBundle.getMessage("5601", false, (Object[])new String[]{"/etc/resolv.conf"}));
        ArrayList<String> domainExistNode = new ArrayList<String>();
        ArrayList<String> domainNonExistantNodes = new ArrayList<String>();
        for (String node : this.m_confOKVector) {
            if (this.m_allNodeResolvConf.get(node).isDomainDefined()) {
                Trace.out((String)("domain exists on node :" + node));
                domainExistNode.add(node);
                continue;
            }
            Trace.out((String)("domain does not exist on node :" + node));
            domainNonExistantNodes.add(node);
        }
        if (domainExistNode.size() > 0 && domainNonExistantNodes.size() > 0) {
            String[] domainNonExistantArray = domainNonExistantNodes.toArray(new String[0]);
            String msg = s_msgBundle.getMessage("5603", true, (Object[])new String[]{"/etc/resolv.conf", VerificationUtil.strList2List(domainNonExistantNodes)});
            locRes.addResult(domainNonExistantArray, 3);
            errDesc = new ErrorDescription(msg);
            locRes.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            status = false;
        } else {
            if (domainExistNode.size() == 0) {
                ReportUtil.println(s_gMsgBundle.getMessage("2010", false, (Object[])new String[]{"/etc/resolv.conf"}));
            }
            locRes.addResult(this.m_confOKVector.toArray(new String[0]), 1);
        }
        if (domainExistNode.size() == 0) {
            Trace.out((String)"domain name doesn't exist on any node");
            this.m_resultSet.addResultSetData(locRes);
            return status;
        }
        ArrayList<String> singleDomainNodes = new ArrayList<String>();
        ArrayList<String> multiDomainNodes = new ArrayList<String>();
        ReportUtil.println(s_msgBundle.getMessage("5625", false, (Object[])new String[]{"/etc/resolv.conf"}));
        for (String node : domainExistNode) {
            int domainCount = this.m_allNodeResolvConf.get(node).getDomainCount();
            Trace.out((String)("There are " + domainCount + " domains on " + node));
            if (domainCount > 1) {
                multiDomainNodes.add(node);
                continue;
            }
            locRes.addResult(node, 1);
            singleDomainNodes.add(node);
        }
        if (multiDomainNodes.size() > 0) {
            toRejectAllConfigFiles = true;
            String[] multiDomainArray = multiDomainNodes.toArray(new String[0]);
            String msg = s_msgBundle.getMessage("5609", true, (Object[])new String[]{"/etc/resolv.conf", VerificationUtil.strList2List(multiDomainNodes)});
            locRes.addResult(multiDomainArray, 3);
            errDesc = new ErrorDescription(msg);
            locRes.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            status = false;
        } else {
            ReportUtil.println(s_gMsgBundle.getMessage("2015", false, (Object[])new String[]{"/etc/resolv.conf"}));
        }
        if (singleDomainNodes.size() <= 1) {
            Trace.out((String)"no or only one nodes with single domain name");
            this.m_resultSet.addResultSetData(locRes);
            return status;
        }
        Hashtable<Object, Vector<Object>> domainTable = new Hashtable<Object, Vector<Object>>();
        for (String node : singleDomainNodes) {
            VerificationUtil.updateResultMap(domainTable, this.m_allNodeResolvConf.get(node).getDomainName(0), node);
        }
        if (domainTable.size() == 1) {
            if (!toRejectAllConfigFiles) {
                locRes.addResult(singleDomainNodes, 1);
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("2011", false, (Object[])new String[]{"/etc/resolv.conf"}));
            }
        } else {
            StringBuilder msg = new StringBuilder();
            msg.append(s_gMsgBundle.getMessage("2012", true, (Object[])new String[]{"/etc/resolv.conf"}) + LSEP);
            Enumeration<Object> e = domainTable.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String nodeListStr = VerificationUtil.strVect2List(domainTable.get(key));
                msg.append(s_gMsgBundle.getMessage("2013", false, (Object[])new String[]{key, nodeListStr}) + LSEP);
            }
            locRes.addResult(singleDomainNodes, 3);
            locRes.addErrorDescription(new ErrorDescription(msg.toString()));
            ReportUtil.sureprintln(msg.toString());
            status = false;
        }
        this.m_resultSet.addResultSetData(locRes);
        return status;
    }

    public boolean performSearchOrderValidation() {
        ErrorDescription errDesc;
        ResultSet locRes = new ResultSet();
        boolean status = true;
        boolean toRejectAllConfigFiles = false;
        ReportUtil.println(s_msgBundle.getMessage("5621", false, (Object[])new String[]{"/etc/resolv.conf"}));
        ArrayList<String> searchExistNode = new ArrayList<String>();
        ArrayList<String> searchNonExistantNodes = new ArrayList<String>();
        for (String node : this.m_confOKVector) {
            if (this.m_allNodeResolvConf.get(node).isSearchOrderDefined()) {
                Trace.out((String)("search order exists on node :" + node));
                searchExistNode.add(node);
                continue;
            }
            Trace.out((String)("search order does not exist on node :" + node));
            searchNonExistantNodes.add(node);
        }
        if (searchExistNode.size() > 0 && searchNonExistantNodes.size() > 0) {
            String[] searchNonExistantArray = searchNonExistantNodes.toArray(new String[0]);
            String msg = s_msgBundle.getMessage("5622", true, (Object[])new String[]{"/etc/resolv.conf", VerificationUtil.strList2List(searchNonExistantNodes)});
            locRes.addResult(searchNonExistantArray, 3);
            errDesc = new ErrorDescription(msg);
            locRes.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            this.m_resultSet.addResultSetData(locRes);
            status = false;
        } else {
            if (searchExistNode.size() == 0) {
                ReportUtil.println(s_gMsgBundle.getMessage("2004", false, (Object[])new String[]{"/etc/resolv.conf"}));
            }
            locRes.addResult(this.m_confOKVector.toArray(new String[0]), 1);
        }
        if (searchExistNode.size() == 0) {
            Trace.out((String)"search order name doesn't exist on any node");
            this.m_resultSet.addResultSetData(locRes);
            return status;
        }
        ArrayList<String> singleSearchNodes = new ArrayList<String>();
        ArrayList<String> multiSearchNodes = new ArrayList<String>();
        ReportUtil.println(s_msgBundle.getMessage("5627", false, (Object[])new String[]{"/etc/resolv.conf"}));
        for (String node : searchExistNode) {
            int searchCount = this.m_allNodeResolvConf.get(node).getSearchOrderCount();
            Trace.out((String)("There are " + searchCount + " search order entries on " + node));
            if (searchCount > 1) {
                multiSearchNodes.add(node);
                continue;
            }
            singleSearchNodes.add(node);
            locRes.addResult(node, 1);
        }
        if (multiSearchNodes.size() > 0) {
            toRejectAllConfigFiles = true;
            String msg = s_msgBundle.getMessage("5610", true, (Object[])new String[]{"/etc/resolv.conf", VerificationUtil.strList2List(multiSearchNodes)});
            locRes.addResult(searchExistNode, 3);
            errDesc = new ErrorDescription(msg);
            locRes.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            status = false;
        } else {
            ReportUtil.println(s_gMsgBundle.getMessage("2014", false, (Object[])new String[]{"/etc/resolv.conf"}));
        }
        if (singleSearchNodes.size() <= 1) {
            Trace.out((String)"no nodes with one search order");
            this.m_resultSet.addResultSetData(locRes);
            return status;
        }
        Hashtable<Object, Vector<Object>> searchTable = new Hashtable<Object, Vector<Object>>();
        for (String node : singleSearchNodes) {
            VerificationUtil.updateResultMap(searchTable, this.m_allNodeResolvConf.get(node).getSearchOrder(0), node);
        }
        if (searchTable.size() == 1) {
            if (!toRejectAllConfigFiles) {
                locRes.addResult(singleSearchNodes, 1);
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("2009", false, (Object[])new String[]{"/etc/resolv.conf"}));
            }
        } else {
            StringBuilder msg = new StringBuilder();
            msg.append(s_gMsgBundle.getMessage("2000", true, (Object[])new String[]{"/etc/resolv.conf"}) + LSEP);
            Enumeration<Object> e = searchTable.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String nodeListStr = VerificationUtil.strVect2List(searchTable.get(key));
                msg.append(s_gMsgBundle.getMessage("2001", false, (Object[])new String[]{key, nodeListStr}) + LSEP);
            }
            locRes.addResult(singleSearchNodes, 3);
            locRes.addErrorDescription(new ErrorDescription(msg.toString()));
            ReportUtil.sureprintln(msg.toString());
            status = false;
        }
        this.m_resultSet.uploadResultSet(locRes);
        return status;
    }

    public boolean performNameServerValidation() {
        boolean status = true;
        ReportUtil.println(s_msgBundle.getMessage("5611", false, (Object[])new String[]{"/etc/resolv.conf"}));
        ArrayList<String> nameServerExistNode = new ArrayList<String>();
        ArrayList<String> nameServerNonExistantNodes = new ArrayList<String>();
        for (String node : this.m_confOKVector) {
            if (this.m_allNodeResolvConf.get(node).isNameServerDefined()) {
                Trace.out((String)("name server exists on node :" + node));
                nameServerExistNode.add(node);
                continue;
            }
            Trace.out((String)("name server does not exist on node :" + node));
            nameServerNonExistantNodes.add(node);
        }
        if (nameServerExistNode.size() > 0 && nameServerNonExistantNodes.size() > 0) {
            String[] nameServerNonExistantArray = nameServerNonExistantNodes.toArray(new String[0]);
            String msg = s_msgBundle.getMessage("5613", true, (Object[])new String[]{"/etc/resolv.conf", VerificationUtil.strList2List(nameServerNonExistantNodes)});
            this.m_resultSet.addResult(nameServerNonExistantArray, 3);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(nameServerNonExistantArray, errDesc);
            ReportUtil.sureprintln(msg);
            status = false;
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5612", false, (Object[])new String[]{"/etc/resolv.conf"}));
            this.m_resultSet.addResult(this.m_confOKVector.toArray(new String[0]), 1);
        }
        if (nameServerExistNode.size() == 0) {
            Trace.out((String)"name server doesn't exist on any node");
            return status;
        }
        ArrayList<String> validNameServerNodes = new ArrayList<String>();
        ArrayList<String> invalidNameServerNodes = new ArrayList<String>();
        ReportUtil.println(s_msgBundle.getMessage("5630", false, (Object[])new String[]{"/etc/resolv.conf", Integer.toString(this.m_maxNS)}));
        for (String node : nameServerExistNode) {
            int nameServerCount = this.m_allNodeResolvConf.get(node).getNameServerCount();
            Trace.out((String)("There are " + nameServerCount + " name server entries on " + node));
            if (nameServerCount > this.m_maxNS) {
                invalidNameServerNodes.add(node);
                continue;
            }
            this.m_resultSet.addResult(node, 1);
            validNameServerNodes.add(node);
        }
        if (invalidNameServerNodes.size() > 0) {
            String[] invalidNameServerArray = invalidNameServerNodes.toArray(new String[0]);
            String msg = s_msgBundle.getMessage("5607", true, (Object[])new String[]{"/etc/resolv.conf", Integer.toString(this.m_maxNS), VerificationUtil.strList2List(invalidNameServerNodes)});
            this.m_resultSet.addResult(invalidNameServerArray, 3);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(invalidNameServerArray, errDesc);
            ReportUtil.sureprintln(msg);
            status = false;
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5631", false, (Object[])new String[]{Integer.toString(this.m_maxNS), "/etc/resolv.conf"}));
        }
        if (validNameServerNodes.size() <= 1) {
            Trace.out((String)"no nodes with valid nameserver list");
            return status;
        }
        String refNode = (String)validNameServerNodes.get(0);
        List<String> refNameServerData = this.m_allNodeResolvConf.get(refNode).getNameServer();
        String refString = VerificationUtil.strCollection2String(refNameServerData, VerificationConstants.LSEP);
        Trace.out((String)("reference data" + refString));
        ReportUtil.sureprintln(s_msgBundle.getMessage("5617", false, (Object[])new String[]{refString, refNode}));
        ResultSet locRes = new ResultSet();
        for (String node : validNameServerNodes) {
            List<String> curNodeNameServerData = this.m_allNodeResolvConf.get(node).getNameServer();
            if (curNodeNameServerData.equals(refNameServerData)) {
                locRes.addResult(node, 1);
                continue;
            }
            String curString = VerificationUtil.strCollection2String(curNodeNameServerData, VerificationConstants.LSEP);
            Trace.out((String)("different search order :" + curString));
            String msg = s_msgBundle.getMessage("5614", true, (Object[])new String[]{"/etc/resolv.conf", node, curString});
            locRes.addResult(node, 3);
            ErrorDescription errDesc = new ErrorDescription(msg);
            locRes.addErrorDescription(node, errDesc);
            ReportUtil.sureprintln(msg);
            status = false;
        }
        this.m_resultSet.addResultSetData(locRes);
        if (locRes.allSuccess()) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5618", false));
        }
        return status;
    }

    public boolean performTimeOutRetryAttempsValidation() {
        ErrorDescription errDesc;
        int i;
        ArrayList<String> vffailedNodeList = new ArrayList<String>();
        ArrayList<String> opfailedNodeList = new ArrayList<String>();
        String[] confNodeList = this.m_confOKVector.toArray(new String[0]);
        ReportUtil.println(s_msgBundle.getMessage("5635", false, (Object[])new String[]{"/etc/resolv.conf"}));
        ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("8018", false));
        String unReachableNode = "unknown-not-reachable-node";
        VerificationCommand[] localDriverCmdArray = new VerificationCommand[confNodeList.length];
        for (i = 0; i < confNodeList.length; ++i) {
            Trace.out((String)("forming command for node:" + confNodeList[i]));
            String[] args = new String[]{"-rungencmd", this.m_nslookup, unReachableNode};
            String[] env = null;
            localDriverCmdArray[i] = new VerificationCommand(confNodeList[i], args, env);
        }
        for (i = 0; i < confNodeList.length; ++i) {
            String reportStatus = null;
            NslookupThread nsThread = new NslookupThread(localDriverCmdArray[i], confNodeList[i]);
            Trace.out((String)("executing on node" + confNodeList[i]));
            long startTime = System.currentTimeMillis();
            nsThread.run();
            long currentTime = System.currentTimeMillis();
            Trace.out((String)("currentTime = " + currentTime + " start time = " + startTime));
            if (currentTime - startTime > this.m_dnsAcceptableTime) {
                Trace.out((String)("currentTime=" + currentTime + "Start time =" + startTime));
                vffailedNodeList.add(confNodeList[i]);
                reportStatus = ReportUtil.FAILED;
                this.m_resultSet.addResult(confNodeList[i], 3);
                Trace.out((String)("Caught interrupted exception for node:" + confNodeList[i]));
            }
            if (reportStatus == null) {
                Trace.out((String)("thread not interrupted on node:" + confNodeList[i]));
                Result locRes = nsThread.getResult();
                if (locRes.getStatus() != 2) {
                    this.m_resultSet.addResult(confNodeList[i], 1);
                    reportStatus = ReportUtil.PASSED;
                } else {
                    Trace.out((String)("nslookup command didn't run on node:" + confNodeList[i]));
                    reportStatus = ReportUtil.FAILED;
                    opfailedNodeList.add(confNodeList[i]);
                    this.m_resultSet.addResult(confNodeList[i], 2);
                }
            }
            ReportUtil.writeRecord(confNodeList[i], reportStatus);
        }
        if (vffailedNodeList.size() != 0) {
            String msg = s_msgBundle.getMessage("5636", true, (Object[])new String[]{Long.toString(this.m_dnsAcceptableTime), VerificationUtil.strList2List(vffailedNodeList)});
            errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(vffailedNodeList.toArray(new String[0]), errDesc);
            ReportUtil.sureprintln(msg);
            return false;
        }
        if (opfailedNodeList.size() != 0) {
            String msg = s_msgBundle.getMessage("5637", true, (Object[])new String[]{VerificationUtil.strList2List(opfailedNodeList)});
            errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(opfailedNodeList.toArray(new String[0]), errDesc);
            ReportUtil.sureprintln(msg);
            return false;
        }
        ReportUtil.sureprintln(s_msgBundle.getMessage("5638", false));
        return true;
    }

    private boolean performOptionValidation(String option) {
        ErrorDescription errDesc;
        ResultSet locRes = new ResultSet();
        boolean status = true;
        boolean toRejectAllConfigFiles = false;
        Trace.out((String)(option + " option validation"));
        ArrayList<String> optionExistNode = new ArrayList<String>();
        ArrayList<String> optionNonExistantNodes = new ArrayList<String>();
        for (String node : this.m_confOKVector) {
            boolean isOptionDefined = this.m_allNodeResolvConf.get(node).isOptionDefined(option);
            if (isOptionDefined) {
                Trace.out((String)(option + " option exists on node :" + node));
                optionExistNode.add(node);
                continue;
            }
            Trace.out((String)(option + " option does not exist on node :" + node));
            optionNonExistantNodes.add(node);
        }
        if (optionExistNode.size() > 0 && optionNonExistantNodes.size() > 0) {
            String[] optionNonExistantArray = optionNonExistantNodes.toArray(new String[0]);
            String msg = s_gMsgBundle.getMessage("12861", true, (Object[])new String[]{option, "/etc/resolv.conf", VerificationUtil.strList2List(optionNonExistantNodes)});
            locRes.addResult(optionNonExistantArray, 3);
            errDesc = new ErrorDescription(msg);
            locRes.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            status = false;
        } else {
            locRes.addResult(this.m_confOKVector.toArray(new String[0]), 1);
        }
        if (optionExistNode.size() == 0) {
            Trace.out((String)(option + " option doesn't exist on any node"));
            this.m_resultSet.uploadResultSet(locRes);
            return status;
        }
        ArrayList<String> singleOptionNodes = new ArrayList<String>();
        ArrayList<String> multiOptionNodes = new ArrayList<String>();
        for (String node : optionExistNode) {
            int optionCount = this.m_allNodeResolvConf.get(node).getOptionCount(option);
            Trace.out((String)("There are " + optionCount + " " + option + " option entries on " + node));
            if (optionCount > 1) {
                Trace.out((String)(option + " option count multiple " + node));
                multiOptionNodes.add(node);
                continue;
            }
            Trace.out((String)(option + " option count single " + node));
            singleOptionNodes.add(node);
            locRes.addResult(node, 1);
        }
        if (multiOptionNodes.size() > 0) {
            toRejectAllConfigFiles = true;
            String msg = s_gMsgBundle.getMessage("12864", true, (Object[])new String[]{"/etc/resolv.conf", VerificationUtil.strList2List(multiOptionNodes), option});
            locRes.addResult(multiOptionNodes, 3);
            errDesc = new ErrorDescription(msg);
            locRes.addErrorDescription(errDesc);
            ReportUtil.printError(msg.toString());
            status = false;
        } else {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("12865", false, (Object[])new String[]{option}));
        }
        if (singleOptionNodes.size() <= 1) {
            Trace.out((String)("no nodes with one " + option + " option"));
            this.m_resultSet.uploadResultSet(locRes);
            return status;
        }
        Hashtable<Object, Vector<Object>> optionTable = new Hashtable<Object, Vector<Object>>();
        for (String node : singleOptionNodes) {
            VerificationUtil.updateResultMap(optionTable, this.m_allNodeResolvConf.get(node).getOption(option, 0), node);
        }
        if (optionTable.size() == 1) {
            if (!toRejectAllConfigFiles) {
                locRes.addResult(singleOptionNodes, 1);
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("12866", false, (Object[])new String[]{VerificationUtil.strList2List(singleOptionNodes), option, "/etc/resolv.conf"}));
            }
        } else {
            StringBuilder msg = new StringBuilder();
            msg.append(s_gMsgBundle.getMessage("12867", true, (Object[])new String[]{option, "/etc/resolv.conf"}) + LSEP);
            Enumeration<Object> e = optionTable.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String nodeListStr = VerificationUtil.strVect2List(optionTable.get(key));
                msg.append(s_gMsgBundle.getMessage("12868", false, (Object[])new String[]{option, key, nodeListStr}) + LSEP);
            }
            locRes.addResult(singleOptionNodes, 3);
            locRes.addErrorDescription(new ErrorDescription(msg.toString()));
            ReportUtil.printError(msg.toString());
            status = false;
        }
        this.m_resultSet.addResultSetData(locRes);
        return status;
    }

    private boolean performTimeoutAttemptsValidation() {
        String node = this.m_nodeList[0];
        boolean result = true;
        int timeout = 0;
        int attempts = 0;
        boolean isTimeoutDefined = true;
        boolean isRetransDefined = true;
        boolean isAttemptsDefined = true;
        boolean isRetryDefined = true;
        TaskResolvConfData data = null;
        String flagTimeoutDefined = null;
        String flagAttemptsDefined = null;
        String timeoutFileValue = null;
        String attemptsFileValue = null;
        Trace.out((String)("node-timeoutattempts [" + node + "]"));
        data = this.m_allNodeResolvConf.get(node);
        if (data == null) {
            return false;
        }
        isTimeoutDefined = data.isOptionDefined("timeout");
        isRetransDefined = data.isOptionDefined("retrans");
        isAttemptsDefined = data.isOptionDefined("attempts");
        boolean bl = isRetryDefined = data.isOptionDefined("retry");
        if (isTimeoutDefined) {
            flagTimeoutDefined = "timeout";
        }
        if (isRetransDefined) {
            flagTimeoutDefined = "retrans";
        }
        if (isAttemptsDefined) {
            flagAttemptsDefined = "attempts";
        }
        if (isRetryDefined) {
            flagAttemptsDefined = "retry";
        }
        if (isTimeoutDefined || isRetransDefined) {
            try {
                timeoutFileValue = data.getOption(flagTimeoutDefined, 0);
                timeout = Integer.parseInt(timeoutFileValue);
            }
            catch (NumberFormatException nfe) {
                timeout = 30;
            }
        } else {
            timeout = 5;
        }
        if (isAttemptsDefined || isRetryDefined) {
            try {
                attemptsFileValue = data.getOption(flagAttemptsDefined, 0);
                attempts = Integer.parseInt(attemptsFileValue);
            }
            catch (NumberFormatException nfe) {
                attempts = 5;
            }
        } else {
            attempts = 2;
        }
        if (timeout > 30) {
            timeout = 30;
        }
        if (attempts > 5) {
            attempts = 5;
        }
        Trace.out((String)("timeout[" + timeout + "] attempts[" + attempts + "]"));
        if (timeout * attempts > 90) {
            result = false;
            String msg = s_gMsgBundle.getMessage("12869", true, (Object[])new String[]{attemptsFileValue, timeoutFileValue, "/etc/resolv.conf", String.valueOf(90)});
            ReportUtil.sureprintln(msg);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addResult(this.m_nodeList, 3);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
        } else {
            this.m_resultSet.addResult(this.m_nodeList, 1);
        }
        return result;
    }

    public boolean performSearchAndDomainCheck() {
        boolean status = true;
        ReportUtil.println(s_msgBundle.getMessage("5639", false, (Object[])new String[]{"/etc/resolv.conf"}));
        ArrayList<String> bothExistNodes = new ArrayList<String>();
        ArrayList<String> configOkayNodeList = new ArrayList<String>();
        for (String node : this.m_confOKVector) {
            TaskResolvConfData taskData = this.m_allNodeResolvConf.get(node);
            if (taskData.isDomainDefined() && taskData.isSearchOrderDefined()) {
                Trace.out((String)("domain and search exists on node :" + node));
                bothExistNodes.add(node);
                continue;
            }
            configOkayNodeList.add(node);
        }
        this.m_confOKVector.clear();
        this.m_confOKVector.addAll(configOkayNodeList);
        if (bothExistNodes.size() > 0) {
            String[] bothExistArray = bothExistNodes.toArray(new String[0]);
            String msg = s_msgBundle.getMessage("5640", true, (Object[])new String[]{"/etc/resolv.conf", VerificationUtil.strList2List(bothExistNodes)});
            this.m_resultSet.addResult(bothExistArray, 4);
            ReportUtil.printWarning(msg);
            for (String node : bothExistArray) {
                msg = s_gMsgBundle.getMessage("2016", true, (Object[])new String[]{"/etc/resolv.conf", node});
                ErrorDescription errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(node, errDesc);
            }
            status = false;
        } else {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("2003", false, (Object[])new String[]{"/etc/resolv.conf"}));
            this.m_resultSet.addResult(this.m_confOKVector.toArray(new String[0]), 1);
        }
        return status;
    }

    private boolean prepareNodeResolvConfMap() {
        boolean status = true;
        String scratchPath = VerificationUtil.getCVUSubDirPath() + "scratch";
        File tempArea = new File(scratchPath);
        if (!tempArea.exists()) {
            tempArea.mkdirs();
        }
        if (!tempArea.isDirectory()) {
            tempArea.delete();
            tempArea.mkdir();
        }
        if (!tempArea.exists() || !tempArea.isDirectory()) {
            Trace.out((String)("Couldn't create " + tempArea.getName()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            String msg = s_msgBundle.getMessage("5642", true, (Object[])new String[]{scratchPath});
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            return false;
        }
        ArrayList<String> resolvConfnotExistNodes = new ArrayList<String>();
        ArrayList<String> resolvConfExistNodes = new ArrayList<String>();
        ClusterCmd clusterCmd = new ClusterCmd();
        for (String node : this.m_nodeList) {
            boolean copyStatus = false;
            Trace.out((String)("copying file from node:" + node));
            try {
                boolean currentNodeStatus = clusterCmd.fileExists(node, "/etc/resolv.conf");
                if (!currentNodeStatus) {
                    Trace.out((String)("resolv.conf does not exists on node" + node));
                    resolvConfnotExistNodes.add(node);
                    continue;
                }
                resolvConfExistNodes.add(node);
                String nodeFilePath = scratchPath + "/resolv.conf_" + node;
                File prvCopy = new File(nodeFilePath);
                if (prvCopy.exists()) {
                    prvCopy.delete();
                }
                copyStatus = clusterCmd.copyFileFromNode(node, "/etc/resolv.conf", nodeFilePath);
                Trace.out((String)("copy status = " + copyStatus));
                if (!copyStatus) continue;
                this.m_confOKVector.add(node);
            }
            catch (ClusterException e) {
                Trace.out((String)"ClusterException while looking for resolv.conf");
                this.m_resultSet.addResult(node, 2);
                String msg = s_gMsgBundle.getMessage("2002", true, (Object[])new String[]{"/etc/resolv.conf", node, m_localNode}) + LSEP + e.getMessage();
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(msg));
                ReportUtil.sureprintln(msg);
                status = false;
            }
        }
        if (resolvConfnotExistNodes.size() > 0 && resolvConfExistNodes.size() > 0) {
            Trace.out((String)"resolv.conf exists on some nodes");
            String msg = s_msgBundle.getMessage("5605", true, (Object[])new String[]{"/etc/resolv.conf", VerificationUtil.strList2List(resolvConfnotExistNodes)});
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addResult(resolvConfnotExistNodes.toArray(new String[0]), 3);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
            ReportUtil.sureprintNodelist(resolvConfExistNodes.toArray(new String[0]));
            ReportUtil.sureprintln("");
        } else if (resolvConfExistNodes.size() == 0) {
            Trace.out((String)"no resolv.conf on any node. not an error just skip the test");
            ReportUtil.sureprintln(s_msgBundle.getMessage("5606", false, (Object[])new String[]{"/etc/resolv.conf"}));
            this.m_resultSet.addResult(this.m_nodeList, 1);
            this.m_resolvConfMissingAllNodes = true;
            return true;
        }
        if (this.m_confOKVector.size() == 0) {
            return false;
        }
        ArrayList<String> copyConfOKVector = new ArrayList<String>(this.m_confOKVector);
        for (String node : copyConfOKVector) {
            ErrorDescription errDesc;
            boolean badConfFile = false;
            ArrayList<String> badResolvConfLines = new ArrayList<String>();
            TaskResolvConfData curResolvConfData = new TaskResolvConfData();
            curResolvConfData.setNodeName(node);
            Trace.out((String)("Parsing resolv.conf of node:" + node));
            try {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(scratchPath + "/resolv.conf_" + node));
                while ((line = in.readLine()) != null) {
                    String[] tokens;
                    line = line.trim();
                    Trace.out((String)("line [" + line + "]"));
                    if (line.length() == 0 || line.startsWith("#") || line.startsWith(";")) continue;
                    int index = line.indexOf("#");
                    if (index != -1) {
                        line = line.substring(0, index).trim();
                    }
                    if ((index = line.indexOf(";")) != -1) {
                        line = line.substring(0, index).trim();
                    }
                    if ((line = VerificationUtil.strArr2String(tokens = line.split("\\s+"), " ")).matches("^domain[\\s]+.*")) {
                        String[] domainArr = line.split("^domain[\\s]+");
                        if (domainArr.length != 2) {
                            badConfFile = true;
                            badResolvConfLines.add(line);
                            continue;
                        }
                        String domain = domainArr[1].trim();
                        Trace.out((String)("domain = " + domain));
                        if (domain != null && domain.length() != 0) {
                            curResolvConfData.setDomain(domain);
                            continue;
                        }
                        badConfFile = true;
                        badResolvConfLines.add(line);
                        continue;
                    }
                    if (line.matches("^search[\\s]+.*")) {
                        Trace.out((String)("search order line matched" + line));
                        String[] searchOrderArr = line.split("^search[\\s]+");
                        Trace.out((String)("search order length =" + searchOrderArr.length));
                        if (searchOrderArr.length != 2) {
                            badConfFile = true;
                            badResolvConfLines.add(line);
                            continue;
                        }
                        String searchOrder = searchOrderArr[1].trim();
                        Trace.out((String)("search order = " + searchOrder));
                        if (searchOrder != null && searchOrder.length() != 0) {
                            curResolvConfData.setSearchOrder(searchOrder);
                            continue;
                        }
                        badConfFile = true;
                        badResolvConfLines.add(line);
                        continue;
                    }
                    if (line.matches("^nameserver[\\s]+.*")) {
                        String[] nameServerArr = line.split("^nameserver[\\s]+");
                        if (nameServerArr.length != 2) {
                            badConfFile = true;
                            badResolvConfLines.add(line);
                            continue;
                        }
                        String nameServer = nameServerArr[1].trim();
                        Trace.out((String)("name server = " + nameServer));
                        if (nameServer != null && nameServer.length() != 0) {
                            curResolvConfData.setNameServer(nameServer);
                            continue;
                        }
                        badConfFile = true;
                        badResolvConfLines.add(line);
                        continue;
                    }
                    if (!line.matches("^options[\\s]+.*")) continue;
                    String optionType = null;
                    if (line.matches(this.m_timeoutAttemptsOptionValidLine.toString())) {
                        String[] timeoutTokens = line.split(this.m_timeoutOptionField);
                        String[] attemptsTokens = line.split(this.m_attemptsOptionField);
                        if (timeoutTokens.length == 1 && attemptsTokens.length == 1) continue;
                        if (timeoutTokens.length > 2 || attemptsTokens.length > 2) {
                            badConfFile = true;
                            badResolvConfLines.add(line);
                            continue;
                        }
                        if (timeoutTokens.length == 2) {
                            if (line.indexOf("timeout") != -1) {
                                optionType = "timeout";
                            }
                            if (line.indexOf("retrans") != -1) {
                                optionType = "retrans";
                            }
                            Trace.out((String)("option [" + optionType + "]"));
                            badConfFile |= this.setOptionValue(optionType, line, badResolvConfLines, curResolvConfData);
                        }
                        if (attemptsTokens.length != 2) continue;
                        if (line.indexOf("attempts") != -1) {
                            optionType = "attempts";
                        }
                        if (line.indexOf("retry") != -1) {
                            optionType = "retry";
                        }
                        Trace.out((String)("option [" + optionType + "]"));
                        badConfFile |= this.setOptionValue(optionType, line, badResolvConfLines, curResolvConfData);
                        continue;
                    }
                    badConfFile = true;
                    badResolvConfLines.add(line);
                }
                if (!badConfFile && (curResolvConfData.isDomainDefined() || curResolvConfData.isSearchOrderDefined() || curResolvConfData.isNameServerDefined())) {
                    this.m_allNodeResolvConf.put(node, curResolvConfData);
                } else {
                    badResolvConfLines.add(0, node);
                    String msg = !badConfFile ? s_gMsgBundle.getMessage("13159", true, (Object[])new String[]{node}) : s_msgBundle.getMessage("5600", true, (Object[])new String[]{node, "/etc/resolv.conf", VerificationUtil.strCollection2String(badResolvConfLines, VerificationConstants.LSEP)});
                    errDesc = new ErrorDescription(msg);
                    this.m_resultSet.addErrorDescription(node, errDesc);
                    this.m_resultSet.addResult(node, 3);
                    ReportUtil.sureprintln(msg);
                    this.m_confOKVector.remove(node);
                    status = false;
                }
                in.close();
            }
            catch (IOException e) {
                Trace.out((String)("IOException while reading copied resolv.conf for node :" + node));
                this.m_resultSet.addResult(node, 2);
                String msg = s_msgBundle.getMessage("5629", true, (Object[])new String[]{"/etc/resolv.conf", node}) + VerificationConstants.LSEP + e.getMessage();
                errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(node, errDesc);
                ReportUtil.sureprintln(msg);
                this.m_confOKVector.remove(node);
                status = false;
            }
        }
        this.cleanScratchDirectory(scratchPath);
        return status;
    }

    private boolean setOptionValue(String option, String line, List<String> badResolvConfLines, TaskResolvConfData curResolvConfData) {
        boolean badConfFile = false;
        Pattern optionPattern = null;
        Matcher matcher = null;
        String optionGroup = null;
        String pattern = null;
        String optionValue = null;
        String[] optionToken = null;
        if (option.equals("timeout") || option.equals("retrans")) {
            pattern = this.m_timeoutOptionValueField.toString();
        } else if (option.equals("attempts") || option.equals("retry")) {
            pattern = this.m_attemptsOptionValueField.toString();
        }
        optionPattern = Pattern.compile(pattern);
        matcher = optionPattern.matcher(line);
        matcher.find();
        optionGroup = matcher.group(1);
        optionToken = optionGroup.split(":");
        optionValue = optionToken[1];
        optionValue = optionValue.trim();
        Trace.out((String)("option " + option + " = " + optionValue));
        if (VerificationUtil.isStringGood(optionValue)) {
            curResolvConfData.setOption(option, optionValue);
        } else {
            badConfFile = true;
            badResolvConfLines.add(line);
        }
        return badConfFile;
    }

    public boolean performNsLookup() {
        Task previousTaskReference;
        String message;
        Object outputCmd;
        String nodeCmd;
        String[] validNodes = this.m_confOKVector.toArray(new String[0]);
        TaskResolvConfData confData = null;
        List<String> servers = null;
        ArrayList<String> nslookupQuery = null;
        ResultSet resultSetInet = new ResultSet();
        ResultSet resultSetInet6 = new ResultSet();
        Hashtable<String, String[]> nslookupInputInet6 = new Hashtable<String, String[]>(this.m_confOKVector.size());
        Hashtable<String, String[]> nslookupInputInet = new Hashtable<String, String[]>(this.m_confOKVector.size());
        Hashtable<String, String[]> nslookupOutputInet = null;
        Hashtable<String, String[]> nslookupOutputInet6 = null;
        ArrayList<String> nodeInterfaceInet = new ArrayList<String>(this.m_confOKVector.size());
        ArrayList<String> nodeInterfaceInet6 = new ArrayList<String>(this.m_confOKVector.size());
        ArrayList<String> nodesEmptyNameserver = new ArrayList<String>();
        Set<Map.Entry<String, String[]>> nslookupSet = null;
        Iterator<Map.Entry<String, String[]>> nslookupSetIterator = null;
        HashMap<String, Set<NetworkInfo>> nodeNetworksMap = new HashMap();
        ResultSet networksResultSet = new ResultSet();
        nodeNetworksMap = NetworkDataDiscovery.getNodeNetworksMap(validNodes, networksResultSet);
        if (!NetworkUtility.isNetworksMapGood(nodeNetworksMap)) {
            Trace.out((String)"Could not discover the network details successfully during Resolve Config Integrity checks");
            NetworkUtility.reportResultSet(networksResultSet, this.m_resultSet, true);
            return false;
        }
        for (String node : nodeNetworksMap.keySet()) {
            for (NetworkInfo network : nodeNetworksMap.get(node)) {
                if (NetworkUtility.isIPV6(network, false) && !nodeInterfaceInet6.contains(node)) {
                    nodeInterfaceInet6.add(node);
                }
                if (NetworkUtility.isIPV4(network, false) && !nodeInterfaceInet.contains(node)) {
                    nodeInterfaceInet.add(node);
                }
                Trace.out((String)(network.getNodeName() + " Inet: " + network.getIpAddressType().toString()));
            }
        }
        for (String nodeConf : this.m_confOKVector) {
            confData = this.m_allNodeResolvConf.get(nodeConf);
            if (confData.getNameServerCount() == 0) {
                nodesEmptyNameserver.add(nodeConf);
                continue;
            }
            servers = confData.getNameServer();
            nslookupQuery = new ArrayList<String>();
            for (String nodeServer : servers) {
                if (!nodeInterfaceInet.contains(nodeConf)) continue;
                nslookupQuery.add(nodeServer);
            }
            Trace.out((String)("adding nslookup queries to node " + nodeConf));
            nslookupInputInet.put(nodeConf, nslookupQuery.toArray(new String[0]));
        }
        String autoConfig = CVUVariables.getValue(CVUVariableConstants.AUTO_CONFIGURE_CLUSTER_NODE_VIP);
        if (!(nodesEmptyNameserver.size() <= 0 || autoConfig != null && Boolean.parseBoolean(autoConfig))) {
            String[] nodesEmptyNameserverArr = nodesEmptyNameserver.toArray(new String[0]);
            String scanName = CVUVariables.getValue(CVUVariableConstants.SCAN_NAME);
            String nodeVipStr = CVUVariables.getValue(CVUVariableConstants.HOST_VIP_NAMES);
            if (!VerificationUtil.isStringGood(scanName) || !VerificationUtil.isStringGood(nodeVipStr)) {
                VerificationUtil.traceAndLog("Scan and VIPs are not available");
                if (!VerificationUtil.isAPIMode()) {
                    String strNodesEmptyNs = VerificationUtil.strArr2List(nodesEmptyNameserverArr);
                    String errMsg = s_gMsgBundle.getMessage("2064", true, (Object[])new String[]{strNodesEmptyNs});
                    this.m_resultSet.addErrorDescription(nodesEmptyNameserverArr, new ErrorDescription(errMsg));
                    this.m_resultSet.addResult(nodesEmptyNameserverArr, 4);
                }
            } else {
                String[] fullNodeName;
                VerificationUtil.traceAndLog("Scan, VIP exists, see content of hosts");
                VerificationUtil.traceAndLog("Scan " + scanName + " VIP " + nodeVipStr);
                ArrayList nodeVips = new ArrayList();
                for (String string : fullNodeName = VerificationUtil.string2strArr(nodeVipStr)) {
                    String[] arrNodeVip = VerificationUtil.string2strArr(string, ":");
                    nodeVips.add(arrNodeVip[1].toLowerCase());
                }
                GlobalExecution globalExec = new GlobalExecution();
                ResultSet resultSetHosts = new ResultSet();
                ArrayList<String> nodesBadHosts = new ArrayList<String>();
                scanName = scanName.toLowerCase();
                globalExec.checkHostsFile(nodesEmptyNameserverArr, resultSetHosts);
                block5: for (String node : nodesEmptyNameserverArr) {
                    Result resultHosts = resultSetHosts.getResult(node);
                    String output = resultHosts.getExectaskOutput();
                    if (!VerificationUtil.fetchExecResult(output)) continue;
                    String hostsContent = VerificationUtil.fetchTextByTags(output, "<CV_CMDOUT>", "</CV_CMDOUT>");
                    if ((hostsContent = hostsContent.toLowerCase()).indexOf(scanName) == -1) {
                        nodesBadHosts.add(node);
                        continue;
                    }
                    Iterator iterator = nodeVips.iterator();
                    while (iterator.hasNext()) {
                        String nodeV = (String)iterator.next();
                        if (hostsContent.indexOf(nodeV) != -1) continue;
                        nodesBadHosts.add(node);
                        continue block5;
                    }
                }
                if (nodesBadHosts.size() > 0) {
                    String[] stringArray = nodesBadHosts.toArray(new String[0]);
                    String strNodesEmptyNs = VerificationUtil.strArr2List(stringArray);
                    String errMsg = s_gMsgBundle.getMessage("2064", true, (Object[])new String[]{strNodesEmptyNs});
                    this.m_resultSet.addErrorDescription(nodesEmptyNameserverArr, new ErrorDescription(errMsg));
                    this.m_resultSet.addResult(nodesEmptyNameserverArr, 3);
                }
            }
        }
        Set nodeswithNameserver = nslookupInputInet.keySet();
        if (nslookupInputInet.size() <= 0) {
            return false;
        }
        nslookupOutputInet = this.resolveNames(nodeswithNameserver.toArray(new String[0]), nslookupInputInet, true, nodeInterfaceInet6, resultSetInet);
        if (resultSetInet.getStatus() == 2) {
            Trace.out((String)"an error occurred while querying to dns type A");
            Object[] failureNodes = new String[]{VerificationUtil.objArr2String(resultSetInet.getFailureNodes())};
            String errMsg = s_gMsgBundle.getMessage("2018", true, failureNodes);
            for (VerificationError vErr : resultSetInet.getErrors()) {
                errMsg = errMsg + LSEP + vErr.getErrorMessage();
            }
            this.m_resultSet.addResultSetData(resultSetInet);
            this.m_resultSet.setStatus(3);
            ReportUtil.sureprintln(errMsg);
            return false;
        }
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("2024", false, (Object[])new String[]{"/etc/resolv.conf"}));
        ArrayList<String> nodesApplyInet6 = new ArrayList<String>();
        nslookupSet = nslookupOutputInet.entrySet();
        for (Map.Entry<String, String[]> entry : nslookupSet) {
            nodeCmd = entry.getKey();
            outputCmd = entry.getValue();
            if (ReportUtil.isVerbose()) {
                message = s_gMsgBundle.getMessage("2025", false, (Object[])new String[]{nodeCmd, "/etc/resolv.conf"});
                ReportUtil.sureprintln(message);
                previousTaskReference = ReportUtil.setTaskReference(this);
                ReportUtil.reportFormatPrintln(LSEP + message);
                ReportUtil.setTaskReference(previousTaskReference);
            }
            ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("8006", false), s_msgBundle.getMessage("8001", false), s_msgBundle.getMessage("8018", false));
            String[] cmd = nslookupInputInet.get(nodeCmd);
            ArrayList<String> serversApplyInet6 = new ArrayList<String>();
            for (int i = 0; i < ((Object)outputCmd).length; ++i) {
                String string = VerificationUtil.fetchVerificationValue((String)outputCmd[i]);
                String exitStat = VerificationUtil.fetchVerificationResult((String)outputCmd[i]);
                Trace.out((String)("reading output from node " + nodeCmd + "  " + string));
                if (exitStat != null && exitStat.contentEquals("0")) {
                    String server = cmd[i];
                    if (string.indexOf(CRSTXT_SUC) != -1) {
                        this.m_resultSet.addResult(nodeCmd, 1);
                        ReportUtil.writeRecord(nodeCmd, server, "IPv4", ReportUtil.PASSED);
                        continue;
                    }
                    ReportUtil.writeRecord(nodeCmd, server, "IPv4", ReportUtil.FAILED);
                    if (nodeInterfaceInet6.contains(nodeCmd)) {
                        Trace.out((String)("node " + nodeCmd + " did not resolve an ipv4 we try for an ipv6 address " + server));
                        nodesApplyInet6.add(nodeCmd);
                        serversApplyInet6.add(server);
                        continue;
                    }
                    Trace.out((String)("The node " + nodeCmd + " failed with type=A and has not ipv6"));
                    String errMsg = null;
                    errMsg = VerificationUtil.getCRSErrorMessage(string);
                    if (errMsg == null) {
                        String crsErr = string.substring(string.indexOf("CRS"), string.indexOf(":"));
                        String command = this.m_isCvunetquery ? CRSCTL_LITE_CMD : CRSCTL_CMD;
                        String[] listServers = nslookupInputInet.get(nodeCmd);
                        command = command + " query dns -name " + nodeCmd + " -type " + "A" + " -dnsserver " + listServers[i];
                        errMsg = s_msgBundle.getMessage("5718", true, (Object[])new String[]{command, nodeCmd, crsErr});
                    }
                    ErrorDescription errDesc = new ErrorDescription(errMsg);
                    this.m_resultSet.addErrorDescription(nodeCmd, errDesc);
                    this.m_resultSet.addResult(nodeCmd, 3);
                    ReportUtil.sureprintln(errMsg);
                    continue;
                }
                Trace.out((String)"an error occurred while querying to dns type A after -rungencmd");
                String errMsg = s_gMsgBundle.getMessage("2018", true, (Object[])new String[]{nodeCmd});
                errMsg = errMsg + LSEP + string;
                this.m_resultSet.addErrorDescription(nodeCmd, new ErrorDescription(errMsg));
                this.m_resultSet.addResult(nodeCmd, 3);
                ReportUtil.sureprintln(errMsg);
            }
            if (serversApplyInet6.size() <= 0) continue;
            nslookupInputInet6.put(nodeCmd, serversApplyInet6.toArray(new String[0]));
        }
        if (nslookupInputInet6.size() > 0) {
            nslookupOutputInet6 = this.resolveNames(nodesApplyInet6.toArray(new String[0]), nslookupInputInet6, false, nodeInterfaceInet6, resultSetInet6);
            if (resultSetInet6.getStatus() == 2) {
                Trace.out((String)"an error occurred while querying to dns type AAAA");
                Object[] failureNodes = new String[]{VerificationUtil.objArr2String(resultSetInet6.getFailureNodes())};
                String errMsg = s_gMsgBundle.getMessage("2018", true, failureNodes);
                for (VerificationError vErr : resultSetInet6.getErrors()) {
                    errMsg = errMsg + LSEP + vErr.getErrorMessage();
                }
                this.m_resultSet.addResultSetData(resultSetInet6);
                this.m_resultSet.setStatus(3);
                ReportUtil.sureprintln(errMsg);
                return false;
            }
            nslookupSet = nslookupOutputInet6.entrySet();
            for (Map.Entry<String, String[]> entry : nslookupSet) {
                nodeCmd = entry.getKey();
                outputCmd = entry.getValue();
                message = LSEP + s_gMsgBundle.getMessage("2025", false, (Object[])new String[]{nodeCmd, "/etc/resolv.conf"});
                ReportUtil.println(message);
                if (ReportUtil.isVerbose()) {
                    previousTaskReference = ReportUtil.setTaskReference(this);
                    ReportUtil.reportFormatPrintln(LSEP + message);
                    ReportUtil.setTaskReference(previousTaskReference);
                }
                ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("8006", false), s_msgBundle.getMessage("8001", false), s_msgBundle.getMessage("8018", false));
                String[] cmd = nslookupInputInet6.get(nodeCmd);
                for (int i = 0; i < ((Object)outputCmd).length; ++i) {
                    String string = VerificationUtil.fetchVerificationValue((String)outputCmd[i]);
                    String exitStat = VerificationUtil.fetchVerificationResult((String)outputCmd[i]);
                    Trace.out((String)("reading output from node " + nodeCmd + "  " + string));
                    if (exitStat != null && exitStat.contentEquals("0")) {
                        String server = cmd[i];
                        if (string.indexOf(CRSTXT_SUC) != -1) {
                            this.m_resultSet.addResult(nodeCmd, 1);
                            ReportUtil.writeRecord(nodeCmd, server, "IPv6", ReportUtil.PASSED);
                            continue;
                        }
                        Trace.out((String)("error while lookingup the node " + nodeCmd + "  from server " + server + " using AAAA"));
                        String crsErrMsg = VerificationUtil.getCRSErrorMessage(string);
                        String msgErr = s_gMsgBundle.getMessage("2048", true, (Object[])new String[]{nodeCmd, server});
                        if (VerificationUtil.isStringGood(crsErrMsg)) {
                            msgErr = msgErr + LSEP + crsErrMsg;
                        }
                        this.m_resultSet.addResult(nodeCmd, 3);
                        this.m_resultSet.addErrorDescription(nodeCmd, new ErrorDescription(msgErr));
                        if (!ReportUtil.isVerbose()) {
                            ReportUtil.sureprintln(msgErr);
                        }
                        ReportUtil.writeRecord(nodeCmd, server, "IPv6", ReportUtil.FAILED);
                        continue;
                    }
                    Trace.out((String)"an error occurred while querying to dns type AAAA after -rungencmd");
                    String errMsg = s_gMsgBundle.getMessage("2018", true, (Object[])new String[]{nodeCmd});
                    errMsg = errMsg + LSEP + string;
                    ErrorDescription errDesc = new ErrorDescription(errMsg);
                    this.m_resultSet.addErrorDescription(nodeCmd, errDesc);
                    this.m_resultSet.addResult(nodeCmd, 3);
                    ReportUtil.sureprintln(errMsg);
                }
            }
        }
        return true;
    }

    public String getResolvConfLocation() {
        return "/etc/resolv.conf";
    }

    private void cleanScratchDirectory(String scratchPath) {
        for (String node : this.m_nodeList) {
            String tempLocation = scratchPath + "/resolv.conf_" + node;
            File resolvConf = new File(tempLocation);
            if (!resolvConf.exists()) continue;
            resolvConf.delete();
        }
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("5632", false, (Object[])new String[]{"/etc/resolv.conf"});
    }

    @Override
    public String getDefaultElementName() {
        String operatingSystem = VerificationUtil.getCurrentOS();
        return "(" + operatingSystem + ") " + s_msgBundle.getMessage("5633", false);
    }

    @Override
    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.HUB_CAPABLE;
    }

    private Hashtable<String, String[]> resolveNames(String[] nodeList, Hashtable<String, String[]> nodeQueryList, boolean isTypeA, ArrayList<String> nodeInterfaceInet6, ResultSet resultSet) {
        Hashtable<String, String[]> tableResult = new Hashtable<String, String[]>(nodeList.length);
        Result resultLocation = new Result(m_localNode);
        String queryType = isTypeA ? "A" : "AAAA";
        String binLocation = null;
        String[] envPath = null;
        CvunetQueryData locationAndEnv = null;
        locationAndEnv = VerificationUtil.getCvunetqueryLocation(resultLocation);
        this.m_isCvunetquery = locationAndEnv.isCvunetquery();
        Trace.out((String)("isCvunetquery : " + this.m_isCvunetquery));
        if (resultLocation.getStatus() != 1) {
            StringBuffer errMsg = new StringBuffer();
            for (VerificationError vErr : resultLocation.getErrors()) {
                errMsg.append(vErr.getErrorMessage());
                errMsg.append(LSEP);
            }
            ErrorDescription errDesc = new ErrorDescription(errMsg.toString());
            resultSet.addErrorDescription(errDesc);
            resultSet.setStatus(2);
            ReportUtil.sureprintln(errMsg.toString());
            return null;
        }
        binLocation = locationAndEnv.getLocation();
        envPath = locationAndEnv.getEnv();
        Hashtable nodeCmdListTable = new Hashtable();
        VerificationCommand[] cmdArray = null;
        CommandResult cmdResult = null;
        String cmd = null;
        String[] args = null;
        int cntCommands = 0;
        for (int i = 0; i < nodeList.length; ++i) {
            boolean hasIpv6Inet = nodeInterfaceInet6.contains(nodeList[i]);
            ArrayList<VerificationCommand> listCmdsNode = new ArrayList<VerificationCommand>();
            for (String server : nodeQueryList.get(nodeList[i])) {
                if (!hasIpv6Inet && IPAddressUtil.isIPv6AddressString((String)server)) continue;
                cmd = binLocation + " query dns -name " + nodeList[i] + " -type " + queryType + " -dnsserver " + server;
                if (!locationAndEnv.isCvunetquery()) {
                    cmd = cmd + " -xml ";
                }
                args = new String[]{"-rungencmd", cmd};
                cmdResult = new CommandResult();
                listCmdsNode.add(new VerificationCommand(m_localNode, args, envPath, (NativeResult)cmdResult));
            }
            nodeCmdListTable.put(nodeList[i], listCmdsNode);
            cntCommands += listCmdsNode.size();
            Trace.out((String)("total commands " + listCmdsNode.size() + " for the node " + nodeList[i]));
        }
        cmdArray = new VerificationCommand[cntCommands];
        cntCommands = 0;
        for (String cmdnode : nodeList) {
            VerificationCommand[] cmdArrayNode = ((List)nodeCmdListTable.get(cmdnode)).toArray(new VerificationCommand[0]);
            System.arraycopy(cmdArrayNode, 0, cmdArray, cntCommands, cmdArrayNode.length);
            cntCommands += cmdArrayNode.length;
        }
        new GlobalHandler().submit((Command[])cmdArray, 0, resultSet);
        cntCommands = 0;
        for (String nodeToQuery : nodeList) {
            int numServers = ((List)nodeCmdListTable.get(nodeToQuery)).size();
            String[] queryOutput = new String[numServers];
            for (int z = 0; z < numServers; ++z) {
                String[] rsltStr = cmdArray[cntCommands++].getCommandResult().getResultString();
                queryOutput[z] = VerificationUtil.strArr2List(rsltStr, System.getProperty("line.separator"));
            }
            tableResult.put(nodeToQuery, queryOutput);
            Trace.out((String)("output[" + nodeToQuery + "]: " + numServers));
        }
        return tableResult;
    }
}

