/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.TaskNameService;
import oracle.ops.verification.framework.engine.task.sTaskNameServiceSwitch;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.framework.util.sCommandsUtil;

public class sTaskNameService
extends TaskNameService {
    private String[] m_nodeList = null;
    private String m_scanName = null;
    private sCommandsUtil m_cmdsUtil = null;
    private TaskNameService m_taskNS = null;
    private MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    static final String LSEP = System.getProperty("line.separator");

    public sTaskNameService(String[] nodeList, String scanName, TaskNameService taskNS) {
        this.m_nodeList = nodeList;
        this.m_scanName = scanName;
        this.m_taskNS = taskNS;
    }

    @Override
    public boolean performTask() {
        ErrorDescription errDesc;
        String status;
        String comment;
        InetAddress[] inetScanAddresses;
        List<String> ipv6AddressesFromDNS;
        String nameServiceHost = null;
        boolean DNSbeforeNIS = false;
        this.m_cmdsUtil = new sCommandsUtil();
        String hostsLine = null;
        if (Trace.isTraceEnabled()) {
            VerificationUtil.traceAndLog("ENTRY: scan name '" + this.m_scanName + "'");
        }
        String osName = VerificationUtil.getCurrentOS().toLowerCase();
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (!nativeSystem.isUnixSystem()) {
            return true;
        }
        ReportUtil.sureprintln(LSEP + this.s_msgBundle.getMessage("4655", false, (Object[])new String[]{this.m_scanName}));
        sTaskNameServiceSwitch taskNSS = new sTaskNameServiceSwitch(this.m_nodeList);
        String taskNameStr = this.s_gMsgBundle.getMessage("2061", false);
        taskNSS.setElementName(taskNameStr);
        this.m_taskNS.addChildTask(taskNSS);
        boolean isOkNSS = taskNSS.perform();
        ResultSet nssResultSet = taskNSS.getResultSet();
        this.m_resultSet.uploadResultSet(nssResultSet);
        if (!isOkNSS) {
            return false;
        }
        Vector resInfoSet = nssResultSet.getResult(this.m_nodeList[0]).getResultInfoSet();
        if (resInfoSet != null && resInfoSet.size() > 0) {
            hostsLine = (String)resInfoSet.get(0);
        }
        VerificationUtil.traceAndLog("hostsLine=" + hostsLine);
        int foundDNS = 0;
        int foundNIS = 0;
        String searchStr = "dns";
        if (osName.contentEquals("aix")) {
            searchStr = "bind";
        }
        if (hostsLine == null) {
            hostsLine = new String();
        }
        foundNIS = hostsLine.indexOf("nis");
        foundDNS = hostsLine.indexOf(searchStr);
        if (foundNIS != -1 && foundDNS != -1 && foundDNS < foundNIS || foundDNS != -1 && foundNIS == -1) {
            DNSbeforeNIS = true;
        }
        VerificationUtil.traceAndLog("DNSbeforeNIS is: " + DNSbeforeNIS);
        nameServiceHost = VerificationUtil.getLocalNode();
        Result result = new Result(nameServiceHost);
        HashSet<String> ipAddressListFromDNS = new HashSet<String>();
        List<String> ipAddressesFromDNS = VerificationUtil.resolveIPAddressbyName(this.m_scanName, true, result);
        if (ipAddressesFromDNS != null && !ipAddressesFromDNS.isEmpty()) {
            VerificationUtil.traceAndLog("IPv4 Host/IP Addresses obtained for scan name " + this.m_scanName + ": " + VerificationUtil.strList2List(ipAddressesFromDNS));
            ipAddressListFromDNS.addAll(ipAddressesFromDNS);
        }
        if ((ipv6AddressesFromDNS = VerificationUtil.resolveIPAddressbyName(this.m_scanName, false, result)) != null && !ipv6AddressesFromDNS.isEmpty()) {
            VerificationUtil.traceAndLog("IPv6 Host/IP Addresses obtained for scan name " + this.m_scanName + ": " + VerificationUtil.strList2List(ipv6AddressesFromDNS));
            ipAddressListFromDNS.addAll(ipv6AddressesFromDNS);
        }
        if (ipAddressListFromDNS.isEmpty()) {
            ErrorDescription errDesc2 = new ErrorDescription("1101", new String[]{this.m_scanName}, this.s_gMsgBundle);
            ReportUtil.printError(errDesc2.getErrorMessage());
            this.m_resultSet.addResult(nameServiceHost, 3);
            this.m_resultSet.addErrorDescription(errDesc2);
            return false;
        }
        this.m_taskNS.setScanVIPAddressListFromDNS(ipAddressListFromDNS);
        HashSet<String> ipAddressListFromNIS = new HashSet<String>();
        try {
            inetScanAddresses = InetAddress.getAllByName(this.m_scanName);
        }
        catch (UnknownHostException uhe2) {
            VerificationUtil.traceAndLog("UNKNOWNHOSTEXCEPTION: InetAddress.getAllByName() failed: " + uhe2.getMessage());
            ErrorDescription errDesc3 = new ErrorDescription("1101", new String[]{this.m_scanName}, this.s_gMsgBundle);
            ReportUtil.printError(errDesc3.getErrorMessage());
            this.m_resultSet.addResult(nameServiceHost, 2);
            this.m_resultSet.addErrorDescription(errDesc3);
            return false;
        }
        if (inetScanAddresses != null && inetScanAddresses.length > 0) {
            for (InetAddress inetScanAddress : inetScanAddresses) {
                ipAddressListFromNIS.add(inetScanAddress.getHostAddress());
            }
        }
        if (ipAddressListFromNIS.isEmpty()) {
            ErrorDescription errDesc4 = new ErrorDescription("1101", new String[]{this.m_scanName}, this.s_gMsgBundle);
            ReportUtil.printError(errDesc4.getErrorMessage());
            this.m_resultSet.addResult(nameServiceHost, 3);
            this.m_resultSet.addErrorDescription(errDesc4);
            return false;
        }
        VerificationUtil.traceAndLog("DNS Host/IP Addresses obtained for scan name " + this.m_scanName + ": " + VerificationUtil.strList2List(new ArrayList<String>(ipAddressListFromDNS)));
        VerificationUtil.traceAndLog("Name service configuration Host/IP Addresses obtained for scan name " + this.m_scanName + ": " + VerificationUtil.strList2List(new ArrayList<String>(ipAddressListFromNIS)));
        ReportUtil.writeColHeaders(ReportUtil.SCANNAME, ReportUtil.IPADDR, ReportUtil.STATUS, ReportUtil.COMMENT);
        boolean diffDNSNIS = false;
        HashSet<String> inconsistentDNSIPAddresses = new HashSet<String>();
        HashSet<String> inconsistentNISIPAddresses = new HashSet<String>();
        for (String dnsIP : ipAddressListFromDNS) {
            inconsistentDNSIPAddresses.add(dnsIP);
        }
        for (String nisIP : ipAddressListFromNIS) {
            inconsistentNISIPAddresses.add(nisIP);
        }
        for (String ipAddr : ipAddressListFromDNS) {
            VerificationUtil.traceAndLog("Checking ipAddr: '" + ipAddr + "'");
            if (!ipAddressListFromNIS.isEmpty() && ipAddressListFromNIS.contains(ipAddr)) {
                comment = new String("");
                status = ReportUtil.PASSED;
                ReportUtil.writeRecord(this.m_scanName, ipAddr, status, comment);
                inconsistentDNSIPAddresses.remove(ipAddr);
                inconsistentNISIPAddresses.remove(ipAddr);
                VerificationUtil.traceAndLog("Match DNS and network resolved IP address entry: '" + ipAddr + "'");
                continue;
            }
            VerificationUtil.traceAndLog("DNS returned IP address : '" + ipAddr + "'" + " is not part " + "of the NIS returned IP address list.");
            comment = this.s_msgBundle.getMessage("4659", false);
            status = ReportUtil.FAILED;
            ReportUtil.writeRecord(this.m_scanName, ipAddr, status, comment);
            diffDNSNIS = true;
        }
        for (String nisAddr : inconsistentNISIPAddresses) {
            VerificationUtil.traceAndLog("getAllByName() returned IP address : '" + nisAddr + "'" + " is not part " + "of the DNS returned IP address list.");
            comment = this.s_msgBundle.getMessage("4660", false);
            status = ReportUtil.FAILED;
            ReportUtil.writeRecord(this.m_scanName, nisAddr, status, comment);
            diffDNSNIS = true;
        }
        if (!inconsistentDNSIPAddresses.isEmpty()) {
            errDesc = new ErrorDescription("11826", new String[]{VerificationUtil.strList2List(new ArrayList<String>(inconsistentDNSIPAddresses)), this.m_scanName, VerificationUtil.strList2List(new ArrayList<String>(ipAddressListFromNIS))}, this.s_gMsgBundle);
            this.m_resultSet.addResult(nameServiceHost, 3);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.printError(errDesc.getErrorMessage());
        }
        if (!inconsistentNISIPAddresses.isEmpty()) {
            errDesc = new ErrorDescription("11827", new String[]{VerificationUtil.strList2List(new ArrayList<String>(inconsistentNISIPAddresses)), this.m_scanName, VerificationUtil.strList2List(new ArrayList<String>(ipAddressListFromDNS))}, this.s_gMsgBundle);
            this.m_resultSet.addResult(nameServiceHost, 3);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.printError(errDesc.getErrorMessage());
        }
        if (diffDNSNIS) {
            errDesc = !DNSbeforeNIS ? new ErrorDescription("4663", this.s_msgBundle) : new ErrorDescription("4664", new String[]{this.m_scanName}, this.s_msgBundle);
            this.m_resultSet.addResult(this.m_nodeList, 3);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            ReportUtil.printError(errDesc.getErrorMessage());
            return false;
        }
        this.m_resultSet.addResult(this.m_nodeList, 1);
        return true;
    }
}

