/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.verification.VerificationError;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.PidOrConfFileData;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskNTP;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

class sTaskNTP
extends Task
implements VerificationConstants {
    final String NTP_CONFIG_FILE = "/etc/inet/ntp.conf";
    final String CHRONY_CONFIG_FILE = "/etc/chrony.conf";
    final String NTP_ALTCONFIG_FILE = "/etc/inet/ntp.conf.cluster";
    final String CHRONY_DAEMON_NAME = "chronyd";
    final String NTP_DAEMON_NAME = "xntpd";
    final String NTP_DAEMON_NAME_2 = "ntpd";
    final String NTP_NAME = "ntp";
    final String NTP_QUERY_COMMAND = "/usr/sbin/ntpq -p";
    final String CHRONY_QUERY_COMMAND = "/usr/bin/chronyc sources";
    final String CV_NTP_CONF_FILE = "CV_NTP_CONF_FILE";
    final String CV_NTP_DAEMON_NAME = "CV_NTP_DAEMON_NAME";
    final String NTP_SLEWING_OPTION_PRE_SOL_REL11 = "'slewalways yes' & 'disable pll'";
    final String NTP_SLEWING_OPTION_POST_SOL_REL10 = "slew_always = true";
    final String NTPD_STARTUP_OPTION_QUERY = "/bin/cat ";
    final String SOL11_SVCCFG_CMDLINE_SLEWING = "/usr/sbin/svccfg -s svc:/network/ntp:default listprop \\| /bin/grep slew";
    final String NTP_SVCS_CMDLINE = "/bin/svcs -a \\|/bin/grep ntp";
    final String NTP_SVCS_DISABLED_OUTPUT = "disabled";
    final String NTPD_STARTUP_CONFIG_FILE = "/etc/inet/ntp.conf";
    private boolean m_isNTPQSupported = true;
    private boolean isOSReleasePost10 = false;
    final String CHRONY_PID_FILE_NAME = "/var/run/chronyd.pid";
    private Vector<String> m_rejectedTimeServerEntries = null;
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private TaskNTP m_genTask;

    sTaskNTP(TaskNTP genTask) {
        String osName = VerificationUtil.getCurrentOS().toLowerCase();
        if (osName.contentEquals("aix")) {
            this.m_isNTPQSupported = false;
        }
        this.m_genTask = genTask;
        this.isOSReleasePost10 = this.compareOSRelease(5, 11);
        this.m_rejectedTimeServerEntries = null;
    }

    sTaskNTP() {
        String osName = VerificationUtil.getCurrentOS().toLowerCase();
        if (osName.contentEquals("aix")) {
            this.m_isNTPQSupported = false;
        }
        this.m_rejectedTimeServerEntries = null;
    }

    public List<String> getNTPConfigFile() {
        Vector<String> failNodes;
        Vector<String> succNodes;
        boolean alternate_exists;
        ArrayList<String> retList = new ArrayList<String>();
        String cfile = System.getProperty("CV_NTP_CONF_FILE");
        if (cfile != null && cfile.trim().length() > 0) {
            retList.add(cfile);
            return retList;
        }
        boolean primary_exists = new File("/etc/inet/ntp.conf").exists();
        if (primary_exists) {
            retList.add("/etc/inet/ntp.conf");
            return retList;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Checking availability of Cluster NTP config file locally");
        }
        if (alternate_exists = new File("/etc/inet/ntp.conf.cluster").exists()) {
            retList.add("/etc/inet/ntp.conf.cluster");
            return retList;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Cluster NTP config file does not exist locally");
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Neither NTP config exists locally");
            Trace.out((String)"Checking for ntp.conf on at least 1 node");
        }
        if (VerificationUtil.pathExists(this.m_genTask.m_nodeList, "/etc/inet/ntp.conf", 2, succNodes = new Vector<String>(), failNodes = new Vector<String>()) && succNodes.size() > 0) {
            retList.add("/etc/inet/ntp.conf");
            return retList;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Checking for ntp.conf.cluster on at least 1 node");
        }
        if (VerificationUtil.pathExists(this.m_genTask.m_nodeList, "/etc/inet/ntp.conf.cluster", 2, succNodes, failNodes) && succNodes.size() > 0) {
            retList.add("/etc/inet/ntp.conf.cluster");
            return retList;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Could not find either NTP config on at least 1 node");
        }
        retList.add("/etc/inet/ntp.conf");
        return retList;
    }

    public List<String> getNTPDaemonNames() {
        ArrayList<String> retList = new ArrayList<String>();
        String dmn = System.getProperty("CV_NTP_DAEMON_NAME");
        if (dmn != null && dmn.trim().length() > 0) {
            retList.add(dmn);
        } else {
            retList.add("xntpd");
        }
        retList.add("ntpd");
        return retList;
    }

    public String getNTPDaemonName() {
        String ret = this.getNTPDaemonNames().get(0);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    public String getDaemonPidFilePath(String daemonName) {
        throw new UnsupportedOperationException("Operation: " + daemonName + ":'getDaemonPidFilePath' is not supported on " + "this platform");
    }

    public List<String> getDaemonPidFilePath() {
        throw new UnsupportedOperationException("Operation: 'getDaemonPidFilePath' is not supported on this platform");
    }

    public String getNTPQueryCommand() {
        return "/usr/sbin/ntpq -p";
    }

    public String getNTPDCommandLine(String queryType) {
        if (this.isOSReleasePost10) {
            return "/usr/sbin/svccfg -s svc:/network/ntp:default listprop \\| /bin/grep slew";
        }
        return "/bin/cat " + this.getNTPDBootConfigFile();
    }

    public String getNTPDBootConfigFile() {
        return "/etc/inet/ntp.conf";
    }

    public String getNTPDSlewingOption() {
        if (this.isOSReleasePost10) {
            return "slew_always = true";
        }
        return "'slewalways yes' & 'disable pll'";
    }

    public boolean isDaemonChrony(String daemonName) {
        return false;
    }

    public void doChronyChecks(ResultSet locrs, Vector<String> dmnOkVec) {
        throw new UnsupportedOperationException("Operation: 'getDaemonPidFilePath' is not supported on this platform");
    }

    public String[] parseNTPQueryOutput(String ntpqOutput) {
        String[] lineArray = ntpqOutput.split("\n");
        String[] tsArray = null;
        if (lineArray.length > 2) {
            tsArray = new String[lineArray.length - 2];
            for (int i = 2; i < lineArray.length; ++i) {
                tsArray[i - 2] = lineArray[i];
            }
        }
        return tsArray;
    }

    public String getIDFromNTPOutput(String tsline) {
        if (tsline.length() < 2) {
            return null;
        }
        String[] tsEntries = tsline.substring(1).split("\\s+");
        if (tsEntries.length >= 2) {
            char firstChar = tsline.charAt(0);
            if (' ' == firstChar || 'x' == firstChar || '.' == firstChar || '-' == firstChar) {
                if (this.m_rejectedTimeServerEntries == null) {
                    this.m_rejectedTimeServerEntries = new Vector();
                }
                this.m_rejectedTimeServerEntries.add(tsEntries[1] + ": '" + firstChar + "'");
                return null;
            }
            return tsEntries[1];
        }
        return null;
    }

    public Vector<String> getRejectedTimeServerList() {
        return this.m_rejectedTimeServerEntries;
    }

    public void cleanRejectedTimeServerList() {
        this.m_rejectedTimeServerEntries = null;
    }

    public float getNTPOffsetLimit() {
        String maxOffset = VDMUtil.getNTPOffsetLimit();
        Trace.out((String)("using " + maxOffset + " as threshold limit"));
        float f = Float.parseFloat(maxOffset);
        return f;
    }

    public boolean parseNTPDCommandLine(String cmdline, String queryType) {
        if (this.isOSReleasePost10) {
            String slewingOptionEnabledRegx = "slew_always\\s+boolean\\s+true";
            String slewingOptionDisabledRegx = "slew_always\\s+boolean\\s+false";
            if (cmdline.contains("slew_always")) {
                String buffer = cmdline.trim();
                buffer = buffer.substring(buffer.indexOf("slew_always"));
                Trace.out((String)("Determining the slewing option status from the command output (" + buffer + ")"));
                if (buffer.matches(slewingOptionEnabledRegx)) {
                    Trace.out((String)"Slew always is ENABLED");
                    return true;
                }
                if (buffer.matches(slewingOptionDisabledRegx)) {
                    Trace.out((String)"Slew always is DISABLED");
                    return false;
                }
                Trace.out((String)("Returning false as pattern 'slew_always   boolean true/false'  does not match with the command output (" + cmdline + ")"));
                return false;
            }
            Trace.out((String)("Returning false as token 'slew_always' not found in the command output (" + cmdline + ")"));
            return false;
        }
        String slewingOptionRegx = "slewalways\\s+yes";
        String slewingOptionRegx_supp = "disable\\s+pll";
        boolean slew = false;
        boolean dis_pll = false;
        if (cmdline != null && cmdline.length() != 0) {
            String[] option = cmdline.split("\n");
            for (int i = 0; i < option.length; ++i) {
                option[i] = option[i].trim();
                if (option[i].matches(slewingOptionRegx)) {
                    Trace.out((String)"slew is true");
                    slew = true;
                } else if (option[i].matches(slewingOptionRegx_supp)) {
                    Trace.out((String)"dis_pll is true");
                    dis_pll = true;
                }
                if (!slew || !dis_pll) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean compareOSRelease(int requiredMajor, int requiredMinor) {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet osReleaseResSet = new ResultSet();
        Trace.out((String)"Getting OS release from the nodes");
        globalExec.getKernelVersion(this.m_genTask.m_nodeList, osReleaseResSet);
        Hashtable t = osReleaseResSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() != 1) continue;
            String currentVersion = (String)result.getResultInfoSet().firstElement();
            int currentMajor = 0;
            int currentMinor = 0;
            Trace.out((String)("Available OS Release on node " + node + "is (" + currentVersion + ")"));
            if (VerificationUtil.isStringGood(currentVersion)) {
                if ((currentVersion = currentVersion.trim()).contains(".")) {
                    String majorString = currentVersion.substring(0, currentVersion.indexOf("."));
                    Trace.out((String)("majorString=" + majorString));
                    currentMajor = Integer.parseInt(majorString);
                    String minorString = currentVersion.substring(majorString.length() + 1);
                    Trace.out((String)("minorString=" + minorString));
                    currentMinor = minorString.contains(".") ? Integer.parseInt(minorString.substring(0, minorString.indexOf("."))) : Integer.parseInt(minorString);
                } else {
                    currentMajor = Integer.parseInt(currentVersion);
                }
            }
            Trace.out((String)("The current Major number is " + currentMajor + "\nThe Current Minor number is " + currentMinor));
            if (currentMajor < requiredMajor || currentMinor < requiredMinor) continue;
            return true;
        }
        return false;
    }

    public String getCfgFileToSearch() {
        return new String("/etc/services");
    }

    public boolean isNTPQSupported() {
        return this.m_isNTPQSupported;
    }

    boolean isGenericDaemonCheck(String[] nodeList, ResultSet locrs) {
        if (VerificationUtil.isSolarisGlobalZone(nodeList, locrs)) {
            Trace.out((String)"global zone so do generic daemon liveliness check");
            return true;
        }
        if (!locrs.allSuccess()) {
            Trace.out((String)"failure in determining zones");
            this.displayErrors(locrs);
            return false;
        }
        Trace.out((String)"non-global zone on all nodes");
        if (VerificationUtil.isSolarisKernelZone(nodeList, locrs)) {
            Trace.out((String)"Kernel zone nodes");
            return true;
        }
        if (!locrs.allSuccess()) {
            Trace.out((String)"failure in determining if kernel zones");
            this.displayErrors(locrs);
            return false;
        }
        Trace.out((String)"no errors - non global, non kernel zone");
        return false;
    }

    private void displayErrors(ResultSet locrs) {
        if (!locrs.allSuccess()) {
            List<VerificationError> errorList = locrs.getGlobalAndNodeErrorList();
            String errMsg = "";
            for (VerificationError verr : errorList) {
                errMsg = errMsg + verr.getErrorMessage() + LSEP;
            }
            ReportUtil.printError(errMsg);
        }
    }

    public void doSolarisNonGlobalZoneDaemonCheck(String[] nodeList, ResultSet locrs) {
        ErrorDescription errDesc;
        String errMsg;
        String cmd = "/bin/svcs -a \\|/bin/grep ntp";
        GlobalExecution globalExec = new GlobalExecution();
        Trace.out((String)("about to run command " + cmd + " to ensure that ntpd is not running"));
        ReportUtil.println(s_gMsgBundle.getMessage("1044", false));
        ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("8018", false));
        ResultSet rslt = new ResultSet();
        globalExec.runGenericCmd(nodeList, cmd, rslt);
        locrs.addResultSetData(rslt);
        ArrayList<String> opFailedNodeList = new ArrayList<String>();
        ArrayList<String> vfyFailedNodeList = new ArrayList<String>();
        ArrayList<String> successNodeList = new ArrayList<String>();
        Hashtable rsltTab = rslt.getResultTable();
        Enumeration e = rsltTab.keys();
        while (e.hasMoreElements()) {
            String ntpdStatus = ReportUtil.UNKNOWN;
            String node = (String)e.nextElement();
            Result result = (Result)rsltTab.get(node);
            if (result.getStatus() == 1) {
                String cmdOut = null;
                String[] cmdOutArr = (String[])result.getResultInfoSet().get(1);
                if (cmdOutArr != null && cmdOutArr.length > 0) {
                    cmdOut = VerificationUtil.strArr2List(cmdOutArr, LSEP);
                }
                Trace.out((String)("The svcs output is " + cmdOut + " on node " + node));
                if (VerificationUtil.isStringGood(cmdOut)) {
                    if (cmdOut.indexOf("ntp") != -1) {
                        boolean ntpDisabled = true;
                        for (String output : cmdOutArr) {
                            if (output.toLowerCase().startsWith("disabled")) continue;
                            ntpDisabled = false;
                        }
                        if (ntpDisabled) {
                            locrs.addResult(node, 1);
                            ntpdStatus = s_msgBundle.getMessage("8134", false);
                            successNodeList.add(node);
                        } else {
                            locrs.addResult(node, 3);
                            vfyFailedNodeList.add(node);
                            ntpdStatus = s_msgBundle.getMessage("8133", false);
                        }
                    } else {
                        Trace.out((String)("The svcs command failed to run on node " + node));
                        locrs.addResult(node, 2);
                        opFailedNodeList.add(node);
                    }
                } else {
                    Trace.out((String)("The ntp service is not installed on node " + node));
                    ntpdStatus = s_msgBundle.getMessage("8134", false);
                    locrs.addResult(node, 1);
                    successNodeList.add(node);
                }
            } else {
                Trace.out((String)("The svcs command failed to run on node " + node));
                locrs.addResult(node, 2);
                opFailedNodeList.add(node);
            }
            ReportUtil.writeRecord(node, ntpdStatus);
        }
        if (locrs.allSuccess()) {
            ReportUtil.printResult(LSEP + s_gMsgBundle.getMessage("1045", false));
            return;
        }
        if (vfyFailedNodeList.size() != 0) {
            errMsg = s_gMsgBundle.getMessage("1046", true, (Object[])new String[]{VerificationUtil.strList2List(vfyFailedNodeList)});
            errDesc = new ErrorDescription(errMsg);
            locrs.addErrorDescription(errDesc);
        }
        if (opFailedNodeList.size() != 0) {
            errMsg = s_gMsgBundle.getMessage("1047", true, (Object[])new String[]{VerificationUtil.strList2List(opFailedNodeList)});
            errDesc = new ErrorDescription(errMsg);
            locrs.addErrorDescription(errDesc);
        }
        if (successNodeList.size() != 0) {
            String succMesg = s_gMsgBundle.getMessage("1048", false, (Object[])new String[]{VerificationUtil.strList2List(successNodeList)});
            ReportUtil.sureprintln(succMesg);
        }
        this.displayErrors(locrs);
    }

    boolean isPTPfile(String fileName) {
        throw new UnsupportedOperationException("Not supported on this platform");
    }

    boolean isPTPconfigured(Vector<PidOrConfFileData> confVector) {
        throw new UnsupportedOperationException("Not supported on this platform");
    }

    boolean isPTPrunning(Vector<PidOrConfFileData> pidVector) {
        throw new UnsupportedOperationException("Not supported on this platform");
    }

    boolean isNTPconfigured(Vector<PidOrConfFileData> confVector) {
        throw new UnsupportedOperationException("Not supported on this platform");
    }

    boolean isNTPrunning(Vector<PidOrConfFileData> pidVector) {
        throw new UnsupportedOperationException("Not supported on this platform");
    }

    public boolean doCheckRegistryKeys(String srvcName, List<String> registryOKNodes, String[] nlist) {
        throw new UnsupportedOperationException("Operation 'doCheckRegistryKeys' is not supported on this platform");
    }

    public boolean canServicesCoexist(Set<String> serviceNames) {
        throw new UnsupportedOperationException("Operation 'canServicesCoexist' is not supported on this platform");
    }

    @Override
    public String getDefaultDescription() {
        return "";
    }

    @Override
    public String getDefaultElementName() {
        return "";
    }
}

