/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.fixup.FixupData;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.TaskKernelParam;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.InvalidRangeManipulationException;
import oracle.ops.verification.framework.util.RangeOfValue;
import oracle.ops.verification.framework.util.RangeOperator;
import oracle.ops.verification.framework.util.RangeType;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskKernelParam
extends TaskKernelParam {
    private TaskKernelParam m_pTask;
    static String CONSTRAINT_NAME = s_msgBundle.getMessage("1060", false);
    private static List<String> m_fixableParams = Arrays.asList("project.max-sem-ids", "process.max-sem-nsems", "process.max-file-descriptor", "project.max-shm-memory", "project.max-shm-ids", "tcp_smallest_anon_port", "tcp_largest_anon_port", "udp_smallest_anon_port", "udp_largest_anon_port");

    public sTaskKernelParam(TaskKernelParam genTask) {
        this.m_pTask = genTask;
        this.m_resultSet = genTask.m_resultSet;
        this.m_nodeList = genTask.m_nodeList;
        this.m_paramName = genTask.m_paramName;
        this.m_exepctedRange = genTask.m_exepctedRange;
        this.m_exactEqualTo = genTask.m_exactEqualTo;
        this.m_expectedStepList = genTask.m_expectedStepList;
        this.m_maxVal = genTask.m_maxVal;
        this.m_taskSeverity = genTask.m_taskSeverity;
    }

    Object getData(String cmdoutput, String paramName) {
        String[] wordArr;
        String tval = null;
        String zero = new String("0");
        if (cmdoutput.indexOf("=") <= 0) {
            return zero;
        }
        String[] output = cmdoutput.split("=");
        if (output.length <= 1) {
            return zero;
        }
        tval = output[1].trim();
        if (paramName.equals("ip_local_port_range")) {
            RangeOfValue rov;
            block17: {
                String[] wordArr2 = tval.split("\\s+");
                if (wordArr2 == null || wordArr2.length < 2) {
                    return zero;
                }
                rov = new RangeOfValue(RangeType.INTEGER);
                try {
                    rov.include(RangeOperator.GE, wordArr2[0], RangeOperator.LE, wordArr2[1]);
                }
                catch (InvalidRangeManipulationException e) {
                    if (!Trace.isTraceEnabled()) break block17;
                    Trace.out((String)("Ignored error while initializing range for ip_local_port_range:" + e));
                }
            }
            return rov;
        }
        int wordInx = 0;
        String osName = VerificationUtil.getCurrentOS().toLowerCase();
        if (!osName.contentEquals("hp-ux") && !osName.contentEquals("hp_ux")) {
            if (paramName.equals("semmsl")) {
                wordInx = 0;
            } else if (paramName.equals("semmns")) {
                wordInx = 1;
            } else if (paramName.equals("semopm")) {
                wordInx = 2;
            } else if (paramName.equals("semmni")) {
                wordInx = 3;
            }
        }
        if ((wordArr = tval.split("\\s+")) == null || wordArr.length < wordInx + 1) {
            return zero;
        }
        tval = wordArr[wordInx];
        try {
            double dval = VerificationUtil.parseStringToNumber(tval);
            return VerificationUtil.parseObjectToString(dval);
        }
        catch (NumberFormatException ne) {
            return zero;
        }
    }

    String getName(String cmdoutput, String paramName) {
        int end = cmdoutput.indexOf("= ");
        if (end < 0) {
            return null;
        }
        String tval = cmdoutput.substring(0, end);
        tval = tval.trim();
        return tval;
    }

    void performVerification() {
        ResultSet knlparamRsltSet = new ResultSet();
        GlobalExecution globalExec = new GlobalExecution();
        globalExec.getKerParam(this.m_nodeList, this.m_paramName, knlparamRsltSet);
        this.m_resultSet.addResultSetData(knlparamRsltSet);
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1012", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_paramName}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.CURRENT, ReportUtil.REQUIRED, ReportUtil.STATUS, ReportUtil.COMMENT);
        Hashtable t = knlparamRsltSet.getResultTable();
        Enumeration e = t.keys();
        String reqdValueInString = null;
        FixupData fixupKernelParamData = null;
        if (this.m_pTask.isFixupReqd() && m_fixableParams.contains(this.m_paramName)) {
            fixupKernelParamData = new FixupData(null);
            if (this.m_paramName.equals("project.max-sem-ids") || this.m_paramName.equals("process.max-sem-nsems") || this.m_paramName.equals("project.max-shm-memory") || this.m_paramName.equals("process.max-file-descriptor") || this.m_paramName.equals("project.max-shm-ids")) {
                this.m_pTask.setRebootRequiredForFixup(true);
            }
        }
        for (String node : this.m_nodeList) {
            ErrorDescription errDesc;
            reqdValueInString = this.m_pTask.getExpectedValue(node);
            if (reqdValueInString == null) continue;
            Result result = (Result)knlparamRsltSet.getResultTable().get(node);
            Object cur = ReportUtil.UNKNOWN;
            CollectionElement collectionElement = new CollectionElement(this.getElementName(), null, reqdValueInString, null, this.getDefaultDescription(), 5);
            this.m_resultSet.addCollectionElement(node, collectionElement);
            if (result.getStatus() == 1) {
                cur = result.getResultInfoSet().elementAt(0);
                Trace.out((String)("CURRENT = " + cur));
                if (cur == null || cur.toString().trim().length() == 0) {
                    cur = ReportUtil.UNKNOWN;
                    Trace.out((String)("FAILED:: No value returned for param: " + this.m_paramName + " on node:" + node));
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("7544", true, (Object[])new String[]{this.m_paramName, node}), s_msgBundle, "7544");
                    this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                    this.m_resultSet.addResult(node, 2);
                    collectionElement.setValue(cur);
                    collectionElement.setStatus(2);
                    collectionElement.addErrorDescription(errDesc);
                } else {
                    String fullParamName = this.getName((cur = this.getData(cur.toString(), this.m_paramName)).toString(), this.m_paramName);
                    if (fullParamName != null) {
                        this.m_paramName = fullParamName;
                    }
                }
            }
            boolean currentValueVerified = this.meetsRequirements(cur, reqdValueInString);
            this.m_resultSet.getResult(node).setHasResultValues(true);
            this.m_resultSet.getResult(node).setExpectedValue(reqdValueInString);
            this.m_resultSet.getResult(node).setActualValue(String.valueOf(cur));
            collectionElement.setValue(cur);
            if (currentValueVerified) {
                Trace.out((String)("Result.OPERATION_SUCCESSFUL:: available value for kernel parameter '" + this.m_paramName + "' =" + cur));
                ReportUtil.writeRecord(node, cur.toString(), reqdValueInString, ReportUtil.PASSED);
                collectionElement.setStatus(1);
                continue;
            }
            collectionElement.setStatus(3);
            collectionElement.addErrorDescription(new ErrorDescription(s_msgBundle.getMessage("7543", true, (Object[])new String[]{this.m_paramName, node, reqdValueInString, String.valueOf(cur)}), s_msgBundle, "7543"));
            String comment = "";
            String nstatus = m_isCLImode && (this.m_paramName.contains("ip_local_port_range") || this.m_paramName.contains("tcp_smallest_anon_port") || this.m_paramName.contains("tcp_largest_anon_port") || this.m_paramName.contains("udp_smallest_anon_port") || this.m_paramName.contains("udp_largest_anon_port")) && SeverityType.IGNORABLE.equals((Object)this.m_taskSeverity) ? ReportUtil.FAILED_IGNORABLE : ReportUtil.FAILED;
            this.m_resultSet.addResult(node, 3);
            errDesc = new ErrorDescription(s_msgBundle.getMessage("7543", true, (Object[])new String[]{this.m_paramName, node, reqdValueInString, String.valueOf(cur)}));
            this.m_resultSet.getResult(node).addErrorDescription(errDesc);
            comment = s_gMsgBundle.getMessage("1203", false);
            ReportUtil.writeRecord(node, cur.toString(), reqdValueInString, nstatus, comment);
            if (null == fixupKernelParamData) continue;
            Trace.out((String)("Generating fixup for param (" + this.m_paramName + ") on node '" + node + "'"));
            VerificationLogData.logInfo("Generating fixup for param (" + this.m_paramName + ") on node '" + node + "'");
            fixupKernelParamData.addParticipatingNode(node);
            String expectedValue = null;
            expectedValue = this.m_exepctedRange == null ? reqdValueInString : (this.m_exepctedRange.getMaxValue() != null && this.m_exepctedRange.getMinValue() != null && this.m_exepctedRange.getMaxValue().trim().equals(this.m_exepctedRange.getMinValue().trim()) ? this.m_exepctedRange.getMaxValue() : this.m_exepctedRange.getBoundedRangeString());
            Trace.out((String)("ExpectedValue = '" + expectedValue + "'"));
            if (VerificationUtil.isStringGood(expectedValue)) {
                fixupKernelParamData.setExpectedValue(node, expectedValue);
            }
            String actualValue = cur instanceof RangeOfValue ? ((RangeOfValue)cur).getBoundedRangeString() : cur.toString();
            Trace.out((String)("ActualValue = '" + actualValue + "'"));
            if (!VerificationUtil.isStringGood(actualValue)) continue;
            fixupKernelParamData.setActualValue(node, actualValue);
        }
        if (null != fixupKernelParamData) {
            fixupKernelParamData.addFixupInstruction("NAME", this.m_paramName);
            String currentUser = System.getProperty("user.name");
            if (VerificationUtil.isStringGood(currentUser)) {
                fixupKernelParamData.addFixupInstruction("USER", currentUser);
            }
            this.m_pTask.setFixupData(fixupKernelParamData);
        }
    }

    boolean meetsRequirements(Object value, String reqdValueInString) {
        boolean verified;
        if (value == null || ReportUtil.UNKNOWN.equals(value) || reqdValueInString == null) {
            return false;
        }
        if (value instanceof RangeOfValue) {
            if (this.m_exepctedRange == null) {
                try {
                    RangeOfValue rov = new RangeOfValue(RangeType.INTEGER);
                    rov.include(RangeOperator.EQ, reqdValueInString);
                    verified = ((RangeOfValue)value).contains(rov);
                }
                catch (InvalidRangeManipulationException e1) {
                    verified = false;
                }
            } else {
                try {
                    verified = this.m_exepctedRange.contains((RangeOfValue)value);
                }
                catch (InvalidRangeManipulationException e1) {
                    verified = false;
                }
            }
        } else if (this.m_exepctedRange == null) {
            verified = this.m_exactEqualTo ? VerificationUtil.parseStringToNumber(value.toString()) == VerificationUtil.parseStringToNumber(reqdValueInString) : VerificationUtil.parseStringToNumber(value.toString()) >= VerificationUtil.parseStringToNumber(reqdValueInString);
        } else {
            try {
                verified = this.m_exepctedRange.contains(value);
            }
            catch (InvalidRangeManipulationException e1) {
                verified = false;
            }
        }
        return verified;
    }

    public static List<String> getApplicableNodes(String paramName, String[] nodeList) {
        List<String> applicableNodes = new ArrayList<String>();
        if (nodeList != null && nodeList.length > 0) {
            applicableNodes = Arrays.asList(nodeList);
        }
        return applicableNodes;
    }
}

