/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskGIConfigurationFiles
extends Task {
    public sTaskGIConfigurationFiles(VerificationTaskContext ctx) {
        super(ctx);
    }

    public sTaskGIConfigurationFiles(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public sTaskGIConfigurationFiles(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public sTaskGIConfigurationFiles(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public boolean performTask() {
        String inittabPath;
        ResultSet locResSet;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        boolean isUnixSystem = nativeSystem.isUnixSystem();
        if (!isUnixSystem) {
            return false;
        }
        ReportUtil.sureprintln("Performing check for GI configuration files");
        List<String> unexpectedFiles = this.getUnexpectedFiles();
        List<String> unexpectedDirs = this.getUnexpectedDirs();
        for (String file : unexpectedFiles) {
            locResSet = new ResultSet();
            VerificationUtil.checkFileAbsence(this.m_nodeList, file, locResSet);
            this.m_resultSet.addResultSetData(locResSet);
        }
        for (String dir : unexpectedDirs) {
            locResSet = new ResultSet();
            VerificationUtil.checkDirAbsence(this.m_nodeList, dir, locResSet);
            this.m_resultSet.addResultSetData(locResSet);
        }
        String initdLoc = VerificationUtil.getInitdLoc();
        if (VerificationUtil.isStringGood(initdLoc) && VerificationUtil.isStringGood(inittabPath = VerificationUtil.getInitTabLoc())) {
            boolean entryExists = false;
            for (String node : this.m_nodeList) {
                ResultSet locResSet2 = new ResultSet();
                if (this.checkOhasdEntryInInittab(node, initdLoc, inittabPath, locResSet2)) {
                    entryExists = true;
                }
                this.m_resultSet.addResultSetData(locResSet2);
            }
            if (!entryExists) {
                ReportUtil.sureprintln("ohasd entry does not exist in '" + inittabPath + "' file on any node");
            }
        }
        return this.m_resultSet.allSuccess();
    }

    List<String> getUnexpectedFiles() {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        ArrayList<String> listOfUnexpectedFiles = new ArrayList<String>();
        String ocrLoc = nativeSys.getConfigLocation(new Version());
        String olrLoc = nativeSys.getOLRConfigLocation(m_localNode, new Version());
        String initdLoc = VerificationUtil.getInitdLoc();
        Trace.out((String)("INITD LOCATION IS : " + initdLoc));
        if (VerificationUtil.isStringGood(initdLoc)) {
            listOfUnexpectedFiles.add(initdLoc + FSEP + "init.ohasd");
            listOfUnexpectedFiles.add(initdLoc + FSEP + "ohasd");
        }
        Trace.out((String)("OCR LOCATION IS : " + ocrLoc));
        if (VerificationUtil.isStringGood(ocrLoc)) {
            listOfUnexpectedFiles.add(ocrLoc);
        }
        Trace.out((String)("OLR LOCATION IS : " + olrLoc));
        if (VerificationUtil.isStringGood(olrLoc)) {
            listOfUnexpectedFiles.add(olrLoc);
        }
        return listOfUnexpectedFiles;
    }

    List<String> getUnexpectedDirs() {
        ArrayList<String> listOfUnexpectedDirs = new ArrayList<String>();
        return listOfUnexpectedDirs;
    }

    @Override
    public String getDefaultDescription() {
        return "Validates the existence and contents of configuration files directories related to Grid Infrastructure";
    }

    @Override
    public String getDefaultElementName() {
        return "GI Configuration files";
    }

    @Override
    public String getTaskID() {
        return "GI_CONFIG";
    }

    private boolean checkOhasdEntryInInittab(String node, String initdLoc, String inittabPath, ResultSet resultSet) {
        GlobalExecution globalExec = new GlobalExecution();
        ErrorDescription errDesc = null;
        String cmdSpec = "grep respawn:" + initdLoc + FSEP + "init.ohasd" + " " + inittabPath;
        ResultSet itabResultSet = new ResultSet();
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Attempt to run command '" + cmdSpec + "' on node '" + node + "'"));
        }
        Hashtable itabCheckOutput = globalExec.runExeWithOutput(new String[]{node}, cmdSpec, itabResultSet);
        Result result = itabResultSet.getResult(node);
        String etOutput = (String)itabCheckOutput.get(node);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("exectask Output is:'" + etOutput + "'"));
        }
        if (result == null || result.getStatus() == 2) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Failed to execute the exectask command on node '" + node + "'"));
            }
            errDesc = new ErrorDescription("5302", new String[]{node}, s_msgBundle);
            errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + cmdSpec + LSEP + result.getExecutionErrorDetails());
            ReportUtil.printError(errDesc.getErrorMessage());
            resultSet.addErrorDescription(errDesc);
            resultSet.addResult(node, 2);
            return false;
        }
        String cmdOutput = VerificationUtil.fetchVerificationValue(etOutput);
        String cmdExitStat = VerificationUtil.fetchVerificationResult(etOutput);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Command exit status ='" + cmdExitStat + "'" + LSEP + "Command output ='" + cmdOutput + "'"));
        }
        if (cmdExitStat.equals("0")) {
            String[] outlist = VerificationUtil.getTokensAsArray(cmdOutput, System.getProperty("line.separator"));
            String entryLine = null;
            boolean validOhasdEntry = false;
            for (String line : outlist) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("inittab line on node '" + node + "' with 'oahasd' string: '" + line + "'"));
                }
                if (!line.startsWith("#")) {
                    validOhasdEntry = true;
                    entryLine = line;
                    if (!Trace.isLevelEnabled((int)1)) break;
                    Trace.out((String)("Found inittab entry with 'ohasd' string on node '" + node + "' ;line: '" + line + "'"));
                    break;
                }
                if (!Trace.isLevelEnabled((int)1)) continue;
                Trace.out((String)("Found commented inittab line with 'ohasd'string on node '" + node + "'; line: '" + line + "'"));
            }
            if (!validOhasdEntry) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("inittab on node '" + node + "' does not contain any valid ohasd entry"));
                }
                resultSet.addResult(node, 1);
                return false;
            }
            ReportUtil.printError("Found entry '" + entryLine + "' in file '" + inittabPath + "' on node '" + node + "'");
            resultSet.addResult(node, 3);
            return true;
        }
        if (cmdExitStat.equals("1")) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("/etc/inittab on node '" + node + "' does not contain any oahasd entry"));
            }
            resultSet.addResult(node, 1);
            return false;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Error in executing the command '" + cmdSpec + "' on node '" + node + "'" + LSEP + "command output : '" + cmdOutput + "'"));
        }
        return false;
    }
}

