/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.task.TaskContainerFreeSpace;
import oracle.ops.verification.framework.engine.task.TaskFreeSpace;

public class sTaskFreeSpace {
    public static final int fileSystem = 0;
    public static final int diskType = 1;
    public static final int diskSpace = 2;
    public static final int usedSpace = 3;
    public static final int freeSpace = 4;
    public static final int percntUse = 5;
    public static final int mountPoint = 6;
    private static String cmdPrefix = "/bin/df -k ";
    private static String cmdSuffix = " \\| grep -v Filesystem \\&\\& df -n ";
    private TaskFreeSpace m_freeTask;
    private TaskContainerFreeSpace m_conTask;

    public sTaskFreeSpace(TaskFreeSpace genTask) {
        this.m_freeTask = genTask;
    }

    public sTaskFreeSpace(TaskContainerFreeSpace genTask) {
        this.m_conTask = genTask;
    }

    public sTaskFreeSpace() {
    }

    public String getCommand(String location) {
        return cmdPrefix + location + cmdSuffix + location;
    }

    private boolean checkError(String str) {
        int noSuchDev = str.indexOf("not a block device, directory or mounted resource");
        return noSuchDev != -1;
    }

    public String getData(String cmdoutput, int dataRequested) {
        String outputLine;
        String unknown = new String("UNKNOWN");
        String zero = new String("0");
        String returnData = unknown;
        StringTokenizer st = new StringTokenizer(cmdoutput, "\n");
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nLine(s): " + cmdoutput + "\ndataReqested: " + dataRequested + "\nnumber of line tokens: " + st.countTokens() + "\n"));
        }
        switch (dataRequested) {
            case 1: {
                try {
                    String outputLine2;
                    do {
                        outputLine2 = st.nextToken();
                    } while (st.countTokens() != 0);
                    if (this.checkError(outputLine2)) {
                        return returnData;
                    }
                    returnData = outputLine2.substring(outputLine2.lastIndexOf(58) + 1).trim();
                    int strToken = returnData.indexOf("</CV_VAL>");
                    if (strToken != -1) {
                        String newReturnVal;
                        returnData = newReturnVal = returnData.substring(0, strToken);
                    }
                }
                catch (NoSuchElementException nse) {
                    return returnData;
                }
                return returnData;
            }
            case 0: 
            case 5: 
            case 6: {
                returnData = unknown;
                break;
            }
            default: {
                returnData = zero;
            }
        }
        try {
            outputLine = st.nextToken();
        }
        catch (NoSuchElementException nse) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("NOSUCHELEMENTEXCEPTION: cannot get line tokens from: '" + cmdoutput + "'\nReturning: " + returnData + "\n"));
            }
            return returnData;
        }
        if (st.countTokens() > 1) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("\nReturning: " + returnData + "\n"));
            }
            return returnData;
        }
        if (this.checkError(outputLine)) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("\nReturning: " + returnData + "\n"));
            }
            return returnData;
        }
        if (dataRequested != 0) {
            --dataRequested;
        }
        try {
            StringTokenizer dl = new StringTokenizer(outputLine, " ");
            returnData = dl.nextToken();
            for (int i = 0; i < dataRequested; ++i) {
                returnData = dl.nextToken();
            }
            int strToken = returnData.indexOf("</CV_VAL>");
            if (strToken != -1) {
                String newReturnVal;
                returnData = newReturnVal = returnData.substring(0, strToken);
            }
        }
        catch (NoSuchElementException nse) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("NOSUCHELEMENTEXCEPTION: could not get second line \nReturning: " + returnData + "\n"));
            }
            return returnData;
        }
        switch (dataRequested + 1) {
            case 2: 
            case 3: 
            case 4: {
                StorageSize ssFS = new StorageSize((double)new Double(returnData), StorageUnit.KBYTE);
                double dblFS = ssFS.sizeIn(StorageUnit.MBYTE);
                returnData = Double.toString(dblFS);
                break;
            }
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nReturning: " + returnData + "\n"));
        }
        return returnData;
    }
}

