/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskCoreFileNameConsistency {
    private final String CORE_PATTERN_CMD = "/usr/bin/coreadm \\| /usr/bin/grep \\'init core file pattern\\'";
    private final String CORE_ENABLED = "/usr/bin/coreadm \\| /usr/bin/grep \\'per-process core dumps: enabled\\'";

    sTaskCoreFileNameConsistency() {
    }

    public void checkCoreFileNameConsitency(String[] nodeList, ResultSet rsltSet, Hashtable node_pattern) {
        GlobalExecution globalExec = new GlobalExecution();
        globalExec.runGenericCmd(nodeList, "/usr/bin/coreadm \\| /usr/bin/grep \\'init core file pattern\\'", rsltSet);
        Hashtable rsltTab = rsltSet.getResultTable();
        Enumeration e = rsltTab.keys();
        while (e.hasMoreElements()) {
            int index;
            String token = "Core dump is disabled";
            String node = (String)e.nextElement();
            Result result = (Result)rsltTab.get(node);
            if (result.getStatus() != 1) continue;
            String output = new String();
            output = VerificationUtil.fetchVerificationValue((String)result.getResultInfoSet().firstElement());
            if ((output = output.trim()) != null && output.length() > 0 && this.isCoreDumpEnabled(node) && (index = output.indexOf(58)) != -1 && index + 1 < output.length()) {
                token = output.substring(index + 1).trim();
            }
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("Core Pattern on " + token + "  Node " + node));
            }
            VerificationUtil.updateResultMap(node_pattern, token, node);
        }
    }

    boolean isCoreDumpEnabled(String node) {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet rsltSet = new ResultSet();
        boolean retVal = false;
        globalExec.runGenericCmd(new String[]{node}, "/usr/bin/coreadm \\| /usr/bin/grep \\'per-process core dumps: enabled\\'", rsltSet);
        Hashtable rsltTab = rsltSet.getResultTable();
        Result result = (Result)rsltTab.get(node);
        if (result.getStatus() == 1) {
            String output = new String();
            output = VerificationUtil.fetchVerificationValue((String)result.getResultInfoSet().firstElement());
            if ((output = output.trim()) != null || output.length() > 0) {
                return true;
            }
        } else {
            result.setStatus(2);
        }
        return false;
    }
}

